/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.util;

import junit.framework.TestCase;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.riena.core.test.collect.NonUITestCase;
import org.eclipse.riena.core.util.FileUtils;

@NonUITestCase
public class FileUtilsTest
extends TestCase {
    public void testGetNameWithoutExtension() throws Exception {
        try {
            FileUtils.getNameWithoutExtension(null);
            FileUtilsTest.fail((String)"AssertionFailedException expected");
        }
        catch (AssertionFailedException assertionFailedException) {}
        String name = FileUtils.getNameWithoutExtension((String)"");
        FileUtilsTest.assertEquals((String)"", (String)name);
        name = FileUtils.getNameWithoutExtension((String)"a");
        FileUtilsTest.assertEquals((String)"a", (String)name);
        name = FileUtils.getNameWithoutExtension((String)"b.");
        FileUtilsTest.assertEquals((String)"b", (String)name);
        name = FileUtils.getNameWithoutExtension((String)"c.1");
        FileUtilsTest.assertEquals((String)"c", (String)name);
        name = FileUtils.getNameWithoutExtension((String)"dd.1.2");
        FileUtilsTest.assertEquals((String)"dd.1", (String)name);
        name = FileUtils.getNameWithoutExtension((String)".3");
        FileUtilsTest.assertEquals((String)"", (String)name);
        name = FileUtils.getNameWithoutExtension((String)"/folder/fileName.txt");
        FileUtilsTest.assertEquals((String)"fileName", (String)name);
    }

    public void testGetFileExtension() throws Exception {
        try {
            FileUtils.getFileExtension(null);
            FileUtilsTest.fail((String)"AssertionFailedException expected");
        }
        catch (AssertionFailedException assertionFailedException) {}
        String name = FileUtils.getFileExtension((String)"");
        FileUtilsTest.assertEquals((String)"", (String)name);
        name = FileUtils.getFileExtension((String)"a");
        FileUtilsTest.assertEquals((String)"", (String)name);
        name = FileUtils.getFileExtension((String)"b.");
        FileUtilsTest.assertEquals((String)"", (String)name);
        name = FileUtils.getFileExtension((String)"c.1");
        FileUtilsTest.assertEquals((String)"1", (String)name);
        name = FileUtils.getFileExtension((String)"dd.1.2");
        FileUtilsTest.assertEquals((String)"2", (String)name);
        name = FileUtils.getFileExtension((String)".3");
        FileUtilsTest.assertEquals((String)"3", (String)name);
        name = FileUtils.getFileExtension((String)"/folder/fileName.txt");
        FileUtilsTest.assertEquals((String)"txt", (String)name);
    }
}

