/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.riena.beans.common.BooleanBean;
import org.eclipse.riena.beans.common.DoubleBean;
import org.eclipse.riena.beans.common.IntegerBean;
import org.eclipse.riena.beans.common.StringBean;
import org.eclipse.riena.core.marker.IMarkable;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.ui.ridgets.swt.NumericTextRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.TextRidgetTest;
import org.eclipse.riena.internal.ui.swt.test.UITestHelper;
import org.eclipse.riena.internal.ui.swt.utils.TestUtils;
import org.eclipse.riena.ui.core.marker.ErrorMarker;
import org.eclipse.riena.ui.core.marker.IMessageMarker;
import org.eclipse.riena.ui.core.marker.NegativeMarker;
import org.eclipse.riena.ui.core.marker.ValidationTime;
import org.eclipse.riena.ui.ridgets.IMarkableRidget;
import org.eclipse.riena.ui.ridgets.INumericTextRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.marker.ValidationMessageMarker;
import org.eclipse.riena.ui.ridgets.swt.MarkerSupport;
import org.eclipse.riena.ui.ridgets.swt.uibinding.SwtControlRidgetMapper;
import org.eclipse.riena.ui.ridgets.validation.MaxLength;
import org.eclipse.riena.ui.ridgets.validation.MaxNumberLength;
import org.eclipse.riena.ui.ridgets.validation.MinLength;
import org.eclipse.riena.ui.ridgets.validation.ValidationFailure;
import org.eclipse.riena.ui.ridgets.validation.ValidationRuleStatus;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class NumericTextRidgetTest
extends TextRidgetTest {
    private static final Integer INTEGER_ONE = 471;
    private static final Integer INTEGER_TWO = 23;

    @Override
    protected IRidget createRidget() {
        return new NumericTextRidget();
    }

    protected INumericTextRidget getRidget() {
        return (INumericTextRidget)super.getRidget();
    }

    @Override
    protected Control createWidget(Composite parent) {
        Text result = new Text((Composite)this.getShell(), 133124);
        result.setData("type", (Object)"numeric");
        result.setLayoutData((Object)new RowData(100, -1));
        return result;
    }

    public void testCreatePatternEmpty() throws Exception {
        INumericTextRidget r = this.getRidget();
        r.setMaxLength(-1);
        r.setSigned(true);
        String pattern = (String)ReflectionUtils.invokeHidden((Object)r, (String)"createPattern", (Object[])new Object[]{""});
        NumericTextRidgetTest.assertTrue((boolean)"".matches(pattern));
        r.setSigned(false);
        pattern = (String)ReflectionUtils.invokeHidden((Object)r, (String)"createPattern", (Object[])new Object[]{""});
        NumericTextRidgetTest.assertTrue((boolean)"".matches(pattern));
        r.setMaxLength(3);
        pattern = (String)ReflectionUtils.invokeHidden((Object)r, (String)"createPattern", (Object[])new Object[]{""});
        NumericTextRidgetTest.assertTrue((boolean)"".matches(pattern));
        r.setSigned(true);
        pattern = (String)ReflectionUtils.invokeHidden((Object)r, (String)"createPattern", (Object[])new Object[]{""});
        NumericTextRidgetTest.assertTrue((boolean)"".matches(pattern));
    }

    public void testCreatePattern() throws Exception {
        INumericTextRidget r = this.getRidget();
        r.setMaxLength(-1);
        r.setSigned(true);
        String pattern = (String)ReflectionUtils.invokeHidden((Object)r, (String)"createPattern", (Object[])new Object[]{"-123"});
        NumericTextRidgetTest.assertTrue((boolean)"-123".matches(pattern));
        r.setSigned(false);
        pattern = (String)ReflectionUtils.invokeHidden((Object)r, (String)"createPattern", (Object[])new Object[]{"-123"});
        NumericTextRidgetTest.assertFalse((boolean)"-123".matches(pattern));
        r.setMaxLength(3);
        pattern = (String)ReflectionUtils.invokeHidden((Object)r, (String)"createPattern", (Object[])new Object[]{"-123"});
        NumericTextRidgetTest.assertFalse((boolean)"-123".matches(pattern));
        r.setSigned(true);
        pattern = (String)ReflectionUtils.invokeHidden((Object)r, (String)"createPattern", (Object[])new Object[]{"-123"});
        NumericTextRidgetTest.assertTrue((boolean)"-123".matches(pattern));
    }

    public void testCreatePatternMaxLengthSigned() throws Exception {
        INumericTextRidget r = this.getRidget();
        r.setMaxLength(3);
        r.setSigned(true);
        String input = "-123";
        String pattern = (String)ReflectionUtils.invokeHidden((Object)r, (String)"createPattern", (Object[])new Object[]{input});
        NumericTextRidgetTest.assertTrue((boolean)input.matches(pattern));
        input = "1234";
        pattern = (String)ReflectionUtils.invokeHidden((Object)r, (String)"createPattern", (Object[])new Object[]{input});
        NumericTextRidgetTest.assertFalse((boolean)input.matches(pattern));
    }

    @Override
    public void testRidgetMapping() {
        SwtControlRidgetMapper mapper = SwtControlRidgetMapper.getInstance();
        NumericTextRidgetTest.assertSame(NumericTextRidget.class, (Object)mapper.getRidgetClass((Object)this.getWidget()));
    }

    @Override
    public void testCreate() throws Exception {
        NumericTextRidgetTest.assertFalse((boolean)this.getRidget().isDirectWriting());
        NumericTextRidgetTest.assertEquals((String)"0", (String)this.getRidget().getText());
    }

    @Override
    public void testSetText() throws Exception {
        INumericTextRidget ridget = this.getRidget();
        ridget.setGrouping(true);
        ridget.setText("");
        NumericTextRidgetTest.assertEquals((String)"", (String)ridget.getText());
        ridget.setText("-1234");
        NumericTextRidgetTest.assertEquals((String)this.localize("-1.234"), (String)ridget.getText());
        ridget.setText("1234");
        NumericTextRidgetTest.assertEquals((String)this.localize("1.234"), (String)ridget.getText());
        ridget.setText(this.localize("98.765"));
        NumericTextRidgetTest.assertEquals((String)this.localize("98.765"), (String)ridget.getText());
        try {
            ridget.setText(this.localize("98.765,12"));
            NumericTextRidgetTest.fail();
        }
        catch (NumberFormatException numberFormatException) {
            this.ok();
        }
        try {
            ridget.setText("abcd");
            NumericTextRidgetTest.fail();
        }
        catch (NumberFormatException numberFormatException) {
            this.ok();
        }
        try {
            ridget.setText("a,bcd");
            NumericTextRidgetTest.fail();
        }
        catch (NumberFormatException numberFormatException) {
            this.ok();
        }
    }

    public void testValueChanged() {
        NumericTextRidgetTest.assertFalse((boolean)this.callExternalValueChanged("1.234,5600", "1.234,56"));
        NumericTextRidgetTest.assertTrue((boolean)this.callExternalValueChanged("1.234,5600", "1.234,5601"));
        NumericTextRidgetTest.assertFalse((boolean)this.callExternalValueChanged("1.234,5600", "01.234,56"));
        NumericTextRidgetTest.assertTrue((boolean)this.callExternalValueChanged(",", "0"));
        NumericTextRidgetTest.assertTrue((boolean)this.callExternalValueChanged(",", "0,00000"));
    }

    private boolean callExternalValueChanged(Object ... values) {
        return (Boolean)ReflectionUtils.invokeHidden((Object)this.getRidget(), (String)"isExternalValueChange", (Object[])values);
    }

    public void testSetTextNoGroup() throws Exception {
        INumericTextRidget ridget = this.getRidget();
        ridget.setGrouping(false);
        ridget.setText("");
        NumericTextRidgetTest.assertEquals((String)"", (String)ridget.getText());
        ridget.setText("-1234");
        NumericTextRidgetTest.assertEquals((String)"-1234", (String)ridget.getText());
        ridget.setText("1234");
        NumericTextRidgetTest.assertEquals((String)"1234", (String)ridget.getText());
        ridget.setText(this.localize("98.765"));
        NumericTextRidgetTest.assertEquals((String)"98765", (String)ridget.getText());
        try {
            ridget.setText(this.localize("98.765,12"));
            NumericTextRidgetTest.fail();
        }
        catch (NumberFormatException numberFormatException) {
            this.ok();
        }
        try {
            ridget.setText("abcd");
            NumericTextRidgetTest.fail();
        }
        catch (NumberFormatException numberFormatException) {
            this.ok();
        }
    }

    @Override
    public void testSetTextNull() {
        INumericTextRidget ridget = this.getRidget();
        ridget.setText("42");
        NumericTextRidgetTest.assertEquals((String)"42", (String)ridget.getText());
        ridget.setText(null);
        NumericTextRidgetTest.assertEquals((String)"", (String)ridget.getText());
    }

    @Override
    public void testGetText() throws Exception {
        INumericTextRidget ridget = this.getRidget();
        NumericTextRidgetTest.assertEquals((String)"0", (String)ridget.getText());
    }

    @Override
    public void testBindToModelPropertyName() {
        INumericTextRidget ridget = this.getRidget();
        IntegerBean model = new IntegerBean(1337);
        ridget.bindToModel((Object)model, "value");
        NumericTextRidgetTest.assertEquals((String)"0", (String)ridget.getText());
        ridget.updateFromModel();
        NumericTextRidgetTest.assertEquals((String)this.localize("1.337"), (String)ridget.getText());
    }

    @Override
    public void testUpdateFromModel() {
        INumericTextRidget ridget = this.getRidget();
        IntegerBean model = new IntegerBean(1337);
        ridget.bindToModel((Object)model, "value");
        model.setValue(Integer.valueOf(-7));
        ridget.updateFromModel();
        NumericTextRidgetTest.assertEquals((String)this.localize("-7"), (String)ridget.getText());
    }

    @Override
    public void testBindToModelIObservableValue() throws Exception {
        INumericTextRidget ridget = this.getRidget();
        IntegerBean model = new IntegerBean(4711);
        IObservableValue modelOV = BeansObservables.observeValue((Object)model, (String)"value");
        ridget.bindToModel(modelOV);
        NumericTextRidgetTest.assertEquals((String)"0", (String)ridget.getText());
        ridget.updateFromModel();
        NumericTextRidgetTest.assertEquals((String)this.localize("4.711"), (String)ridget.getText());
    }

    @Override
    public void testFocusGainedDoesSelectOnSingleText() {
        Text control = this.getWidget();
        NumericTextRidgetTest.assertEquals((String)"0", (String)control.getSelectionText());
        control.setSelection(0, 0);
        Event e = new Event();
        e.type = 15;
        e.widget = control;
        e.widget.notifyListeners(e.type, e);
        NumericTextRidgetTest.assertEquals((int)0, (int)(control.getStyle() & 2));
        NumericTextRidgetTest.assertEquals((String)"0", (String)control.getSelectionText());
    }

    @Override
    public void testFocusGainedDoesNotSelectOnMultiLineText() {
        NumericTextRidgetTest.assertTrue((boolean)true);
    }

    public void testCheckWidget() {
        INumericTextRidget ridget = this.getRidget();
        Text control = new Text((Composite)this.getShell(), 2);
        try {
            ridget.setUIControl((Object)control);
            NumericTextRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        try {
            ridget.setUIControl((Object)new Button((Composite)this.getShell(), 8));
            NumericTextRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
    }

    public void testSetSignedTrue() {
        INumericTextRidget ridget = this.getRidget();
        Text control = this.getWidget();
        IntegerBean model = new IntegerBean(1337);
        ridget.bindToModel((Object)model, "value");
        ridget.updateFromModel();
        NumericTextRidgetTest.assertTrue((boolean)ridget.isSigned());
        this.expectNoPropertyChangeEvent();
        ridget.setSigned(true);
        this.verifyPropertyChangeEvents();
        NumericTextRidgetTest.assertTrue((boolean)ridget.isSigned());
        int caretPos = control.getText().length() - 1;
        this.focusIn(control);
        control.setSelection(caretPos, caretPos);
        NumericTextRidgetTest.assertEquals((String)this.localize("1.337"), (String)control.getText());
        NumericTextRidgetTest.assertEquals((int)caretPos, (int)control.getCaretPosition());
        UITestHelper.sendString((Display)control.getDisplay(), (String)"-");
        NumericTextRidgetTest.assertEquals((String)this.localize("-1.337"), (String)control.getText());
        NumericTextRidgetTest.assertEquals((int)(caretPos + 1), (int)control.getCaretPosition());
        control.setSelection(1, 1);
        UITestHelper.sendString((Display)control.getDisplay(), (String)"\b");
        NumericTextRidgetTest.assertEquals((String)this.localize("1.337"), (String)control.getText());
        NumericTextRidgetTest.assertEquals((int)0, (int)control.getCaretPosition());
    }

    public void testSetSignedFalse() {
        INumericTextRidget ridget = this.getRidget();
        Text control = this.getWidget();
        IntegerBean model = new IntegerBean(1337);
        ridget.bindToModel((Object)model, "value");
        ridget.updateFromModel();
        NumericTextRidgetTest.assertTrue((boolean)ridget.isSigned());
        this.expectPropertyChangeEvent("signed", Boolean.TRUE, Boolean.FALSE);
        ridget.setSigned(false);
        this.verifyPropertyChangeEvents();
        NumericTextRidgetTest.assertFalse((boolean)ridget.isSigned());
        int caretPos = control.getText().length() - 1;
        this.focusIn(control);
        control.setSelection(caretPos, caretPos);
        NumericTextRidgetTest.assertEquals((String)this.localize("1.337"), (String)control.getText());
        NumericTextRidgetTest.assertEquals((int)caretPos, (int)control.getCaretPosition());
        UITestHelper.sendString((Display)control.getDisplay(), (String)"-");
        NumericTextRidgetTest.assertEquals((String)this.localize("1.337"), (String)control.getText());
        NumericTextRidgetTest.assertEquals((int)caretPos, (int)control.getCaretPosition());
    }

    public void testSetSignedThrowsException() {
        INumericTextRidget ridget = this.getRidget();
        ridget.setText("1234");
        ridget.setSigned(false);
        try {
            ridget.setText("-4711");
            NumericTextRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok("expected");
        }
        NumericTextRidgetTest.assertEquals((String)this.localize("1.234"), (String)ridget.getText());
    }

    public void testSetGrouping() {
        INumericTextRidget ridget = this.getRidget();
        IntegerBean model = new IntegerBean(1337);
        ridget.bindToModel((Object)model, "value");
        ridget.updateFromModel();
        final BooleanBean changed = new BooleanBean(false);
        model.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                changed.setValue(true);
            }
        });
        NumericTextRidgetTest.assertTrue((boolean)ridget.isGrouping());
        NumericTextRidgetTest.assertEquals((String)this.localize("1.337"), (String)ridget.getText());
        ridget.setGrouping(false);
        NumericTextRidgetTest.assertFalse((boolean)ridget.isGrouping());
        String uiText = ((Text)ridget.getUIControl()).getText();
        NumericTextRidgetTest.assertEquals((String)"1337", (String)uiText);
        NumericTextRidgetTest.assertEquals((String)this.localize("1.337"), (String)ridget.getText());
        NumericTextRidgetTest.assertFalse((boolean)changed.isValue());
        ridget.setGrouping(true);
        NumericTextRidgetTest.assertTrue((boolean)ridget.isGrouping());
        uiText = ((Text)ridget.getUIControl()).getText();
        NumericTextRidgetTest.assertEquals((String)this.localize("1.337"), (String)uiText);
        NumericTextRidgetTest.assertEquals((String)this.localize("1.337"), (String)ridget.getText());
        NumericTextRidgetTest.assertFalse((boolean)changed.isValue());
    }

    public void testUpdateFromControlUserInput() throws Exception {
        Text control = this.getWidget();
        INumericTextRidget ridget = this.getRidget();
        Display display = control.getDisplay();
        IntegerBean bean = new IntegerBean();
        ridget.bindToModel((Object)bean, "value");
        NumericTextRidgetTest.assertFalse((boolean)ridget.isDirectWriting());
        UITestHelper.sendString((Display)display, (String)"47");
        NumericTextRidgetTest.assertEquals((String)"47", (String)control.getText());
        NumericTextRidgetTest.assertEquals((String)"0", (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((Object)0, (Object)bean.getValue());
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "textInternal", "0", "47"), new PropertyChangeEvent(ridget, "text", "0", "47"));
        UITestHelper.sendString((Display)display, (String)"\r");
        UITestHelper.readAndDispatch((Widget)control);
        this.verifyPropertyChangeEvents();
        NumericTextRidgetTest.assertEquals((String)"47", (String)control.getText());
        NumericTextRidgetTest.assertEquals((String)"47", (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((Object)47, (Object)bean.getValue());
        this.expectNoPropertyChangeEvent();
        UITestHelper.sendString((Display)display, (String)"1");
        this.verifyPropertyChangeEvents();
        NumericTextRidgetTest.assertEquals((String)"471", (String)control.getText());
        NumericTextRidgetTest.assertEquals((String)"47", (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((Object)47, (Object)bean.getValue());
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "textInternal", "47", "471"), new PropertyChangeEvent(ridget, "text", "47", "471"));
        UITestHelper.sendString((Display)display, (String)"\t");
        this.verifyPropertyChangeEvents();
        NumericTextRidgetTest.assertEquals((String)"471", (String)control.getText());
        NumericTextRidgetTest.assertEquals((String)"471", (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((Object)471, (Object)bean.getValue());
    }

    public void testInputNegativeNumber() throws Exception {
        IntegerBean bean = new IntegerBean();
        this.getRidget().setDirectWriting(true);
        this.getRidget().bindToModel((Object)bean, "value");
        NumericTextRidgetTest.assertEquals((Object)0, (Object)bean.getValue());
        UITestHelper.sendString((Display)this.getWidget().getDisplay(), (String)this.minus);
        NumericTextRidgetTest.assertEquals((String)this.minus, (String)this.getWidget().getText());
        NumericTextRidgetTest.assertEquals((Object)0, (Object)bean.getValue());
        UITestHelper.sendString((Display)this.getWidget().getDisplay(), (String)"5");
        NumericTextRidgetTest.assertEquals((String)(String.valueOf(this.minus) + "5"), (String)this.getWidget().getText());
        NumericTextRidgetTest.assertEquals((Object)-5, (Object)bean.getValue());
    }

    public void testInputNegativeNumberInEmptyTextField() throws Exception {
        IntegerBean bean = new IntegerBean();
        this.getRidget().setDirectWriting(true);
        this.getRidget().bindToModel((Object)bean, "value");
        NumericTextRidgetTest.assertEquals((Object)0, (Object)bean.getValue());
        UITestHelper.sendKeyAction((Display)this.getWidget().getDisplay(), (int)127);
        Integer expectedAfterMinus = bean.getValue();
        UITestHelper.sendString((Display)this.getWidget().getDisplay(), (String)this.minus);
        NumericTextRidgetTest.assertEquals((String)this.minus, (String)this.getWidget().getText());
        NumericTextRidgetTest.assertEquals((Object)expectedAfterMinus, (Object)bean.getValue());
        UITestHelper.sendString((Display)this.getWidget().getDisplay(), (String)"5");
        NumericTextRidgetTest.assertEquals((String)(String.valueOf(this.minus) + "5"), (String)this.getWidget().getText());
        NumericTextRidgetTest.assertEquals((Object)-5, (Object)bean.getValue());
    }

    public void testUpdateFromControlUserInputDirectWriting() {
        Text control = this.getWidget();
        INumericTextRidget ridget = this.getRidget();
        IntegerBean bean = new IntegerBean();
        ridget.bindToModel((Object)bean, "value");
        ridget.setDirectWriting(true);
        Display display = control.getDisplay();
        UITestHelper.sendString((Display)display, (String)"4");
        NumericTextRidgetTest.assertEquals((String)"4", (String)control.getText());
        NumericTextRidgetTest.assertEquals((String)"4", (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((Object)4, (Object)bean.getValue());
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "textInternal", "4", "47"), new PropertyChangeEvent(ridget, "text", "4", "47"));
        UITestHelper.sendString((Display)display, (String)"7");
        this.verifyPropertyChangeEvents();
        NumericTextRidgetTest.assertEquals((String)"47", (String)control.getText());
        NumericTextRidgetTest.assertEquals((String)"47", (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((Object)47, (Object)bean.getValue());
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "textInternal", "47", "471"), new PropertyChangeEvent(ridget, "text", "47", "471"));
        UITestHelper.sendString((Display)display, (String)"1");
        this.verifyPropertyChangeEvents();
        NumericTextRidgetTest.assertEquals((String)"471", (String)control.getText());
        NumericTextRidgetTest.assertEquals((String)"471", (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((Object)471, (Object)bean.getValue());
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "textInternal", "471", this.localize("4.711")), new PropertyChangeEvent(ridget, "text", "471", this.localize("4.711")));
        UITestHelper.sendString((Display)display, (String)"1");
        this.verifyPropertyChangeEvents();
        NumericTextRidgetTest.assertEquals((String)this.localize("4.711"), (String)control.getText());
        NumericTextRidgetTest.assertEquals((String)this.localize("4.711"), (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((Object)4711, (Object)bean.getValue());
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "textInternal", this.localize("4.711"), "471"), new PropertyChangeEvent(ridget, "text", this.localize("4.711"), "471"));
        UITestHelper.sendKeyAction((Display)display, (int)0x1000003);
        UITestHelper.sendString((Display)display, (String)"\b");
        this.verifyPropertyChangeEvents();
        NumericTextRidgetTest.assertEquals((String)"471", (String)control.getText());
        NumericTextRidgetTest.assertEquals((String)"471", (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((Object)Integer.valueOf("471"), (Object)bean.getValue());
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "textInternal", "471", "47"), new PropertyChangeEvent(ridget, "text", "471", "47"));
        UITestHelper.sendString((Display)display, (String)String.valueOf('\u007f'));
        this.verifyPropertyChangeEvents();
        NumericTextRidgetTest.assertEquals((String)"47", (String)control.getText());
        NumericTextRidgetTest.assertEquals((String)"47", (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((Object)47, (Object)bean.getValue());
        this.expectNoPropertyChangeEvent();
        bean.setValue(Integer.valueOf(4711));
        this.verifyPropertyChangeEvents();
        NumericTextRidgetTest.assertEquals((String)"47", (String)control.getText());
        NumericTextRidgetTest.assertEquals((String)"47", (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((Object)4711, (Object)bean.getValue());
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "textInternal", "47", "4"), new PropertyChangeEvent(ridget, "text", "47", "4"));
        UITestHelper.sendString((Display)display, (String)"\b");
        this.verifyPropertyChangeEvents();
        NumericTextRidgetTest.assertEquals((String)"4", (String)control.getText());
        NumericTextRidgetTest.assertEquals((String)"4", (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((Object)Integer.valueOf("4"), (Object)bean.getValue());
    }

    public void testUpdateFromRidgetOnRebind() throws Exception {
        Text control = this.getWidget();
        INumericTextRidget ridget = this.getRidget();
        IntegerBean bean = new IntegerBean();
        ridget.bindToModel((Object)bean, "value");
        bean.setValue(INTEGER_ONE);
        ridget.updateFromModel();
        NumericTextRidgetTest.assertEquals((String)INTEGER_ONE.toString(), (String)control.getText());
        NumericTextRidgetTest.assertEquals((String)INTEGER_ONE.toString(), (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((Object)INTEGER_ONE, (Object)bean.getValue());
        ridget.setUIControl(null);
        control.selectAll();
        UITestHelper.sendString((Display)control.getDisplay(), (String)"99");
        NumericTextRidgetTest.assertEquals((String)"99", (String)control.getText());
        NumericTextRidgetTest.assertEquals((String)INTEGER_ONE.toString(), (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((Object)INTEGER_ONE, (Object)bean.getValue());
        ridget.setUIControl((Object)control);
        NumericTextRidgetTest.assertEquals((String)INTEGER_ONE.toString(), (String)control.getText());
        NumericTextRidgetTest.assertEquals((String)INTEGER_ONE.toString(), (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((Object)INTEGER_ONE, (Object)bean.getValue());
        ridget.setUIControl(null);
        bean.setValue(INTEGER_TWO);
        ridget.updateFromModel();
        NumericTextRidgetTest.assertEquals((String)INTEGER_ONE.toString(), (String)control.getText());
        NumericTextRidgetTest.assertEquals((String)INTEGER_TWO.toString(), (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((Object)INTEGER_TWO, (Object)bean.getValue());
        ridget.setUIControl((Object)control);
        NumericTextRidgetTest.assertEquals((String)INTEGER_TWO.toString(), (String)control.getText());
        NumericTextRidgetTest.assertEquals((String)INTEGER_TWO.toString(), (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((Object)INTEGER_TWO, (Object)bean.getValue());
    }

    public void testValidationOnUpdateToModel() throws Exception {
        Text control = this.getWidget();
        INumericTextRidget ridget = this.getRidget();
        IntegerBean bean = new IntegerBean();
        ridget.bindToModel((Object)bean, "value");
        ridget.addValidationRule((IValidator)new MinLength(3), ValidationTime.ON_UPDATE_TO_MODEL);
        bean.setValue(INTEGER_ONE);
        ridget.updateFromModel();
        NumericTextRidgetTest.assertTrue((boolean)ridget.getMarkersOfType(ErrorMarker.class).isEmpty());
        NumericTextRidgetTest.assertEquals((String)INTEGER_ONE.toString(), (String)ridget.getText());
        control.selectAll();
        UITestHelper.sendString((Display)control.getDisplay(), (String)"99\t");
        NumericTextRidgetTest.assertFalse((boolean)ridget.getMarkersOfType(ErrorMarker.class).isEmpty());
        NumericTextRidgetTest.assertEquals((String)"99", (String)ridget.getText());
        this.focusIn(control);
        UITestHelper.sendKeyAction((Display)control.getDisplay(), (int)0x1000008);
        UITestHelper.sendString((Display)control.getDisplay(), (String)"9");
        NumericTextRidgetTest.assertFalse((boolean)ridget.getMarkersOfType(ErrorMarker.class).isEmpty());
        UITestHelper.sendString((Display)control.getDisplay(), (String)"\r");
        NumericTextRidgetTest.assertTrue((boolean)ridget.getMarkersOfType(ErrorMarker.class).isEmpty());
        NumericTextRidgetTest.assertEquals((String)"999", (String)ridget.getText());
    }

    public void testCharactersAreBlockedInControl() throws Exception {
        Text control = this.getWidget();
        INumericTextRidget ridget = this.getRidget();
        IntegerBean bean = new IntegerBean();
        ridget.bindToModel((Object)bean, "value");
        ridget.setDirectWriting(true);
        UITestHelper.sendString((Display)control.getDisplay(), (String)"12");
        NumericTextRidgetTest.assertEquals((String)"12", (String)control.getText());
        NumericTextRidgetTest.assertEquals((String)"12", (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((Object)12, (Object)bean.getValue());
        UITestHelper.sendString((Display)control.getDisplay(), (String)"foo");
        NumericTextRidgetTest.assertEquals((String)"12", (String)control.getText());
        NumericTextRidgetTest.assertEquals((String)"12", (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((Object)12, (Object)bean.getValue());
    }

    public void testValidationOnUpdateFromModelWithOnEditRule() {
        INumericTextRidget ridget = this.getRidget();
        IntegerBean bean = new IntegerBean();
        ridget.bindToModel((Object)bean, "value");
        NumericTextRidgetTest.assertFalse((boolean)ridget.isErrorMarked());
        ridget.addValidationRule((IValidator)new MaxLength(5), ValidationTime.ON_UI_CONTROL_EDIT);
        bean.setValue(Integer.valueOf(123456));
        ridget.updateFromModel();
        NumericTextRidgetTest.assertTrue((boolean)ridget.isErrorMarked());
        NumericTextRidgetTest.assertEquals((String)this.localize("123.456"), (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((String)this.localize("123.456"), (String)this.getWidget().getText());
        NumericTextRidgetTest.assertEquals((Object)123456, (Object)bean.getValue());
        bean.setValue(Integer.valueOf(1234));
        ridget.updateFromModel();
        NumericTextRidgetTest.assertFalse((boolean)ridget.isErrorMarked());
        NumericTextRidgetTest.assertEquals((String)this.localize("1.234"), (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((String)this.localize("1.234"), (String)this.getWidget().getText());
        NumericTextRidgetTest.assertEquals((Object)1234, (Object)bean.getValue());
    }

    public void testValidationOnUpdateFromModelWithOnUpdateRule() {
        INumericTextRidget ridget = this.getRidget();
        IntegerBean bean = new IntegerBean(Integer.valueOf(123456));
        ridget.bindToModel((Object)bean, "value");
        ridget.updateFromModel();
        NumericTextRidgetTest.assertFalse((boolean)ridget.isErrorMarked());
        ridget.addValidationRule((IValidator)new MinLength(5), ValidationTime.ON_UPDATE_TO_MODEL);
        bean.setValue(Integer.valueOf(123));
        ridget.updateFromModel();
        NumericTextRidgetTest.assertTrue((boolean)ridget.isErrorMarked());
        NumericTextRidgetTest.assertEquals((String)"123", (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((String)"123", (String)this.getWidget().getText());
        NumericTextRidgetTest.assertEquals((Object)123, (Object)bean.getValue());
        bean.setValue(Integer.valueOf(1234));
        ridget.updateFromModel();
        NumericTextRidgetTest.assertFalse((boolean)ridget.isErrorMarked());
        NumericTextRidgetTest.assertEquals((String)this.localize("1.234"), (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((String)this.localize("1.234"), (String)this.getWidget().getText());
        NumericTextRidgetTest.assertEquals((Object)1234, (Object)bean.getValue());
    }

    public void testUpdateFromRidgetWithValidationOnEditRule() {
        Text control = this.getWidget();
        INumericTextRidget ridget = this.getRidget();
        IntegerBean bean = new IntegerBean(Integer.valueOf(1234));
        ridget.addValidationRule((IValidator)new MinLength(5), ValidationTime.ON_UI_CONTROL_EDIT);
        ridget.bindToModel((Object)bean, "value");
        NumericTextRidgetTest.assertFalse((boolean)ridget.isErrorMarked());
        NumericTextRidgetTest.assertFalse((boolean)ridget.isDirectWriting());
        UITestHelper.sendString((Display)control.getDisplay(), (String)"98765\t");
        NumericTextRidgetTest.assertFalse((boolean)ridget.isErrorMarked());
        NumericTextRidgetTest.assertEquals((String)this.localize("98.765"), (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((Object)98765, (Object)bean.getValue());
        this.focusIn(control);
        control.selectAll();
        UITestHelper.sendString((Display)control.getDisplay(), (String)"12\t");
        NumericTextRidgetTest.assertTrue((boolean)ridget.isErrorMarked());
        NumericTextRidgetTest.assertEquals((String)"12", (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((Object)98765, (Object)bean.getValue());
        this.focusIn(control);
        control.selectAll();
        UITestHelper.sendString((Display)control.getDisplay(), (String)"43210\t");
        NumericTextRidgetTest.assertFalse((boolean)ridget.isErrorMarked());
        NumericTextRidgetTest.assertEquals((String)this.localize("43.210"), (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((Object)43210, (Object)bean.getValue());
    }

    public void testUpdateFromRidgetWithValidationOnUpdateRule() {
        Text control = this.getWidget();
        INumericTextRidget ridget = this.getRidget();
        IntegerBean bean = new IntegerBean();
        ridget.addValidationRule((IValidator)new EndsWithFive(), ValidationTime.ON_UPDATE_TO_MODEL);
        ridget.bindToModel((Object)bean, "value");
        NumericTextRidgetTest.assertTrue((boolean)ridget.isErrorMarked());
        NumericTextRidgetTest.assertFalse((boolean)ridget.isDirectWriting());
        UITestHelper.sendString((Display)control.getDisplay(), (String)"98765\t");
        NumericTextRidgetTest.assertFalse((boolean)ridget.isErrorMarked());
        NumericTextRidgetTest.assertEquals((String)this.localize("98.765"), (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((Object)98765, (Object)bean.getValue());
        this.focusIn(control);
        control.selectAll();
        UITestHelper.sendString((Display)control.getDisplay(), (String)"98\t");
        NumericTextRidgetTest.assertTrue((boolean)ridget.isErrorMarked());
        NumericTextRidgetTest.assertEquals((String)"98", (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((Object)98765, (Object)bean.getValue());
        this.focusIn(control);
        control.setSelection(2, 2);
        UITestHelper.sendString((Display)control.getDisplay(), (String)"555\t");
        NumericTextRidgetTest.assertFalse((boolean)ridget.isErrorMarked());
        NumericTextRidgetTest.assertEquals((String)this.localize("98.555"), (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((Object)98555, (Object)bean.getValue());
    }

    public void testValidationMessageWithOnEditRule() throws Exception {
        Text control = this.getWidget();
        INumericTextRidget ridget = this.getRidget();
        ridget.addValidationRule((IValidator)new EvenNumberOfCharacters(), ValidationTime.ON_UI_CONTROL_EDIT);
        ridget.setDirectWriting(true);
        ridget.addValidationMessage("ValidationErrorMessage");
        NumericTextRidgetTest.assertEquals((int)0, (int)ridget.getMarkers().size());
        UITestHelper.sendString((Display)control.getDisplay(), (String)"1");
        NumericTextRidgetTest.assertEquals((int)2, (int)ridget.getMarkers().size());
        for (IMarker next : ridget.getMarkers()) {
            NumericTextRidgetTest.assertTrue((boolean)(next instanceof IMessageMarker));
            IMessageMarker marker = (IMessageMarker)next;
            NumericTextRidgetTest.assertTrue((marker.getMessage().equals("ValidationErrorMessage") || marker.getMessage().equals("Odd number of characters.") ? 1 : 0) != 0);
        }
        UITestHelper.sendString((Display)control.getDisplay(), (String)"2");
        NumericTextRidgetTest.assertEquals((int)0, (int)ridget.getMarkers().size());
    }

    public void testValidationMessageWithOnUpdateRule() throws Exception {
        Text control = this.getWidget();
        INumericTextRidget ridget = this.getRidget();
        ridget.bindToModel((Object)new IntegerBean(12345), "value");
        ridget.addValidationRule((IValidator)new EvenNumberOfCharacters(), ValidationTime.ON_UPDATE_TO_MODEL);
        ridget.setDirectWriting(true);
        ridget.addValidationMessage("ValidationErrorMessage");
        NumericTextRidgetTest.assertEquals((int)0, (int)ridget.getMarkers().size());
        UITestHelper.sendString((Display)control.getDisplay(), (String)"1\r");
        NumericTextRidgetTest.assertEquals((int)2, (int)ridget.getMarkers().size());
        TestUtils.assertMessage((IMarkable)ridget, ValidationMessageMarker.class, "ValidationErrorMessage");
        UITestHelper.sendString((Display)control.getDisplay(), (String)"2\r");
        NumericTextRidgetTest.assertEquals((int)0, (int)ridget.getMarkers().size());
    }

    public void testRevalidateOnEditRule() {
        INumericTextRidget ridget = this.getRidget();
        ridget.bindToModel((Object)new IntegerBean(123), "value");
        ridget.updateFromModel();
        NumericTextRidgetTest.assertFalse((boolean)ridget.isErrorMarked());
        EvenNumberOfCharacters rule = new EvenNumberOfCharacters();
        ridget.addValidationRule((IValidator)rule, ValidationTime.ON_UI_CONTROL_EDIT);
        NumericTextRidgetTest.assertFalse((boolean)ridget.isErrorMarked());
        boolean isOk1 = ridget.revalidate();
        NumericTextRidgetTest.assertFalse((boolean)isOk1);
        NumericTextRidgetTest.assertTrue((boolean)ridget.isErrorMarked());
        ridget.removeValidationRule((IValidator)rule);
        NumericTextRidgetTest.assertFalse((boolean)ridget.isErrorMarked());
        boolean isOk2 = ridget.revalidate();
        NumericTextRidgetTest.assertTrue((boolean)isOk2);
        NumericTextRidgetTest.assertFalse((boolean)ridget.isErrorMarked());
    }

    public void testRevalidateOnUpdateRule() {
        INumericTextRidget ridget = this.getRidget();
        ridget.bindToModel((Object)new IntegerBean(123), "value");
        ridget.updateFromModel();
        NumericTextRidgetTest.assertFalse((boolean)ridget.isErrorMarked());
        EvenNumberOfCharacters rule = new EvenNumberOfCharacters();
        ridget.addValidationRule((IValidator)rule, ValidationTime.ON_UPDATE_TO_MODEL);
        NumericTextRidgetTest.assertFalse((boolean)ridget.isErrorMarked());
        boolean isOk1 = ridget.revalidate();
        NumericTextRidgetTest.assertFalse((boolean)isOk1);
        NumericTextRidgetTest.assertTrue((boolean)ridget.isErrorMarked());
        ridget.removeValidationRule((IValidator)rule);
        NumericTextRidgetTest.assertFalse((boolean)ridget.isErrorMarked());
        boolean isOk2 = ridget.revalidate();
        NumericTextRidgetTest.assertTrue((boolean)isOk2);
        NumericTextRidgetTest.assertFalse((boolean)ridget.isErrorMarked());
    }

    public void testRevalidateDoesUpdate() {
        INumericTextRidget ridget = this.getRidget();
        Text control = this.getWidget();
        EvenNumberOfCharacters evenChars = new EvenNumberOfCharacters();
        ridget.addValidationRule((IValidator)evenChars, ValidationTime.ON_UI_CONTROL_EDIT);
        IntegerBean bean = new IntegerBean(12);
        ridget.bindToModel((Object)bean, "value");
        ridget.updateFromModel();
        NumericTextRidgetTest.assertFalse((boolean)ridget.isErrorMarked());
        this.focusIn(control);
        control.selectAll();
        UITestHelper.sendString((Display)control.getDisplay(), (String)"345\t");
        NumericTextRidgetTest.assertEquals((String)"345", (String)control.getText());
        NumericTextRidgetTest.assertEquals((String)"345", (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((Object)12, (Object)bean.getValue());
        NumericTextRidgetTest.assertTrue((boolean)ridget.isErrorMarked());
        ridget.removeValidationRule((IValidator)evenChars);
        ridget.revalidate();
        NumericTextRidgetTest.assertFalse((boolean)ridget.isErrorMarked());
        NumericTextRidgetTest.assertEquals((String)"345", (String)control.getText());
        NumericTextRidgetTest.assertEquals((String)"345", (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((Object)345, (Object)bean.getValue());
    }

    public void testReValidationOnUpdateFromModel() {
        INumericTextRidget ridget = this.getRidget();
        IntegerBean bean = new IntegerBean(12);
        ridget.bindToModel((Object)bean, "value");
        ridget.updateFromModel();
        NumericTextRidgetTest.assertFalse((boolean)ridget.isErrorMarked());
        NumericTextRidgetTest.assertEquals((String)"12", (String)ridget.getText());
        EvenNumberOfCharacters rule = new EvenNumberOfCharacters();
        ridget.addValidationRule((IValidator)rule, ValidationTime.ON_UI_CONTROL_EDIT);
        bean.setValue(Integer.valueOf(321));
        ridget.updateFromModel();
        NumericTextRidgetTest.assertTrue((boolean)ridget.isErrorMarked());
        NumericTextRidgetTest.assertEquals((Object)321, (Object)bean.getValue());
        NumericTextRidgetTest.assertEquals((String)"321", (String)ridget.getText());
        ridget.removeValidationRule((IValidator)rule);
        ridget.updateFromModel();
        NumericTextRidgetTest.assertFalse((boolean)ridget.isErrorMarked());
        NumericTextRidgetTest.assertEquals((Object)321, (Object)bean.getValue());
        NumericTextRidgetTest.assertEquals((String)"321", (String)ridget.getText());
    }

    public void testControlNotEditableWithOutputMarker() {
        INumericTextRidget ridget = this.getRidget();
        Text control = this.getWidget();
        NumericTextRidgetTest.assertTrue((boolean)control.getEditable());
        ridget.setOutputOnly(true);
        NumericTextRidgetTest.assertFalse((boolean)control.getEditable());
        ridget.setOutputOnly(false);
        NumericTextRidgetTest.assertTrue((boolean)control.getEditable());
    }

    public void testOutputMultipleSelectionCannotBeChangedFromUI() {
        INumericTextRidget ridget = this.getRidget();
        Text control = this.getWidget();
        NumericTextRidgetTest.assertEquals((String)"0", (String)control.getText());
        NumericTextRidgetTest.assertEquals((String)"0", (String)ridget.getText());
        ridget.setOutputOnly(true);
        control.selectAll();
        this.focusIn(control);
        UITestHelper.sendString((Display)control.getDisplay(), (String)"123\t");
        NumericTextRidgetTest.assertEquals((String)"0", (String)control.getText());
        NumericTextRidgetTest.assertEquals((String)"0", (String)ridget.getText());
        ridget.setOutputOnly(false);
        control.selectAll();
        this.focusIn(control);
        UITestHelper.sendString((Display)control.getDisplay(), (String)"123\t");
        NumericTextRidgetTest.assertEquals((String)"123", (String)control.getText());
        NumericTextRidgetTest.assertEquals((String)"123", (String)ridget.getText());
    }

    public void testDisabledHasNoTextFromModel() {
        if (!MarkerSupport.isHideDisabledRidgetContent()) {
            System.out.println("Skipping TextRidgetTest2.testDisabledHasNoTextFromModel()");
            return;
        }
        INumericTextRidget ridget = this.getRidget();
        Text control = this.getWidget();
        IntegerBean bean = new IntegerBean(INTEGER_TWO);
        ridget.bindToModel((Object)bean, "value");
        ridget.updateFromModel();
        NumericTextRidgetTest.assertTrue((boolean)ridget.isEnabled());
        NumericTextRidgetTest.assertEquals((String)INTEGER_TWO.toString(), (String)control.getText());
        NumericTextRidgetTest.assertEquals((String)INTEGER_TWO.toString(), (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((Object)INTEGER_TWO, (Object)bean.getValue());
        ridget.setEnabled(false);
        NumericTextRidgetTest.assertEquals((String)"", (String)control.getText());
        NumericTextRidgetTest.assertEquals((String)INTEGER_TWO.toString(), (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((Object)INTEGER_TWO, (Object)bean.getValue());
        bean.setValue(INTEGER_ONE);
        ridget.updateFromModel();
        NumericTextRidgetTest.assertEquals((String)"", (String)control.getText());
        NumericTextRidgetTest.assertEquals((String)INTEGER_ONE.toString(), (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((Object)INTEGER_ONE, (Object)bean.getValue());
        ridget.setEnabled(true);
        NumericTextRidgetTest.assertEquals((String)INTEGER_ONE.toString(), (String)control.getText());
        NumericTextRidgetTest.assertEquals((String)INTEGER_ONE.toString(), (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((Object)INTEGER_ONE, (Object)bean.getValue());
    }

    public void testMaxLengthWithRule() throws Exception {
        INumericTextRidget ridget = this.getRidget();
        Text control = this.getWidget();
        ridget.addValidationRule((IValidator)new MaxNumberLength(5), ValidationTime.ON_UI_CONTROL_EDIT);
        this.focusIn(control);
        UITestHelper.sendString((Display)control.getDisplay(), (String)"1234");
        NumericTextRidgetTest.assertEquals((String)this.localize("1.234"), (String)control.getText());
        this.focusOut(control);
        NumericTextRidgetTest.assertEquals((String)this.localize("1.234"), (String)ridget.getText());
        this.focusIn(control);
        control.setSelection(control.getText().length());
        UITestHelper.sendString((Display)control.getDisplay(), (String)"5");
        NumericTextRidgetTest.assertEquals((String)this.localize("12.345"), (String)control.getText());
        this.focusOut(control);
        NumericTextRidgetTest.assertEquals((String)this.localize("12.345"), (String)control.getText());
        this.focusIn(control);
        control.setSelection(control.getText().length());
        UITestHelper.sendString((Display)control.getDisplay(), (String)"6");
        NumericTextRidgetTest.assertEquals((String)this.localize("12.345"), (String)control.getText());
        this.focusOut(control);
        NumericTextRidgetTest.assertEquals((String)this.localize("12.345"), (String)control.getText());
    }

    public void testSetMarkNegative() {
        INumericTextRidget ridget = this.getRidget();
        NumericTextRidgetTest.assertTrue((boolean)ridget.isMarkNegative());
        ridget.setMarkNegative(false);
        NumericTextRidgetTest.assertFalse((boolean)ridget.isMarkNegative());
        ridget.setMarkNegative(true);
        NumericTextRidgetTest.assertTrue((boolean)ridget.isMarkNegative());
    }

    public void testNegativeMarkerFromSetText() {
        INumericTextRidget ridget = this.getRidget();
        ridget.setMarkNegative(true);
        ridget.setText("100");
        NumericTextRidgetTest.assertEquals((int)0, (int)ridget.getMarkersOfType(NegativeMarker.class).size());
        ridget.setText("-100");
        NumericTextRidgetTest.assertEquals((int)1, (int)ridget.getMarkersOfType(NegativeMarker.class).size());
        ridget.setText("0");
        NumericTextRidgetTest.assertEquals((int)0, (int)ridget.getMarkersOfType(NegativeMarker.class).size());
        ridget.setText("-0");
        NumericTextRidgetTest.assertEquals((int)0, (int)ridget.getMarkersOfType(NegativeMarker.class).size());
        ridget.setText("-1");
        ridget.setMarkNegative(false);
        NumericTextRidgetTest.assertEquals((int)0, (int)ridget.getMarkersOfType(NegativeMarker.class).size());
        ridget.setMarkNegative(true);
        NumericTextRidgetTest.assertEquals((int)1, (int)ridget.getMarkersOfType(NegativeMarker.class).size());
    }

    public void testNegativeMarkerFromControl() {
        INumericTextRidget ridget = this.getRidget();
        Text control = this.getWidget();
        Display display = control.getDisplay();
        ridget.setMarkNegative(true);
        NumericTextRidgetTest.assertEquals((int)0, (int)ridget.getMarkersOfType(NegativeMarker.class).size());
        control.setFocus();
        UITestHelper.sendString((Display)display, (String)"123-\r");
        NumericTextRidgetTest.assertEquals((int)1, (int)ridget.getMarkersOfType(NegativeMarker.class).size());
        control.setSelection(0, 0);
        UITestHelper.sendKeyAction((Display)display, (int)127);
        UITestHelper.sendString((Display)display, (String)"\r");
        NumericTextRidgetTest.assertEquals((int)0, (int)ridget.getMarkersOfType(NegativeMarker.class).size());
        UITestHelper.sendString((Display)display, (String)"-\r");
        NumericTextRidgetTest.assertEquals((int)1, (int)ridget.getMarkersOfType(NegativeMarker.class).size());
    }

    public void testRemoveLeadingCruft() {
        NumericTextRidgetTest.assertEquals((String)"-", (String)NumericTextRidget.removeLeadingCruft((String)"-"));
        NumericTextRidgetTest.assertEquals((String)"-", (String)NumericTextRidget.removeLeadingCruft((String)"-0"));
        NumericTextRidgetTest.assertEquals((String)"0", (String)NumericTextRidget.removeLeadingCruft((String)"0"));
        NumericTextRidgetTest.assertEquals((String)"-1", (String)NumericTextRidget.removeLeadingCruft((String)"-01"));
        NumericTextRidgetTest.assertEquals((String)"-10", (String)NumericTextRidget.removeLeadingCruft((String)"-010"));
        NumericTextRidgetTest.assertEquals((String)"-101", (String)NumericTextRidget.removeLeadingCruft((String)"-0101"));
        NumericTextRidgetTest.assertEquals((String)"-23", (String)NumericTextRidget.removeLeadingCruft((String)"-0023"));
        NumericTextRidgetTest.assertEquals((String)"1", (String)NumericTextRidget.removeLeadingCruft((String)"01"));
        NumericTextRidgetTest.assertEquals((String)"10", (String)NumericTextRidget.removeLeadingCruft((String)"010"));
        NumericTextRidgetTest.assertEquals((String)"101", (String)NumericTextRidget.removeLeadingCruft((String)"0101"));
        NumericTextRidgetTest.assertEquals((String)"23", (String)NumericTextRidget.removeLeadingCruft((String)"0023"));
    }

    public void testDelete() {
        INumericTextRidget ridget = this.getRidget();
        ridget.setGrouping(true);
        ridget.setSigned(true);
        this.assertText("1^.234", 127, "1^34");
        this.assertText("^1.234", 127, "^234");
        this.assertText("12^.345", 127, "1.2^45");
        this.assertText("1.234^.567", 127, "123.4^67");
        this.assertText("1.234.5^67", 127, "123.45^7");
        this.assertText("-1^.234", 127, "-1^34");
        this.assertText("-^1.234", 127, "-^234");
        this.assertText("-1.234.5^67", 127, "-123.45^7");
    }

    public void testBackspace() {
        INumericTextRidget ridget = this.getRidget();
        ridget.setGrouping(true);
        ridget.setSigned(true);
        this.assertText("123.^456", "\b", "12^.456");
        this.assertText("1.^456", "\b", "^456");
        this.assertText("1.234.^567", "\b", "123^.567");
        this.assertText("1.23^4", "\b", "12^4");
        this.assertText("1.234.56^7", "\b", "123.45^7");
        this.assertText("-1.23^4", "\b", "-12^4");
        this.assertText("-1^.234", "\b", "-^234");
        this.assertText("-1.234.56^7", "\b", "-123.45^7");
    }

    public void testMandatoryMarker() {
        INumericTextRidget ridget = this.getRidget();
        ridget.setMandatory(true);
        ridget.setText("123");
        TestUtils.assertMandatoryMarker((IMarkableRidget)ridget, 1, true);
        ridget.setText(null);
        TestUtils.assertMandatoryMarker((IMarkableRidget)ridget, 1, false);
        ridget.setMandatory(false);
        TestUtils.assertMandatoryMarker((IMarkableRidget)ridget, 0, false);
    }

    public void testGetSetMaxLength() {
        INumericTextRidget ridget = this.getRidget();
        try {
            ridget.setMaxLength(0);
            NumericTextRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        Integer oldValue = ridget.getMaxLength();
        this.expectPropertyChangeEvent("maxLength", oldValue, 5);
        ridget.setMaxLength(5);
        this.verifyPropertyChangeEvents();
        NumericTextRidgetTest.assertEquals((int)5, (int)ridget.getMaxLength());
        this.expectNoPropertyChangeEvent();
        ridget.setMaxLength(5);
        this.verifyPropertyChangeEvents();
    }

    public void testResetMaxLengthToUnlimited() {
        INumericTextRidget ridget = this.getRidget();
        Integer oldValue = ridget.getMaxLength();
        this.expectPropertyChangeEvent("maxLength", oldValue, 5);
        ridget.setMaxLength(5);
        this.verifyPropertyChangeEvents();
        NumericTextRidgetTest.assertEquals((int)5, (int)ridget.getMaxLength());
        oldValue = ridget.getMaxLength();
        this.expectPropertyChangeEvent("maxLength", oldValue, -1);
        ridget.setMaxLength(-1);
        NumericTextRidgetTest.assertEquals((int)-1, (int)ridget.getMaxLength());
        this.verifyPropertyChangeEvents();
    }

    public void testMaxLength() {
        INumericTextRidget ridget = this.getRidget();
        Text control = this.getWidget();
        ridget.setMaxLength(6);
        StringBean bean = new StringBean();
        ridget.bindToModel((Object)bean, "value");
        control.setFocus();
        UITestHelper.sendString((Display)control.getDisplay(), (String)this.localize("12345678-\r"));
        NumericTextRidgetTest.assertEquals((String)this.localize("-123.456"), (String)control.getText());
        NumericTextRidgetTest.assertEquals((String)this.localize("-123.456"), (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((String)this.localize("-123.456"), (String)bean.getValue());
        boolean exception = false;
        try {
            ridget.setMaxLength(-2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exception = true;
        }
        NumericTextRidgetTest.assertTrue((boolean)exception);
        exception = false;
        try {
            ridget.setMaxLength(-1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exception = true;
        }
        NumericTextRidgetTest.assertFalse((boolean)exception);
    }

    public void testExceedMaxLengthWithSetText() {
        INumericTextRidget ridget = this.getRidget();
        Text control = this.getWidget();
        ridget.setMaxLength(3);
        NumericTextRidgetTest.assertEquals((int)3, (int)ridget.getMaxLength());
        ridget.setText(this.localize("-123"));
        try {
            ridget.setText(this.localize("1234"));
            NumericTextRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            NumericTextRidgetTest.assertEquals((String)this.localize("-123"), (String)ridget.getText());
            NumericTextRidgetTest.assertEquals((String)this.localize("-123"), (String)control.getText());
        }
    }

    public void testExceedMaxLengthWithUpdate() {
        INumericTextRidget ridget = this.getRidget();
        Text control = this.getWidget();
        ridget.setMaxLength(3);
        NumericTextRidgetTest.assertEquals((int)3, (int)ridget.getMaxLength());
        DoubleBean value = new DoubleBean(123.0);
        ridget.bindToModel((Object)value, "value");
        ridget.updateFromModel();
        try {
            value.setValue(Double.valueOf(1234.12));
            ridget.updateFromModel();
            NumericTextRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            NumericTextRidgetTest.assertEquals((String)this.localize("123"), (String)ridget.getText());
            NumericTextRidgetTest.assertEquals((String)this.localize("123"), (String)control.getText());
        }
        value.setValue(Double.valueOf(-321.0));
        ridget.updateFromModel();
        try {
            value.setValue(Double.valueOf(1234.0));
            ridget.updateFromModel();
            NumericTextRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            NumericTextRidgetTest.assertEquals((String)this.localize("-321"), (String)ridget.getText());
            NumericTextRidgetTest.assertEquals((String)this.localize("-321"), (String)control.getText());
        }
    }

    public void testSetConvertEmptyToZero() {
        INumericTextRidget ridget = this.getRidget();
        NumericTextRidgetTest.assertFalse((boolean)ridget.isConvertEmptyToZero());
        ridget.setConvertEmptyToZero(true);
        NumericTextRidgetTest.assertTrue((boolean)ridget.isConvertEmptyToZero());
        ridget.setConvertEmptyToZero(false);
        NumericTextRidgetTest.assertFalse((boolean)ridget.isConvertEmptyToZero());
    }

    public void testSetConvertEmptyToZeroWithSetText() {
        INumericTextRidget ridget = this.getRidget();
        Text control = this.getWidget();
        ridget.setText(null);
        NumericTextRidgetTest.assertEquals((String)"", (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((String)"", (String)control.getText());
        ridget.setText("");
        NumericTextRidgetTest.assertEquals((String)"", (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((String)"", (String)control.getText());
        ridget.setConvertEmptyToZero(true);
        NumericTextRidgetTest.assertEquals((String)"", (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((String)"0", (String)control.getText());
        ridget.setText(null);
        NumericTextRidgetTest.assertEquals((String)"", (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((String)"0", (String)control.getText());
        ridget.setText("");
        NumericTextRidgetTest.assertEquals((String)"", (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((String)"0", (String)control.getText());
        ridget.setText("0");
        NumericTextRidgetTest.assertEquals((String)"0", (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((String)"0", (String)control.getText());
    }

    public void testSetConvertEmptyDoubleToZeroWithUpdate() {
        INumericTextRidget ridget = this.getRidget();
        Text control = this.getWidget();
        ridget.setConvertEmptyToZero(true);
        IntegerBean integerBean = new IntegerBean(null);
        ridget.bindToModel((Object)integerBean, "value");
        ridget.updateFromModel();
        NumericTextRidgetTest.assertEquals((String)"", (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((String)"0", (String)control.getText());
        integerBean.setValue(Integer.valueOf(3141));
        ridget.updateFromModel();
        NumericTextRidgetTest.assertEquals((String)this.localize("3.141"), (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((String)this.localize("3.141"), (String)control.getText());
        integerBean.setValue(Integer.valueOf(0));
        ridget.updateFromModel();
        NumericTextRidgetTest.assertEquals((String)"0", (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((String)"0", (String)control.getText());
    }

    public void testSetConvertEmptyStringToZeroWithUpdate() {
        INumericTextRidget ridget = this.getRidget();
        Text control = this.getWidget();
        ridget.setConvertEmptyToZero(true);
        StringBean stringBean = new StringBean(null);
        ridget.bindToModel((Object)stringBean, "value");
        ridget.updateFromModel();
        NumericTextRidgetTest.assertEquals((String)"", (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((String)"0", (String)control.getText());
        stringBean.setValue(this.localize("3141"));
        ridget.updateFromModel();
        NumericTextRidgetTest.assertEquals((String)this.localize("3.141"), (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((String)this.localize("3.141"), (String)control.getText());
        stringBean.setValue("");
        ridget.updateFromModel();
        NumericTextRidgetTest.assertEquals((String)"", (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((String)"0", (String)control.getText());
        stringBean.setValue("0");
        ridget.updateFromModel();
        NumericTextRidgetTest.assertEquals((String)"0", (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((String)"0", (String)control.getText());
    }

    public void testSetConvertEmptyToZeroWithMandatoryMarker() {
        INumericTextRidget ridget = this.getRidget();
        ridget.setMandatory(true);
        ridget.setText("");
        TestUtils.assertMandatoryMarker((IMarkableRidget)ridget, 1, false);
        ridget.setConvertEmptyToZero(true);
        ridget.setText(null);
        TestUtils.assertMandatoryMarker((IMarkableRidget)ridget, 1, false);
        ridget.setText("1");
        TestUtils.assertMandatoryMarker((IMarkableRidget)ridget, 1, true);
    }

    public void testSetConvertEmptyToZeroDoesNotInterfereWithHiddenValue() {
        INumericTextRidget ridget = this.getRidget();
        Text control = this.getWidget();
        ridget.setText("1");
        NumericTextRidgetTest.assertEquals((String)"1", (String)control.getText());
        ridget.setEnabled(false);
        NumericTextRidgetTest.assertEquals((String)"", (String)control.getText());
        ridget.setConvertEmptyToZero(true);
        NumericTextRidgetTest.assertEquals((String)"", (String)control.getText());
        ridget.setText(null);
        NumericTextRidgetTest.assertEquals((String)"", (String)control.getText());
        ridget.setEnabled(true);
        NumericTextRidgetTest.assertEquals((String)"", (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((String)"0", (String)control.getText());
    }

    public void testSetConvertEmptyToZeroWhenLosingFocus() {
        INumericTextRidget ridget = this.getRidget();
        Text control = this.getWidget();
        ridget.setText(this.localize("3.141"));
        ridget.setConvertEmptyToZero(true);
        NumericTextRidgetTest.assertEquals((String)this.localize("3.141"), (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((String)this.localize("3.141"), (String)control.getText());
        control.selectAll();
        control.setFocus();
        UITestHelper.sendString((Display)control.getDisplay(), (String)"\b\t");
        NumericTextRidgetTest.assertEquals((String)"0", (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((String)"0", (String)control.getText());
        ridget.setConvertEmptyToZero(false);
        control.selectAll();
        control.setFocus();
        UITestHelper.sendString((Display)control.getDisplay(), (String)"\b\t");
        NumericTextRidgetTest.assertEquals((String)"", (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((String)"", (String)control.getText());
    }

    private void assertText(String before, String keySeq, String after) {
        TestUtils.assertText(this.getWidget(), this.localize(before), keySeq, this.localize(after));
    }

    private void assertText(String before, int keyCode, String after) {
        TestUtils.assertText(this.getWidget(), this.localize(before), keyCode, this.localize(after));
    }

    private void focusIn(Text control) {
        control.setFocus();
        NumericTextRidgetTest.assertTrue((boolean)control.isFocusControl());
    }

    private void focusOut(Text control) {
        UITestHelper.sendString((Display)control.getDisplay(), (String)"\t");
        NumericTextRidgetTest.assertFalse((boolean)control.isFocusControl());
    }

    private String localize(String number) {
        return TestUtils.getLocalizedNumber(number);
    }

    private static final class EndsWithFive
    implements IValidator {
        private EndsWithFive() {
        }

        public IStatus validate(Object value) {
            boolean isOk = false;
            String s = null;
            if (value instanceof Number) {
                s = ((Number)value).toString();
            } else if (value instanceof String) {
                s = (String)value;
            }
            if (s != null) {
                char lastChar = s.charAt(s.length() - 1);
                isOk = lastChar == '5';
            }
            return isOk ? Status.OK_STATUS : Status.CANCEL_STATUS;
        }
    }

    private static final class EvenNumberOfCharacters
    implements IValidator {
        private EvenNumberOfCharacters() {
        }

        public IStatus validate(Object value) {
            if (value == null) {
                return ValidationRuleStatus.ok();
            }
            if (value instanceof String) {
                String string = (String)value;
                if (string.length() % 2 == 0) {
                    return ValidationRuleStatus.ok();
                }
                return ValidationRuleStatus.error((boolean)false, (String)"Odd number of characters.");
            }
            throw new ValidationFailure(String.valueOf(this.getClass().getName()) + " can only validate objects of type " + String.class.getName());
        }
    }
}

