/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.security.services.itest.authorization;

import java.io.FilePermission;
import java.net.URL;
import java.security.AccessControlException;
import java.security.Permission;
import java.security.Permissions;
import java.security.Principal;
import java.util.Set;
import org.eclipse.equinox.security.auth.ILoginContext;
import org.eclipse.equinox.security.auth.LoginContextFactory;
import org.eclipse.riena.communication.core.IRemoteServiceRegistration;
import org.eclipse.riena.communication.core.factory.Register;
import org.eclipse.riena.core.service.Service;
import org.eclipse.riena.core.test.RienaTestCase;
import org.eclipse.riena.core.test.collect.IntegrationTestCase;
import org.eclipse.riena.core.util.Iter;
import org.eclipse.riena.internal.tests.Activator;
import org.eclipse.riena.sample.app.common.model.Customer;
import org.eclipse.riena.sample.app.common.model.CustomersPermission;
import org.eclipse.riena.sample.app.common.model.ICustomerSearch;
import org.eclipse.riena.security.authentication.callbackhandler.TestLocalCallbackHandler;
import org.eclipse.riena.security.common.authentication.IAuthenticationService;
import org.eclipse.riena.security.common.authorization.IAuthorizationService;
import org.osgi.framework.ServiceReference;

@IntegrationTestCase
public class AuthorizationServiceITest
extends RienaTestCase {
    private IRemoteServiceRegistration authenticationServiceRegistration;
    private IRemoteServiceRegistration authorizationServiceRegistration;
    private IRemoteServiceRegistration customerServiceRegistration;
    private static final String JAAS_CONFIG_FILE = "config/sample_jaas.config";

    protected void setUp() throws Exception {
        super.setUp();
        this.startBundles("org\\.eclipse\\.riena.communication.core", null);
        this.startBundles("org\\.eclipse\\.riena.communication.factory.hessian", null);
        this.startBundles("org\\.eclipse\\.riena.communication.registry", null);
        this.stopBundles("org\\.eclipse\\.riena.example.client", null);
        this.stopBundles("org\\.eclipse\\.riena.security.client.startup", null);
        this.authenticationServiceRegistration = Register.remoteProxy(IAuthenticationService.class).usingUrl("http://localhost:8080/hessian/AuthenticationService").withProtocol("hessian").andStart(Activator.getDefault().getContext());
        this.authorizationServiceRegistration = Register.remoteProxy(IAuthorizationService.class).usingUrl("http://localhost:8080/hessian/AuthorizationService").withProtocol("hessian").andStart(Activator.getDefault().getContext());
        this.customerServiceRegistration = Register.remoteProxy(ICustomerSearch.class).usingUrl("http://localhost:8080/hessian/CustomerSearchWS").withProtocol("hessian").andStart(Activator.getDefault().getContext());
    }

    protected void tearDown() throws Exception {
        this.authenticationServiceRegistration.unregister();
        this.authorizationServiceRegistration.unregister();
        this.customerServiceRegistration.unregister();
        super.tearDown();
    }

    public void testLoginWithUserWithRights() throws Exception {
        this.printTestName();
        TestLocalCallbackHandler.setSuppliedCredentials("testuser", "testpass");
        URL configUrl = Activator.getDefault().getContext().getBundle().getEntry(JAAS_CONFIG_FILE);
        ILoginContext secureContext = LoginContextFactory.createContext((String)"RemoteTest", (URL)configUrl);
        secureContext.login();
        IAuthenticationService as = (IAuthenticationService)Service.get(IAuthenticationService.class);
        System.out.println("subject:" + secureContext.getSubject());
        System.out.println("login in sucessful");
        ICustomerSearch cs = (ICustomerSearch)Service.get(ICustomerSearch.class);
        Customer cust = new Customer();
        cust.setLastName("Solo");
        cust.setFirstName("Han");
        cust.setCustomerNumber(Integer.valueOf(1));
        Customer[] foundCustomers = cs.findCustomerWithPermission(cust);
        AuthorizationServiceITest.assertTrue((foundCustomers != null ? 1 : 0) != 0);
        AuthorizationServiceITest.assertTrue((foundCustomers.length > 0 ? 1 : 0) != 0);
        AuthorizationServiceITest.assertTrue((boolean)foundCustomers[0].getLastName().equals("Solo"));
        as.logout();
        System.out.println("logoff sucessful");
    }

    public void testLoginWithUserWithoutRights() throws Exception {
        this.printTestName();
        TestLocalCallbackHandler.setSuppliedCredentials("testuser1", "testpass2");
        URL configUrl = Activator.getDefault().getContext().getBundle().getEntry(JAAS_CONFIG_FILE);
        ILoginContext secureContext = LoginContextFactory.createContext((String)"RemoteTest", (URL)configUrl);
        secureContext.login();
        ServiceReference ref = this.getContext().getServiceReference(IAuthenticationService.class.getName());
        IAuthenticationService as = (IAuthenticationService)this.getContext().getService(ref);
        System.out.println("subject:" + secureContext.getSubject());
        System.out.println("login in sucessful");
        try {
            ICustomerSearch cs = (ICustomerSearch)this.getContext().getService(this.getContext().getServiceReference(ICustomerSearch.class.getName()));
            Customer cust = new Customer();
            cust.setLastName("Solo");
            cust.setFirstName("Han");
            cust.setCustomerNumber(Integer.valueOf(1));
            cs.findCustomerWithPermission(cust);
            AuthorizationServiceITest.fail((String)"findCustomerWithPermission must not work for testuser1 since it has to authorization");
        }
        catch (AccessControlException accessControlException) {
            this.ok("expected exception");
        }
        as.logout();
        System.out.println("logoff sucessful");
    }

    public void testLoginWithUserWithRightsAndGetPermissions() throws Exception {
        this.printTestName();
        TestLocalCallbackHandler.setSuppliedCredentials("stefan", "passpass");
        URL configUrl = Activator.getDefault().getContext().getBundle().getEntry(JAAS_CONFIG_FILE);
        ILoginContext secureContext = LoginContextFactory.createContext((String)"RemoteTest", (URL)configUrl);
        secureContext.login();
        ServiceReference ref = this.getContext().getServiceReference(IAuthenticationService.class.getName());
        IAuthenticationService authenticationService = (IAuthenticationService)this.getContext().getService(ref);
        System.out.println("subject:" + secureContext.getSubject());
        System.out.println("login in sucessful");
        try {
            ServiceReference authorizationServiceRef = this.getContext().getServiceReference(IAuthorizationService.class.getName());
            IAuthorizationService authorizationService = (IAuthorizationService)this.getContext().getService(authorizationServiceRef);
            Set<Principal> principals = secureContext.getSubject().getPrincipals();
            AuthorizationServiceITest.assertEquals((int)1, (int)principals.size());
            Permissions[] permissionss = authorizationService.getPermissions(principals.toArray(new Principal[principals.size()]));
            AuthorizationServiceITest.assertNotNull((Object)permissionss);
            AuthorizationServiceITest.assertEquals((int)1, (int)permissionss.length);
            Permissions permissions = permissionss[0];
            AuthorizationServiceITest.assertNotNull((Object)permissions);
            int count = 0;
            for (Permission permission : Iter.able(permissions.elements())) {
                System.out.println("Permission: " + permission);
                if (permission.getClass() == FilePermission.class) {
                    AuthorizationServiceITest.assertEquals((String)"*.tmp", (String)permission.getName());
                    AuthorizationServiceITest.assertEquals((String)"write", (String)permission.getActions());
                } else if (permission.getClass() == CustomersPermission.class) {
                    AuthorizationServiceITest.assertTrue((permission.getActions().equals("find") || permission.getActions().equals("create") ? 1 : 0) != 0);
                    AuthorizationServiceITest.assertTrue((permission.getName().equals("riena.sample.A") || permission.getName().equals("riena.sample.B") ? 1 : 0) != 0);
                } else {
                    AuthorizationServiceITest.fail((String)("Unexpected permission: " + permission));
                }
                ++count;
            }
            AuthorizationServiceITest.assertEquals((int)3, (int)count);
        }
        finally {
            authenticationService.logout();
            System.out.println("logoff sucessful");
        }
        new FilePermission("", "delete");
    }
}

