/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.utils;

import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URI;
import java.net.URL;
import javax.imageio.ImageIO;
import junit.framework.TestCase;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.riena.core.test.collect.UITestCase;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultLnf;
import org.eclipse.riena.ui.swt.utils.ImageFileExtension;
import org.eclipse.riena.ui.swt.utils.ImageStore;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

@UITestCase
public class SwtUtilitiesTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
        ReflectionUtils.setHidden(SwtUtilities.class, (String)"cachedDpiFactors", (Object)new float[]{0.0f, 0.0f});
    }

    protected void tearDown() throws Exception {
        ReflectionUtils.setHidden(SwtUtilities.class, (String)"cachedDpiFactors", (Object)new float[]{0.0f, 0.0f});
        super.tearDown();
    }

    public void testIsDisposedWidget() {
        Shell shell = new Shell();
        Label label = new Label((Composite)shell, 0);
        SwtUtilitiesTest.assertFalse((boolean)SwtUtilities.isDisposed((Widget)label));
        label.dispose();
        SwtUtilitiesTest.assertTrue((boolean)SwtUtilities.isDisposed((Widget)label));
        label = null;
        SwtUtilitiesTest.assertTrue((boolean)SwtUtilities.isDisposed((Widget)label));
        shell.dispose();
        SwtUtilitiesTest.assertTrue((boolean)SwtUtilities.isDisposed((Widget)shell));
        shell = null;
        SwtUtilitiesTest.assertTrue((boolean)SwtUtilities.isDisposed((Widget)shell));
    }

    public void testIsDisposedResource() {
        Color color = new Color((Device)Display.getCurrent(), 0, 0, 0);
        SwtUtilitiesTest.assertFalse((boolean)SwtUtilities.isDisposed((Resource)color));
        color.dispose();
        SwtUtilitiesTest.assertTrue((boolean)SwtUtilities.isDisposed((Resource)color));
        color = null;
        SwtUtilitiesTest.assertTrue((boolean)SwtUtilities.isDisposed((Resource)color));
    }

    public void testGetDpiFactors() throws Exception {
        float[] defaultFactors = SwtUtilities.getDpiFactors();
        SwtUtilitiesTest.assertEquals((int)2, (int)defaultFactors.length);
        MyLnf lnf = new MyLnf();
        LnfManager.setLnf((RienaDefaultLnf)lnf);
        float[] factors = SwtUtilities.getDpiFactors();
        SwtUtilitiesTest.assertEquals((int)2, (int)factors.length);
        SwtUtilitiesTest.assertEquals((Object)Float.valueOf(defaultFactors[0]), (Object)Float.valueOf(factors[0]));
        SwtUtilitiesTest.assertEquals((Object)Float.valueOf(defaultFactors[1]), (Object)Float.valueOf(factors[1]));
        ReflectionUtils.setHidden(SwtUtilities.class, (String)"cachedDpiFactors", (Object)new float[]{0.0f, 0.0f});
        LnfManager.setLnf((RienaDefaultLnf)lnf);
        factors = SwtUtilities.getDpiFactors();
        SwtUtilitiesTest.assertEquals((int)2, (int)factors.length);
        float[] lnfFactors = lnf.getDpiFactors(new Point(0, 0));
        SwtUtilitiesTest.assertEquals((Object)Float.valueOf(lnfFactors[0]), (Object)Float.valueOf(factors[0]));
        SwtUtilitiesTest.assertEquals((Object)Float.valueOf(lnfFactors[1]), (Object)Float.valueOf(factors[1]));
    }

    public void testConvertXToDpi() throws Exception {
        MyLnf lnf = new MyLnf();
        LnfManager.setLnf((RienaDefaultLnf)lnf);
        int x = SwtUtilities.convertXToDpi((int)2);
        int expectedValue = 40;
        SwtUtilitiesTest.assertEquals((int)expectedValue, (int)x);
        ReflectionUtils.setHidden(SwtUtilities.class, (String)"cachedDpiFactors", (Object)new float[]{1.2f, 1.3f});
        x = SwtUtilities.convertXToDpi((int)2);
        expectedValue = 2;
        SwtUtilitiesTest.assertEquals((int)expectedValue, (int)x);
        ReflectionUtils.setHidden(SwtUtilities.class, (String)"cachedDpiFactors", (Object)new float[]{1.9f, 1.0f});
        x = SwtUtilities.convertXToDpi((int)2);
        expectedValue = 4;
        SwtUtilitiesTest.assertEquals((int)expectedValue, (int)x);
    }

    public void testConvertYToDpi() throws Exception {
        MyLnf lnf = new MyLnf();
        LnfManager.setLnf((RienaDefaultLnf)lnf);
        int y = SwtUtilities.convertYToDpi((int)2);
        int expectedValue = 6;
        SwtUtilitiesTest.assertEquals((int)expectedValue, (int)y);
        ReflectionUtils.setHidden(SwtUtilities.class, (String)"cachedDpiFactors", (Object)new float[]{1.2f, 2.4f});
        y = SwtUtilities.convertYToDpi((int)2);
        expectedValue = 5;
        SwtUtilitiesTest.assertEquals((int)expectedValue, (int)y);
        ReflectionUtils.setHidden(SwtUtilities.class, (String)"cachedDpiFactors", (Object)new float[]{1.9f, 4.4f});
        y = SwtUtilities.convertYToDpi((int)2);
        expectedValue = 9;
        SwtUtilitiesTest.assertEquals((int)expectedValue, (int)y);
        ReflectionUtils.setHidden(SwtUtilities.class, (String)"cachedDpiFactors", (Object)new float[]{1.9f, 4.8f});
        y = SwtUtilities.convertYToDpi((int)2);
        expectedValue = 10;
        SwtUtilitiesTest.assertEquals((int)expectedValue, (int)y);
    }

    public void testConvertPixelToDpi() throws Exception {
        MyLnf lnf = new MyLnf();
        LnfManager.setLnf((RienaDefaultLnf)lnf);
        int y = SwtUtilities.convertPixelToDpi((int)2);
        int expectedValue = 6;
        SwtUtilitiesTest.assertEquals((int)expectedValue, (int)y);
        ReflectionUtils.setHidden(SwtUtilities.class, (String)"cachedDpiFactors", (Object)new float[]{1.2f, 6.4f});
        y = SwtUtilities.convertPixelToDpi((int)2);
        expectedValue = 2;
        SwtUtilitiesTest.assertEquals((int)expectedValue, (int)y);
        ReflectionUtils.setHidden(SwtUtilities.class, (String)"cachedDpiFactors", (Object)new float[]{5.9f, 4.4f});
        y = SwtUtilities.convertPixelToDpi((int)2);
        expectedValue = 9;
        SwtUtilitiesTest.assertEquals((int)expectedValue, (int)y);
        ReflectionUtils.setHidden(SwtUtilities.class, (String)"cachedDpiFactors", (Object)new float[]{1.9f, 4.8f});
        y = SwtUtilities.convertPixelToDpi((int)2);
        expectedValue = 4;
        SwtUtilitiesTest.assertEquals((int)expectedValue, (int)y);
    }

    public void testConvertPixelToDpiTruncate() throws Exception {
        MyLnf lnf = new MyLnf();
        LnfManager.setLnf((RienaDefaultLnf)lnf);
        int y = SwtUtilities.convertPixelToDpi((int)2);
        int expectedValue = 6;
        SwtUtilitiesTest.assertEquals((int)expectedValue, (int)y);
        ReflectionUtils.setHidden(SwtUtilities.class, (String)"cachedDpiFactors", (Object)new float[]{1.2f, 6.4f});
        y = SwtUtilities.convertPixelToDpiTruncate((int)2);
        expectedValue = 2;
        SwtUtilitiesTest.assertEquals((int)expectedValue, (int)y);
        ReflectionUtils.setHidden(SwtUtilities.class, (String)"cachedDpiFactors", (Object)new float[]{5.9f, 4.4f});
        y = SwtUtilities.convertPixelToDpiTruncate((int)2);
        expectedValue = 8;
        SwtUtilitiesTest.assertEquals((int)expectedValue, (int)y);
        ReflectionUtils.setHidden(SwtUtilities.class, (String)"cachedDpiFactors", (Object)new float[]{1.9f, 4.8f});
        y = SwtUtilities.convertPixelToDpiTruncate((int)2);
        expectedValue = 3;
        SwtUtilitiesTest.assertEquals((int)expectedValue, (int)y);
    }

    public void testConvertXToDpiTruncate() throws Exception {
        MyLnf lnf = new MyLnf();
        LnfManager.setLnf((RienaDefaultLnf)lnf);
        int x = SwtUtilities.convertXToDpiTruncate((int)2);
        int expectedValue = 40;
        SwtUtilitiesTest.assertEquals((int)expectedValue, (int)x);
        ReflectionUtils.setHidden(SwtUtilities.class, (String)"cachedDpiFactors", (Object)new float[]{1.2f, 1.3f});
        x = SwtUtilities.convertXToDpiTruncate((int)2);
        expectedValue = 2;
        SwtUtilitiesTest.assertEquals((int)expectedValue, (int)x);
        ReflectionUtils.setHidden(SwtUtilities.class, (String)"cachedDpiFactors", (Object)new float[]{1.9f, 1.0f});
        x = SwtUtilities.convertXToDpiTruncate((int)2);
        expectedValue = 3;
        SwtUtilitiesTest.assertEquals((int)expectedValue, (int)x);
    }

    public void testConvertYToDpiTruncate() throws Exception {
        MyLnf lnf = new MyLnf();
        LnfManager.setLnf((RienaDefaultLnf)lnf);
        int y = SwtUtilities.convertYToDpiTruncate((int)2);
        int expectedValue = 6;
        SwtUtilitiesTest.assertEquals((int)expectedValue, (int)y);
        ReflectionUtils.setHidden(SwtUtilities.class, (String)"cachedDpiFactors", (Object)new float[]{1.2f, 2.4f});
        y = SwtUtilities.convertYToDpiTruncate((int)2);
        expectedValue = 4;
        SwtUtilitiesTest.assertEquals((int)expectedValue, (int)y);
        ReflectionUtils.setHidden(SwtUtilities.class, (String)"cachedDpiFactors", (Object)new float[]{1.9f, 4.4f});
        y = SwtUtilities.convertYToDpiTruncate((int)2);
        expectedValue = 8;
        SwtUtilitiesTest.assertEquals((int)expectedValue, (int)y);
        ReflectionUtils.setHidden(SwtUtilities.class, (String)"cachedDpiFactors", (Object)new float[]{1.9f, 4.8f});
        y = SwtUtilities.convertYToDpiTruncate((int)2);
        expectedValue = 9;
        SwtUtilitiesTest.assertEquals((int)expectedValue, (int)y);
    }

    public void testConvertAwtImageToImageData() throws Exception {
        URI imageUri = ImageStore.getInstance().getImageUri("eclipse", ImageFileExtension.GIF);
        URL imageUrl = FileLocator.toFileURL((URL)imageUri.toURL());
        File img = new File(imageUrl.getPath());
        BufferedImage bi = ImageIO.read(img);
        ImageData imageData = SwtUtilities.convertAwtImageToImageData((BufferedImage)bi);
        SwtUtilitiesTest.assertNotNull((Object)imageData);
        SwtUtilitiesTest.assertEquals((int)16, (int)imageData.width);
        SwtUtilitiesTest.assertEquals((int)16, (int)imageData.height);
        int pixelValue = imageData.getPixel(5, 5);
        RGB rgb = imageData.palette.getRGB(pixelValue);
        SwtUtilitiesTest.assertEquals((Object)new RGB(113, 117, 169), (Object)rgb);
        imageUri = ImageStore.getInstance().getImageUri("spirit", ImageFileExtension.PNG);
        imageUrl = FileLocator.toFileURL((URL)imageUri.toURL());
        img = new File(imageUrl.getPath());
        bi = ImageIO.read(img);
        imageData = SwtUtilities.convertAwtImageToImageData((BufferedImage)bi);
        SwtUtilitiesTest.assertNotNull((Object)imageData);
        SwtUtilitiesTest.assertEquals((int)16, (int)imageData.width);
        SwtUtilitiesTest.assertEquals((int)16, (int)imageData.height);
        pixelValue = imageData.getPixel(1, 1);
        rgb = imageData.palette.getRGB(pixelValue);
        SwtUtilitiesTest.assertEquals((Object)new RGB(20, 100, 150), (Object)rgb);
    }

    private static class MyLnf
    extends RienaDefaultLnf {
        private MyLnf() {
        }

        public float[] getDpiFactors(Point dpi) {
            return new float[]{20.0f, 3.0f};
        }
    }
}

