/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateListStrategy;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiffEntry;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.equinox.log.Logger;
import org.eclipse.jface.databinding.viewers.IViewerObservableList;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.viewers.AbstractTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.internal.ui.ridgets.swt.ColumnUtils;
import org.eclipse.riena.internal.ui.ridgets.swt.ITableTreeWrapper;
import org.eclipse.riena.internal.ui.ridgets.swt.OutputAwareValidator;
import org.eclipse.riena.internal.ui.ridgets.swt.StructuredViewerFilterHolder;
import org.eclipse.riena.internal.ui.ridgets.swt.TableRidgetEditingSupport;
import org.eclipse.riena.internal.ui.ridgets.swt.TableRidgetLabelProvider;
import org.eclipse.riena.ui.core.marker.RowErrorMessageMarker;
import org.eclipse.riena.ui.ridgets.IColumnFormatter;
import org.eclipse.riena.ui.ridgets.IMarkableRidget;
import org.eclipse.riena.ui.ridgets.ISelectableRidget;
import org.eclipse.riena.ui.ridgets.ITableFormatter;
import org.eclipse.riena.ui.ridgets.ITableRidget;
import org.eclipse.riena.ui.ridgets.swt.AbstractSWTWidgetRidget;
import org.eclipse.riena.ui.ridgets.swt.AbstractSelectableIndexedRidget;
import org.eclipse.riena.ui.ridgets.swt.ColumnFormatter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Widget;

public abstract class AbstractTableRidget
extends AbstractSelectableIndexedRidget
implements ITableRidget {
    private static final Logger LOGGER = Log4r.getLogger(AbstractTableRidget.class);
    private static final String TABLE_VIEWER_DATA_KEY = "TBL.VIEWER";
    private AbstractTableViewer viewer;
    private ColumnLayoutData[] columnWidths;
    private ITableTreeWrapper tableWrapper;
    protected final SelectionListener selectionTypeEnforcer;
    protected SelectionListener sortListener;
    protected String[] columnHeaders;
    protected DataBindingContext dbc;
    protected String[] renderingMethods;
    private boolean viewConfigured;
    private boolean nativeToolTip = true;
    private boolean isSortedAscending = true;
    private int sortedColumn = -1;
    private ITableFormatter tableFormatter;
    private final Map<Integer, Boolean> sortableColumnsMap;
    private final Map<Integer, Boolean> editableColumnsMap;
    private final Map<Integer, Comparator<?>> comparatorMap;
    private final Map<Integer, IColumnFormatter> formatterMap = new HashMap<Integer, IColumnFormatter>();
    private final TableKeyListener keyListener;
    private Binding viewerMSB;
    private IObservableList modelObservables;
    protected IObservableList viewerObservables;
    private Class<?> rowClass;
    private boolean moveableColumns;
    private StructuredViewerFilterHolder filterHolder;

    protected boolean isViewConfigured() {
        return this.viewConfigured;
    }

    public AbstractTableRidget() {
        this.sortableColumnsMap = new HashMap<Integer, Boolean>();
        this.editableColumnsMap = new HashMap<Integer, Boolean>();
        this.comparatorMap = new HashMap();
        this.keyListener = new TableKeyListener();
        this.selectionTypeEnforcer = new SelectionTypeEnforcer();
        this.addPropertyChangeListener("output", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (AbstractTableRidget.this.isOutputOnly()) {
                    AbstractTableRidget.this.disposeMultipleSelectionBinding();
                } else {
                    AbstractTableRidget.this.createMultipleSelectionBinding();
                }
            }
        });
    }

    public int getColumnCount() {
        if (this.tableWrapper == null) {
            return -1;
        }
        return this.tableWrapper.getColumnCount();
    }

    protected int getExpectedColumnCount() {
        if (this.renderingMethods == null) {
            return 0;
        }
        return this.renderingMethods.length;
    }

    private int getItemCount() {
        if (this.tableWrapper == null) {
            return -1;
        }
        return this.tableWrapper.getItemCount();
    }

    protected final Item getItem(Point point) {
        if (this.tableWrapper == null) {
            return null;
        }
        return this.tableWrapper.getItem(point);
    }

    protected abstract int getUiSelectionCount();

    protected abstract void setUiSelection(Widget var1);

    protected abstract void applyColumns();

    protected abstract void applyTableColumnHeaders();

    protected abstract void applyColumnsMovable();

    protected abstract void applyComparator(Map<Integer, Comparator<?>> var1);

    protected abstract void updateToolTipSupport();

    protected abstract AbstractTableViewer createTableViewer();

    protected abstract ITableTreeWrapper createTableWrapper();

    protected abstract int getColumnStyle(int var1);

    public void setColumnWidths(Object[] widths) {
        this.columnWidths = ColumnUtils.copyWidths(widths);
        this.applyColumnWidths();
    }

    protected final void applyColumnWidths() {
        if (this.tableWrapper == null) {
            return;
        }
        ColumnUtils.applyColumnWidths(this.tableWrapper, this.columnWidths);
    }

    protected void applyEditingSupport(ViewerColumn viewerColumn, int columnIndex) {
        Boolean editable = this.editableColumnsMap.get(columnIndex);
        TableRidgetEditingSupport editingSupport = null;
        if (Boolean.TRUE.equals(editable)) {
            PropertyDescriptor property = this.getPropertyDescriptor(this.renderingMethods[columnIndex]);
            int columnStyle = this.getColumnStyle(columnIndex);
            editingSupport = new TableRidgetEditingSupport(this, property, columnStyle);
        }
        viewerColumn.setEditingSupport(editingSupport);
    }

    protected PropertyDescriptor getPropertyDescriptor(String propertyName) {
        try {
            PropertyDescriptor[] descriptors;
            PropertyDescriptor[] propertyDescriptorArray = descriptors = Introspector.getBeanInfo(this.rowClass).getPropertyDescriptors();
            int n = descriptors.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDescriptor descriptor = propertyDescriptorArray[n2];
                if (descriptor.getName().equals(propertyName)) {
                    return descriptor;
                }
                ++n2;
            }
        }
        catch (IntrospectionException e) {
            String msg = "Could not detect descriptor of the property " + propertyName;
            LOGGER.log(1, msg, (Throwable)e);
        }
        return null;
    }

    protected PropertyDescriptor getPropertyDescriptor(int columnIndex) {
        this.checkColumnRange(columnIndex);
        return this.getPropertyDescriptor(this.renderingMethods[columnIndex]);
    }

    protected void checkColumnRange(int columnIndex) {
        int range = this.getColumnCount();
        if (range != -1) {
            String msg = "columnIndex out of range (0 - " + range + " ): " + columnIndex;
            Assert.isLegal((-1 < columnIndex ? 1 : 0) != 0, (String)msg);
            Assert.isLegal((columnIndex < range ? 1 : 0) != 0, (String)msg);
        }
    }

    public void setColumnFormatter(int columnIndex, IColumnFormatter formatter) {
        this.checkColumnRange(columnIndex);
        if (formatter != null) {
            Assert.isLegal((boolean)(formatter instanceof ColumnFormatter), (String)"formatter must sublass ColumnFormatter");
        }
        Integer key = columnIndex;
        this.formatterMap.put(key, formatter);
    }

    public void setTableFormatter(ITableFormatter formatter) {
        this.tableFormatter = formatter;
    }

    public void clearColumnFormatters() {
        this.formatterMap.clear();
    }

    private IColumnFormatter[] getColumnFormatters(int numColumns) {
        Assert.isLegal((numColumns >= 0 ? 1 : 0) != 0);
        IColumnFormatter[] result = new IColumnFormatter[numColumns];
        int i = 0;
        while (i < numColumns) {
            IColumnFormatter columnFormatter = this.formatterMap.get(i);
            if (columnFormatter != null) {
                result[i] = columnFormatter;
            }
            ++i;
        }
        return result;
    }

    private boolean isViewerConfigured() {
        return this.viewer.getLabelProvider() instanceof TableRidgetLabelProvider && this.viewConfigured;
    }

    @Override
    public int indexOfOption(Object option) {
        int optionCount = this.getItemCount();
        if (optionCount > 0) {
            int i = 0;
            while (i < optionCount) {
                if (this.viewer.getElementAt(i).equals(option)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public void refresh(Object element) {
        if (this.viewer != null) {
            this.viewer.refresh(element, true);
        }
    }

    @Override
    protected void bindUIControl() {
        Control control = this.getUIControl();
        if (control != null) {
            this.dbc = new DataBindingContext();
            this.tableWrapper = this.createTableWrapper();
            this.viewer = (AbstractTableViewer)control.getData(TABLE_VIEWER_DATA_KEY);
            if (this.viewer == null || this.viewer.getControl() != control) {
                this.viewer = this.createTableViewer();
                control.setData(TABLE_VIEWER_DATA_KEY, (Object)this.viewer);
            }
            this.configureControl();
            if (this.getObservableList() != null) {
                this.configureViewer(this.viewer);
            }
            IViewerObservableValue viewerSelection = ViewersObservables.observeSingleSelection((Viewer)this.viewer);
            this.dbc.bindValue((IObservableValue)viewerSelection, this.getSingleSelectionObservable(), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setAfterGetValidator((IValidator)new OutputAwareValidator((IMarkableRidget)this)), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE));
            control.addKeyListener((KeyListener)this.keyListener);
            this.updateToolTipSupport();
            this.viewerMSB = null;
            if (!this.isOutputOnly()) {
                this.createMultipleSelectionBinding();
            }
        }
        this.getFilterHolder().activate((StructuredViewer)this.viewer);
    }

    @Override
    protected void unbindUIControl() {
        Control control;
        super.unbindUIControl();
        this.getFilterHolder().deactivate((StructuredViewer)this.viewer);
        this.disposeMultipleSelectionBinding();
        if (this.dbc != null) {
            this.dbc.dispose();
            this.dbc = null;
        }
        if ((control = this.getUIControl()) != null) {
            control.removeKeyListener((KeyListener)this.keyListener);
        }
        this.viewConfigured = false;
        this.viewer = null;
        this.tableWrapper = null;
    }

    public void updateFromModel() {
        super.updateFromModel();
        if (this.modelObservables != null) {
            ArrayList copy = new ArrayList(this.modelObservables);
            this.viewerObservables = new WritableList(copy, this.rowClass);
        }
        if (this.viewer != null) {
            if (!this.isViewerConfigured()) {
                this.configureControl();
                this.configureViewer(this.viewer);
            } else {
                this.refreshViewer(this.viewer);
            }
        } else {
            this.refreshSelection();
        }
    }

    private void configureControl() {
        if (this.renderingMethods != null) {
            this.applyColumns();
        }
        this.applyColumnsMovable();
        this.applyTableColumnHeaders();
    }

    protected void configureViewer(AbstractTableViewer viewer) {
        ObservableListContentProvider viewerCP = new ObservableListContentProvider();
        TableRidgetLabelProvider labelProvider = this.createLabelProvider(viewerCP);
        viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        viewer.setContentProvider((IContentProvider)viewerCP);
        this.configureLableProvider((IBaseLabelProvider)labelProvider, viewer);
        viewer.setInput((Object)this.viewerObservables);
        this.applyComparator(this.comparatorMap);
        this.viewConfigured = true;
    }

    private void refreshViewer(AbstractTableViewer viewer) {
        viewer.getControl().setRedraw(false);
        boolean scrollBarVisibleBeforeRefresh = this.isVerticalScrollBarVisible(viewer.getControl());
        StructuredSelection currentSelection = new StructuredSelection(this.getSelection());
        try {
            this.configureLableProvider(viewer.getLabelProvider(), viewer);
            viewer.setInput((Object)this.viewerObservables);
        }
        finally {
            viewer.setSelection((ISelection)currentSelection);
            viewer.getControl().setRedraw(true);
            this.layoutIfScrollBarVisibilityChanged(viewer.getControl(), scrollBarVisibleBeforeRefresh);
        }
    }

    protected void configureLableProvider(IBaseLabelProvider labelProvider, AbstractTableViewer viewer) {
        if (labelProvider instanceof TableRidgetLabelProvider) {
            TableRidgetLabelProvider tableLabelProvider = (TableRidgetLabelProvider)labelProvider;
            IColumnFormatter[] formatters = this.getColumnFormatters(tableLabelProvider.getColumnCount());
            tableLabelProvider.setFormatters(formatters);
            tableLabelProvider.setTableFormatter(this.tableFormatter);
        }
    }

    protected StructuredViewerFilterHolder getFilterHolder() {
        if (this.filterHolder == null) {
            this.filterHolder = new StructuredViewerFilterHolder();
        }
        return this.filterHolder;
    }

    private TableRidgetLabelProvider createLabelProvider(ObservableListContentProvider viewerCP) {
        IObservableMap[] attrMap = AbstractSWTWidgetRidget.isBean(this.rowClass) ? BeansObservables.observeMaps((IObservableSet)viewerCP.getKnownElements(), this.rowClass, (String[])this.renderingMethods) : PojoObservables.observeMaps((IObservableSet)viewerCP.getKnownElements(), this.rowClass, (String[])this.renderingMethods);
        IColumnFormatter[] formatters = this.getColumnFormatters(attrMap.length);
        final TableRidgetLabelProvider labelProvider = new TableRidgetLabelProvider(attrMap, formatters);
        this.viewerObservables.addListChangeListener(new IListChangeListener(){

            public void handleListChange(ListChangeEvent event) {
                if (event.diff != null && !event.diff.isEmpty()) {
                    ListDiffEntry[] listDiffEntryArray = event.diff.getDifferences();
                    int n = listDiffEntryArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object deletedElement;
                        ListDiffEntry diffEntry = listDiffEntryArray[n2];
                        if (!diffEntry.isAddition() && (deletedElement = diffEntry.getElement()) != null) {
                            labelProvider.disposeImageOfElement(deletedElement);
                        }
                        ++n2;
                    }
                }
            }
        });
        return labelProvider;
    }

    protected void layoutIfScrollBarVisibilityChanged(Control control, boolean barVisibilityBefore) {
        if (barVisibilityBefore != this.isVerticalScrollBarVisible(control) && control.getParent().getChildren().length == 1) {
            control.getParent().layout(true, true);
        }
    }

    protected boolean isVerticalScrollBarVisible(Control control) {
        if (control instanceof Scrollable) {
            ScrollBar sb = ((Scrollable)control).getVerticalBar();
            return sb != null && sb.isVisible();
        }
        return false;
    }

    public void bindToModel(IObservableList rowObservables, Class<? extends Object> aRowClass, String[] columnPropertyNames, String[] columnHeaders) {
        if (columnHeaders != null) {
            Assert.isLegal((columnPropertyNames.length == columnHeaders.length ? 1 : 0) != 0, (String)"Mismatch between number of columnPropertyNames and columnHeaders");
        }
        this.unbindUIControl();
        this.rowClass = aRowClass;
        this.modelObservables = rowObservables;
        this.viewerObservables = null;
        this.renderingMethods = new String[columnPropertyNames.length];
        System.arraycopy(columnPropertyNames, 0, this.renderingMethods, 0, this.renderingMethods.length);
        if (columnHeaders != null) {
            this.columnHeaders = new String[columnHeaders.length];
            System.arraycopy(columnHeaders, 0, this.columnHeaders, 0, this.columnHeaders.length);
        } else {
            this.columnHeaders = null;
        }
        this.bindUIControl();
    }

    public void bindToModel(Object listHolder, String listPropertyName, Class<? extends Object> rowClass, String[] columnPropertyNames, String[] columnHeaders) {
        IObservableList rowValues = AbstractSWTWidgetRidget.isBean(rowClass) ? BeansObservables.observeList((Object)listHolder, (String)listPropertyName) : PojoObservables.observeList((Object)listHolder, (String)listPropertyName);
        this.bindToModel(rowValues, rowClass, columnPropertyNames, columnHeaders);
    }

    @Override
    public Object getOption(int index) {
        if (this.getRowObservables() == null || index < 0 || index >= this.getOptionCount()) {
            throw new IllegalArgumentException("index: " + index);
        }
        if (this.viewer != null) {
            return this.viewer.getElementAt(index);
        }
        return this.getRowObservables().get(index);
    }

    @Override
    protected List<?> getRowObservables() {
        return this.viewerObservables;
    }

    public IObservableList getObservableList() {
        return this.viewerObservables;
    }

    public boolean hasMoveableColumns() {
        return this.moveableColumns;
    }

    public void setMoveableColumns(boolean moveableColumns) {
        if (this.moveableColumns != moveableColumns) {
            this.moveableColumns = moveableColumns;
            this.applyColumnsMovable();
        }
    }

    public boolean isNativeToolTip() {
        return this.nativeToolTip;
    }

    public void setNativeToolTip(boolean nativeToolTip) {
        if (this.nativeToolTip != nativeToolTip) {
            this.nativeToolTip = nativeToolTip;
            this.updateToolTipSupport();
        }
    }

    public void setComparator(int columnIndex, Comparator<?> compi) {
        this.checkColumnRange(columnIndex);
        Integer key = columnIndex;
        if (compi != null) {
            this.comparatorMap.put(key, compi);
        } else {
            this.comparatorMap.remove(key);
        }
        if (columnIndex == this.sortedColumn) {
            this.applyComparator(this.comparatorMap);
        }
    }

    public boolean isColumnSortable(int columnIndex) {
        this.checkColumnRange(columnIndex);
        boolean result = false;
        Integer key = columnIndex;
        Boolean sortable = this.sortableColumnsMap.get(columnIndex);
        if (!Boolean.FALSE.equals(sortable)) {
            result = this.comparatorMap.get(key) != null;
        }
        return result;
    }

    protected int getSortDirection() {
        int direction = this.isSortedAscending() ? 128 : 1024;
        return direction;
    }

    public int getSortedColumn() {
        boolean isSorted = this.sortedColumn != -1 && this.isColumnSortable(this.sortedColumn);
        return isSorted ? this.sortedColumn : -1;
    }

    public boolean isSortedAscending() {
        return this.getSortedColumn() != -1 && this.isSortedAscending;
    }

    public void setColumnSortable(int columnIndex, boolean sortable) {
        this.checkColumnRange(columnIndex);
        Integer key = columnIndex;
        Boolean newValue = sortable;
        Boolean oldValue = this.sortableColumnsMap.put(key, newValue);
        if (oldValue == null) {
            oldValue = Boolean.TRUE;
        }
        if (!newValue.equals(oldValue)) {
            this.firePropertyChange("columnSortability", null, columnIndex);
        }
    }

    public void setColumnEditable(int columnIndex, boolean editable) {
        this.checkColumnRange(columnIndex);
        Integer key = columnIndex;
        Boolean newValue = editable;
        Boolean oldValue = this.editableColumnsMap.put(key, newValue);
        if (oldValue == null) {
            oldValue = Boolean.TRUE;
        }
    }

    public void setSortedAscending(boolean ascending) {
        if (this.isSortedAscending != ascending) {
            boolean oldSortedAscending = this.isSortedAscending;
            this.isSortedAscending = ascending;
            this.applyComparator(this.comparatorMap);
            this.firePropertyChange("sortAscending", oldSortedAscending, this.isSortedAscending);
        }
    }

    public void setSortedColumn(int columnIndex) {
        if (columnIndex != -1) {
            this.checkColumnRange(columnIndex);
        }
        if (this.sortedColumn != columnIndex) {
            int oldSortedColumn = this.sortedColumn;
            this.sortedColumn = columnIndex;
            this.applyComparator(this.comparatorMap);
            this.firePropertyChange("sortedColumn", oldSortedColumn, this.sortedColumn);
        }
    }

    protected AbstractTableViewer getTableViewer() {
        return this.viewer;
    }

    @Override
    public boolean isDisableMandatoryMarker() {
        return true;
    }

    protected boolean isErrorMarked(Widget item) {
        Object data = item.getData();
        Collection<RowErrorMessageMarker> markers = this.getMarkersOfType(RowErrorMessageMarker.class);
        for (RowErrorMessageMarker marker : markers) {
            if (marker.getRowValue() != data) continue;
            return true;
        }
        return false;
    }

    private void createMultipleSelectionBinding() {
        if (this.viewerMSB == null && this.dbc != null && this.viewer != null) {
            StructuredSelection currentSelection = new StructuredSelection(this.getSelection());
            IViewerObservableList viewerSelections = ViewersObservables.observeMultiSelection((Viewer)this.viewer);
            this.viewerMSB = this.dbc.bindList((IObservableList)viewerSelections, this.getMultiSelectionObservable(), new UpdateListStrategy(UpdateListStrategy.POLICY_UPDATE), new UpdateListStrategy(UpdateListStrategy.POLICY_UPDATE));
            this.viewer.setSelection((ISelection)currentSelection);
        }
    }

    private void disposeMultipleSelectionBinding() {
        if (this.viewerMSB != null) {
            this.viewerMSB.dispose();
            if (this.dbc != null) {
                this.dbc.removeBinding(this.viewerMSB);
            }
            this.viewerMSB = null;
        }
    }

    private final class SelectionTypeEnforcer
    extends SelectionAdapter {
        private SelectionTypeEnforcer() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (AbstractTableRidget.this.isOutputOnly()) {
                AbstractTableViewer tableViewer = AbstractTableRidget.this.getTableViewer();
                if (tableViewer != null) {
                    tableViewer.setSelection((ISelection)new StructuredSelection(AbstractTableRidget.this.getSelection()));
                }
            } else if (ISelectableRidget.SelectionType.SINGLE.equals((Object)AbstractTableRidget.this.getSelectionType()) && AbstractTableRidget.this.getUiSelectionCount() > 1) {
                Assert.isTrue((e.widget == AbstractTableRidget.this.getUIControl() ? 1 : 0) != 0);
                e.doit = false;
                AbstractTableRidget.this.setUiSelection(e.item);
                Event event = new Event();
                event.type = 13;
                event.doit = true;
                AbstractTableRidget.this.getUIControl().notifyListeners(13, event);
            }
        }
    }

    private final class TableKeyListener
    extends KeyAdapter {
        private TableKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            if (e.character == ' ' || e.character == '\r') {
                AbstractTableRidget.this.getClickForwarder().mouseDoubleClick(null);
            }
        }
    }
}

