/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.core.marker.IMarkerAttributeChangeListener;
import org.eclipse.riena.core.marker.Markable;
import org.eclipse.riena.ui.core.marker.DisabledMarker;
import org.eclipse.riena.ui.core.marker.HiddenMarker;
import org.eclipse.riena.ui.core.marker.IMarkerPropertyChangeEvent;
import org.eclipse.riena.ui.core.marker.OutputMarker;
import org.eclipse.riena.ui.ridgets.IBasicMarkableRidget;

public abstract class AbstractMarkerSupport {
    private Collection<IMarker> markers;
    private Set<Class<? extends IMarker>> hiddenMarkerTypes;
    private IBasicMarkableRidget ridget;
    private PropertyChangeSupport propertyChangeSupport;
    private IMarkerAttributeChangeListener markerAttributeChangeListener;

    public AbstractMarkerSupport() {
        this.markerAttributeChangeListener = new MarkerAttributeChangeListener();
    }

    public AbstractMarkerSupport(IBasicMarkableRidget ridget, PropertyChangeSupport propertyChangeSupport) {
        this.init(ridget, propertyChangeSupport);
    }

    public void addMarker(IMarker marker) {
        if (marker == null) {
            return;
        }
        this.initializeMarkers();
        if (this.markers.contains(marker)) {
            return;
        }
        Collection<IMarker> oldValue = this.cloneMarkers();
        if (this.markers.add(marker)) {
            this.updateMarkers();
            Collection<IMarker> newValue = this.getMarkers();
            this.fireMarkerPropertyChangeEvent(oldValue, newValue);
            this.fireOutputPropertyChangeEvent(oldValue, newValue);
            this.fireEnabledPropertyChangeEvent(oldValue, newValue);
            marker.addAttributeChangeListener(this.markerAttributeChangeListener);
        }
    }

    public void bind() {
    }

    public void init(IBasicMarkableRidget ridget, PropertyChangeSupport propertyChangeSupport) {
        this.ridget = ridget;
        this.propertyChangeSupport = propertyChangeSupport;
    }

    public void fireShowingPropertyChangeEvent() {
        this.propertyChangeSupport.firePropertyChange("showing", !this.ridget.isVisible(), this.ridget.isVisible());
        this.updateMarkers();
    }

    public void flash() {
    }

    public final Set<Class<IMarker>> getHiddenMarkerTypes() {
        if (this.hiddenMarkerTypes == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<Class<IMarker>> result = new HashSet<Class<IMarker>>();
        for (Class<? extends IMarker> markerType : this.hiddenMarkerTypes) {
            result.add(markerType);
        }
        return result;
    }

    public Collection<IMarker> getMarkers() {
        return this.cloneMarkers();
    }

    public <T extends IMarker> Collection<T> getMarkersOfType(Class<T> type) {
        return Markable.getMarkersOfType(this.getMarkers(), type);
    }

    public final Set<Class<IMarker>> hideMarkersOfType(Class<? extends IMarker> ... types) {
        if (this.hiddenMarkerTypes == null) {
            this.hiddenMarkerTypes = new HashSet<Class<? extends IMarker>>();
        }
        boolean changed = false;
        Class<? extends IMarker>[] classArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            Class<? extends IMarker> clazz = classArray[n2];
            changed |= this.hiddenMarkerTypes.add(clazz);
            ++n2;
        }
        if (changed) {
            this.updateMarkers();
            this.fireMarkerHidingPropertyChangeEvent(null, null);
        }
        return this.getHiddenMarkerTypes();
    }

    public void removeAllMarkers() {
        if (this.markers != null && !this.markers.isEmpty()) {
            for (IMarker marker : this.markers) {
                marker.removeAttributeChangeListener(this.markerAttributeChangeListener);
            }
            Collection<IMarker> oldValue = this.cloneMarkers();
            this.clearMarkers();
            this.updateMarkers();
            Collection<IMarker> newValue = this.getMarkers();
            this.fireMarkerPropertyChangeEvent(oldValue, newValue);
            this.fireOutputPropertyChangeEvent(oldValue, newValue);
            this.fireEnabledPropertyChangeEvent(oldValue, newValue);
        }
    }

    public boolean removeMarker(IMarker marker) {
        if (this.markers != null && !this.markers.isEmpty()) {
            Collection<IMarker> oldValue = this.cloneMarkers();
            if (this.markers.remove(marker)) {
                this.updateMarkers();
                Collection<IMarker> newValue = this.getMarkers();
                this.fireMarkerPropertyChangeEvent(oldValue, newValue);
                this.fireOutputPropertyChangeEvent(oldValue, newValue);
                this.fireEnabledPropertyChangeEvent(oldValue, newValue);
                marker.removeAttributeChangeListener(this.markerAttributeChangeListener);
                return true;
            }
        }
        return false;
    }

    public void setRidget(IBasicMarkableRidget ridget) {
        this.ridget = ridget;
    }

    public final Set<Class<IMarker>> showMarkersOfType(Class<? extends IMarker> ... types) {
        if (this.hiddenMarkerTypes == null) {
            return new HashSet<Class<IMarker>>();
        }
        boolean changed = false;
        Class<? extends IMarker>[] classArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            Class<? extends IMarker> clazz = classArray[n2];
            changed |= this.hiddenMarkerTypes.remove(clazz);
            ++n2;
        }
        if (changed) {
            this.updateMarkers();
            this.fireMarkerHidingPropertyChangeEvent(null, null);
        }
        return this.getHiddenMarkerTypes();
    }

    public void unbind() {
    }

    public abstract void updateMarkers();

    protected Object getUIControl() {
        return this.getRidget().getUIControl();
    }

    protected IBasicMarkableRidget getRidget() {
        return this.ridget;
    }

    protected void handleMarkerAttributesChanged() {
        this.propertyChangeSupport.firePropertyChange(new MarkerPropertyChangeEvent(true, this.getRidget(), (Object)this.getMarkers()));
    }

    protected boolean hasHiddenMarkers() {
        return !this.getRidget().getMarkersOfType(HiddenMarker.class).isEmpty();
    }

    private void clearMarkers() {
        this.markers.clear();
    }

    private Collection<IMarker> cloneMarkers() {
        if (this.markers != null) {
            return new ArrayList<IMarker>(this.markers);
        }
        return Collections.emptySet();
    }

    private void initializeMarkers() {
        if (this.markers == null) {
            this.markers = new ArrayList<IMarker>(1);
        }
    }

    private Boolean isEnabled(Collection<IMarker> markers) {
        boolean result = true;
        if (markers != null) {
            Iterator<IMarker> iter = markers.iterator();
            while (result && iter.hasNext()) {
                boolean bl = result = !(iter.next() instanceof DisabledMarker);
            }
        }
        return result;
    }

    private Boolean isOutput(Collection<IMarker> markers) {
        boolean result = false;
        if (markers != null) {
            Iterator<IMarker> iter = markers.iterator();
            while (!result && iter.hasNext()) {
                result = iter.next() instanceof OutputMarker;
            }
        }
        return result;
    }

    private void fireEnabledPropertyChangeEvent(Collection<IMarker> oldMarkers, Collection<IMarker> newMarkers) {
        Boolean newValue;
        Boolean oldValue = this.isEnabled(oldMarkers);
        if (!oldValue.equals(newValue = this.isEnabled(newMarkers))) {
            PropertyChangeEvent evt = new PropertyChangeEvent(this.getRidget(), "enabled", oldValue, newValue);
            this.propertyChangeSupport.firePropertyChange(evt);
        }
    }

    private void fireMarkerPropertyChangeEvent(Collection<IMarker> oldMarkers, Collection<IMarker> newMarkers) {
        this.propertyChangeSupport.firePropertyChange(new MarkerPropertyChangeEvent(oldMarkers, this.getRidget(), newMarkers));
    }

    private void fireMarkerHidingPropertyChangeEvent(Collection<IMarker> oldMarkers, Collection<IMarker> newMarkers) {
        this.propertyChangeSupport.firePropertyChange("markerHiding", null, null);
    }

    private void fireOutputPropertyChangeEvent(Collection<IMarker> oldMarkers, Collection<IMarker> newMarkers) {
        Boolean newValue;
        Boolean oldValue = this.isOutput(oldMarkers);
        if (!oldValue.equals(newValue = this.isOutput(newMarkers))) {
            PropertyChangeEvent evt = new PropertyChangeEvent(this.getRidget(), "output", oldValue, newValue);
            this.propertyChangeSupport.firePropertyChange(evt);
        }
    }

    private final class MarkerAttributeChangeListener
    implements IMarkerAttributeChangeListener {
        private MarkerAttributeChangeListener() {
        }

        public void attributesChanged() {
            AbstractMarkerSupport.this.handleMarkerAttributesChanged();
        }
    }

    private static final class MarkerPropertyChangeEvent
    extends PropertyChangeEvent
    implements IMarkerPropertyChangeEvent {
        private static final long serialVersionUID = 1L;
        private boolean attributeRelated = false;

        private MarkerPropertyChangeEvent(Object oldValue, IBasicMarkableRidget source, Object newValue) {
            super(source, "marker", oldValue, newValue);
        }

        private MarkerPropertyChangeEvent(boolean attributeRelated, IBasicMarkableRidget source, Object newValue) {
            this(null, source, newValue);
            this.attributeRelated = attributeRelated;
        }

        public boolean isAttributeRelated() {
            return this.attributeRelated;
        }
    }
}

