/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.swt.facades;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.internal.ui.swt.facades.WorkbenchFacade;
import org.eclipse.riena.navigation.ApplicationNodeManager;
import org.eclipse.riena.navigation.IApplicationNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ui.swt.component.MenuCoolBarComposite;
import org.eclipse.riena.navigation.ui.swt.presentation.SwtViewId;
import org.eclipse.riena.navigation.ui.swt.presentation.SwtViewProvider;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISourceProvider;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.services.ISourceProviderService;

public class WorkbenchFacadeImpl
extends WorkbenchFacade {
    private static final Logger LOGGER = Log4r.getLogger(WorkbenchFacadeImpl.class);

    public void showView(IWorkbenchPage page, IViewReference viewRef) {
        ((WorkbenchPage)page).getActivePerspective().bringToTop(viewRef);
    }

    public Shell getActiveShell() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    public boolean closeWorkbench() {
        return PlatformUI.getWorkbench().close();
    }

    public Shell getActiveWindowShell() {
        if (PlatformUI.isWorkbenchRunning() && PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null) {
            return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        }
        return null;
    }

    public Display getWorkbenchDisplay() {
        if (PlatformUI.isWorkbenchRunning() && PlatformUI.getWorkbench().getDisplay() != null) {
            return PlatformUI.getWorkbench().getDisplay();
        }
        return null;
    }

    private ISourceProviderService getSourceProviderService() {
        return (ISourceProviderService)PlatformUI.getWorkbench().getService(ISourceProviderService.class);
    }

    public ISourceProvider[] getSourceProviders() {
        try {
            ISourceProviderService sourceProviderService = this.getSourceProviderService();
            if (sourceProviderService == null) {
                return new ISourceProvider[0];
            }
            return sourceProviderService.getSourceProviders();
        }
        catch (IllegalStateException ex) {
            LOGGER.log(1, "No service for ISourceProviderService!", (Throwable)ex);
            return new ISourceProvider[0];
        }
    }

    public boolean switchToNavigation(ExecutionEvent event) {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        IWorkbenchPage page = window.getActivePage();
        IViewPart navigationView = null;
        if (page != null) {
            IViewReference[] viewRefs;
            IViewReference[] iViewReferenceArray = viewRefs = page.getViewReferences();
            int n = viewRefs.length;
            int n2 = 0;
            while (n2 < n) {
                IViewReference ref = iViewReferenceArray[n2];
                if ("org.eclipse.riena.navigation.ui.swt.views.navigationViewPart".equals(ref.getId())) {
                    navigationView = ref.getView(false);
                    break;
                }
                ++n2;
            }
        }
        if (navigationView != null) {
            navigationView.setFocus();
            return true;
        }
        return false;
    }

    public boolean switchToWorkarea(ExecutionEvent event) {
        String viewId = this.getViewId(this.getActiveNode());
        if (viewId == null) {
            return false;
        }
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        IWorkbenchPage page = window.getActivePage();
        IViewReference[] iViewReferenceArray = page.getViewReferences();
        int n = iViewReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference viewRef = iViewReferenceArray[n2];
            if (viewId.equals(this.getFullId(viewRef))) {
                IViewPart view = viewRef.getView(false);
                if (view == null) break;
                view.setFocus();
                return true;
            }
            ++n2;
        }
        return false;
    }

    private INavigationNode<?> getActiveNode() {
        IApplicationNode appNode = ApplicationNodeManager.getApplicationNode();
        return appNode.getNavigationProcessor().getSelectedNode();
    }

    private String getViewId(INavigationNode<?> node) {
        SwtViewId viewId;
        String result = null;
        if (node != null && (viewId = SwtViewProvider.getInstance().getSwtViewId(node)) != null) {
            result = viewId.getCompoundId();
        }
        return result;
    }

    private String getFullId(IViewReference viewRef) {
        String result = viewRef.getId();
        if (viewRef.getSecondaryId() != null) {
            result = String.valueOf(result) + ":" + viewRef.getSecondaryId();
        }
        return result;
    }

    public boolean switchToWindowMenu(ExecutionEvent event) {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        Shell shell = window.getShell();
        Control[] controlArray = shell.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof MenuCoolBarComposite) {
                child.setFocus();
                return true;
            }
            ++n2;
        }
        return false;
    }
}

