/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.facades.internal;

import java.util.Collection;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.internal.ui.ridgets.swt.TableRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.TableRidgetLabelProvider;
import org.eclipse.riena.internal.ui.ridgets.swt.TableRidgetTableViewer;
import org.eclipse.riena.ui.core.marker.RowErrorMessageMarker;
import org.eclipse.riena.ui.swt.facades.internal.ITableRidgetToolTipSupport;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class TableRidgetToolTipSupport
extends ColumnViewerToolTipSupport
implements ITableRidgetToolTipSupport {
    private static final String VIEWER_CELL_KEY = "org.eclipse.jface_VIEWER_CELL_KEY";
    private static final int DEFAULT_SHIFT_X = 10;
    private static final int DEFAULT_SHIFT_Y = 0;
    private TableRidgetTableViewer viewer;
    private String defaultToolTip;

    protected TableRidgetToolTipSupport(ColumnViewer viewer, int style) {
        super(viewer, 2, false);
        Assert.isLegal((boolean)(viewer instanceof TableRidgetTableViewer));
        this.viewer = (TableRidgetTableViewer)viewer;
    }

    public static ITableRidgetToolTipSupport enableSupportFor(ColumnViewer viewer) {
        TableRidgetToolTipSupport support = new TableRidgetToolTipSupport(viewer, 2);
        support.init();
        return support;
    }

    TableRidgetTableViewer getViewer() {
        return this.viewer;
    }

    private void init() {
        Table table = this.viewer.getTable();
        if (table != null) {
            String tableToolTip = table.getToolTipText();
            this.defaultToolTip = tableToolTip != null ? tableToolTip : "";
            table.setToolTipText(this.defaultToolTip);
        }
    }

    protected boolean shouldCreateToolTip(Event event) {
        boolean rv = false;
        Point point = new Point(event.x, event.y);
        ViewerRow row = this.viewer.getViewerRow(point);
        this.viewer.getControl().setToolTipText(this.defaultToolTip);
        if (row != null) {
            String text;
            Widget item = row.getItem();
            Object element = item.getData();
            ViewerCell cell = row.getCell(point);
            if (cell == null) {
                return false;
            }
            Table table = this.viewer.getTable();
            int column = SwtUtilities.findColumn((Table)table, (Point)point);
            TableRidgetLabelProvider labelProvider = null;
            if (this.viewer.getLabelProvider() instanceof TableRidgetLabelProvider && column != -1) {
                labelProvider = (TableRidgetLabelProvider)this.viewer.getLabelProvider();
            }
            if (StringUtils.isEmpty((CharSequence)(text = this.getErrorToolTip(element))) && labelProvider != null && column != -1) {
                text = labelProvider.getToolTipText(element, column);
            }
            if (StringUtils.isEmpty((CharSequence)text) && item instanceof TableItem && column != -1) {
                text = ((TableItem)item).getText(column);
            }
            if (StringUtils.isEmpty((CharSequence)text)) {
                text = this.defaultToolTip;
            }
            Image img = null;
            if (labelProvider != null && column != -1) {
                img = labelProvider.getToolTipImage(element, column);
            }
            if (text == null && img == null) {
                table.setToolTipText(this.defaultToolTip);
                rv = false;
            } else {
                Point shift = null;
                if (column != -1) {
                    this.setPopupDelay(labelProvider.getToolTipDisplayDelayTime(element, column));
                    this.setHideDelay(labelProvider.getToolTipTimeDisplayed(element, column));
                    shift = labelProvider.getToolTipShift(element, column);
                }
                if (shift == null) {
                    this.setShift(new Point(10, 0));
                } else {
                    this.setShift(new Point(shift.x, shift.y));
                }
                this.setData(VIEWER_CELL_KEY, cell);
                this.setText(text);
                this.setImage(img);
                if (column != -1) {
                    this.setStyle(labelProvider.getToolTipStyle(element, column));
                    this.setForegroundColor(labelProvider.getToolTipForegroundColor(element, column));
                    this.setBackgroundColor(labelProvider.getToolTipBackgroundColor(element, column));
                    this.setFont(labelProvider.getToolTipFont(element, column));
                }
                rv = true;
            }
        }
        return rv;
    }

    private String getErrorToolTip(Object element) {
        if (element != null) {
            TableRidget tableRidget = this.viewer.getTableRidget();
            Collection markers = tableRidget.getMarkersOfType(RowErrorMessageMarker.class);
            for (RowErrorMessageMarker marker : markers) {
                if (marker.getRowValue() != element) continue;
                return marker.getMessage();
            }
        }
        return null;
    }

    private void resetToolTip(Control table) {
        if (table == null) {
            return;
        }
        if (table.getToolTipText() == null || !table.getToolTipText().equals(this.defaultToolTip)) {
            table.setToolTipText(this.defaultToolTip);
        }
    }

    public void disableSupport() {
        this.deactivate();
        if (this.viewer != null) {
            this.resetToolTip((Control)this.viewer.getTable());
        }
    }

    public void enableSupport(ColumnViewer viewer) {
        if (viewer instanceof TableRidgetTableViewer) {
            if (this.viewer != viewer) {
                this.disableSupport();
                this.viewer = (TableRidgetTableViewer)viewer;
                this.init();
            }
            this.activate();
        }
    }
}

