/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.layout;

import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.riena.ui.swt.layout.DpiGridLayout;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class DpiGridLayoutFactory {
    private final DpiGridLayout l;

    private DpiGridLayoutFactory(DpiGridLayout l) {
        this.l = l;
    }

    public static DpiGridLayoutFactory createFrom(DpiGridLayout l) {
        return new DpiGridLayoutFactory(DpiGridLayoutFactory.copyLayout(l));
    }

    public static DpiGridLayoutFactory createFrom(GridLayout l) {
        return new DpiGridLayoutFactory(DpiGridLayoutFactory.copyLayout(l));
    }

    public DpiGridLayoutFactory copy() {
        return new DpiGridLayoutFactory(this.create());
    }

    public static DpiGridLayoutFactory swtDefaults() {
        return new DpiGridLayoutFactory(new DpiGridLayout());
    }

    public static DpiGridLayoutFactory fillDefaults() {
        DpiGridLayout layout = new DpiGridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        Point defaultSpacing = LayoutConstants.getSpacing();
        layout.horizontalSpacing = defaultSpacing.x;
        layout.verticalSpacing = defaultSpacing.y;
        return new DpiGridLayoutFactory(layout);
    }

    public DpiGridLayoutFactory equalWidth(boolean equal) {
        this.l.makeColumnsEqualWidth = equal;
        return this;
    }

    public DpiGridLayoutFactory spacing(int hSpacing, int vSpacing) {
        this.l.horizontalSpacing = hSpacing;
        this.l.verticalSpacing = vSpacing;
        return this;
    }

    public DpiGridLayoutFactory spacing(Point spacing) {
        this.l.horizontalSpacing = spacing.x;
        this.l.verticalSpacing = spacing.y;
        return this;
    }

    public DpiGridLayoutFactory margins(Point margins) {
        this.l.marginWidth = margins.x;
        this.l.marginHeight = margins.y;
        return this;
    }

    public DpiGridLayoutFactory margins(int width, int height) {
        this.l.marginWidth = width;
        this.l.marginHeight = height;
        return this;
    }

    public DpiGridLayoutFactory extendedMargins(int left, int right, int top, int bottom) {
        this.l.marginLeft = left;
        this.l.marginRight = right;
        this.l.marginTop = top;
        this.l.marginBottom = bottom;
        return this;
    }

    public DpiGridLayoutFactory extendedMargins(Rectangle differenceRect) {
        this.l.marginLeft = -differenceRect.x;
        this.l.marginTop = -differenceRect.y;
        this.l.marginBottom = differenceRect.y + differenceRect.height;
        this.l.marginRight = differenceRect.x + differenceRect.width;
        return this;
    }

    public DpiGridLayoutFactory numColumns(int numColumns) {
        this.l.numColumns = numColumns;
        return this;
    }

    public DpiGridLayout create() {
        return DpiGridLayoutFactory.copyLayout(this.l);
    }

    public void applyTo(Composite c) {
        c.setLayout((Layout)DpiGridLayoutFactory.copyLayout(this.l));
    }

    public static DpiGridLayout copyLayout(DpiGridLayout l) {
        DpiGridLayout result = new DpiGridLayout(l.numColumns, l.makeColumnsEqualWidth);
        result.horizontalSpacing = l.horizontalSpacing;
        result.marginBottom = l.marginBottom;
        result.marginHeight = l.marginHeight;
        result.marginLeft = l.marginLeft;
        result.marginRight = l.marginRight;
        result.marginTop = l.marginTop;
        result.marginWidth = l.marginWidth;
        result.verticalSpacing = l.verticalSpacing;
        return result;
    }

    public static DpiGridLayout copyLayout(GridLayout l) {
        DpiGridLayout result = new DpiGridLayout(l.numColumns, l.makeColumnsEqualWidth);
        result.horizontalSpacing = l.horizontalSpacing;
        result.marginBottom = l.marginBottom;
        result.marginHeight = l.marginHeight;
        result.marginLeft = l.marginLeft;
        result.marginRight = l.marginRight;
        result.marginTop = l.marginTop;
        result.marginWidth = l.marginWidth;
        result.verticalSpacing = l.verticalSpacing;
        return result;
    }
}

