/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.utils;

import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.cache.LRUHashMap;
import org.eclipse.riena.internal.ui.swt.Activator;
import org.eclipse.riena.internal.ui.swt.utils.RcpUtilities;
import org.eclipse.riena.ui.swt.facades.GCFacade;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;

public final class SwtUtilities {
    private static final Logger LOGGER = Log4r.getLogger((IRienaActivator)Activator.getDefault(), SwtUtilities.class);
    private static final String THREE_DOTS = "...";
    private static final Map<GCString, Integer> TEXT_WIDTH_CACHE = LRUHashMap.createLRUHashMap((int)2048);
    private static final Map<GCChar, Integer> CHAR_WIDTH_CACHE = LRUHashMap.createLRUHashMap((int)1024);
    private static final float DEFAULT_DPI_X = 96.0f;
    private static final float DEFAULT_DPI_Y = 96.0f;
    private static final Point DEFAULT_DPI = new Point(Math.round(96.0f), Math.round(96.0f));
    private static float[] cachedDpiFactors = new float[]{0.0f, 0.0f};
    private static Point cachedDpi = null;

    private SwtUtilities() {
        throw new Error("SwtUtilities is just a container for static methods");
    }

    public static String clipText(GC gc, String text, int maxWidth) {
        int textwidth = SwtUtilities.calcTextWidth(gc, text);
        if (textwidth <= maxWidth) {
            return text;
        }
        int threeDotsWidth = SwtUtilities.calcTextWidth(gc, THREE_DOTS);
        StringBuilder shortenedText = new StringBuilder(text);
        while (textwidth + threeDotsWidth > maxWidth && shortenedText.length() != 0) {
            shortenedText.setLength(shortenedText.length() - 1);
            textwidth = SwtUtilities.calcTextWidth(gc, shortenedText);
        }
        shortenedText.append(THREE_DOTS);
        return shortenedText.toString();
    }

    public static int calcTextWidth(GC gc, CharSequence text) {
        if (text == null) {
            return 0;
        }
        GCString lookupKey = new GCString(gc, text);
        Integer width = TEXT_WIDTH_CACHE.get(lookupKey);
        if (width == null) {
            int w = 0;
            int i = 0;
            while (i < text.length()) {
                w += SwtUtilities.calcCharWidth(gc, text.charAt(i));
                ++i;
            }
            width = w;
            TEXT_WIDTH_CACHE.put(lookupKey, width);
        }
        return width;
    }

    public static int calcCharWidth(GC gc, char ch) {
        GCChar lookupKey = new GCChar(gc, ch);
        Integer width = CHAR_WIDTH_CACHE.get(lookupKey);
        if (width == null) {
            width = GCFacade.getDefault().getAdvanceWidth(gc, ch);
            CHAR_WIDTH_CACHE.put(lookupKey, width);
        }
        return width;
    }

    public static void dispose(Resource resource) {
        if (!SwtUtilities.isDisposed(resource)) {
            resource.dispose();
        }
    }

    public static void dispose(Widget widget) {
        if (!SwtUtilities.isDisposed(widget)) {
            widget.dispose();
        }
    }

    public static int findColumn(Tree tree, Point pt) {
        int width = 0;
        int[] colOrder = tree.getColumnOrder();
        TreeColumn[] columns = new TreeColumn[colOrder.length];
        int i = 0;
        while (i < colOrder.length) {
            int idx = colOrder[i];
            columns[i] = tree.getColumn(idx);
            ++i;
        }
        TreeColumn[] treeColumnArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn col = treeColumnArray[n2];
            int colWidth = col.getWidth();
            if (width < pt.x && pt.x < width + colWidth) {
                return tree.indexOf(col);
            }
            width += colWidth;
            ++n2;
        }
        return -1;
    }

    public static int findColumn(Table table, Point pt) {
        int width = 0;
        int[] colOrder = table.getColumnOrder();
        TableColumn[] columns = new TableColumn[colOrder.length];
        int i = 0;
        while (i < colOrder.length) {
            int idx = colOrder[i];
            columns[i] = table.getColumn(idx);
            ++i;
        }
        TableColumn[] tableColumnArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn col = tableColumnArray[n2];
            int colWidth = col.getWidth();
            if (width < pt.x && pt.x < width + colWidth) {
                return table.indexOf(col);
            }
            width += colWidth;
            ++n2;
        }
        return -1;
    }

    public static boolean hasStyle(Widget widget, int styleBit) {
        return widget == null ? false : (widget.getStyle() & styleBit) == styleBit;
    }

    public static boolean isDisposed(Widget widget) {
        return widget == null || widget.isDisposed();
    }

    public static boolean isDisposed(Resource resource) {
        return resource == null || resource.isDisposed();
    }

    public static Point getDpi() {
        return SwtUtilities.getDpi(null);
    }

    public static Point getDefaultDpi() {
        return DEFAULT_DPI;
    }

    public static Point getDpi(Widget widget) {
        if (cachedDpi == null) {
            Display display = null;
            if (widget != null) {
                display = widget.getDisplay();
            }
            if (display == null) {
                display = SwtUtilities.getDisplay();
            }
            Assert.isNotNull((Object)display, (String)"No display exits");
            final Display d = display;
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    cachedDpi = d.getDPI();
                }
            });
        }
        return cachedDpi;
    }

    public static boolean isDpiScalingEnabled() {
        return SwtUtilities.isDpiScalingEnabled(null);
    }

    public static boolean isDpiScalingEnabled(Widget widget) {
        float[] dpiFactors;
        float[] fArray = dpiFactors = SwtUtilities.getDpiFactors(widget);
        int n = dpiFactors.length;
        int n2 = 0;
        while (n2 < n) {
            float factor = fArray[n2];
            if ((double)factor > 1.0) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static Display getDisplay() {
        Display display = null;
        if (display == null) {
            try {
                display = RcpUtilities.getDisplay();
            }
            catch (RuntimeException runtimeException) {
                display = null;
            }
        }
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static float[] getDpiFactors() {
        return SwtUtilities.getDpiFactors(null);
    }

    public static float[] getDpiFactors(Widget widget) {
        if (cachedDpiFactors[0] <= 0.001f || cachedDpiFactors[1] <= 0.001f) {
            Point dpi = SwtUtilities.getDpi(widget);
            float[] lnfDpiFactors = LnfManager.getLnf().getDpiFactors(dpi);
            if (lnfDpiFactors.length == 2) {
                SwtUtilities.cachedDpiFactors[0] = lnfDpiFactors[0];
                SwtUtilities.cachedDpiFactors[1] = lnfDpiFactors[1];
            }
        }
        if (cachedDpiFactors[0] <= 0.001f || cachedDpiFactors[1] <= 0.001f) {
            float[] factors = SwtUtilities.getCalculatedDpiFactors(widget);
            SwtUtilities.cachedDpiFactors[0] = factors[0];
            SwtUtilities.cachedDpiFactors[1] = factors[1];
        }
        return cachedDpiFactors;
    }

    public static float[] getCalculatedDpiFactors() {
        return SwtUtilities.getCalculatedDpiFactors(null);
    }

    public static float[] getCalculatedDpiFactors(Widget widget) {
        Point dpi = SwtUtilities.getDpi(widget);
        float[] factors = new float[]{(float)dpi.x / 96.0f, (float)dpi.y / 96.0f};
        return factors;
    }

    public static int convertXToDpi(int x) {
        float factorX = SwtUtilities.getDpiFactors()[0];
        return SwtUtilities.convertPixelToDpi(x, factorX);
    }

    public static int convertYToDpi(int y) {
        float factorY = SwtUtilities.getDpiFactors()[1];
        return SwtUtilities.convertPixelToDpi(y, factorY);
    }

    public static Point convertPointToDpi(Point pixelPoint) {
        int x = SwtUtilities.convertXToDpi(pixelPoint.x);
        int y = SwtUtilities.convertYToDpi(pixelPoint.y);
        return new Point(x, y);
    }

    public static int convertPixelToDpi(int pixel) {
        float factor = Math.min(SwtUtilities.getDpiFactors()[0], SwtUtilities.getDpiFactors()[1]);
        return SwtUtilities.convertPixelToDpi(pixel, factor);
    }

    private static int convertPixelToDpi(int px, float factor) {
        if (px < 0) {
            return -((int)((double)((float)(-px) * factor) + 0.5));
        }
        return (int)((double)((float)px * factor) + 0.5);
    }

    public static int convertXToDpiTruncate(int x) {
        float factorX = SwtUtilities.getDpiFactors()[0];
        return SwtUtilities.convertPixelToDpiTruncate(x, factorX);
    }

    public static int convertYToDpiTruncate(int y) {
        float factorY = SwtUtilities.getDpiFactors()[1];
        return SwtUtilities.convertPixelToDpiTruncate(y, factorY);
    }

    public static int convertPixelToDpiTruncate(int pixel) {
        float factor = Math.min(SwtUtilities.getDpiFactors()[0], SwtUtilities.getDpiFactors()[1]);
        return SwtUtilities.convertPixelToDpiTruncate(pixel, factor);
    }

    private static int convertPixelToDpiTruncate(int px, float factor) {
        return (int)((float)px * factor);
    }

    public static Color makeBrighter(Color color, float f) {
        Assert.isNotNull((Object)color);
        Assert.isTrue(((double)f >= 0.0 ? 1 : 0) != 0);
        float[] hsb = color.getRGB().getHSB();
        float h = hsb[0];
        float s = hsb[1];
        float b = hsb[2];
        b *= f;
        if (b > 1.0f) {
            b = 1.0f;
        }
        RGB rgb = new RGB(h, s, b);
        return new Color(color.getDevice(), rgb);
    }

    public static ImageData convertAwtImageToImageData(BufferedImage bufferedImage) {
        if (bufferedImage.getColorModel() instanceof DirectColorModel) {
            DirectColorModel colorModel = (DirectColorModel)bufferedImage.getColorModel();
            PaletteData palette = SwtUtilities.convertColorModelToPalette(colorModel);
            ImageData data = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), colorModel.getPixelSize(), palette);
            int y = 0;
            while (y < data.height) {
                int x = 0;
                while (x < data.width) {
                    int rgb = bufferedImage.getRGB(x, y);
                    int pixel = palette.getPixel(new RGB(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF));
                    data.setPixel(x, y, pixel);
                    if (colorModel.hasAlpha()) {
                        data.setAlpha(x, y, rgb >> 24 & 0xFF);
                    }
                    ++x;
                }
                ++y;
            }
            return data;
        }
        if (bufferedImage.getColorModel() instanceof IndexColorModel) {
            IndexColorModel colorModel = (IndexColorModel)bufferedImage.getColorModel();
            PaletteData palette = SwtUtilities.convertColorModelToPalette(colorModel);
            ImageData data = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), colorModel.getPixelSize(), palette);
            data.transparentPixel = colorModel.getTransparentPixel();
            WritableRaster raster = bufferedImage.getRaster();
            int[] pixelArray = new int[1];
            int y = 0;
            while (y < data.height) {
                int x = 0;
                while (x < data.width) {
                    raster.getPixel(x, y, pixelArray);
                    data.setPixel(x, y, pixelArray[0]);
                    ++x;
                }
                ++y;
            }
            return data;
        }
        if (bufferedImage.getColorModel() instanceof ComponentColorModel && bufferedImage.getType() == 5) {
            ComponentColorModel colorModel = (ComponentColorModel)bufferedImage.getColorModel();
            PaletteData palette = SwtUtilities.convertColorModelToPalette(colorModel);
            WritableRaster raster = bufferedImage.getRaster();
            int scanlinePad = colorModel.getColorSpace().getNumComponents();
            byte[] pixels = ((DataBufferByte)raster.getDataBuffer()).getData();
            ImageData data = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), colorModel.getPixelSize(), palette, scanlinePad, pixels);
            return data;
        }
        if (bufferedImage.getColorModel() != null) {
            String colorModelName = bufferedImage.getColorModel().getClass().getSimpleName();
            String msg = MessageFormat.format("The color model {0} is not supported!", colorModelName);
            LOGGER.log(1, msg);
        } else {
            LOGGER.log(1, "No color model!");
        }
        return null;
    }

    private static PaletteData convertColorModelToPalette(DirectColorModel colorModel) {
        return new PaletteData(colorModel.getRedMask(), colorModel.getGreenMask(), colorModel.getBlueMask());
    }

    private static PaletteData convertColorModelToPalette(ComponentColorModel colorModel) {
        return new PaletteData(255, 65280, 0xFF0000);
    }

    private static PaletteData convertColorModelToPalette(IndexColorModel colorModel) {
        int size = colorModel.getMapSize();
        byte[] reds = new byte[size];
        byte[] greens = new byte[size];
        byte[] blues = new byte[size];
        colorModel.getReds(reds);
        colorModel.getGreens(greens);
        colorModel.getBlues(blues);
        RGB[] rgbs = new RGB[size];
        int i = 0;
        while (i < rgbs.length) {
            rgbs[i] = new RGB(reds[i] & 0xFF, greens[i] & 0xFF, blues[i] & 0xFF);
            ++i;
        }
        PaletteData palette = new PaletteData(rgbs);
        return palette;
    }

    private static final class GCChar {
        private final char ch;
        private final Font font;

        private GCChar(GC gc, char ch) {
            this.font = gc.getFont();
            this.ch = ch;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.ch;
            result = 31 * result + (this.font == null ? 0 : this.font.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            GCChar other = (GCChar)obj;
            if (this.ch != other.ch) {
                return false;
            }
            return !(this.font == null ? other.font != null : !this.font.equals((Object)other.font));
        }
    }

    private static final class GCString {
        private final String text;
        private final Font font;

        private GCString(GC gc, CharSequence seq) {
            this.font = gc.getFont();
            this.text = seq.toString();
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.font == null ? 0 : this.font.hashCode());
            result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            GCString other = (GCString)obj;
            if (this.font == null ? other.font != null : !this.font.equals((Object)other.font)) {
                return false;
            }
            return !(this.text == null ? other.text != null : !this.text.equals(other.text));
        }
    }
}

