/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.workarea.spi;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.riena.navigation.ApplicationModelFailure;
import org.eclipse.riena.ui.workarea.IWorkareaDefinition;
import org.eclipse.riena.ui.workarea.spi.IWorkareaDefinitionRegistry;

public abstract class AbstractWorkareaDefinitionRegistry
implements IWorkareaDefinitionRegistry {
    protected final Map<Object, IWorkareaDefinition> workareas = new HashMap<Object, IWorkareaDefinition>();

    @Override
    public IWorkareaDefinition getDefinition(Object id) {
        return this.workareas.get(id);
    }

    @Override
    public IWorkareaDefinition register(Object id, IWorkareaDefinition definition) {
        return this.internalRegister(id, definition);
    }

    protected IWorkareaDefinition internalRegister(Object id, IWorkareaDefinition definition) {
        IWorkareaDefinition existingDefinition = this.getDefinition(id);
        if (existingDefinition != null) {
            if (existingDefinition.getViewId() == null && definition.getViewId() != null || existingDefinition.getViewId() != null && !existingDefinition.getViewId().equals(definition.getViewId())) {
                throw new ApplicationModelFailure("Inconsistent workarea definition: a definition for submodules with typeId=\"" + id + "\" already exists and it has a different view (" + existingDefinition.getViewId() + " instead of " + definition.getViewId() + ").");
            }
            if (existingDefinition.isViewShared() != definition.isViewShared()) {
                throw new ApplicationModelFailure("Inconsistent workarea definition: a definition for submodules with typeId=\"" + id + "\" already exists and it has a different shared value.");
            }
        }
        this.workareas.put(id, definition);
        return definition;
    }
}

