/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimeUtility;
import org.eclipse.scout.commons.CharsetSafeMimeMessage;
import org.eclipse.scout.commons.FileUtility;
import org.eclipse.scout.commons.IOUtility;
import org.eclipse.scout.commons.MailUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;

@Deprecated
final class WordMailUtility {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(WordMailUtility.class);
    public static final Pattern wordPatternItem = Pattern.compile("item\\d{3,4}\\.xml");
    public static final Pattern wordPatternProps = Pattern.compile("props\\d{3,4}\\.xml");
    private static final String UTF_8 = "UTF-8";

    WordMailUtility() {
    }

    @Deprecated
    public static MailUtility.MailMessage extractMailMessageFromWordArchive(File archiveFile) {
        return WordMailUtility.extractMailMessageFromWordArchiveInternal(archiveFile);
    }

    private static MailUtility.MailMessage extractMailMessageFromWordArchiveInternal(File archiveFile) {
        MailUtility.MailMessage mailMessage = null;
        File tempDir = WordMailUtility.extractWordArchive(archiveFile);
        String simpleName = WordMailUtility.extractSimpleNameFromWordArchive(archiveFile);
        String messagePlainText = WordMailUtility.extractPlainTextFromWordArchiveInternal(tempDir, simpleName);
        String messageHtml = WordMailUtility.extractHtmlFromWordArchiveInternal(tempDir, simpleName);
        File attachmentFolder = null;
        if (tempDir.isDirectory()) {
            File[] fileArray = tempDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory() && file.getName().startsWith(simpleName)) {
                    attachmentFolder = file;
                    break;
                }
                ++n2;
            }
        }
        String folderName = null;
        if (attachmentFolder != null) {
            folderName = attachmentFolder.getName();
        }
        messageHtml = messageHtml.replaceAll(String.valueOf(folderName) + "/", "");
        messageHtml = WordMailUtility.removeWordTags(messageHtml);
        ArrayList<File> attachmentList = new ArrayList<File>();
        if (attachmentFolder != null) {
            File[] fileArray = attachmentFolder.listFiles();
            int n = fileArray.length;
            int n3 = 0;
            while (n3 < n) {
                File attFile = fileArray[n3];
                if (!attFile.isDirectory() && !WordMailUtility.isWordSpecificFile(attFile.getName())) {
                    attachmentList.add(attFile);
                }
                ++n3;
            }
        }
        mailMessage = new MailUtility.MailMessage(messagePlainText, messageHtml, attachmentList);
        return mailMessage;
    }

    private static String extractHtmlFromWordArchiveInternal(File dir, String simpleName) {
        String txt = null;
        try {
            txt = WordMailUtility.extractTextFromWordArchiveInternal(dir, simpleName, "html");
        }
        catch (Exception e) {
            LOG.error("Error occured while trying to extract plain text file", e);
        }
        return txt;
    }

    private static String extractSimpleNameFromWordArchive(File archiveFile) {
        String simpleName = archiveFile.getName();
        if (archiveFile.getName().lastIndexOf(46) != -1) {
            simpleName = archiveFile.getName().substring(0, archiveFile.getName().lastIndexOf(46));
        }
        return simpleName;
    }

    private static File extractWordArchive(File archiveFile) {
        File tempDir = null;
        try {
            tempDir = IOUtility.createTempDirectory("");
            FileUtility.extractArchive(archiveFile, tempDir);
        }
        catch (Exception e) {
            LOG.error("Error occured while trying to extract word archive", e);
        }
        return tempDir;
    }

    @Deprecated
    public static String extractPlainTextFromWordArchive(File archiveFile) {
        return WordMailUtility.extractPlainTextFromWordArchiveInternal(archiveFile);
    }

    private static String extractPlainTextFromWordArchiveInternal(File archiveFile) {
        File tempDir = WordMailUtility.extractWordArchive(archiveFile);
        String simpleName = WordMailUtility.extractSimpleNameFromWordArchive(archiveFile);
        return WordMailUtility.extractPlainTextFromWordArchiveInternal(tempDir, simpleName);
    }

    private static String extractPlainTextFromWordArchiveInternal(File dir, String simpleName) {
        String plainText = null;
        try {
            plainText = WordMailUtility.extractTextFromWordArchiveInternal(dir, simpleName, "txt");
        }
        catch (Exception e) {
            LOG.error("Error occured while trying to extract plain text file", e);
        }
        return plainText;
    }

    private static String extractTextFromWordArchiveInternal(File dir, String simpleName, String fileType) throws ProcessingException, IOException {
        String txt = null;
        File plainTextFile = new File(dir, String.valueOf(simpleName) + "." + fileType);
        if (plainTextFile.exists() && plainTextFile.canRead()) {
            txt = IOUtility.getContentInEncoding(plainTextFile.getPath(), UTF_8);
        }
        return txt;
    }

    @Deprecated
    public static MimeMessage createMimeMessageFromWordArchiveDirectory(File archiveDir, String simpleName, File[] attachments, boolean markAsUnsent) throws ProcessingException {
        return WordMailUtility.createMimeMessageFromWordArchiveInternal(archiveDir, simpleName, attachments, markAsUnsent);
    }

    @Deprecated
    public static MimeMessage createMimeMessageFromWordArchive(File archiveFile, File[] attachments) throws ProcessingException {
        return WordMailUtility.createMimeMessageFromWordArchive(archiveFile, attachments, false);
    }

    @Deprecated
    public static MimeMessage createMimeMessageFromWordArchive(File archiveFile, File[] attachments, boolean markAsUnsent) throws ProcessingException {
        try {
            File tempDir = IOUtility.createTempDirectory("");
            FileUtility.extractArchive(archiveFile, tempDir);
            String simpleName = archiveFile.getName();
            if (archiveFile.getName().lastIndexOf(46) != -1) {
                simpleName = archiveFile.getName().substring(0, archiveFile.getName().lastIndexOf(46));
            }
            return WordMailUtility.createMimeMessageFromWordArchiveInternal(tempDir, simpleName, attachments, markAsUnsent);
        }
        catch (ProcessingException pe) {
            throw pe;
        }
        catch (IOException e) {
            throw new ProcessingException("Error occured while accessing files", e);
        }
    }

    private static MimeMessage createMimeMessageFromWordArchiveInternal(File archiveDir, String simpleName, File[] attachments, boolean markAsUnsent) throws ProcessingException {
        try {
            File plainTextFile = new File(archiveDir, String.valueOf(simpleName) + ".txt");
            String plainTextMessage = null;
            boolean hasPlainText = false;
            if (plainTextFile.exists()) {
                plainTextMessage = IOUtility.getContentInEncoding(plainTextFile.getPath(), UTF_8);
                hasPlainText = StringUtility.hasText(plainTextMessage);
            }
            String folderName = null;
            ArrayList<DataSource> htmlDataSourceList = new ArrayList<DataSource>();
            File[] fileArray = archiveDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File filesFolder = fileArray[n2];
                if (filesFolder.isDirectory() && filesFolder.getName().startsWith(simpleName)) {
                    folderName = filesFolder.getName();
                    File[] fileArray2 = filesFolder.listFiles();
                    int n3 = fileArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        File file = fileArray2[n4];
                        String filename = file.getName();
                        if (!WordMailUtility.isWordSpecificFile(filename)) {
                            FileDataSource fds = new FileDataSource(file);
                            htmlDataSourceList.add((DataSource)fds);
                        }
                        ++n4;
                    }
                    break;
                }
                ++n2;
            }
            File htmlFile = new File(archiveDir, String.valueOf(simpleName) + ".html");
            String htmlMessage = null;
            boolean hasHtml = false;
            if (htmlFile.exists()) {
                htmlMessage = IOUtility.getContentInEncoding(htmlFile.getPath(), UTF_8);
                htmlMessage = htmlMessage.replaceAll("\"" + folderName + "/", "\"cid:");
                htmlMessage = WordMailUtility.removeWordTags(htmlMessage);
                htmlMessage = htmlMessage.replaceAll("<!--\\[if gte vml 1(.*\\r?\\n)*?.*?endif\\]-->", "");
                htmlMessage = Pattern.compile("<!\\[if !vml\\]>(.*?)<!\\[endif\\]>", 32).matcher(htmlMessage).replaceAll("$1");
                Iterator it = htmlDataSourceList.iterator();
                while (it.hasNext()) {
                    DataSource ds = (DataSource)it.next();
                    if (htmlMessage.contains("cid:" + ds.getName())) continue;
                    it.remove();
                }
                hasHtml = StringUtility.hasText(htmlMessage);
            }
            if (!hasPlainText && !hasHtml) {
                throw new ProcessingException("message has no body");
            }
            CharsetSafeMimeMessage mimeMessage = new CharsetSafeMimeMessage();
            CharsetSafeMimeMessage bodyPart = null;
            if (attachments != null && attachments.length > 0) {
                MimeMultipart multiPart = new MimeMultipart();
                mimeMessage.setContent((Multipart)multiPart);
                MimeBodyPart multiPartBody = new MimeBodyPart();
                multiPart.addBodyPart((BodyPart)multiPartBody);
                bodyPart = multiPartBody;
                File[] fileArray3 = attachments;
                int n5 = attachments.length;
                int n6 = 0;
                while (n6 < n5) {
                    File attachment = fileArray3[n6];
                    MimeBodyPart part = new MimeBodyPart();
                    FileDataSource fds = new FileDataSource(attachment);
                    DataHandler handler = new DataHandler((DataSource)fds);
                    part.setDataHandler(handler);
                    part.setFileName(MimeUtility.encodeText((String)attachment.getName(), (String)UTF_8, null));
                    multiPart.addBodyPart((BodyPart)part);
                    ++n6;
                }
            } else {
                bodyPart = mimeMessage;
            }
            if (hasPlainText && hasHtml) {
                MimeMultipart alternativePart = new MimeMultipart("alternative");
                bodyPart.setContent((Multipart)alternativePart);
                MimeBodyPart plainBodyPart = new MimeBodyPart();
                alternativePart.addBodyPart((BodyPart)plainBodyPart);
                WordMailUtility.writePlainBody((MimePart)plainBodyPart, plainTextMessage);
                MimeBodyPart htmlBodyPart = new MimeBodyPart();
                alternativePart.addBodyPart((BodyPart)htmlBodyPart);
                WordMailUtility.writeHtmlBody((MimePart)htmlBodyPart, htmlMessage, htmlDataSourceList);
            } else if (hasPlainText) {
                WordMailUtility.writePlainBody((MimePart)bodyPart, plainTextMessage);
            } else {
                WordMailUtility.writeHtmlBody((MimePart)bodyPart, htmlMessage, htmlDataSourceList);
            }
            if (markAsUnsent) {
                mimeMessage.setHeader("X-Unsent", "1");
            }
            return mimeMessage;
        }
        catch (MessagingException e) {
            throw new ProcessingException("Error occured while creating MIME-message", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new ProcessingException("Error occured while creating MIME-message", e);
        }
    }

    private static String removeWordTags(String htmlMessage) {
        htmlMessage = htmlMessage.replaceAll("<link rel=File-List href=\"cid:filelist.xml\">", "");
        htmlMessage = htmlMessage.replaceAll("<link rel=colorSchemeMapping href=\"cid:colorschememapping.xml\">", "");
        htmlMessage = htmlMessage.replaceAll("<link rel=themeData href=\"cid:themedata.thmx\">", "");
        htmlMessage = htmlMessage.replaceAll("<link rel=Edit-Time-Data href=\"cid:editdata.mso\">", "");
        htmlMessage = htmlMessage.replaceAll("<!--\\[if gte mso(.*\\r?\\n)*?.*?endif\\]-->", "");
        return htmlMessage;
    }

    private static boolean isWordSpecificFile(String filename) {
        return "filelist.xml".equalsIgnoreCase(filename) || "colorschememapping.xml".equalsIgnoreCase(filename) || "themedata.thmx".equalsIgnoreCase(filename) || "header.html".equalsIgnoreCase(filename) || "editdata.mso".equalsIgnoreCase(filename) || wordPatternItem.matcher(filename).matches() || wordPatternProps.matcher(filename).matches();
    }

    private static void writeHtmlBody(MimePart htmlBodyPart, String htmlMessage, List<DataSource> htmlDataSourceList) throws MessagingException {
        MimeMultipart multiPartHtml = new MimeMultipart("related");
        htmlBodyPart.setContent((Multipart)multiPartHtml);
        MimeBodyPart part = new MimeBodyPart();
        part.setContent((Object)htmlMessage, "text/html; charset=\"UTF-8\"");
        part.setHeader("Content-Type", "text/html; charset=\"UTF-8\"");
        part.setHeader("Content-Transfer-Encoding", "quoted-printable");
        multiPartHtml.addBodyPart((BodyPart)part);
        for (DataSource source : htmlDataSourceList) {
            part = new MimeBodyPart();
            DataHandler handler = new DataHandler(source);
            part.setDataHandler(handler);
            part.setFileName(source.getName());
            part.addHeader("Content-ID", "<" + source.getName() + ">");
            multiPartHtml.addBodyPart((BodyPart)part);
        }
    }

    private static void writePlainBody(MimePart plainBodyPart, String plainTextMessage) throws MessagingException {
        plainBodyPart.setText(plainTextMessage, UTF_8);
        plainBodyPart.setHeader("Content-Type", "text/plain; charset=\"UTF-8\"");
        plainBodyPart.setHeader("Content-Transfer-Encoding", "quoted-printable");
    }
}

