/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.osgi;

import java.lang.reflect.Array;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.internal.Activator;
import org.eclipse.scout.commons.osgi.BundleInspector;
import org.eclipse.scout.commons.serialization.SerializationUtility;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class BundleListClassLoader
extends ClassLoader {
    private static final String OSGI_RESOURCE_URL_PROTOCOL = "bundleresource";
    private static final Pattern BUNDLE_ID_URL_HOST_NAME_PATTERN = Pattern.compile("(\\d+)" + Pattern.quote(".fwk") + ".*");
    private static final Map<String, Class<?>> PRIMITIVE_TYPES = new HashMap();
    private static final String BUNDLE_INCLUDE_FILTER_PROPERTY = "org.eclipse.scout.commons.osgi.BundleListClassLoader#includeBundles";
    private static final String BUNDLE_EXCLUDE_FILTER_PROPERTY = "org.eclipse.scout.commons.osgi.BundleListClassLoader#excludeBundles";
    private static final String REGEX_MARKER = "regex:";
    private final ClassLoader m_parentClassLoader;
    private final String[] m_bundleOrderPrefixes;
    private final BundleContext m_bundleContext;
    private final Bundle[] m_bundles;
    private final boolean m_useResourceFiltering;
    private final boolean m_useResourceCaching;
    private final Map<String, Class<?>> m_classCache = new ConcurrentHashMap();
    private final Map<String, List<URL>> m_resourceCache = new ConcurrentHashMap<String, List<URL>>();
    private final ThreadLocal<Set<String>> LOOP_DETECTOR = new ThreadLocal<Set<String>>(){

        @Override
        protected Set<String> initialValue() {
            return new HashSet<String>();
        }
    };

    static {
        PRIMITIVE_TYPES.put("boolean", Boolean.TYPE);
        PRIMITIVE_TYPES.put("byte", Byte.TYPE);
        PRIMITIVE_TYPES.put("char", Character.TYPE);
        PRIMITIVE_TYPES.put("short", Short.TYPE);
        PRIMITIVE_TYPES.put("int", Integer.TYPE);
        PRIMITIVE_TYPES.put("long", Long.TYPE);
        PRIMITIVE_TYPES.put("float", Float.TYPE);
        PRIMITIVE_TYPES.put("double", Double.TYPE);
        PRIMITIVE_TYPES.put("void", Void.TYPE);
        PRIMITIVE_TYPES.put("Z", Boolean.TYPE);
        PRIMITIVE_TYPES.put("B", Byte.TYPE);
        PRIMITIVE_TYPES.put("C", Character.TYPE);
        PRIMITIVE_TYPES.put("S", Short.TYPE);
        PRIMITIVE_TYPES.put("I", Integer.TYPE);
        PRIMITIVE_TYPES.put("J", Long.TYPE);
        PRIMITIVE_TYPES.put("F", Float.TYPE);
        PRIMITIVE_TYPES.put("D", Double.TYPE);
        PRIMITIVE_TYPES.put("V", Void.TYPE);
    }

    public BundleListClassLoader(ClassLoader parent, Bundle ... bundles) {
        super(parent);
        ClassLoader classLoader = this.m_parentClassLoader = parent != null ? parent : new ClassLoader(Object.class.getClassLoader()){};
        if (bundles == null || bundles.length == 0) {
            throw new IllegalArgumentException("bundle list must not be null or empty");
        }
        this.m_bundleContext = Activator.getDefault().getBundle().getBundleContext();
        String bundleIncludeFilter = this.m_bundleContext.getProperty(BUNDLE_INCLUDE_FILTER_PROPERTY);
        String bundleExcludeFilter = this.m_bundleContext.getProperty(BUNDLE_EXCLUDE_FILTER_PROPERTY);
        Pattern[] bundleIncludePatterns = BundleListClassLoader.parseFilterPatterns(bundleIncludeFilter);
        Pattern[] bundleExcludePatterns = BundleListClassLoader.parseFilterPatterns(bundleExcludeFilter);
        ArrayList<Bundle> filteredBundleList = new ArrayList<Bundle>();
        Bundle[] bundleArray = BundleInspector.filterPluginBundles(bundles);
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle b = bundleArray[n2];
            if (BundleListClassLoader.accept(b.getSymbolicName(), bundleIncludePatterns, bundleExcludePatterns)) {
                filteredBundleList.add(b);
            }
            ++n2;
        }
        if (filteredBundleList.isEmpty()) {
            throw new IllegalArgumentException("filtered bundle list must not be empty. [bundles=" + Arrays.toString(bundles) + "]");
        }
        this.m_bundles = filteredBundleList.toArray(new Bundle[filteredBundleList.size()]);
        this.m_useResourceFiltering = SerializationUtility.isUseBundleOrderPrefixListAsResourceFilterEnabled();
        this.m_useResourceCaching = SerializationUtility.isResourceUrlCachingInBundleListClassLoaderEnabled();
        this.m_bundleOrderPrefixes = SerializationUtility.getBundleOrderPrefixes();
    }

    @Override
    protected Class<?> loadClass(String className, boolean resolve) throws ClassNotFoundException {
        Set<String> prev = this.LOOP_DETECTOR.get();
        if (prev.contains(className)) {
            throw new ClassNotFoundException(className);
        }
        try {
            prev.add(className);
            Class<?> clazz = this.doLoadClass(className);
            return clazz;
        }
        finally {
            prev.remove(className);
            if (prev.isEmpty()) {
                this.LOOP_DETECTOR.remove();
            }
        }
    }

    private Class<?> doLoadClass(String className) throws ClassNotFoundException {
        Class<?> fromCache = this.m_classCache.get(className);
        if (fromCache == P_Unknown.class) {
            throw new ClassNotFoundException(className);
        }
        if (fromCache != null) {
            return fromCache;
        }
        if (PRIMITIVE_TYPES.containsKey(className)) {
            return PRIMITIVE_TYPES.get(className);
        }
        Class<?> arrayClass = this.tryLoadAsArray(className);
        if (arrayClass != null) {
            return arrayClass;
        }
        Class<?> fromBundles = this.tryLoadFromBundles(className);
        if (fromBundles != null) {
            return fromBundles;
        }
        try {
            Class<?> fromParent = this.m_parentClassLoader.loadClass(className);
            if (fromParent != null) {
                this.m_classCache.put(className, fromParent);
                return fromParent;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.m_classCache.put(className, P_Unknown.class);
        throw new ClassNotFoundException(className);
    }

    private Class<?> tryLoadAsArray(String className) throws ClassNotFoundException {
        int arrayDim = 0;
        String memberClassName = className;
        while (memberClassName.startsWith("[")) {
            ++arrayDim;
            memberClassName = memberClassName.substring(1);
        }
        if (memberClassName.matches("L.*;")) {
            memberClassName = memberClassName.substring(1, memberClassName.length() - 1);
        }
        if (arrayDim > 0) {
            Class<?> memberClass = this.loadClass(memberClassName);
            int[] dimensions = new int[arrayDim];
            Class<?> arrayClass = Array.newInstance(memberClass, dimensions).getClass();
            this.m_classCache.put(className, arrayClass);
            return arrayClass;
        }
        return null;
    }

    private Class<?> tryLoadFromBundles(String className) {
        Class<?> candidate;
        Bundle bundle;
        HashSet<Bundle> triedBundles = new HashSet<Bundle>();
        Bundle[] bundleArray = this.m_bundles;
        int n = this.m_bundles.length;
        int n2 = 0;
        while (n2 < n) {
            bundle = bundleArray[n2];
            if (className.startsWith(bundle.getSymbolicName()) && (candidate = this.tryLoadFromSingleBundle(className, bundle, triedBundles)) != null) {
                return candidate;
            }
            ++n2;
        }
        bundleArray = this.m_bundles;
        n = this.m_bundles.length;
        n2 = 0;
        while (n2 < n) {
            bundle = bundleArray[n2];
            if (bundle.getState() == 32 && (candidate = this.tryLoadFromSingleBundle(className, bundle, triedBundles)) != null) {
                return candidate;
            }
            ++n2;
        }
        bundleArray = this.m_bundles;
        n = this.m_bundles.length;
        n2 = 0;
        while (n2 < n) {
            bundle = bundleArray[n2];
            candidate = this.tryLoadFromSingleBundle(className, bundle, triedBundles);
            if (candidate != null) {
                return candidate;
            }
            ++n2;
        }
        return null;
    }

    private Class<?> tryLoadFromSingleBundle(String className, Bundle bundle, Set<Bundle> triedBundles) {
        if (triedBundles.contains(bundle)) {
            return null;
        }
        triedBundles.add(bundle);
        try {
            Class result = bundle.loadClass(className);
            this.m_classCache.put(className, result);
            return result;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public URL getResource(String name) {
        Enumeration<URL> all = this.getResources(name);
        if (all != null && all.hasMoreElements()) {
            return all.nextElement();
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String resourceName) {
        Set<String> prev = this.LOOP_DETECTOR.get();
        if (prev.contains(resourceName)) {
            return null;
        }
        try {
            prev.add(resourceName);
            Enumeration<URL> enumeration = this.doGetResources(resourceName);
            return enumeration;
        }
        finally {
            prev.remove(resourceName);
            if (prev.isEmpty()) {
                this.LOOP_DETECTOR.remove();
            }
        }
    }

    private Enumeration<URL> doGetResources(String resourceName) {
        List<URL> fromCache = this.m_resourceCache.get(resourceName);
        if (fromCache != null) {
            return new P_ListEnumeration(fromCache);
        }
        ArrayList<URL> all = new ArrayList<URL>();
        Bundle[] bundleArray = this.m_bundles;
        int n = this.m_bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle b = bundleArray[n2];
            try {
                Enumeration en = b.getResources(resourceName);
                while (en != null && en.hasMoreElements()) {
                    all.add((URL)en.nextElement());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
        List<URL> filtered = this.filterResources(all);
        if (this.m_useResourceCaching) {
            this.m_resourceCache.put(resourceName, filtered);
        }
        return new P_ListEnumeration(filtered);
    }

    private List<URL> filterResources(List<URL> all) {
        if (!this.m_useResourceFiltering) {
            return all;
        }
        ArrayList<URL> customUrlList = new ArrayList<URL>();
        for (URL url : all) {
            if (!this.isUrlFromBundlePrefixes(url)) continue;
            customUrlList.add(url);
        }
        if (customUrlList.size() > 0) {
            return customUrlList;
        }
        return all;
    }

    private boolean isUrlFromBundlePrefixes(URL resource) {
        if (!OSGI_RESOURCE_URL_PROTOCOL.equalsIgnoreCase(resource.getProtocol()) || resource.getHost() == null) {
            return false;
        }
        Matcher m = BUNDLE_ID_URL_HOST_NAME_PATTERN.matcher(resource.getHost());
        if (!m.matches()) {
            return false;
        }
        long bundleId = Long.valueOf(m.group(1));
        Bundle bundle = this.m_bundleContext.getBundle(bundleId);
        if (bundle != null) {
            String[] stringArray = this.m_bundleOrderPrefixes;
            int n = this.m_bundleOrderPrefixes.length;
            int n2 = 0;
            while (n2 < n) {
                String bundlePrefix = stringArray[n2];
                if (StringUtility.contains(bundle.getSymbolicName(), bundlePrefix)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private static boolean accept(String s, Pattern[] includePatterns, Pattern[] excludePatterns) {
        Pattern p;
        int n;
        int n2;
        Pattern[] patternArray;
        if (s == null) {
            return false;
        }
        boolean included = true;
        boolean excluded = false;
        if (includePatterns != null && includePatterns.length > 0) {
            included = false;
            patternArray = includePatterns;
            n2 = includePatterns.length;
            n = 0;
            while (n < n2) {
                p = patternArray[n];
                if (p.matcher(s).matches()) {
                    included = true;
                    break;
                }
                ++n;
            }
        }
        if (included && excludePatterns != null && excludePatterns.length > 0) {
            patternArray = excludePatterns;
            n2 = excludePatterns.length;
            n = 0;
            while (n < n2) {
                p = patternArray[n];
                if (p.matcher(s).matches()) {
                    excluded = true;
                    break;
                }
                ++n;
            }
        }
        return included && !excluded;
    }

    private static Pattern[] parseFilterPatterns(String filter) {
        if (filter == null) {
            return null;
        }
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        String[] stringArray = filter.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String f = stringArray[n2];
            if ((f = f.trim()).length() > 0) {
                try {
                    f = BundleListClassLoader.toRegexPattern(f);
                    Pattern pattern = Pattern.compile(f);
                    patterns.add(pattern);
                }
                catch (Exception e) {
                    System.err.println("invalid filter pattern: " + e);
                }
            }
            ++n2;
        }
        if (patterns.isEmpty()) {
            return null;
        }
        return patterns.toArray(new Pattern[patterns.size()]);
    }

    private static String toRegexPattern(String s) {
        if (s == null) {
            return null;
        }
        String pattern = s.trim();
        if (pattern.startsWith(REGEX_MARKER)) {
            return pattern.substring(REGEX_MARKER.length());
        }
        pattern = pattern.replaceAll("[.]", "\\\\.");
        pattern = pattern.replaceAll("[*]", ".*");
        pattern = pattern.replaceAll("[?]", ".");
        return pattern;
    }

    private static class P_ListEnumeration
    implements Enumeration<URL> {
        private final Iterator<URL> m_iterator;

        public P_ListEnumeration(Iterable<URL> inner) {
            this.m_iterator = inner.iterator();
        }

        @Override
        public boolean hasMoreElements() {
            return this.m_iterator.hasNext();
        }

        @Override
        public URL nextElement() {
            return this.m_iterator.next();
        }
    }

    private static class P_Unknown {
        private P_Unknown() {
        }
    }
}

