/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.simple.model.ws.nlsfile;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.scout.nls.sdk.internal.NlsCore;
import org.eclipse.scout.nls.sdk.simple.model.ws.nlsfile.AbstractNlsFile;
import org.eclipse.scout.sdk.util.resources.IResourceFilter;
import org.eclipse.scout.sdk.util.resources.ResourceUtility;
import org.eclipse.scout.sdk.util.resources.WeakResourceChangeListener;

public class WorkspaceNlsFile
extends AbstractNlsFile {
    private final IFile m_file;
    private final IResourceChangeListener m_translationFileChangedListener;

    public WorkspaceNlsFile(IFile file) throws CoreException {
        super(file);
        this.m_file = file;
        this.m_translationFileChangedListener = new P_NlsFileChangeListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)new WeakResourceChangeListener(this.m_translationFileChangedListener), 1);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    private class P_NlsFileChangeListener
    implements IResourceChangeListener {
        private P_NlsFileChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            try {
                IResourceDelta delta = event.getDelta();
                List matches = ResourceUtility.getAllResources((IResourceDelta)delta, (IResourceFilter)new IResourceFilter(){

                    public boolean accept(IResourceProxy resource) {
                        return WorkspaceNlsFile.this.m_file.equals((Object)resource.requestResource());
                    }
                });
                if (!matches.isEmpty()) {
                    WorkspaceNlsFile.this.parseInput(WorkspaceNlsFile.this.m_file);
                }
            }
            catch (CoreException e) {
                NlsCore.logWarning((Throwable)e);
            }
        }
    }
}

