/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.simple.model.ws.translationfile;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.nls.sdk.internal.NlsCore;
import org.eclipse.scout.nls.sdk.model.workspace.translationResource.AbstractTranslationResource;
import org.eclipse.scout.nls.sdk.model.workspace.translationResource.ITranslationResource;
import org.eclipse.scout.nls.sdk.model.workspace.translationResource.TranslationResourceEvent;
import org.eclipse.scout.nls.sdk.simple.internal.NlsSdkSimple;
import org.eclipse.scout.sdk.util.resources.ResourceUtility;
import org.eclipse.scout.sdk.util.resources.WeakResourceChangeListener;

public class WorkspaceTranslationFile
extends AbstractTranslationResource {
    private final IFile m_file;
    private final IResourceChangeListener m_translationFileChangedListener;

    public WorkspaceTranslationFile(IFile file) {
        super(NlsSdkSimple.getLanguage(file.getName()));
        Assert.isTrue((file != null ? 1 : 0) != 0);
        Assert.isTrue((boolean)file.exists());
        this.m_file = file;
        this.m_translationFileChangedListener = new P_TranslationFileChangedListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)new WeakResourceChangeListener(this.m_translationFileChangedListener), 1);
        this.reload((IProgressMonitor)new NullProgressMonitor());
    }

    public boolean isReadOnly() {
        return false;
    }

    public void reload(IProgressMonitor monitor) {
        block12: {
            InputStream io = null;
            try {
                try {
                    this.m_file.refreshLocal(0, monitor);
                    io = this.m_file.getContents();
                    this.parseResource(io);
                }
                catch (Exception e) {
                    NlsCore.logError((String)("cold not reload translation file: " + this.m_file.getName()), (Throwable)e);
                    if (io == null) break block12;
                    try {
                        io.close();
                    }
                    catch (IOException e2) {
                        NlsSdkSimple.logWarning("could not close input stream of file '" + this.m_file.getFullPath() + "'.", e2);
                    }
                }
            }
            finally {
                if (io != null) {
                    try {
                        io.close();
                    }
                    catch (IOException e) {
                        NlsSdkSimple.logWarning("could not close input stream of file '" + this.m_file.getFullPath() + "'.", e);
                    }
                }
            }
        }
    }

    public void updateText(String key, String newText, boolean fireEvent, IProgressMonitor monitor) {
        this.setTranslation(key, newText, fireEvent, monitor);
    }

    public IStatus remove(String key, IProgressMonitor monitor) {
        super.setTranslation(key, null, false, monitor);
        return Status.OK_STATUS;
    }

    public IStatus updateKey(String oldKey, String newKey, IProgressMonitor monitor) {
        String translation = this.getTranslation(oldKey);
        this.setTranslation(oldKey, null, monitor);
        this.setTranslation(newKey, translation, monitor);
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitChanges(IProgressMonitor monitor) {
        IFile iFile = this.m_file;
        synchronized (iFile) {
            if (!this.m_file.exists()) {
                NlsCore.logError((String)("File: " + this.m_file.getName() + " not found!"));
            }
            Properties prop = new Properties();
            String nl = ResourceUtility.getLineSeparator((IResource)this.m_file);
            Map allTranslations = this.getAllTranslations();
            prop.putAll((Map<?, ?>)allTranslations);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            try {
                prop.store(os, null);
                Object[] lines = os.toString().split(nl);
                int i = 0;
                if (lines.length > 0 && ((String)lines[0]).startsWith("#")) {
                    ++i;
                }
                Arrays.sort(lines);
                StringBuilder builder = new StringBuilder();
                while (i < lines.length) {
                    builder.append(((String)lines[i]).replace("\n", "").replace("\r", ""));
                    builder.append(nl);
                    ++i;
                }
                this.m_file.setContents((InputStream)new ByteArrayInputStream(builder.toString().getBytes()), 2, monitor);
                this.m_file.refreshLocal(1, monitor);
            }
            catch (IOException e1) {
                NlsCore.logError((String)("could not refresh file: " + this.m_file.getName()), (Throwable)e1);
            }
            catch (CoreException e1) {
                NlsCore.logError((String)("could not refresh file: " + this.m_file.getName()), (Throwable)e1);
            }
        }
    }

    private class P_TranslationFileChangedListener
    implements IResourceChangeListener {
        private P_TranslationFileChangedListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                if (delta != null) {
                    delta.accept(new IResourceDeltaVisitor(){

                        public boolean visit(IResourceDelta d) {
                            IResource resource = d.getResource();
                            if (resource != null && resource.equals((Object)WorkspaceTranslationFile.this.m_file)) {
                                if (d.getKind() == 2) {
                                    WorkspaceTranslationFile.this.fireTranslationResourceChanged(new TranslationResourceEvent((ITranslationResource)WorkspaceTranslationFile.this, 1024));
                                } else {
                                    WorkspaceTranslationFile.this.reload((IProgressMonitor)new NullProgressMonitor());
                                }
                            }
                            return true;
                        }
                    });
                }
            }
            catch (CoreException e) {
                NlsCore.logWarning((Throwable)e);
            }
        }
    }
}

