/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.simple.operations;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.scout.commons.nls.DynamicNls;
import org.eclipse.scout.nls.sdk.internal.NlsCore;
import org.eclipse.scout.nls.sdk.internal.jdt.NlsJdtUtility;
import org.eclipse.scout.nls.sdk.simple.internal.NlsSdkSimple;
import org.eclipse.scout.nls.sdk.simple.operations.AbstractCreateNlsProjectOperation;
import org.eclipse.scout.nls.sdk.simple.operations.NewNlsFileOperationDesc;
import org.eclipse.scout.sdk.util.pde.PluginModelHelper;
import org.eclipse.scout.sdk.util.resources.ResourceUtility;

public class CreateSimpleNlsProjectOperation
extends AbstractCreateNlsProjectOperation {
    public CreateSimpleNlsProjectOperation(NewNlsFileOperationDesc desc) {
        super(desc);
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            if (!this.getDesc().getPlugin().isSynchronized(2)) {
                this.getDesc().getPlugin().refreshLocal(2, monitor);
            }
            try {
                PluginModelHelper ed = new PluginModelHelper(this.getDesc().getPlugin());
                ed.Manifest.addDependency("org.eclipse.scout.commons", true);
                if (this.getDesc().getParentPlugin() != null && this.getDesc().getParentFile() != null) {
                    ed.Manifest.addDependency(this.getDesc().getParentPlugin().getBundleDescription().getName());
                }
                ed.Manifest.addExportPackage(this.getDesc().getPackage());
                ed.save();
            }
            catch (Exception e1) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.scout.nls.sdk", 0, "Unable to edit manifest of project " + this.getDesc().getPlugin().getName(), (Throwable)e1));
            }
            this.createJavaClass(monitor);
            this.createLanguageFiles(monitor);
            this.createNlsFile(monitor);
        }
        catch (CoreException e) {
            NlsCore.logError((String)"could not create NLS project", (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    private byte[] getNlsFileContent() {
        StringBuilder writer = new StringBuilder();
        writer.append(CreateSimpleNlsProjectOperation.getNlsFileHeader(this.NL));
        writer.append("Nls-Class=" + this.getDesc().getPackage() + "." + this.getDesc().getClassName() + this.NL);
        return writer.toString().getBytes();
    }

    private void createLanguageFiles(IProgressMonitor monitor) throws CoreException {
        IFolder folder = this.getDesc().getPlugin().getFolder(this.getDesc().getTranslationFolder());
        CreateSimpleNlsProjectOperation.createLanguageFile(null, folder, this.getDesc().getFileName(), monitor);
    }

    private static String getNlsClassFileHeader(String translationFileName, String nl) {
        StringBuilder builder = new StringBuilder();
        builder.append("/**" + nl);
        builder.append(" * This class provides the NLS support." + nl);
        builder.append(" */" + nl);
        return builder.toString();
    }

    private static String getNlsFileHeader(String nl) {
        StringBuilder builder = new StringBuilder();
        builder.append("################################################" + nl);
        builder.append("# This file is maintained by the nls editor.   #" + nl);
        builder.append("# To ensure a properly working nls support     #" + nl);
        builder.append("# keep this file untouched.                    #" + nl);
        builder.append("################################################" + nl);
        return builder.toString();
    }

    private static String getTranslationFileHeader(String nl) {
        StringBuilder builder = new StringBuilder();
        builder.append("##############################################################" + nl);
        builder.append("# This file is maintained by the NLS project and should not  #" + nl);
        builder.append("# be modified directly. Use the NLS Editor to add, remove or #" + nl);
        builder.append("# change translations.                                       #" + nl);
        builder.append("##############################################################" + nl);
        return builder.toString();
    }

    public static void createLanguageFile(String lang, IFolder folder, String filePrefix, IProgressMonitor monitor) throws CoreException {
        NlsJdtUtility.createFolder((IContainer)folder, (boolean)true, (IProgressMonitor)monitor);
        lang = lang == null ? "" : "_" + lang;
        String filename = String.valueOf(filePrefix) + lang + ".properties";
        IFile file = folder.getFile(filename);
        if (!file.exists()) {
            file.create((InputStream)new ByteArrayInputStream(CreateSimpleNlsProjectOperation.getDefaultMessagesFileContent(ResourceUtility.getLineSeparator((IResource)folder))), true, monitor);
        }
    }

    private void createNlsFile(IProgressMonitor monitor) throws CoreException {
        IFile file;
        if (this.getDesc().getPlugin() != null && !(file = this.getDesc().getPlugin().getFile(String.valueOf(this.getDesc().getFileName()) + ".nls")).exists()) {
            file.create((InputStream)new ByteArrayInputStream(this.getNlsFileContent()), true, monitor);
        }
    }

    private void createJavaClass(IProgressMonitor monitor) throws CoreException {
        this.createJavaClass(this.getDesc().getPlugin(), this.getDesc().getSourceContainer(), this.getDesc().getPackage(), this.getDesc().getClassName(), this.getClassContent(), monitor);
    }

    public static String getResourcePathString(String folder, String filePrefix) {
        String resourcePathString = folder;
        resourcePathString = resourcePathString.replace("/", ".");
        if ((resourcePathString = String.valueOf(resourcePathString) + "." + filePrefix).endsWith(".properties")) {
            resourcePathString = resourcePathString.substring(0, resourcePathString.length() - ".properties".length());
        }
        return resourcePathString;
    }

    private byte[] getClassContent() throws CoreException {
        NewNlsFileOperationDesc desc = this.getDesc();
        String className = desc.getClassName();
        IType parentType = null;
        if (desc.getParentFile() != null) {
            Properties parentProperties = new Properties();
            InputStream io = null;
            try {
                try {
                    io = desc.getParentFile().getContents();
                    parentProperties.load(io);
                }
                catch (Exception e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.scout.nls.sdk", 0, "Unable to load parent nls file. ", (Throwable)e));
                }
            }
            finally {
                if (io != null) {
                    try {
                        io.close();
                    }
                    catch (IOException e) {
                        NlsSdkSimple.logWarning("could not close input stream of file '" + desc.getParentFile().getFullPath() + "'.", e);
                    }
                }
            }
            String parentClass = parentProperties.getProperty("Nls-Class");
            IJavaProject jp = JavaCore.create((IProject)desc.getParentFile().getProject());
            parentType = jp.findType(parentClass);
        }
        String resourcePathString = CreateSimpleNlsProjectOperation.getResourcePathString(this.getDesc().getTranslationFolder(), this.getDesc().getFileName());
        StringBuilder writer = new StringBuilder();
        writer.append("package " + desc.getPackage() + ";" + this.NL);
        writer.append(this.NL);
        writer.append("import java.util.Locale;" + this.NL);
        writer.append(this.NL);
        writer.append(CreateSimpleNlsProjectOperation.getNlsClassFileHeader(String.valueOf(desc.getFileName()) + ".nls", this.NL));
        writer.append("public class " + className + " extends ");
        if (parentType != null) {
            writer.append(String.valueOf(parentType.getFullyQualifiedName()) + " {" + this.NL);
        } else {
            writer.append(String.valueOf(DynamicNls.class.getName()) + " {" + this.NL);
        }
        writer.append("  private static String RESOURCE_BUNDLE_NAME = \"" + resourcePathString + "\"; //$NON-NLS-1$" + this.NL);
        writer.append("  private static " + className + " instance = new " + className + "();" + this.NL);
        writer.append(this.NL);
        writer.append("  public static " + className + " getInstance() {" + this.NL);
        writer.append("    return instance;" + this.NL);
        writer.append("  }" + this.NL);
        writer.append(this.NL);
        writer.append("  protected " + className + "() {" + this.NL);
        writer.append("    registerResourceBundle(RESOURCE_BUNDLE_NAME, " + className + ".class);" + this.NL);
        writer.append("  }" + this.NL);
        writer.append(this.NL);
        writer.append("  public static String get(String key, String... messageArguments){" + this.NL);
        writer.append("    return getInstance().getText(key, messageArguments);" + this.NL);
        writer.append("  }" + this.NL);
        writer.append(this.NL);
        writer.append("  public static String get(Locale locale, String key, String... messageArguments){" + this.NL);
        writer.append("    return getInstance().getText(locale, key, messageArguments);" + this.NL);
        writer.append("  }" + this.NL);
        writer.append("}" + this.NL);
        return writer.toString().getBytes();
    }

    private static byte[] getDefaultMessagesFileContent(String nl) {
        StringBuilder writer = new StringBuilder();
        writer.append(CreateSimpleNlsProjectOperation.getTranslationFileHeader(nl));
        return writer.toString().getBytes();
    }
}

