/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.simple.ui.wizard;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.dialogs.PluginSelectionDialog;
import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.nls.sdk.internal.NlsCore;
import org.eclipse.scout.nls.sdk.internal.ui.FieldValidator;
import org.eclipse.scout.nls.sdk.internal.ui.TextButtonField;
import org.eclipse.scout.nls.sdk.internal.ui.TextField;
import org.eclipse.scout.nls.sdk.internal.ui.fields.IInputChangedListener;
import org.eclipse.scout.nls.sdk.internal.ui.formatter.IInputValidator;
import org.eclipse.scout.nls.sdk.internal.ui.smartfield.ISmartFieldListener;
import org.eclipse.scout.nls.sdk.internal.ui.smartfield.ISmartFieldModel;
import org.eclipse.scout.nls.sdk.internal.ui.smartfield.SmartField;
import org.eclipse.scout.nls.sdk.simple.operations.NewNlsFileOperationDesc;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class NewNlsFileWizardPage1
extends NewTypeWizardPage {
    private Composite m_rootPane;
    private FieldValidator m_fieldValidator = new FieldValidator();
    private TextField<String> m_fileName;
    private SmartField m_nlsParentFile;
    private TextButtonField m_nlsParentPluginField;
    private TextButtonField m_pluginField;
    private final P_ParentPluginModifyListener m_parentModifyListener;
    private final OptimisticLock m_lock = new OptimisticLock();
    private final NewNlsFileOperationDesc m_desc;

    public NewNlsFileWizardPage1(String pageName, NewNlsFileOperationDesc desc) {
        super(true, "new NLS File");
        this.setTitle("Create a NLS file");
        this.setDescription("This file is provides an easy handling of translations");
        this.m_desc = desc;
        this.m_parentModifyListener = new P_ParentPluginModifyListener();
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.m_rootPane = new Composite(parent, 0);
        this.m_pluginField = new TextButtonField(this.m_rootPane);
        this.m_fieldValidator.addField((Control)this.m_pluginField);
        this.m_pluginField.setLabelText("Plugin");
        this.m_pluginField.setButtonText("Browse");
        this.m_pluginField.addTextModifyListener((ModifyListener)new P_PluginModifyListener());
        this.m_pluginField.addButtonSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IPluginModel model = NewNlsFileWizardPage1.this.choosePlugin();
                if (model != null) {
                    IProject project = model.getUnderlyingResource().getProject();
                    NewNlsFileWizardPage1.this.m_pluginField.setText(project.getName());
                    NewNlsFileWizardPage1.this.m_desc.setPlugin(project);
                }
            }
        });
        this.m_fileName = new TextField(this.m_rootPane, 8);
        this.m_fieldValidator.addField(this.m_fileName);
        this.m_fileName.setLabelText("File Name");
        this.m_fileName.addInputChangedListener((IInputChangedListener)new IInputChangedListener<String>(){

            public void inputChanged(String input) {
                NewNlsFileWizardPage1.this.m_desc.setFileName(input);
            }
        });
        this.m_fileName.setInputValidator(new IInputValidator(){
            private String m_regexp = "\\b[A-Za-z][a-zA-Z0-9_]{0,200}\\b";

            public IStatus isValid(String value) {
                if (value.matches(this.m_regexp)) {
                    return Status.OK_STATUS;
                }
                return Status.CANCEL_STATUS;
            }
        });
        Control bindingType = this.createDynStatRadioBox(this.m_rootPane);
        this.m_rootPane.setLayout((Layout)new GridLayout(1, false));
        this.attachGridData((Control)this.m_pluginField);
        this.attachGridData((Control)this.m_fileName);
        this.attachGridData(bindingType);
        this.initUi();
    }

    private Control createDynStatRadioBox(Composite parent) {
        Group checkBoxGroup = new Group(parent, 0);
        checkBoxGroup.setText("Inherit Texts of");
        this.m_nlsParentPluginField = new TextButtonField((Composite)checkBoxGroup);
        this.m_fieldValidator.addField((Control)this.m_nlsParentPluginField);
        this.m_nlsParentPluginField.setLabelText("Parent Plugin");
        this.m_nlsParentPluginField.setButtonText("Browse");
        this.m_nlsParentPluginField.addTextModifyListener((ModifyListener)this.m_parentModifyListener);
        this.m_nlsParentPluginField.addButtonSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IPluginModel model = NewNlsFileWizardPage1.this.chooseParentPlugin();
                if (model != null) {
                    NewNlsFileWizardPage1.this.m_nlsParentPluginField.setText(model.getBundleDescription().getName());
                    NewNlsFileWizardPage1.this.m_desc.setParentPlugin((IPluginModelBase)model);
                }
            }
        });
        this.m_nlsParentFile = new SmartField((Composite)checkBoxGroup, 0);
        this.m_fieldValidator.addField((Control)this.m_nlsParentFile);
        this.m_nlsParentFile.setLabel("Parent file");
        this.m_nlsParentFile.setSmartFieldModel((ISmartFieldModel)new P_NlsFileSmartFieldModel());
        this.m_nlsParentFile.addSmartFieldListener(new ISmartFieldListener(){

            public void itemSelected(Object item) {
                NewNlsFileWizardPage1.this.m_desc.setParentFile((IFile)item);
            }
        });
        checkBoxGroup.setLayout((Layout)new GridLayout(2, true));
        GridData data = new GridData();
        data.horizontalSpan = 2;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.m_nlsParentPluginField.setLayoutData((Object)data);
        data = new GridData();
        data.horizontalSpan = 2;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.m_nlsParentFile.setLayoutData((Object)data);
        return checkBoxGroup;
    }

    private void initUi() {
        this.m_desc.addPropertyChangeListener(new P_DescPropertyChangedListener());
        for (Map.Entry<String, Object> entry : this.m_desc.getPropertiesMap().entrySet()) {
            this.handlePropertyChanged(entry.getKey(), null, entry.getValue());
        }
        this.revalidate();
    }

    protected IPluginModel choosePlugin() {
        Object[] models;
        PluginSelectionDialog dialog = new PluginSelectionDialog(this.getShell(), PDECore.getDefault().getModelManager().getWorkspaceModels(), false);
        dialog.create();
        if (dialog.open() == 0 && (models = dialog.getResult()).length > 0) {
            return (IPluginModel)models[0];
        }
        return null;
    }

    protected IPluginModel chooseParentPlugin() {
        Object[] models;
        PluginSelectionDialog dialog = new PluginSelectionDialog(PDEPlugin.getActiveWorkbenchShell(), PDECore.getDefault().getModelManager().getActiveModels(false), false);
        dialog.create();
        if (dialog.open() == 0 && (models = dialog.getResult()).length > 0) {
            return (IPluginModel)models[0];
        }
        return null;
    }

    public Control getControl() {
        return this.m_rootPane;
    }

    public void setVisible(boolean visible) {
        if (this.m_rootPane != null && !this.m_rootPane.isDisposed()) {
            this.m_rootPane.setVisible(visible);
        }
    }

    private void revalidate() {
        this.m_fieldValidator.reset();
        if (this.m_desc.getParentPlugin() == null) {
            this.m_fieldValidator.setDisabled((Control)this.m_nlsParentFile);
        }
        this.m_fieldValidator.apply();
        this.setMessage(null);
        if (this.m_desc.getPlugin() == null) {
            this.setMessage("Plugin must be specified!", 2);
            this.setPageComplete(false);
            return;
        }
        if (this.m_desc.getFileName() == null) {
            this.setMessage("NLS File must be specified!", 2);
            this.setPageComplete(false);
            return;
        }
        if (this.m_desc.getParentPlugin() != null && this.m_desc.getParentFile() == null) {
            this.setMessage("Parent file must be specified", 2);
            this.setPageComplete(false);
            return;
        }
        this.setPageComplete(true);
    }

    private void attachGridData(Control c) {
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        c.setLayoutData((Object)data);
    }

    /*
     * Unable to fully structure code
     */
    private void handlePropertyChanged(String name, Object oldValue, Object newValue) {
        if (name.equals("parentPlugin")) {
            try {
                if (!this.m_lock.acquire()) ** GOTO lbl26
                p = (IPluginModelBase)newValue;
                if (p == null) {
                    this.m_nlsParentPluginField.setText("");
                }
                this.m_nlsParentPluginField.setText(p.getBundleDescription().getName());
            }
            finally {
                this.m_lock.release();
            }
        } else if (name.equals("plugin")) {
            p = (IProject)newValue;
            P_ParentPluginModifyListener.access$0(this.m_parentModifyListener, p);
            try {
                if (this.m_lock.acquire()) {
                    if (p == null) {
                        this.m_pluginField.setText("");
                    } else {
                        this.m_pluginField.setText(p.getName());
                    }
                }
            }
            finally {
                this.m_lock.release();
            }
        }
        this.revalidate();
    }

    private class P_DescPropertyChangedListener
    implements PropertyChangeListener {
        private P_DescPropertyChangedListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            NewNlsFileWizardPage1.this.handlePropertyChanged(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        }
    }

    private class P_NlsFileSmartFieldModel
    implements ISmartFieldModel {
        public Image getImage(Object item) {
            return null;
        }

        public List<Object> getProposals(String pattern) {
            LinkedList<IFile> files = new LinkedList<IFile>();
            Assert.isTrue((NewNlsFileWizardPage1.this.m_desc.getParentPlugin() != null ? 1 : 0) != 0);
            IResource r = NewNlsFileWizardPage1.this.m_desc.getParentPlugin().getUnderlyingResource();
            if (r != null) {
                IProject project = r.getProject();
                try {
                    IJavaProject jp = JavaCore.create((IProject)project);
                    Object[] objectArray = jp.getNonJavaResources();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object o = objectArray[n2];
                        if (o instanceof IFile && "nls".equalsIgnoreCase(((IFile)o).getFileExtension())) {
                            files.add((IFile)o);
                        }
                        ++n2;
                    }
                }
                catch (CoreException e) {
                    NlsCore.logWarning((Throwable)e);
                }
            }
            return new ArrayList<Object>(files);
        }

        public String getText(Object item) {
            return ((IFile)item).getName();
        }
    }

    private class P_ParentPluginModifyListener
    implements ModifyListener {
        private final Map<String, IPluginModelBase> m_projects = new HashMap<String, IPluginModelBase>();

        P_ParentPluginModifyListener() {
            this.setPlugin(NewNlsFileWizardPage1.this.m_desc.getPlugin());
        }

        public void modifyText(ModifyEvent e) {
            if (NewNlsFileWizardPage1.this.m_lock.acquire()) {
                try {
                    String input = NewNlsFileWizardPage1.this.m_pluginField.getText();
                    if (this.m_projects.keySet().contains(input)) {
                        NewNlsFileWizardPage1.this.m_desc.setParentPlugin(this.m_projects.get(input));
                    } else {
                        NewNlsFileWizardPage1.this.m_desc.setPlugin(null);
                        NewNlsFileWizardPage1.this.setMessage("invalid plugin name", 2);
                    }
                }
                finally {
                    NewNlsFileWizardPage1.this.m_lock.release();
                }
            }
        }

        private void setPlugin(IProject plugin) {
            if (plugin != null) {
                this.m_projects.clear();
                IPluginModelBase[] iPluginModelBaseArray = PDECore.getDefault().getModelManager().getActiveModels(false);
                int n = iPluginModelBaseArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IPluginModelBase model = iPluginModelBaseArray[n2];
                    this.m_projects.put(model.getBundleDescription().getName(), model);
                    ++n2;
                }
            }
        }

        static /* synthetic */ void access$0(P_ParentPluginModifyListener p_ParentPluginModifyListener, IProject iProject) {
            p_ParentPluginModifyListener.setPlugin(iProject);
        }
    }

    private class P_PluginModifyListener
    implements ModifyListener {
        private final Map<String, IProject> m_projects = new HashMap<String, IProject>();

        P_PluginModifyListener() {
            IPluginModelBase[] iPluginModelBaseArray = PluginRegistry.getWorkspaceModels();
            int n = iPluginModelBaseArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginModelBase model = iPluginModelBaseArray[n2];
                IProject project = model.getUnderlyingResource().getProject();
                if (project != null) {
                    this.m_projects.put(project.getName(), project);
                }
                ++n2;
            }
        }

        public void modifyText(ModifyEvent e) {
            if (NewNlsFileWizardPage1.this.m_lock.acquire()) {
                try {
                    String input = NewNlsFileWizardPage1.this.m_pluginField.getText();
                    if (this.m_projects.keySet().contains(input)) {
                        NewNlsFileWizardPage1.this.m_desc.setPlugin(this.m_projects.get(input));
                    } else {
                        NewNlsFileWizardPage1.this.m_desc.setPlugin(null);
                        NewNlsFileWizardPage1.this.setMessage("invalid plugin name", 2);
                    }
                }
                finally {
                    NewNlsFileWizardPage1.this.m_lock.release();
                }
            }
        }
    }
}

