/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.simple.ui.wizard;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.scout.nls.sdk.internal.NlsCore;
import org.eclipse.scout.sdk.util.resources.IResourceFilter;
import org.eclipse.scout.sdk.util.resources.ResourceProxy;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class ResourceProposalModel
extends LabelProvider
implements IContentProposalProvider {
    private final Set<String> m_proposalSorting = new TreeSet<String>();
    private final Map<String, P_ResourceProposal> m_proposals = new HashMap<String, P_ResourceProposal>();
    private IProject[] m_projects;
    private IResourceFilter m_filter = null;

    public void setProjects(IProject[] projects) {
        this.m_projects = projects;
        this.refreshProposals();
    }

    private void refreshProposals() {
        if (this.m_projects == null) {
            return;
        }
        this.m_proposals.clear();
        this.m_proposalSorting.clear();
        IProject[] iProjectArray = this.m_projects;
        int n = this.m_projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                ArrayList<P_ResourceProposal> proposals = new ArrayList<P_ResourceProposal>();
                this.getResources(project, proposals);
                for (P_ResourceProposal prop : proposals) {
                    this.m_proposals.put(prop.getContent(), prop);
                    this.m_proposalSorting.add(prop.getContent());
                }
            }
            catch (CoreException e) {
                NlsCore.logWarning((Throwable)e);
            }
            ++n2;
        }
    }

    private List<P_ResourceProposal> getResources(IProject project, List<P_ResourceProposal> resources) throws CoreException {
        IResource[] iResourceArray = project.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (this.m_filter == null || this.m_filter.accept((IResourceProxy)new ResourceProxy(resource))) {
                P_ResourceProposal p = new P_ResourceProposal(resource);
                resources.add(p);
                if (resource instanceof IFolder) {
                    this.getResources(project, (IFolder)resource, resources);
                }
            }
            ++n2;
        }
        return resources;
    }

    private List<P_ResourceProposal> getResources(IProject project, IFolder parentResouce, List<P_ResourceProposal> resources) throws CoreException {
        IResource[] iResourceArray = parentResouce.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (this.m_filter == null || this.m_filter.accept((IResourceProxy)new ResourceProxy(resource))) {
                P_ResourceProposal p = new P_ResourceProposal(resource);
                resources.add(p);
                if (resource instanceof IFolder) {
                    this.getResources(project, (IFolder)resource, resources);
                }
            }
            ++n2;
        }
        return resources;
    }

    public void setResourceFilter(IResourceFilter filter) {
        this.m_filter = filter;
        this.refreshProposals();
    }

    public IResourceFilter getResourceFilter() {
        return this.m_filter;
    }

    public IContentProposal[] getProposals(String contents, int position) {
        ArrayList<P_ResourceProposal> list = new ArrayList<P_ResourceProposal>();
        for (String proptext : this.m_proposalSorting) {
            if (!proptext.startsWith(contents)) continue;
            list.add(this.m_proposals.get(proptext));
        }
        return list.toArray(new IContentProposal[list.size()]);
    }

    public Image getImage(Object element) {
        P_ResourceProposal prop = (P_ResourceProposal)element;
        return prop.getImage();
    }

    public String getText(Object element) {
        P_ResourceProposal prop = (P_ResourceProposal)element;
        return prop.getContent();
    }

    private class P_ResourceProposal
    implements IContentProposal {
        private IResource m_resource;

        public P_ResourceProposal(IResource resource) {
            this.m_resource = resource;
        }

        public String getContent() {
            return this.m_resource.getProjectRelativePath().toPortableString();
        }

        public int getCursorPosition() {
            return this.getContent().length();
        }

        public String getDescription() {
            return null;
        }

        public String getLabel() {
            return this.getContent();
        }

        public Image getImage() {
            if (this.m_resource instanceof IFolder) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
            }
            if (this.m_resource instanceof IFile) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
            }
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
        }
    }
}

