/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.internal.ui.editor;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.scout.nls.sdk.internal.NlsCore;
import org.eclipse.scout.nls.sdk.internal.model.InheritedFilter;
import org.eclipse.scout.nls.sdk.internal.model.NlsTableModel;
import org.eclipse.scout.nls.sdk.internal.ui.editor.NlsFilterComponent;
import org.eclipse.scout.nls.sdk.internal.ui.editor.NlsTableCursor;
import org.eclipse.scout.nls.sdk.internal.ui.editor.NlsTableInputValidator;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.nls.sdk.model.util.Language;
import org.eclipse.scout.nls.sdk.model.workspace.NlsEntry;
import org.eclipse.scout.nls.sdk.ui.INlsTableActionHanlder;
import org.eclipse.scout.nls.sdk.ui.INlsTableCursorManangerListener;
import org.eclipse.scout.nls.sdk.util.concurrent.AbstractJob;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class NlsTable
extends Composite {
    public static final int AMOUNT_UTILITY_COLS = 1;
    public static final int INDEX_COLUMN_KEYS = 1;
    public static final int REFRESH_ORIGINAL_COLUMN = 1;
    public static final int REFRESH_ALL = 1;
    public static final String LANGUAGE_COLUMN_ID = "columnIdentifierLanguage";
    private Table m_table;
    private NlsTableCursor m_cursorManager;
    private TableColumn m_sortColumn;
    private MenuManager m_menuManger;
    private TableViewer m_viewer;
    private NlsTableModel m_tableModel;
    private InheritedFilter m_inheritedFilter = new InheritedFilter();
    private INlsTableActionHanlder m_actionHanlder;
    private NlsFilterComponent m_filterComp;

    public NlsTable(Composite parent, NlsTableModel model) {
        super(parent, 0);
        this.setBackground(parent.getBackground());
        this.createContent(this);
        this.setModel(model);
    }

    public void setHideInherited(boolean hideInherited) {
        this.m_table.setRedraw(false);
        try {
            if (hideInherited) {
                this.m_viewer.addFilter((ViewerFilter)this.m_inheritedFilter);
            } else {
                this.m_viewer.removeFilter((ViewerFilter)this.m_inheritedFilter);
            }
        }
        finally {
            this.m_table.setRedraw(true);
        }
    }

    public Table getTable() {
        return this.m_table;
    }

    private void createContent(Composite parent) {
        this.m_table = new Table(parent, 65538);
        this.m_table.setHeaderVisible(true);
        this.m_table.setLinesVisible(true);
        this.m_cursorManager = new NlsTableCursor(this.m_table, this);
        this.m_cursorManager.addCursorMangerListener(new INlsTableCursorManangerListener(){

            @Override
            public void textChangend(INlsEntry row, int i, String string) {
                NlsTable.this.handleTextUpdate(row, i, string);
            }
        });
        this.m_viewer = new TableViewer(this.m_table);
        this.m_filterComp = new NlsFilterComponent(parent);
        this.m_filterComp.setTableViewer(this.m_viewer);
        this.m_viewer.setUseHashlookup(true);
        this.m_viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                if (selection.size() > 1) {
                    NlsTable.this.m_cursorManager.getCursor().setVisible(false);
                } else {
                    NlsTable.this.m_cursorManager.getCursor().setVisible(true);
                }
            }
        });
        this.m_cursorManager.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x100000E) {
                    NlsTable.this.m_actionHanlder.handleRefreshTable();
                }
                if (e.keyCode == 0x100000F) {
                    if (e.stateMask == 131072) {
                        NlsTable.this.m_actionHanlder.handleRefreshReferenceCount(null);
                    } else {
                        NlsTable.this.m_actionHanlder.handleRefreshReferenceCount(NlsTable.this.m_cursorManager.getSelection().getSelectedRow().getKey());
                    }
                }
            }
        });
        this.m_menuManger = new MenuManager();
        this.m_menuManger.setRemoveAllWhenShown(true);
        TableCursor tableCursor = this.m_cursorManager.getCursor();
        Menu contextMenu = this.m_menuManger.createContextMenu((Control)tableCursor);
        tableCursor.setMenu(contextMenu);
        Menu tableMenu = this.m_menuManger.createContextMenu((Control)this.m_table);
        this.m_table.setMenu(tableMenu);
        parent.setLayout((Layout)new FormLayout());
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        this.m_filterComp.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.m_filterComp, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        this.m_table.setLayoutData((Object)data);
    }

    public Point getCursorLocation() {
        TableCursor tableCursor = this.m_cursorManager.getCursor();
        TableItem row = tableCursor.getRow();
        if (row == null) {
            return new Point(-1, -1);
        }
        return new Point(this.m_table.indexOf(tableCursor.getRow()), tableCursor.getColumn());
    }

    public void setEditor(NlsEntry row, int column) {
        if (this.m_table.getColumnCount() < column) {
            return;
        }
        int rowIndex = 0;
        TableItem[] tableItemArray = this.m_table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getData().equals(row)) {
                this.m_cursorManager.setEditableText(rowIndex, column);
                return;
            }
            ++rowIndex;
            ++n2;
        }
    }

    public void setInputValidator(NlsTableInputValidator validator) {
        this.m_cursorManager.setInputValidator(validator);
    }

    public void addMenuListener(IMenuListener listener) {
        this.m_menuManger.addMenuListener(listener);
    }

    private Language getLanguageOfTableColumn(int columnIndex) {
        return this.m_tableModel.getProjects().getAllLanguages().get(columnIndex - 2);
    }

    public NlsTableModel getModel() {
        return this.m_tableModel;
    }

    public void setModel(NlsTableModel model) {
        try {
            this.m_viewer.getTable().setRedraw(false);
            this.m_tableModel = model;
            this.createColumns(this.m_table);
            this.m_viewer.setLabelProvider((IBaseLabelProvider)this.m_tableModel);
            this.m_viewer.setContentProvider((IContentProvider)this.m_tableModel);
            this.m_viewer.setInput((Object)this.m_tableModel);
            this.m_viewer.setComparator((ViewerComparator)this.m_tableModel);
            this.updateSortIcon();
        }
        finally {
            this.m_viewer.getTable().setRedraw(true);
        }
    }

    public void setActionHanlder(INlsTableActionHanlder handler) {
        this.m_actionHanlder = handler;
    }

    private void createColumns(Table table) {
        TableColumn[] cols;
        TableColumn[] tableColumnArray = cols = this.m_table.getColumns();
        int n = cols.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn col = tableColumnArray[n2];
            col.dispose();
            ++n2;
        }
        TableColumn colRefs = new TableColumn(table, 16384);
        colRefs.setResizable(false);
        colRefs.setMoveable(false);
        colRefs.setWidth(45);
        colRefs.setText("*");
        colRefs.setToolTipText("* if the references are not sync!");
        colRefs.addSelectionListener((SelectionListener)new P_SortSelectionAdapter(0));
        int i = 1;
        TableColumn jColumn = new TableColumn(table, 16384);
        jColumn.setText(Language.LANGUAGE_KEY.getDispalyName());
        jColumn.setData(LANGUAGE_COLUMN_ID, (Object)Language.LANGUAGE_KEY);
        jColumn.setMoveable(false);
        jColumn.setWidth(200);
        jColumn.addSelectionListener((SelectionListener)new P_SortSelectionAdapter(i++));
        if (this.m_tableModel.getProjects() != null) {
            for (Language language : this.m_tableModel.getProjects().getAllLanguages()) {
                this.createTableColumnInternal(language);
            }
            this.m_filterComp.columnsChanged();
        }
    }

    public void createTableColumnInternal(Language language) {
        TableColumn c = new TableColumn(this.m_table, 16384);
        c.setData(LANGUAGE_COLUMN_ID, (Object)language);
        if (!language.isLocal()) {
            c.setToolTipText("this language is only in the parent defined!\nCreate a new language for " + language.getLocale().toString() + " to make it locally available.");
            c.setImage(NlsCore.getImage("warning8"));
        }
        c.setText(language.getDispalyName());
        c.setMoveable(true);
        c.addSelectionListener((SelectionListener)new P_SortSelectionAdapter(this.m_table.indexOf(c)));
        c.setWidth(200);
    }

    public void createTableColumn(Language language) {
        this.createTableColumnInternal(language);
        this.m_viewer.setInput((Object)this.m_tableModel);
    }

    private void updateSortIcon() {
        TableColumn col;
        int index = this.m_tableModel.getSortIndex();
        if (index < 0) {
            index = 1;
            this.m_tableModel.setSortIndex(index);
        }
        if ((col = this.m_table.getColumn(index)) == null) {
            return;
        }
        if (col.equals(this.m_sortColumn)) {
            int sortDir = 128;
            switch (this.m_table.getSortDirection()) {
                case 128: {
                    sortDir = 1024;
                }
            }
            this.m_table.setSortDirection(sortDir);
        } else {
            this.m_sortColumn = col;
            this.m_table.setSortColumn(this.m_sortColumn);
            this.m_table.setSortDirection(128);
        }
    }

    private boolean handleTextUpdate(INlsEntry row, int column, String newText) {
        if (column == 1) {
            this.m_tableModel.getProjects().updateKey(row, newText, (IProgressMonitor)new NullProgressMonitor());
            ((NlsEntry)row).setKey(newText);
            this.m_viewer.refresh(false);
            return true;
        }
        NlsEntry copy = new NlsEntry(row);
        copy.addTranslation(this.getLanguageOfTableColumn(column), newText);
        AbstractJob job = new AbstractJob("update text", new Object[]{copy}){

            protected IStatus run(IProgressMonitor monitor) {
                NlsEntry r = (NlsEntry)this.args[0];
                NlsTable.this.m_tableModel.getProjects().updateRow(r, monitor);
                return Status.OK_STATUS;
            }
        };
        job.setSystem(false);
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException e) {
            NlsCore.logWarning(e);
        }
        this.m_viewer.refresh(false);
        return job.getResult().isOK();
    }

    public void asyncRefresh(final INlsEntry row) {
        this.m_table.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                NlsTable.this.refresh(row);
            }
        });
    }

    public void refresh(INlsEntry row) {
        if (row == null) {
            this.refreshAll(false);
        } else {
            this.m_viewer.refresh((Object)row);
        }
    }

    public void refreshAllAsync(final boolean recreateColumns) {
        if (!this.isDisposed()) {
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    NlsTable.this.refreshAll(recreateColumns);
                }
            });
        }
    }

    public void refreshAll(boolean recreateColumns) {
        try {
            this.m_table.setRedraw(false);
            if (recreateColumns) {
                this.createColumns(this.m_table);
            }
            this.m_viewer.refresh();
            TableItem[] selection = this.m_table.getSelection();
            if (selection != null && selection.length > 0) {
                TableItem row = selection.length == 0 ? this.m_table.getItem(this.m_table.getTopIndex()) : selection[0];
                this.m_table.showItem(row);
                this.m_cursorManager.ensureFocus(row);
            }
        }
        finally {
            this.m_table.setRedraw(true);
        }
    }

    public void showEditor() {
        TableCursor cursor = this.m_cursorManager.getCursor();
        Assert.isTrue((cursor.getColumn() == 1 ? 1 : 0) != 0);
        this.m_cursorManager.createEditableText();
    }

    public TableViewer getViewer() {
        return this.m_viewer;
    }

    private class P_SortSelectionAdapter
    extends SelectionAdapter {
        private int m_index;

        public P_SortSelectionAdapter(int index) {
            this.m_index = index;
        }

        public void widgetSelected(SelectionEvent e) {
            if (NlsTable.this.m_tableModel.getSortIndex() == this.m_index) {
                NlsTable.this.m_tableModel.setAscSorting(!NlsTable.this.m_tableModel.isAscSorting());
            } else {
                NlsTable.this.m_tableModel.setAscSorting(false);
                NlsTable.this.m_tableModel.setSortIndex(this.m_index);
            }
            NlsTable.this.updateSortIcon();
            NlsTable.this.refreshAll(false);
        }
    }
}

