/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.mobile.ui.basic.table;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ClientJob;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.mobile.ui.basic.table.ClearTableSelectionFormCloseListener;
import org.eclipse.scout.rt.client.mobile.ui.basic.table.DrillDownStyleMap;
import org.eclipse.scout.rt.client.mobile.ui.basic.table.IMobileTable;
import org.eclipse.scout.rt.client.mobile.ui.basic.table.IMobileTableUiFacade;
import org.eclipse.scout.rt.client.mobile.ui.basic.table.form.DefaultTableRowFormProvider;
import org.eclipse.scout.rt.client.mobile.ui.basic.table.form.ITableRowForm;
import org.eclipse.scout.rt.client.mobile.ui.basic.table.form.ITableRowFormProvider;
import org.eclipse.scout.rt.client.ui.basic.table.AbstractTable;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.ITableUIFacade;

public abstract class AbstractMobileTable
extends AbstractTable
implements IMobileTable {
    private DrillDownStyleMap m_drillDownStyleMap;
    private int m_tableRowFormDisplayHint;
    private String m_tableRowFormDisplayViewId;

    public AbstractMobileTable() {
        this(true);
    }

    public AbstractMobileTable(boolean callInitializer) {
        super(callInitializer);
    }

    protected void initConfig() {
        super.initConfig();
        this.m_drillDownStyleMap = new DrillDownStyleMap();
        this.setPagingEnabled(this.getConfiguredPagingEnabled());
        this.setPageSize(this.getConfiguredPageSize());
        this.setAutoCreateTableRowForm(this.execIsAutoCreateTableRowForm());
        this.setDefaultDrillDownStyle(this.execComputeDefaultDrillDownStyle());
        this.setTableRowFormProvider(this.createTableRowFormProvider());
    }

    @Override
    public boolean isPagingEnabled() {
        return this.propertySupport.getPropertyBool("pagingEnabled");
    }

    @Override
    public void setPagingEnabled(boolean enabled) {
        this.propertySupport.setPropertyBool("pagingEnabled", enabled);
    }

    @Override
    public int getPageSize() {
        return this.propertySupport.getPropertyInt("pageSize");
    }

    @Override
    public void setPageSize(int pageSize) {
        this.propertySupport.setPropertyInt("pageSize", pageSize);
    }

    @Override
    public int getPageIndex() {
        return this.propertySupport.getPropertyInt("pageIndex");
    }

    @Override
    public void setPageIndex(int index) {
        this.propertySupport.setPropertyInt("pageIndex", index);
    }

    @Override
    public int getPageCount() {
        if (this.getRowCount() == 0) {
            return 1;
        }
        return new Double(Math.ceil((double)this.getRowCount() / (double)this.getPageSize())).intValue();
    }

    @Override
    public ITableRowFormProvider getTableRowFormProvider() {
        return (ITableRowFormProvider)this.propertySupport.getProperty("tableRowFormProvider");
    }

    @Override
    public void setTableRowFormProvider(ITableRowFormProvider provider) {
        this.propertySupport.setProperty("tableRowFormProvider", (Object)provider);
    }

    @Override
    public boolean isAutoCreateTableRowForm() {
        return this.propertySupport.getPropertyBool("autoCreateTableRowForm");
    }

    @Override
    public void setAutoCreateTableRowForm(boolean autoCreateTableRowForm) {
        this.propertySupport.setPropertyBool("autoCreateTableRowForm", autoCreateTableRowForm);
    }

    @Override
    public String getDefaultDrillDownStyle() {
        return this.propertySupport.getPropertyString("defaultDrillDownStyle");
    }

    @Override
    public void setDefaultDrillDownStyle(String defaultDrillDownStyle) {
        this.propertySupport.setPropertyString("defaultDrillDownStyle", defaultDrillDownStyle);
    }

    public void putDrillDownStyle(ITableRow row, String drillDownStyle) {
        this.m_drillDownStyleMap.put(row, drillDownStyle);
    }

    public String getDrillDownStyle(ITableRow row) {
        return this.m_drillDownStyleMap.get(row);
    }

    public int getTableRowFormDisplayHint() {
        return this.m_tableRowFormDisplayHint;
    }

    public void setTableRowFormDisplayHint(int tableRowFormDisplayHint) {
        this.m_tableRowFormDisplayHint = tableRowFormDisplayHint;
    }

    public String getTableRowFormDisplayViewId() {
        return this.m_tableRowFormDisplayViewId;
    }

    public void setTableRowFormDisplayViewId(String tableRowFormDisplayViewId) {
        this.m_tableRowFormDisplayViewId = tableRowFormDisplayViewId;
    }

    protected ITableRowFormProvider createTableRowFormProvider() {
        return new DefaultTableRowFormProvider();
    }

    @Override
    public void setDrillDownStyleMap(DrillDownStyleMap drillDownStyleMap) {
        this.m_drillDownStyleMap = drillDownStyleMap;
        if (this.m_drillDownStyleMap == null) {
            this.m_drillDownStyleMap = new DrillDownStyleMap();
        }
    }

    @Override
    public DrillDownStyleMap getDrillDownStyleMap() {
        return this.m_drillDownStyleMap;
    }

    public static void setAutoCreateRowForm(ITable table, boolean autoCreateRowForm) {
        table.setProperty("autoCreateTableRowForm", (Object)autoCreateRowForm);
    }

    public static boolean isAutoCreateRowForm(ITable table) {
        Boolean b = (Boolean)table.getProperty("autoCreateTableRowForm");
        return b != null ? b : false;
    }

    public static void setDrillDownStyleMap(ITable table, DrillDownStyleMap drillDownStyles) {
        table.setProperty("drillDownStyleMap", (Object)drillDownStyles);
    }

    public static DrillDownStyleMap getDrillDownStyleMap(ITable table) {
        return (DrillDownStyleMap)table.getProperty("drillDownStyleMap");
    }

    public static void setDefaultDrillDownStyle(ITable table, String defaultDrillDownStyle) {
        table.setProperty("defaultDrillDownStyle", (Object)defaultDrillDownStyle);
    }

    public static String getDefaultDrillDownStyle(ITable table) {
        return (String)table.getProperty("defaultDrillDownStyle");
    }

    public static boolean isPagingEnabled(ITable table) {
        Boolean b = (Boolean)table.getProperty("pagingEnabled");
        return b != null ? b : false;
    }

    public static void setPagingEnabled(ITable table, boolean enabled) {
        table.setProperty("pagingEnabled", (Object)enabled);
    }

    public static int getPageSize(ITable table) {
        Number n = (Number)table.getProperty("pageSize");
        return n != null ? n.intValue() : 0;
    }

    public static void setPageSize(ITable table, int pageSize) {
        table.setProperty("pageSize", (Object)pageSize);
    }

    public static int getPageIndex(ITable table) {
        Number n = (Number)table.getProperty("pageIndex");
        return n != null ? n.intValue() : 0;
    }

    public static void setPageIndex(ITable table, int index) {
        table.setProperty("pageIndex", (Object)index);
    }

    public static ITableRowFormProvider getTableRowFormProvider(ITable table) {
        return (ITableRowFormProvider)table.getProperty("tableRowFormProvider");
    }

    public static void setTableRowFormProvider(ITable table, ITableRowFormProvider provider) {
        table.setProperty("tableRowFormProvider", (Object)provider);
    }

    protected boolean getConfiguredPagingEnabled() {
        return true;
    }

    protected int getConfiguredPageSize() {
        return 50;
    }

    protected boolean execIsAutoCreateTableRowForm() {
        return !this.isCheckable();
    }

    protected String execComputeDefaultDrillDownStyle() {
        if (this.isCheckable()) {
            return "none";
        }
        return "icon";
    }

    protected void startTableRowForm(ITableRow row) throws ProcessingException {
        ITableRowForm form = this.getTableRowFormProvider().createTableRowForm(row);
        form.setDisplayHint(this.getTableRowFormDisplayHint());
        form.setDisplayViewId(this.getTableRowFormDisplayViewId());
        form.setModal(form.getDisplayHint() == 0);
        form.start();
        if ("icon".equals(this.getDrillDownStyle(row))) {
            form.addFormListener(new ClearTableSelectionFormCloseListener(this));
        }
    }

    protected void clearSelectionDelayed() {
        ClientSyncJob job = new ClientSyncJob("Clearing selection", ClientJob.getCurrentSession()){

            protected void runVoid(IProgressMonitor monitor) throws Throwable {
                AbstractMobileTable.this.clearSelection();
            }
        };
        job.schedule();
    }

    protected void clearSelection() {
        this.selectRow(null);
    }

    protected ITableUIFacade createUIFacade() {
        return new P_MobileTableUIFacade();
    }

    @Override
    public IMobileTableUiFacade getUIFacade() {
        return (IMobileTableUiFacade)super.getUIFacade();
    }

    protected class P_MobileTableUIFacade
    extends AbstractTable.P_TableUIFacade
    implements IMobileTableUiFacade {
        protected P_MobileTableUIFacade() {
            super((AbstractTable)AbstractMobileTable.this);
        }

        @Override
        public void setPageIndexFromUi(int pageIndex) {
            AbstractMobileTable.this.setPageIndex(pageIndex);
        }
    }
}

