/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.mobile.ui.form.fields;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.scout.commons.WeakEventListener;
import org.eclipse.scout.commons.beans.IPropertyObserver;

public class PropertyDelegator<SENDER extends IPropertyObserver, RECEIVER extends IPropertyObserver> {
    private P_PropertyChangeListener m_propertyChangeListener;
    private Set<String> m_filter;
    private SENDER m_sender;
    private RECEIVER m_receiver;

    public PropertyDelegator(SENDER sender, RECEIVER receiver) {
        this(sender, receiver, null);
    }

    public PropertyDelegator(SENDER sender, RECEIVER receiver, Set<String> filteredPropertyNames) {
        this.m_sender = sender;
        this.m_receiver = receiver;
        this.m_filter = filteredPropertyNames;
        if (this.m_filter == null) {
            this.m_filter = new HashSet<String>();
        }
        this.m_propertyChangeListener = new P_PropertyChangeListener();
        this.m_sender.addPropertyChangeListener((PropertyChangeListener)this.m_propertyChangeListener);
    }

    public SENDER getSender() {
        return this.m_sender;
    }

    public RECEIVER getReceiver() {
        return this.m_receiver;
    }

    public void init() {
    }

    public void dispose() {
        this.m_sender.removePropertyChangeListener((PropertyChangeListener)this.m_propertyChangeListener);
        this.m_propertyChangeListener = null;
    }

    protected void handlePropertyChange(String name, Object newValue) {
    }

    private class P_PropertyChangeListener
    implements PropertyChangeListener,
    WeakEventListener {
        private P_PropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!PropertyDelegator.this.m_filter.contains(evt.getPropertyName())) {
                PropertyDelegator.this.handlePropertyChange(evt.getPropertyName(), evt.getNewValue());
            }
        }
    }
}

