/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client;

import java.util.Date;
import java.util.WeakHashMap;
import java.util.zip.CRC32;
import org.eclipse.scout.commons.beans.FastBeanInfo;
import org.eclipse.scout.commons.beans.FastPropertyDescriptor;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.IMemoryPolicy;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.columnfilter.TableColumnFilterEvent;
import org.eclipse.scout.rt.client.ui.basic.table.columnfilter.TableColumnFilterListener;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithTable;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.ISearchForm;
import org.eclipse.scout.rt.client.ui.form.FormEvent;
import org.eclipse.scout.rt.client.ui.form.FormListener;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.fields.pagefield.AbstractPageField;
import org.eclipse.scout.rt.shared.services.common.jdbc.SearchFilter;

public abstract class AbstractMemoryPolicy
implements IMemoryPolicy {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractMemoryPolicy.class);
    private boolean m_active;
    private final WeakHashMap<IForm, String> m_formToIdentifierMap;
    private final WeakHashMap<ITable, String> m_tableToIdentifierMap;
    private final FormListener m_formListener = new FormListener(){

        @Override
        public void formChanged(FormEvent e) throws ProcessingException {
            if (!AbstractMemoryPolicy.this.m_active) {
                e.getForm().removeFormListener(AbstractMemoryPolicy.this.m_formListener);
                return;
            }
            String id = (String)AbstractMemoryPolicy.this.m_formToIdentifierMap.get(e.getForm());
            if (id != null) {
                try {
                    AbstractMemoryPolicy.this.handlePageFormEvent(e, id);
                }
                catch (Throwable t) {
                    LOG.warn("page form event " + e, t);
                }
            }
        }
    };
    private final TableColumnFilterListener m_tableColumnFilterListener = new TableColumnFilterListener(){

        @Override
        public void tableColumnFilterChanged(TableColumnFilterEvent e) throws ProcessingException {
            if (!AbstractMemoryPolicy.this.m_active) {
                e.getColumnFilterManager().removeListener(AbstractMemoryPolicy.this.m_tableColumnFilterListener);
                return;
            }
            String id = (String)AbstractMemoryPolicy.this.m_tableToIdentifierMap.get(e.getTable());
            if (id != null) {
                try {
                    AbstractMemoryPolicy.this.handleTableFilterEvent(e, id);
                }
                catch (Throwable t) {
                    LOG.warn("table filter event " + e, t);
                }
            }
        }
    };

    public AbstractMemoryPolicy() {
        this.m_formToIdentifierMap = new WeakHashMap();
        this.m_tableToIdentifierMap = new WeakHashMap();
    }

    @Override
    public void addNotify() {
        this.m_active = true;
    }

    @Override
    public void removeNotify() {
        this.m_active = false;
    }

    @Override
    public void pageCreated(IPage p) throws ProcessingException {
        String pageTableIdentifier;
        IPageWithTable pt;
        Object table;
        if (p.getOutline() instanceof AbstractPageField.SimpleOutline) {
            return;
        }
        if (p instanceof IPageWithTable && (table = (pt = (IPageWithTable)p).getTable()) != null && (pageTableIdentifier = this.registerPageTable(pt, (ITable)table)) != null) {
            this.loadColumnFilterState((ITable)table, pageTableIdentifier);
        }
    }

    @Override
    public void pageSearchFormStarted(IPageWithTable<?> p) throws ProcessingException {
        if (p.getOutline() instanceof AbstractPageField.SimpleOutline) {
            return;
        }
        ISearchForm f = p.getSearchFormInternal();
        if (f != null) {
            String pageFormIdentifier = this.registerPageForm(p, f);
            if (f.isFormOpen()) {
                this.loadSearchFormState(f, pageFormIdentifier);
            }
        }
    }

    protected String registerPageForm(IPage p, IForm f) {
        String id = this.createUniqueIdForPage(p, f);
        this.m_formToIdentifierMap.put(f, id);
        f.removeFormListener(this.m_formListener);
        f.addFormListener(this.m_formListener);
        return id;
    }

    protected String registerPageTable(IPage p, ITable t) {
        if (t.getColumnFilterManager() == null) {
            return null;
        }
        String id = this.createUniqueIdForPage(p, t);
        this.m_tableToIdentifierMap.put(t, id);
        t.getColumnFilterManager().removeListener(this.m_tableColumnFilterListener);
        t.getColumnFilterManager().addListener(this.m_tableColumnFilterListener);
        return id;
    }

    protected String createUniqueIdForPage(IPage p, Object o) {
        if (p == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        this.createIdForPage(builder, p, o);
        IPage page = p.getParentPage();
        while (page != null) {
            this.createIdForPage(builder, page, null);
            page = page.getParentPage();
        }
        CRC32 crc = new CRC32();
        crc.update(builder.toString().getBytes());
        return "" + crc.getValue();
    }

    private void createIdForPage(StringBuilder b, IPage page, Object o) {
        b.append("/");
        b.append(page.getClass().getName());
        if (page.getUserPreferenceContext() != null) {
            b.append("/");
            b.append(page.getUserPreferenceContext());
        }
        if (o != null) {
            b.append("/");
            b.append(o.getClass().getName());
        }
        FastBeanInfo pi = new FastBeanInfo(page.getClass(), page.getClass().getSuperclass());
        FastPropertyDescriptor[] fastPropertyDescriptorArray = pi.getPropertyDescriptors();
        int n = fastPropertyDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            FastPropertyDescriptor prop = fastPropertyDescriptorArray[n2];
            if (prop.getReadMethod() != null && (Date.class.isAssignableFrom(prop.getPropertyType()) || Number.class.isAssignableFrom(prop.getPropertyType()) || String.class.isAssignableFrom(prop.getPropertyType()) || Long.TYPE.isAssignableFrom(prop.getPropertyType()))) {
                try {
                    b.append("/");
                    b.append(prop.getName());
                    b.append("=");
                    b.append(prop.getReadMethod().invoke((Object)page, new Object[0]));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
    }

    protected void handlePageFormEvent(FormEvent e, String pageFormIdentifier) throws ProcessingException {
        switch (e.getType()) {
            case 1020: {
                this.storeSearchFormState(e.getForm(), pageFormIdentifier);
                break;
            }
            case 2020: {
                this.storeSearchFormState(e.getForm(), pageFormIdentifier);
            }
        }
    }

    protected void loadSearchFormState(IForm f, String pageFormIdentifier) throws ProcessingException {
    }

    protected void storeSearchFormState(IForm f, String pageFormIdentifier) throws ProcessingException {
    }

    protected void handleTableFilterEvent(TableColumnFilterEvent e, String id) throws ProcessingException {
        switch (e.getType()) {
            case 10: 
            case 20: 
            case 30: 
            case 40: {
                this.storeColumnFilterState(e.getTable(), id);
            }
        }
    }

    protected void storeColumnFilterState(ITable t, String pageTableIdentifier) throws ProcessingException {
    }

    protected void loadColumnFilterState(ITable t, String pageTableIdentifier) throws ProcessingException {
    }

    @Override
    public void afterOutlineSelectionChanged(IDesktop desktop) {
    }

    @Override
    public void beforeTablePageLoadData(IPageWithTable<?> page) {
    }

    @Override
    public void afterTablePageLoadData(IPageWithTable<?> page) {
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class SearchFormState {
        final String formContentXml;
        final SearchFilter searchFilter;

        public SearchFormState(String xml, SearchFilter filter) {
            this.formContentXml = xml;
            this.searchFilter = filter;
        }
    }
}

