/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client;

import java.net.CookieManager;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.scout.rt.client.ClientJob;
import org.eclipse.scout.rt.client.IClientSession;

public class MultiClientSessionCookieStore
implements CookieStore {
    private final ReadWriteLock m_cookieStoresLock = new ReentrantReadWriteLock();
    private final Map<IClientSession, CookieStore> m_cookieStores = new WeakHashMap<IClientSession, CookieStore>();
    private final CookieStore m_defaultCookieStore = new CookieManager().getCookieStore();

    @Override
    public void add(URI uri, HttpCookie cookie) {
        this.getDelegate().add(uri, cookie);
    }

    @Override
    public List<HttpCookie> get(URI uri) {
        return this.getDelegate().get(uri);
    }

    @Override
    public List<HttpCookie> getCookies() {
        return this.getDelegate().getCookies();
    }

    @Override
    public List<URI> getURIs() {
        return this.getDelegate().getURIs();
    }

    @Override
    public boolean remove(URI uri, HttpCookie cookie) {
        return this.getDelegate().remove(uri, cookie);
    }

    @Override
    public boolean removeAll() {
        return this.getDelegate().removeAll();
    }

    private CookieStore getDelegate() {
        CookieStore cookieStore;
        IClientSession currentSession = this.getClientSession();
        if (currentSession == null) {
            return this.m_defaultCookieStore;
        }
        this.m_cookieStoresLock.readLock().lock();
        try {
            cookieStore = this.m_cookieStores.get(currentSession);
            if (cookieStore != null) {
                CookieStore cookieStore2 = cookieStore;
                return cookieStore2;
            }
        }
        finally {
            this.m_cookieStoresLock.readLock().unlock();
        }
        this.m_cookieStoresLock.writeLock().lock();
        try {
            cookieStore = this.m_cookieStores.get(currentSession);
            if (cookieStore != null) {
                CookieStore cookieStore3 = cookieStore;
                return cookieStore3;
            }
            cookieStore = new CookieManager().getCookieStore();
            this.m_cookieStores.put(currentSession, cookieStore);
            CookieStore cookieStore4 = cookieStore;
            return cookieStore4;
        }
        finally {
            this.m_cookieStoresLock.writeLock().unlock();
        }
    }

    protected IClientSession getClientSession() {
        return ClientJob.getCurrentSession();
    }

    public void sessionStopped(IClientSession clientSession) {
        this.m_cookieStoresLock.writeLock().lock();
        try {
            this.m_cookieStores.remove(clientSession);
        }
        finally {
            this.m_cookieStoresLock.writeLock().unlock();
        }
    }
}

