/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.extension.ui.basic.tree;

import java.net.URL;
import java.util.Collection;
import java.util.List;
import org.eclipse.scout.commons.dnd.TransferObject;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.extension.ui.basic.tree.ITreeExtension;
import org.eclipse.scout.rt.client.ui.MouseButton;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.tree.AbstractTree;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeEvent;
import org.eclipse.scout.rt.shared.extension.AbstractExtensionChain;

public final class TreeChains {
    private TreeChains() {
    }

    protected static abstract class AbstractTreeChain
    extends AbstractExtensionChain<ITreeExtension<? extends AbstractTree>> {
        public AbstractTreeChain(List<? extends ITreeExtension<? extends AbstractTree>> extensions) {
            super(extensions, ITreeExtension.class);
        }
    }

    public static class TreeDecorateCellChain
    extends AbstractTreeChain {
        public TreeDecorateCellChain(List<? extends ITreeExtension<? extends AbstractTree>> extensions) {
            super(extensions);
        }

        public void execDecorateCell(final ITreeNode node, final Cell cell) throws ProcessingException {
            AbstractExtensionChain.MethodInvocation<Object> methodInvocation = new AbstractExtensionChain.MethodInvocation<Object>((AbstractExtensionChain)this){

                protected void callMethod(ITreeExtension<? extends AbstractTree> next) throws ProcessingException {
                    next.execDecorateCell(TreeDecorateCellChain.this, node, cell);
                }
            };
            this.callChain((AbstractExtensionChain.MethodInvocation)methodInvocation, new Object[]{node, cell});
            if (methodInvocation.getException() instanceof ProcessingException) {
                throw (ProcessingException)methodInvocation.getException();
            }
        }
    }

    public static class TreeDisposeTreeChain
    extends AbstractTreeChain {
        public TreeDisposeTreeChain(List<? extends ITreeExtension<? extends AbstractTree>> extensions) {
            super(extensions);
        }

        public void execDisposeTree() throws ProcessingException {
            AbstractExtensionChain.MethodInvocation<Object> methodInvocation = new AbstractExtensionChain.MethodInvocation<Object>((AbstractExtensionChain)this){

                protected void callMethod(ITreeExtension<? extends AbstractTree> next) throws ProcessingException {
                    next.execDisposeTree(TreeDisposeTreeChain.this);
                }
            };
            this.callChain((AbstractExtensionChain.MethodInvocation)methodInvocation, new Object[0]);
            if (methodInvocation.getException() instanceof ProcessingException) {
                throw (ProcessingException)methodInvocation.getException();
            }
        }
    }

    public static class TreeDragNodeChain
    extends AbstractTreeChain {
        public TreeDragNodeChain(List<? extends ITreeExtension<? extends AbstractTree>> extensions) {
            super(extensions);
        }

        public TransferObject execDrag(final ITreeNode node) throws ProcessingException {
            AbstractExtensionChain.MethodInvocation<TransferObject> methodInvocation = new AbstractExtensionChain.MethodInvocation<TransferObject>((AbstractExtensionChain)this){

                protected void callMethod(ITreeExtension<? extends AbstractTree> next) throws ProcessingException {
                    this.setReturnValue(next.execDrag(TreeDragNodeChain.this, node));
                }
            };
            this.callChain((AbstractExtensionChain.MethodInvocation)methodInvocation, new Object[]{node});
            if (methodInvocation.getException() instanceof ProcessingException) {
                throw (ProcessingException)methodInvocation.getException();
            }
            return (TransferObject)methodInvocation.getReturnValue();
        }
    }

    public static class TreeDragNodesChain
    extends AbstractTreeChain {
        public TreeDragNodesChain(List<? extends ITreeExtension<? extends AbstractTree>> extensions) {
            super(extensions);
        }

        public TransferObject execDrag(final Collection<ITreeNode> nodes) throws ProcessingException {
            AbstractExtensionChain.MethodInvocation<TransferObject> methodInvocation = new AbstractExtensionChain.MethodInvocation<TransferObject>((AbstractExtensionChain)this){

                protected void callMethod(ITreeExtension<? extends AbstractTree> next) throws ProcessingException {
                    this.setReturnValue(next.execDrag(TreeDragNodesChain.this, nodes));
                }
            };
            this.callChain((AbstractExtensionChain.MethodInvocation)methodInvocation, new Object[]{nodes});
            if (methodInvocation.getException() instanceof ProcessingException) {
                throw (ProcessingException)methodInvocation.getException();
            }
            return (TransferObject)methodInvocation.getReturnValue();
        }
    }

    public static class TreeDropChain
    extends AbstractTreeChain {
        public TreeDropChain(List<? extends ITreeExtension<? extends AbstractTree>> extensions) {
            super(extensions);
        }

        public void execDrop(final ITreeNode node, final TransferObject t) throws ProcessingException {
            AbstractExtensionChain.MethodInvocation<Object> methodInvocation = new AbstractExtensionChain.MethodInvocation<Object>((AbstractExtensionChain)this){

                protected void callMethod(ITreeExtension<? extends AbstractTree> next) throws ProcessingException {
                    next.execDrop(TreeDropChain.this, node, t);
                }
            };
            this.callChain((AbstractExtensionChain.MethodInvocation)methodInvocation, new Object[]{node, t});
            if (methodInvocation.getException() instanceof ProcessingException) {
                throw (ProcessingException)methodInvocation.getException();
            }
        }
    }

    public static class TreeDropTargetChangedChain
    extends AbstractTreeChain {
        public TreeDropTargetChangedChain(List<? extends ITreeExtension<? extends AbstractTree>> extensions) {
            super(extensions);
        }

        public void execDropTargetChanged(final ITreeNode node) throws ProcessingException {
            AbstractExtensionChain.MethodInvocation<Object> methodInvocation = new AbstractExtensionChain.MethodInvocation<Object>((AbstractExtensionChain)this){

                protected void callMethod(ITreeExtension<? extends AbstractTree> next) throws ProcessingException {
                    next.execDropTargetChanged(TreeDropTargetChangedChain.this, node);
                }
            };
            this.callChain((AbstractExtensionChain.MethodInvocation)methodInvocation, new Object[]{node});
            if (methodInvocation.getException() instanceof ProcessingException) {
                throw (ProcessingException)methodInvocation.getException();
            }
        }
    }

    public static class TreeHyperlinkActionChain
    extends AbstractTreeChain {
        public TreeHyperlinkActionChain(List<? extends ITreeExtension<? extends AbstractTree>> extensions) {
            super(extensions);
        }

        public void execHyperlinkAction(final URL url, final String path, final boolean local) throws ProcessingException {
            AbstractExtensionChain.MethodInvocation<Object> methodInvocation = new AbstractExtensionChain.MethodInvocation<Object>((AbstractExtensionChain)this){

                protected void callMethod(ITreeExtension<? extends AbstractTree> next) throws ProcessingException {
                    next.execHyperlinkAction(TreeHyperlinkActionChain.this, url, path, local);
                }
            };
            this.callChain((AbstractExtensionChain.MethodInvocation)methodInvocation, new Object[]{url, path, local});
            if (methodInvocation.getException() instanceof ProcessingException) {
                throw (ProcessingException)methodInvocation.getException();
            }
        }
    }

    public static class TreeInitTreeChain
    extends AbstractTreeChain {
        public TreeInitTreeChain(List<? extends ITreeExtension<? extends AbstractTree>> extensions) {
            super(extensions);
        }

        public void execInitTree() throws ProcessingException {
            AbstractExtensionChain.MethodInvocation<Object> methodInvocation = new AbstractExtensionChain.MethodInvocation<Object>((AbstractExtensionChain)this){

                protected void callMethod(ITreeExtension<? extends AbstractTree> next) throws ProcessingException {
                    next.execInitTree(TreeInitTreeChain.this);
                }
            };
            this.callChain((AbstractExtensionChain.MethodInvocation)methodInvocation, new Object[0]);
            if (methodInvocation.getException() instanceof ProcessingException) {
                throw (ProcessingException)methodInvocation.getException();
            }
        }
    }

    public static class TreeNodeActionChain
    extends AbstractTreeChain {
        public TreeNodeActionChain(List<? extends ITreeExtension<? extends AbstractTree>> extensions) {
            super(extensions);
        }

        public void execNodeAction(final ITreeNode node) throws ProcessingException {
            AbstractExtensionChain.MethodInvocation<Object> methodInvocation = new AbstractExtensionChain.MethodInvocation<Object>((AbstractExtensionChain)this){

                protected void callMethod(ITreeExtension<? extends AbstractTree> next) throws ProcessingException {
                    next.execNodeAction(TreeNodeActionChain.this, node);
                }
            };
            this.callChain((AbstractExtensionChain.MethodInvocation)methodInvocation, new Object[]{node});
            if (methodInvocation.getException() instanceof ProcessingException) {
                throw (ProcessingException)methodInvocation.getException();
            }
        }
    }

    public static class TreeNodeClickChain
    extends AbstractTreeChain {
        public TreeNodeClickChain(List<? extends ITreeExtension<? extends AbstractTree>> extensions) {
            super(extensions);
        }

        public void execNodeClick(final ITreeNode node, final MouseButton mouseButton) throws ProcessingException {
            AbstractExtensionChain.MethodInvocation<Object> methodInvocation = new AbstractExtensionChain.MethodInvocation<Object>((AbstractExtensionChain)this){

                protected void callMethod(ITreeExtension<? extends AbstractTree> next) throws ProcessingException {
                    next.execNodeClick(TreeNodeClickChain.this, node, mouseButton);
                }
            };
            this.callChain((AbstractExtensionChain.MethodInvocation)methodInvocation, new Object[]{node, mouseButton});
            if (methodInvocation.getException() instanceof ProcessingException) {
                throw (ProcessingException)methodInvocation.getException();
            }
        }
    }

    public static class TreeNodesSelectedChain
    extends AbstractTreeChain {
        public TreeNodesSelectedChain(List<? extends ITreeExtension<? extends AbstractTree>> extensions) {
            super(extensions);
        }

        public void execNodesSelected(final TreeEvent e) throws ProcessingException {
            AbstractExtensionChain.MethodInvocation<Object> methodInvocation = new AbstractExtensionChain.MethodInvocation<Object>((AbstractExtensionChain)this){

                protected void callMethod(ITreeExtension<? extends AbstractTree> next) throws ProcessingException {
                    next.execNodesSelected(TreeNodesSelectedChain.this, e);
                }
            };
            this.callChain((AbstractExtensionChain.MethodInvocation)methodInvocation, new Object[]{e});
            if (methodInvocation.getException() instanceof ProcessingException) {
                throw (ProcessingException)methodInvocation.getException();
            }
        }
    }
}

