/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.services.common.session.internal;

import javax.security.auth.Subject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.commons.annotations.Priority;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.services.common.session.IClientSessionRegistryService;
import org.eclipse.scout.rt.shared.ui.UserAgent;
import org.eclipse.scout.service.AbstractService;
import org.osgi.framework.Bundle;

@Priority(value=-1.0f)
public class ClientSessionRegistryService
extends AbstractService
implements IClientSessionRegistryService {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(ClientSessionRegistryService.class);

    @Override
    public <T extends IClientSession> T newClientSession(Class<T> clazz, UserAgent userAgent) {
        Bundle bundle = this.getDefiningBundle(clazz);
        if (bundle == null) {
            return null;
        }
        return this.createAndStartClientSession(clazz, bundle, null, null, userAgent);
    }

    @Override
    public <T extends IClientSession> T newClientSession(Class<T> clazz, Subject subject, String virtualSessionId, UserAgent userAgent) {
        Bundle bundle = this.getDefiningBundle(clazz);
        if (bundle == null) {
            return null;
        }
        return this.createAndStartClientSession(clazz, bundle, subject, virtualSessionId, userAgent);
    }

    private <T extends IClientSession> T createAndStartClientSession(Class<T> clazz, final Bundle bundle, Subject subject, String virtualSessionId, UserAgent userAgent) {
        try {
            IClientSession clientSession = (IClientSession)clazz.newInstance();
            clientSession.setSubject(subject);
            if (virtualSessionId != null) {
                clientSession.setVirtualSessionId(virtualSessionId);
            }
            clientSession.setUserAgent(userAgent);
            ClientSyncJob job = new ClientSyncJob("Session startup", clientSession){

                @Override
                protected void runVoid(IProgressMonitor monitor) throws Throwable {
                    1.getCurrentSession().startSession(bundle);
                }
            };
            job.runNow((IProgressMonitor)new NullProgressMonitor());
            job.throwOnError();
            return (T)clientSession;
        }
        catch (Throwable t) {
            LOG.error("could not load session for " + bundle.getSymbolicName(), t);
            return null;
        }
    }

    private <T extends IClientSession> Bundle getDefiningBundle(Class<T> clazz) {
        String symbolicName = clazz.getPackage().getName();
        Bundle bundleLocator = null;
        while (symbolicName != null) {
            bundleLocator = Platform.getBundle((String)symbolicName);
            int i = symbolicName.lastIndexOf(46);
            if (bundleLocator != null || i < 0) break;
            symbolicName = symbolicName.substring(0, i);
        }
        return Platform.getBundle((String)symbolicName);
    }
}

