/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.action.menu;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke;
import org.eclipse.scout.rt.client.ui.action.keystroke.KeyStroke;
import org.eclipse.scout.rt.client.ui.action.menu.ActivityMapMenuType;
import org.eclipse.scout.rt.client.ui.action.menu.CalendarMenuType;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.TableMenuType;
import org.eclipse.scout.rt.client.ui.action.menu.TreeMenuType;
import org.eclipse.scout.rt.client.ui.action.menu.ValueFieldMenuType;
import org.eclipse.scout.rt.client.ui.action.tree.IActionNode;
import org.eclipse.scout.rt.client.ui.basic.activitymap.ActivityCell;
import org.eclipse.scout.rt.client.ui.basic.calendar.CalendarComponent;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;

public final class MenuUtility {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(MenuUtility.class);

    private MenuUtility() {
    }

    public static List<IKeyStroke> getKeyStrokesFromMenus(List<? extends IMenu> menu) {
        HashSet<String> keys = new HashSet<String>();
        if (menu != null) {
            ArrayList<IKeyStroke> keyStrokes = new ArrayList<IKeyStroke>(menu.size());
            for (IMenu iMenu : menu) {
                String s = iMenu.getKeyStroke();
                if (!StringUtility.hasText((CharSequence)s)) continue;
                try {
                    KeyStroke ks = new KeyStroke(s, iMenu);
                    ks.initAction();
                    if (!keys.add(ks.getKeyStroke())) continue;
                    keyStrokes.add(ks);
                }
                catch (ProcessingException e) {
                    LOG.error("could not initialize enter key stroke.", (Throwable)e);
                }
            }
            return keyStrokes;
        }
        return CollectionUtility.emptyArrayList();
    }

    public static <T extends IActionNode<?>> boolean isVisible(T menu) {
        if (!menu.isVisible()) {
            return false;
        }
        if (menu.hasChildActions()) {
            boolean visible = false;
            for (Object o : menu.getChildActions()) {
                IActionNode m;
                if (!(o instanceof IActionNode) || (m = (IActionNode)o).isSeparator() || !m.isVisible()) continue;
                visible = true;
                break;
            }
            return visible;
        }
        return true;
    }

    public static <T extends IActionNode<?>> List<T> consolidateMenus(List<T> original) {
        LinkedList<IActionNode> consolidatedMenus = new LinkedList<IActionNode>();
        IAction lastMenu = null;
        for (IActionNode m : original) {
            if (!MenuUtility.isVisible(m)) continue;
            if (m.isSeparator()) {
                if (lastMenu != null && !lastMenu.isSeparator()) {
                    consolidatedMenus.add(m);
                }
            } else {
                consolidatedMenus.add(m);
            }
            lastMenu = m;
        }
        while (!consolidatedMenus.isEmpty() && ((IActionNode)consolidatedMenus.getLast()).isSeparator()) {
            consolidatedMenus.removeLast();
        }
        return consolidatedMenus;
    }

    public static Set<ActivityMapMenuType> getMenuTypesForActivityMapSelection(ActivityCell<?, ?> selectedCell) {
        if (selectedCell == null) {
            return CollectionUtility.hashSet((Object)ActivityMapMenuType.Selection);
        }
        return CollectionUtility.hashSet((Object)ActivityMapMenuType.Activity);
    }

    public static Set<CalendarMenuType> getMenuTypesForCalendarSelection(CalendarComponent selectedComponent) {
        if (selectedComponent == null) {
            return CollectionUtility.hashSet((Object)CalendarMenuType.EmptySpace);
        }
        return CollectionUtility.hashSet((Object)CalendarMenuType.CalendarComponent);
    }

    public static Set<TableMenuType> getMenuTypesForTableSelection(List<? extends ITableRow> selection) {
        if (CollectionUtility.isEmpty(selection)) {
            return CollectionUtility.hashSet((Object)TableMenuType.EmptySpace);
        }
        if (CollectionUtility.size(selection) == 1) {
            return CollectionUtility.hashSet((Object)TableMenuType.SingleSelection);
        }
        return CollectionUtility.hashSet((Object)TableMenuType.MultiSelection);
    }

    public static Set<ValueFieldMenuType> getMenuTypesForValueFieldValue(Object value) {
        if (value == null) {
            return CollectionUtility.hashSet((Object)ValueFieldMenuType.Null);
        }
        return CollectionUtility.hashSet((Object)ValueFieldMenuType.NotNull);
    }

    public static Set<TreeMenuType> getMenuTypesForTreeSelection(Set<? extends ITreeNode> selection) {
        if (CollectionUtility.isEmpty(selection)) {
            return CollectionUtility.hashSet((Object)TreeMenuType.EmptySpace);
        }
        if (CollectionUtility.size(selection) == 1) {
            return CollectionUtility.hashSet((Object)TreeMenuType.SingleSelection);
        }
        return CollectionUtility.hashSet((Object)TreeMenuType.MultiSelection);
    }
}

