/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.action.menu.root.internal;

import java.beans.PropertyChangeEvent;
import java.util.List;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.MenuUtility;
import org.eclipse.scout.rt.client.ui.action.menu.root.AbstractPropertyObserverContextMenu;
import org.eclipse.scout.rt.client.ui.action.menu.root.ICalendarContextMenu;
import org.eclipse.scout.rt.client.ui.action.menu.root.internal.MenuOwnerChangedVisitor;
import org.eclipse.scout.rt.client.ui.basic.calendar.CalendarComponent;
import org.eclipse.scout.rt.client.ui.basic.calendar.ICalendar;

public class CalendarContextMenu
extends AbstractPropertyObserverContextMenu<ICalendar>
implements ICalendarContextMenu {
    public CalendarContextMenu(ICalendar owner, List<? extends IMenu> initialChildMenus) {
        super(owner, initialChildMenus);
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.setCurrentMenuTypes(MenuUtility.getMenuTypesForCalendarSelection(((ICalendar)this.getOwner()).getSelectedComponent()));
        this.calculateLocalVisibility();
    }

    @Override
    public void callOwnerValueChanged() {
        this.handleOwnerValueChanged();
    }

    protected void handleOwnerValueChanged() {
        if (this.getOwner() != null) {
            CalendarComponent ownerValue = ((ICalendar)this.getOwner()).getSelectedComponent();
            this.setCurrentMenuTypes(MenuUtility.getMenuTypesForCalendarSelection(ownerValue));
            this.acceptVisitor(new MenuOwnerChangedVisitor(ownerValue, this.getCurrentMenuTypes()));
            this.calculateLocalVisibility();
        }
    }

    @Override
    protected void handleOwnerPropertyChanged(PropertyChangeEvent evt) {
        if ("selectedComponent".equals(evt.getPropertyName())) {
            this.handleOwnerValueChanged();
        }
    }
}

