/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.action.menu.root.internal;

import java.beans.PropertyChangeEvent;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.IActionVisitor;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.MenuUtility;
import org.eclipse.scout.rt.client.ui.action.menu.root.AbstractPropertyObserverContextMenu;
import org.eclipse.scout.rt.client.ui.action.menu.root.ITreeContextMenu;
import org.eclipse.scout.rt.client.ui.action.menu.root.internal.MenuOwnerChangedVisitor;
import org.eclipse.scout.rt.client.ui.basic.tree.ITree;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeAdapter;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeEvent;

public class TreeContextMenu
extends AbstractPropertyObserverContextMenu<ITree>
implements ITreeContextMenu {
    private Set<? extends ITreeNode> m_currentSelection;

    public TreeContextMenu(ITree owner, List<? extends IMenu> initialChildMenus) {
        super(owner, initialChildMenus);
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        ((ITree)this.getOwner()).addTreeListener(new P_OwnerTreeListener());
        this.setCurrentMenuTypes(MenuUtility.getMenuTypesForTreeSelection(((ITree)this.getOwner()).getSelectedNodes()));
        this.calculateLocalVisibility();
    }

    @Override
    protected void afterChildMenusAdd(Collection<? extends IMenu> newChildMenus) {
        super.afterChildMenusAdd(newChildMenus);
        this.handleOwnerEnabledChanged();
    }

    @Override
    protected void afterChildMenusRemove(Collection<? extends IMenu> childMenusToRemove) {
        super.afterChildMenusRemove(childMenusToRemove);
        this.handleOwnerEnabledChanged();
    }

    protected void handleOwnerEnabledChanged() {
        if (this.getOwner() != null) {
            final boolean enabled = ((ITree)this.getOwner()).isEnabled();
            this.acceptVisitor(new IActionVisitor(){

                @Override
                public int visit(IAction action) {
                    IMenu menu;
                    if (action instanceof IMenu && !(menu = (IMenu)action).hasChildActions() && menu.isInheritAccessibility()) {
                        menu.setEnabled(enabled);
                    }
                    return 1;
                }
            });
        }
    }

    @Override
    public void callOwnerValueChanged() {
        this.handleOwnerValueChanged();
    }

    protected void handleOwnerValueChanged() {
        if (this.getOwner() != null) {
            Set<ITreeNode> ownerSelection = ((ITree)this.getOwner()).getSelectedNodes();
            this.m_currentSelection = CollectionUtility.hashSet(ownerSelection);
            this.setCurrentMenuTypes(MenuUtility.getMenuTypesForTreeSelection(ownerSelection));
            this.acceptVisitor(new MenuOwnerChangedVisitor(ownerSelection, this.getCurrentMenuTypes()));
            this.calculateLocalVisibility();
            this.calculateEnableState(ownerSelection);
        }
    }

    protected void calculateEnableState(Collection<? extends ITreeNode> ownerSelection) {
        boolean enabled = true;
        for (ITreeNode iTreeNode : ownerSelection) {
            if (iTreeNode.isEnabled()) continue;
            enabled = false;
            break;
        }
        final boolean bl = enabled;
        this.acceptVisitor(new IActionVisitor(){

            @Override
            public int visit(IAction action) {
                IMenu menu;
                if (action instanceof IMenu && !(menu = (IMenu)action).hasChildActions() && menu.isInheritAccessibility()) {
                    menu.setEnabledInheritAccessibility(bl);
                }
                return 1;
            }
        });
    }

    protected void handleNodesUpdated(Collection<ITreeNode> nodes) {
    }

    @Override
    protected void handleOwnerPropertyChanged(PropertyChangeEvent evt) {
        if ("enabled".equals(evt.getPropertyName())) {
            this.handleOwnerEnabledChanged();
        }
    }

    private class P_OwnerTreeListener
    extends TreeAdapter {
        private P_OwnerTreeListener() {
        }

        @Override
        public void treeChanged(TreeEvent e) {
            if (e.getType() == 40) {
                TreeContextMenu.this.handleOwnerValueChanged();
            } else if (e.getType() == 20 && CollectionUtility.containsAny(e.getNodes(), (Collection)TreeContextMenu.this.m_currentSelection)) {
                TreeContextMenu.this.handleOwnerValueChanged();
            }
        }
    }
}

