/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.action.menu.root.internal;

import java.beans.PropertyChangeEvent;
import java.util.Collection;
import java.util.List;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.MenuUtility;
import org.eclipse.scout.rt.client.ui.action.menu.root.IValueFieldContextMenu;
import org.eclipse.scout.rt.client.ui.action.menu.root.internal.FormFieldContextMenu;
import org.eclipse.scout.rt.client.ui.action.menu.root.internal.MenuOwnerChangedVisitor;
import org.eclipse.scout.rt.client.ui.form.fields.IValueField;

public class ValueFieldContextMenu
extends FormFieldContextMenu<IValueField<?>>
implements IValueFieldContextMenu {
    public ValueFieldContextMenu(IValueField owner, List<? extends IMenu> initialChildMenus) {
        super(owner, initialChildMenus);
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.setCurrentMenuTypes(MenuUtility.getMenuTypesForValueFieldValue(((IValueField)this.getOwner()).getValue()));
        this.calculateLocalVisibility();
    }

    @Override
    protected void afterChildMenusAdd(Collection<? extends IMenu> newChildMenus) {
        super.afterChildMenusAdd(newChildMenus);
        this.handleOwnerEnabledChanged();
    }

    @Override
    protected void afterChildMenusRemove(Collection<? extends IMenu> childMenusToRemove) {
        super.afterChildMenusRemove(childMenusToRemove);
        this.handleOwnerEnabledChanged();
    }

    @Override
    public void callOwnerValueChanged() {
        this.handleOwnerValueChanged();
    }

    protected void handleOwnerValueChanged() {
        if (this.getOwner() != null) {
            Object ownerValue = ((IValueField)this.getOwner()).getValue();
            this.setCurrentMenuTypes(MenuUtility.getMenuTypesForValueFieldValue(ownerValue));
            this.acceptVisitor(new MenuOwnerChangedVisitor(ownerValue, this.getCurrentMenuTypes()));
        }
        this.calculateLocalVisibility();
    }

    @Override
    protected void handleOwnerPropertyChanged(PropertyChangeEvent evt) {
        super.handleOwnerPropertyChanged(evt);
        if ("value".equals(evt.getPropertyName())) {
            this.handleOwnerValueChanged();
        }
    }
}

