/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.action.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.ITypeWithClassId;
import org.eclipse.scout.commons.annotations.IOrdered;
import org.eclipse.scout.commons.annotations.OrderedCollection;
import org.eclipse.scout.commons.annotations.OrderedComparator;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.extension.ui.action.tree.IActionNodeExtension;
import org.eclipse.scout.rt.client.ui.action.AbstractAction;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.IActionVisitor;
import org.eclipse.scout.rt.client.ui.action.tree.IActionNode;
import org.eclipse.scout.rt.shared.extension.ContributionComposite;
import org.eclipse.scout.rt.shared.extension.IContributionOwner;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.service.SERVICES;

public abstract class AbstractActionNode<T extends IActionNode>
extends AbstractAction
implements IActionNode<T>,
IContributionOwner {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractActionNode.class);
    private T m_parent;
    private IContributionOwner m_contributionHolder;

    public AbstractActionNode() {
    }

    public AbstractActionNode(boolean callInitializer) {
        super(callInitializer);
    }

    public final List<Object> getAllContributions() {
        return this.m_contributionHolder.getAllContributions();
    }

    public final <TYPE> List<TYPE> getContributionsByClass(Class<TYPE> type) {
        return this.m_contributionHolder.getContributionsByClass(type);
    }

    public final <TYPE> TYPE getContribution(Class<TYPE> contribution) {
        return (TYPE)this.m_contributionHolder.getContribution(contribution);
    }

    private List<Class<? extends IActionNode>> getConfiguredChildActions() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        List filtered = ConfigurationUtility.filterClasses((Class[])dca, IActionNode.class);
        return ConfigurationUtility.removeReplacedClasses((List)filtered);
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        List<Class<IActionNode>> configuredChildActions = this.getConfiguredChildActions();
        OrderedCollection actionNodes = new OrderedCollection();
        for (Class<IActionNode> a : configuredChildActions) {
            try {
                IActionNode node = (IActionNode)ConfigurationUtility.newInnerInstance((Object)this, a);
                node.setParent(this);
                actionNodes.addOrdered((IOrdered)node);
            }
            catch (Exception e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("error creating instance of class '" + a.getName() + "'.", (Throwable)e));
            }
        }
        this.m_contributionHolder = new ContributionComposite((Object)this);
        List contributedActions = this.m_contributionHolder.getContributionsByClass(IActionNode.class);
        for (IActionNode n : contributedActions) {
            actionNodes.addOrdered((IOrdered)n);
        }
        try {
            this.injectActionNodesInternal(actionNodes);
        }
        catch (Exception e) {
            LOG.error("error occured while dynamically contribute action nodes.", (Throwable)e);
        }
        this.setChildActions(actionNodes.getOrderedList());
    }

    protected void injectActionNodesInternal(OrderedCollection<T> actionNodes) {
    }

    @Override
    public void setContainerInternal(ITypeWithClassId container) {
        super.setContainerInternal(container);
        this.setContainerOnActions(this.getChildActionsInternal());
    }

    protected void setContainerOnActions(List<? extends T> actions) {
        if (actions != null) {
            for (IActionNode childAction : actions) {
                if (childAction == null) continue;
                childAction.setContainerInternal(this.getContainer());
            }
        }
    }

    @Override
    public T getParent() {
        return this.m_parent;
    }

    @Override
    public void setParent(T parent) {
        this.m_parent = parent;
    }

    private List<T> getChildActionsInternal() {
        return this.propertySupport.getPropertyList("childActions");
    }

    @Override
    public boolean hasChildActions() {
        return CollectionUtility.hasElements(this.getChildActionsInternal());
    }

    @Override
    public int getChildActionCount() {
        return CollectionUtility.size(this.getChildActionsInternal());
    }

    @Override
    public List<T> getChildActions() {
        return CollectionUtility.arrayList(this.getChildActionsInternal());
    }

    @Override
    public void setChildActions(Collection<? extends T> newList) {
        this.removeChildActions(this.getChildActionsInternal());
        this.addChildActions(newList);
    }

    @Override
    public void addChildAction(T action) {
        this.addChildActions(CollectionUtility.arrayList(action));
    }

    @Override
    public void addChildActions(Collection<? extends T> actionList) {
        ArrayList normalizedList = CollectionUtility.arrayListWithoutNullElements(actionList);
        if (!normalizedList.isEmpty()) {
            this.setContainerOnActions(normalizedList);
            List<T> childList = this.getChildActionsInternal();
            if (childList == null) {
                childList = new ArrayList<T>(normalizedList.size());
            }
            childList.addAll(normalizedList);
            Collections.sort(childList, new OrderedComparator());
            this.propertySupport.setPropertyAlwaysFire("childActions", childList);
        }
    }

    @Override
    public void removeChildAction(T action) {
        this.removeChildActions(CollectionUtility.arrayList(action));
    }

    @Override
    public void removeChildActions(Collection<? extends T> actionList) {
        ArrayList normalizedList = CollectionUtility.arrayListWithoutNullElements(actionList);
        if (!normalizedList.isEmpty()) {
            List<T> childList = this.getChildActionsInternal();
            boolean listChanged = false;
            for (IActionNode a : normalizedList) {
                if (!childList.remove(a)) continue;
                listChanged = true;
                a.setContainerInternal(null);
            }
            if (listChanged) {
                this.propertySupport.setPropertyAlwaysFire("childActions", childList);
            }
        }
    }

    @Override
    public int acceptVisitor(IActionVisitor visitor) {
        switch (visitor.visit(this)) {
            case 0: {
                return 0;
            }
            case 3: {
                return 1;
            }
            case 2: {
                this.visitChildren(visitor);
                return 0;
            }
        }
        return this.visitChildren(visitor);
    }

    private int visitChildren(IActionVisitor visitor) {
        for (IAction t : this.getChildActions()) {
            switch (t.acceptVisitor(visitor)) {
                case 0: {
                    return 0;
                }
            }
        }
        return 1;
    }

    protected IActionNodeExtension<T, ? extends AbstractActionNode<T>> createLocalExtension() {
        return new LocalActionNodeExtension(this);
    }

    protected static class LocalActionNodeExtension<T extends IActionNode, OWNER extends AbstractActionNode<T>>
    extends AbstractAction.LocalActionExtension<OWNER>
    implements IActionNodeExtension<T, OWNER> {
        public LocalActionNodeExtension(OWNER owner) {
            super(owner);
        }
    }
}

