/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.calendar.provider;

import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.DateUtility;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.IOrdered;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.annotations.OrderedCollection;
import org.eclipse.scout.commons.beans.AbstractPropertyObserver;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientAsyncJob;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.extension.ui.action.tree.MoveActionNodesHandler;
import org.eclipse.scout.rt.client.extension.ui.basic.calendar.provider.CalendarItemProviderChains;
import org.eclipse.scout.rt.client.extension.ui.basic.calendar.provider.ICalendarItemProviderExtension;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.basic.calendar.provider.ICalendarItemProvider;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.shared.extension.AbstractExtension;
import org.eclipse.scout.rt.shared.extension.ContributionComposite;
import org.eclipse.scout.rt.shared.extension.IContributionOwner;
import org.eclipse.scout.rt.shared.extension.IExtensibleObject;
import org.eclipse.scout.rt.shared.extension.IExtension;
import org.eclipse.scout.rt.shared.extension.ObjectExtensions;
import org.eclipse.scout.rt.shared.services.common.calendar.ICalendarAppointment;
import org.eclipse.scout.rt.shared.services.common.calendar.ICalendarItem;
import org.eclipse.scout.rt.shared.services.common.calendar.ICalendarTask;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.service.SERVICES;

public abstract class AbstractCalendarItemProvider
extends AbstractPropertyObserver
implements ICalendarItemProvider,
IContributionOwner,
IExtensibleObject {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractCalendarItemProvider.class);
    private P_ReloadJob m_reloadJob;
    private boolean m_initialized;
    private List<IMenu> m_menus;
    private Date m_minDateLoaded;
    private Date m_maxDateLoaded;
    private IContributionOwner m_contributionHolder;
    private final ObjectExtensions<AbstractCalendarItemProvider, ICalendarItemProviderExtension<? extends AbstractCalendarItemProvider>> m_objectExtensions = new ObjectExtensions((Object)this);

    public AbstractCalendarItemProvider() {
        this(true);
    }

    public AbstractCalendarItemProvider(boolean callInitializer) {
        if (callInitializer) {
            this.callInitializer();
        }
    }

    public final List<Object> getAllContributions() {
        return this.m_contributionHolder.getAllContributions();
    }

    public final <T> List<T> getContributionsByClass(Class<T> type) {
        return this.m_contributionHolder.getContributionsByClass(type);
    }

    public final <T> T getContribution(Class<T> contribution) {
        return (T)this.m_contributionHolder.getContribution(contribution);
    }

    protected void callInitializer() {
        if (!this.m_initialized) {
            this.interceptInitConfig();
            this.m_initialized = true;
        }
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=10.0)
    protected boolean getConfiguredMoveItemEnabled() {
        return false;
    }

    @ConfigProperty(value="LONG")
    @Order(value=20.0)
    protected long getConfiguredRefreshIntervallMillis() {
        return 0L;
    }

    protected List<Class<? extends IMenu>> getDeclaredMenus() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        List filtered = ConfigurationUtility.filterClasses((Class[])dca, IMenu.class);
        return ConfigurationUtility.removeReplacedClasses((List)filtered);
    }

    @ConfigOperation
    @Order(value=30.0)
    protected void execLoadItems(Date minDate, Date maxDate, Set<ICalendarItem> result) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=40.0)
    protected void execLoadItemsInBackground(IClientSession session, final Date minDate, final Date maxDate, final Set<ICalendarItem> result) throws ProcessingException {
        ClientSyncJob job = new ClientSyncJob(String.valueOf(this.getClass().getSimpleName()) + " load items", session){

            @Override
            protected void runVoid(IProgressMonitor monitor) throws Throwable {
                AbstractCalendarItemProvider.this.interceptLoadItems(minDate, maxDate, result);
            }
        };
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @ConfigOperation
    @Order(value=10.0)
    protected void execDecorateCell(Cell cell, ICalendarItem item) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=20.0)
    protected void execItemMoved(ICalendarItem item, Date newDate) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=50.0)
    protected void execItemAction(ICalendarItem item) throws ProcessingException {
    }

    protected final void interceptInitConfig() {
        this.m_objectExtensions.initConfig(this.createLocalExtension(), new Runnable(){

            @Override
            public void run() {
                AbstractCalendarItemProvider.this.initConfig();
            }
        });
    }

    protected void initConfig() {
        this.m_contributionHolder = new ContributionComposite((Object)this);
        this.setMoveItemEnabled(this.getConfiguredMoveItemEnabled());
        this.setRefreshIntervalMillis(this.getConfiguredRefreshIntervallMillis());
        List<Class<? extends IMenu>> declaredMenus = this.getDeclaredMenus();
        OrderedCollection menus = new OrderedCollection();
        for (Class<? extends IMenu> menuClazz : declaredMenus) {
            try {
                IMenu menu = (IMenu)ConfigurationUtility.newInnerInstance((Object)this, menuClazz);
                menu.initAction();
                menus.addOrdered((IOrdered)menu);
            }
            catch (Exception e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("error creating instance of class '" + menuClazz.getName() + "'.", (Throwable)e));
            }
        }
        List contributedMenus = this.m_contributionHolder.getContributionsByClass(IMenu.class);
        menus.addAllOrdered((Collection)contributedMenus);
        try {
            this.injectMenusInternal((OrderedCollection<IMenu>)menus);
        }
        catch (Exception e) {
            LOG.error("error occured while dynamically contribute menus.", (Throwable)e);
        }
        new MoveActionNodesHandler(menus).moveModelObjects();
        this.m_menus = menus.getOrderedList();
    }

    public final List<? extends ICalendarItemProviderExtension<? extends AbstractCalendarItemProvider>> getAllExtensions() {
        return this.m_objectExtensions.getAllExtensions();
    }

    protected ICalendarItemProviderExtension<? extends AbstractCalendarItemProvider> createLocalExtension() {
        return new LocalCalendarItemProviderExtension<AbstractCalendarItemProvider>(this);
    }

    public <T extends IExtension<?>> T getExtension(Class<T> c) {
        return (T)this.m_objectExtensions.getExtension(c);
    }

    protected void injectMenusInternal(OrderedCollection<IMenu> menus) {
    }

    @Override
    public void disposeProvider() {
        P_ReloadJob job = this.m_reloadJob;
        if (job != null) {
            job.cancel();
            this.m_reloadJob = null;
        }
    }

    @Override
    public final void decorateCell(Cell cell, ICalendarItem item) {
        this.decorateCellInternal(cell, item);
        try {
            this.interceptDecorateCell(cell, item);
        }
        catch (ProcessingException e) {
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
        }
        catch (Throwable e) {
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("Unexpected", e));
        }
    }

    protected void decorateCellInternal(Cell cell, ICalendarItem item) {
        StringBuffer buf;
        if (item instanceof ICalendarAppointment) {
            ICalendarAppointment app = (ICalendarAppointment)item;
            cell.setText(app.getSubject());
            buf = new StringBuffer();
            if (app.getLocation() != null) {
                if (buf.length() > 0) {
                    buf.append("\n");
                }
                buf.append(app.getLocation());
            }
            if (app.getBody() != null) {
                if (buf.length() > 0) {
                    buf.append("\n");
                }
                buf.append(app.getBody());
            }
            if (buf.length() > 0) {
                cell.setTooltipText(buf.toString());
            }
        }
        if (item instanceof ICalendarTask) {
            ICalendarTask task = (ICalendarTask)item;
            cell.setText(task.getSubject());
            buf = new StringBuffer();
            if (task.getBody() != null) {
                if (buf.length() > 0) {
                    buf.append("\n");
                }
                buf.append(task.getBody());
            }
            if (buf.length() > 0) {
                cell.setTooltipText(buf.toString());
            }
        }
        cell.setBackgroundColor(item.getColor());
    }

    @Override
    public Set<ICalendarItem> getItems(Date minDate, Date maxDate) {
        this.ensureItemsLoadedInternal(minDate, maxDate);
        Set allItems = this.propertySupport.getPropertySet("items");
        if (CollectionUtility.hasElements((Collection)allItems)) {
            HashSet<ICalendarItem> list = new HashSet<ICalendarItem>(allItems.size());
            for (ICalendarItem item : allItems) {
                if (!item.isIntersecting(minDate, maxDate)) continue;
                list.add(item);
            }
            return list;
        }
        return CollectionUtility.hashSet((Object[])new ICalendarItem[0]);
    }

    @Override
    public void reloadProvider() {
        this.loadItemsAsyncInternal(ClientSyncJob.getCurrentSession(), this.m_minDateLoaded, this.m_maxDateLoaded, 250L);
    }

    private void setItemsInternal(Date minDate, Date maxDate, Set<ICalendarItem> items0) {
        HashSet items = CollectionUtility.hashSetWithoutNullElements(items0);
        this.m_minDateLoaded = minDate;
        this.m_maxDateLoaded = maxDate;
        this.propertySupport.setPropertySet("items", (Set)items);
    }

    @Override
    public List<IMenu> getMenus() {
        return CollectionUtility.arrayList(this.m_menus);
    }

    @Override
    public boolean isMoveItemEnabled() {
        return this.propertySupport.getPropertyBool("moveItemEnabled");
    }

    @Override
    public void setMoveItemEnabled(boolean b) {
        this.propertySupport.setPropertyBool("moveItemEnabled", b);
    }

    @Override
    public boolean isLoadInProgress() {
        return this.propertySupport.getPropertyBool("loadInProgress");
    }

    @Override
    public void setLoadInProgress(boolean b) {
        this.propertySupport.setPropertyBool("loadInProgress", b);
    }

    private void setLoadInProgressInSyncJob(final boolean b) {
        ClientSyncJob job = new ClientSyncJob(String.valueOf(this.getClass().getSimpleName()) + " prepare", ClientSyncJob.getCurrentSession()){

            @Override
            protected void runVoid(IProgressMonitor monitor) throws Throwable {
                AbstractCalendarItemProvider.this.setLoadInProgress(b);
            }
        };
        job.schedule();
    }

    @Override
    public long getRefreshIntervalMillis() {
        return this.propertySupport.getPropertyLong("refreshIntervalMillis");
    }

    @Override
    public void setRefreshIntervalMillis(long m) {
        this.propertySupport.setPropertyLong("refreshIntervalMillis", m);
        if (m > 0L) {
            this.loadItemsAsyncInternal(ClientSyncJob.getCurrentSession(), this.m_minDateLoaded, this.m_maxDateLoaded, m);
        }
    }

    @Override
    public void onItemAction(ICalendarItem item) throws ProcessingException {
        try {
            this.interceptItemAction(item);
        }
        catch (ProcessingException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ProcessingException("Unexpected", e);
        }
    }

    @Override
    public void onItemMoved(ICalendarItem item, Date newDate) throws ProcessingException {
        try {
            this.interceptItemMoved(item, newDate);
        }
        catch (ProcessingException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ProcessingException("Unexpected", e);
        }
    }

    private void ensureItemsLoadedInternal(Date minDate, Date maxDate) {
        if (!DateUtility.isInRange((Date)this.m_minDateLoaded, (Date)minDate, (Date)this.m_maxDateLoaded) || !DateUtility.isInRange((Date)this.m_minDateLoaded, (Date)maxDate, (Date)this.m_maxDateLoaded)) {
            this.loadItemsAsyncInternal(ClientSyncJob.getCurrentSession(), minDate, maxDate, 250L);
        }
    }

    private synchronized void loadItemsAsyncInternal(IClientSession session, Date minDate, Date maxDate, long startDelayMillis) {
        P_ReloadJob oldJob = this.m_reloadJob;
        if (oldJob != null) {
            oldJob.cancel();
            this.m_reloadJob = null;
        }
        if (minDate != null && maxDate != null) {
            this.m_reloadJob = new P_ReloadJob(session, minDate, maxDate);
            this.m_reloadJob.schedule(startDelayMillis);
        }
    }

    protected final void interceptLoadItems(Date minDate, Date maxDate, Set<ICalendarItem> result) throws ProcessingException {
        List<? extends ICalendarItemProviderExtension<? extends AbstractCalendarItemProvider>> extensions = this.getAllExtensions();
        CalendarItemProviderChains.CalendarItemProviderLoadItemsChain chain = new CalendarItemProviderChains.CalendarItemProviderLoadItemsChain(extensions);
        chain.execLoadItems(minDate, maxDate, result);
    }

    protected final void interceptItemAction(ICalendarItem item) throws ProcessingException {
        List<? extends ICalendarItemProviderExtension<? extends AbstractCalendarItemProvider>> extensions = this.getAllExtensions();
        CalendarItemProviderChains.CalendarItemProviderItemActionChain chain = new CalendarItemProviderChains.CalendarItemProviderItemActionChain(extensions);
        chain.execItemAction(item);
    }

    protected final void interceptLoadItemsInBackground(IClientSession session, Date minDate, Date maxDate, Set<ICalendarItem> result) throws ProcessingException {
        List<? extends ICalendarItemProviderExtension<? extends AbstractCalendarItemProvider>> extensions = this.getAllExtensions();
        CalendarItemProviderChains.CalendarItemProviderLoadItemsInBackgroundChain chain = new CalendarItemProviderChains.CalendarItemProviderLoadItemsInBackgroundChain(extensions);
        chain.execLoadItemsInBackground(session, minDate, maxDate, result);
    }

    protected final void interceptItemMoved(ICalendarItem item, Date newDate) throws ProcessingException {
        List<? extends ICalendarItemProviderExtension<? extends AbstractCalendarItemProvider>> extensions = this.getAllExtensions();
        CalendarItemProviderChains.CalendarItemProviderItemMovedChain chain = new CalendarItemProviderChains.CalendarItemProviderItemMovedChain(extensions);
        chain.execItemMoved(item, newDate);
    }

    protected final void interceptDecorateCell(Cell cell, ICalendarItem item) throws ProcessingException {
        List<? extends ICalendarItemProviderExtension<? extends AbstractCalendarItemProvider>> extensions = this.getAllExtensions();
        CalendarItemProviderChains.CalendarItemProviderDecorateCellChain chain = new CalendarItemProviderChains.CalendarItemProviderDecorateCellChain(extensions);
        chain.execDecorateCell(cell, item);
    }

    protected static class LocalCalendarItemProviderExtension<OWNER extends AbstractCalendarItemProvider>
    extends AbstractExtension<OWNER>
    implements ICalendarItemProviderExtension<OWNER> {
        public LocalCalendarItemProviderExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public void execLoadItems(CalendarItemProviderChains.CalendarItemProviderLoadItemsChain chain, Date minDate, Date maxDate, Set<ICalendarItem> result) throws ProcessingException {
            ((AbstractCalendarItemProvider)this.getOwner()).execLoadItems(minDate, maxDate, result);
        }

        @Override
        public void execItemAction(CalendarItemProviderChains.CalendarItemProviderItemActionChain chain, ICalendarItem item) throws ProcessingException {
            ((AbstractCalendarItemProvider)this.getOwner()).execItemAction(item);
        }

        @Override
        public void execLoadItemsInBackground(CalendarItemProviderChains.CalendarItemProviderLoadItemsInBackgroundChain chain, IClientSession session, Date minDate, Date maxDate, Set<ICalendarItem> result) throws ProcessingException {
            ((AbstractCalendarItemProvider)this.getOwner()).execLoadItemsInBackground(session, minDate, maxDate, result);
        }

        @Override
        public void execItemMoved(CalendarItemProviderChains.CalendarItemProviderItemMovedChain chain, ICalendarItem item, Date newDate) throws ProcessingException {
            ((AbstractCalendarItemProvider)this.getOwner()).execItemMoved(item, newDate);
        }

        @Override
        public void execDecorateCell(CalendarItemProviderChains.CalendarItemProviderDecorateCellChain chain, Cell cell, ICalendarItem item) throws ProcessingException {
            ((AbstractCalendarItemProvider)this.getOwner()).execDecorateCell(cell, item);
        }
    }

    private class P_ReloadJob
    extends ClientAsyncJob {
        private final Set<ICalendarItem> m_result;
        private final Date m_loadingMinDate;
        private final Date m_loadingMaxDate;

        public P_ReloadJob(IClientSession session, Date loadingMinDate, Date loadingMaxDate) {
            super(String.valueOf(AbstractCalendarItemProvider.this.getClass().getSimpleName()) + " reload", session);
            this.m_result = new HashSet<ICalendarItem>();
            this.m_loadingMinDate = loadingMinDate;
            this.m_loadingMaxDate = loadingMaxDate;
        }

        @Override
        protected IStatus runStatus(final IProgressMonitor monitor) {
            AbstractCalendarItemProvider.this.setLoadInProgressInSyncJob(true);
            if (!monitor.isCanceled()) {
                block5: {
                    try {
                        AbstractCalendarItemProvider.this.interceptLoadItemsInBackground(ClientSyncJob.getCurrentSession(), this.m_loadingMinDate, this.m_loadingMaxDate, this.m_result);
                    }
                    catch (ProcessingException e) {
                        if (e.isInterruption()) break block5;
                        LOG.error(null, (Throwable)e);
                    }
                }
                ClientSyncJob setItemsJob = new ClientSyncJob(String.valueOf(AbstractCalendarItemProvider.this.getClass().getSimpleName()) + " setItems", ClientSyncJob.getCurrentSession()){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    protected void runVoid(IProgressMonitor monitor2) throws Throwable {
                        AbstractCalendarItemProvider abstractCalendarItemProvider = AbstractCalendarItemProvider.this;
                        synchronized (abstractCalendarItemProvider) {
                            if (!monitor.isCanceled()) {
                                AbstractCalendarItemProvider.this.setItemsInternal(P_ReloadJob.this.m_loadingMinDate, P_ReloadJob.this.m_loadingMaxDate, P_ReloadJob.this.m_result);
                                this.reschedule(monitor);
                            }
                        }
                    }

                    private void reschedule(IProgressMonitor monitor2) {
                        long n = AbstractCalendarItemProvider.this.getRefreshIntervalMillis();
                        if (n > 0L && !monitor2.isCanceled()) {
                            AbstractCalendarItemProvider.this.loadItemsAsyncInternal(ClientSyncJob.getCurrentSession(), P_ReloadJob.this.m_loadingMinDate, P_ReloadJob.this.m_loadingMaxDate, n);
                        }
                    }
                };
                setItemsJob.schedule();
                try {
                    setItemsJob.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                AbstractCalendarItemProvider.this.setLoadInProgressInSyncJob(false);
            }
            return Status.OK_STATUS;
        }
    }
}

