/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.CompositeObject;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.ClientUIPreferences;
import org.eclipse.scout.rt.client.ui.basic.table.AbstractTable;
import org.eclipse.scout.rt.client.ui.basic.table.HeaderCell;
import org.eclipse.scout.rt.client.ui.basic.table.TableEvent;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IStringColumn;
import org.eclipse.scout.rt.shared.data.basic.table.SortSpec;

public class ColumnSet {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(ColumnSet.class);
    private final AbstractTable m_table;
    private final List<IColumn<?>> m_columns;
    private final List<IColumn<?>> m_userSortColumns;
    private final List<IColumn<?>> m_permanentHeadSortColumns;
    private final List<IColumn<?>> m_permanentTailSortColumns;
    private int[] m_keyIndexes = new int[0];
    private int[] m_displayableIndexes = new int[0];
    private int[] m_visibleIndexes = new int[0];
    private final Map<Class, IColumn> m_classIndexes = new HashMap<Class, IColumn>();
    private final Map<String, IColumn> m_idIndexes = new HashMap<String, IColumn>();
    private final Map<Class<?>, Class<? extends IColumn>> m_columnReplacements;

    public ColumnSet(AbstractTable table, List<IColumn<?>> columns) {
        ArrayList columnArray = new ArrayList(columns.size());
        for (IColumn<?> c : columns) {
            columnArray.add(c.getClass());
        }
        Map replacements = ConfigurationUtility.getReplacementMapping(columnArray);
        if (replacements.isEmpty()) {
            replacements = null;
        }
        this.m_columnReplacements = replacements;
        this.m_table = table;
        this.m_columns = new ArrayList(columns.size());
        this.m_userSortColumns = new ArrayList();
        this.m_permanentHeadSortColumns = new ArrayList();
        this.m_permanentTailSortColumns = new ArrayList();
        PropertyChangeListener columnListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                IColumn c = (IColumn)e.getSource();
                if (!"viewColumnIndexHint".equals(e.getPropertyName())) {
                    if ("viewOrder".equals(e.getPropertyName())) {
                        ColumnSet.this.resetColumnsViewOrder();
                    } else {
                        ColumnSet.this.updateColumnStructure(c);
                    }
                }
            }
        };
        int index = 0;
        for (IColumn<?> col : columns) {
            if (col instanceof AbstractColumn) {
                ((AbstractColumn)col).setColumnIndexInternal(index);
                ((AbstractColumn)col).setTableInternal(this.m_table);
            }
            this.rebuildHeaderCell(col);
            this.m_columns.add(col);
            this.m_classIndexes.put(col.getClass(), col);
            this.m_idIndexes.put(col.getColumnId(), col);
            col.addPropertyChangeListener(columnListener);
            ++index;
        }
        this.reorganizeIndexes();
    }

    /*
     * WARNING - void declaration
     */
    public void initialize() {
        void var5_6;
        ClientUIPreferences prefs = ClientUIPreferences.getInstance();
        int n = this.getColumnCount();
        TreeMap sortMap = new TreeMap();
        int viewIndex = 0;
        boolean bl = false;
        while (var5_6 < n) {
            IColumn iColumn = this.getColumn((int)var5_6);
            double viewHint = iColumn.getVisibleColumnIndexHint();
            if (viewHint < 0.0) {
                viewHint = iColumn.getOrder();
            }
            if (viewHint < 0.0) {
                viewHint = viewIndex;
            }
            sortMap.put(new CompositeObject(new Object[]{viewHint, viewIndex}), iColumn);
            ++viewIndex;
            ++var5_6;
        }
        viewIndex = 0;
        for (Map.Entry entry : sortMap.entrySet()) {
            ((IColumn)entry.getValue()).setVisibleColumnIndexHint(viewIndex);
            ++viewIndex;
        }
        this.reorganizeIndexes();
        sortMap.clear();
        boolean bl2 = false;
        for (IColumn<?> iColumn : this.getColumns()) {
            void var5_9;
            int sortIndex = -1;
            if (iColumn.isInitialAlwaysIncludeSortAtBegin()) {
                sortIndex = iColumn.getInitialSortIndex();
                if (sortIndex < 0) {
                    LOG.warn("AlwaysIncludeSortAtBegin is set but no sort index configured. Table: " + this.m_table.getClass().getName());
                }
            } else if (iColumn.isInitialAlwaysIncludeSortAtEnd()) {
                sortIndex = iColumn.getInitialSortIndex();
                if (sortIndex < 0) {
                    LOG.warn("AlwaysIncludeSortAtEnd is set but no sort index configured. Table: " + this.m_table.getClass().getName());
                }
            } else {
                sortIndex = prefs.getTableColumnSortIndex(iColumn, iColumn.getInitialSortIndex());
            }
            if (sortIndex >= 0) {
                sortMap.put(new CompositeObject(new Object[]{sortIndex, (int)var5_9}), iColumn);
            }
            ++var5_9;
        }
        this.clearSortColumns();
        this.clearPermanentHeadSortColumns();
        this.clearPermanentTailSortColumns();
        for (IColumn<Object> iColumn : sortMap.values()) {
            boolean asc;
            if (iColumn.isInitialAlwaysIncludeSortAtBegin()) {
                asc = iColumn.isInitialSortAscending();
                this.addPermanentHeadSortColumn(iColumn, asc);
                continue;
            }
            if (iColumn.isInitialAlwaysIncludeSortAtEnd()) {
                asc = iColumn.isInitialSortAscending();
                this.addPermanentTailSortColumn(iColumn, asc);
                continue;
            }
            asc = prefs.getTableColumnSortAscending(iColumn, iColumn.isInitialSortAscending());
            this.addSortColumn(iColumn, asc);
        }
        for (IColumn<Object> iColumn : this.getUserSortColumns()) {
            Boolean explicit = prefs.getTableColumnSortExplicit(iColumn);
            if (explicit == null) continue;
            HeaderCell cell = (HeaderCell)iColumn.getHeaderCell();
            cell.setSortExplicit(explicit);
        }
        if (this.getVisibleColumnCount() == 0) {
            viewIndex = 0;
            for (IColumn<Object> iColumn : this.getColumns()) {
                if (iColumn.isDisplayable() && iColumn.isInitialVisible()) {
                    iColumn.setVisible(true);
                } else {
                    iColumn.setVisible(false);
                }
                iColumn.setWidth(iColumn.getInitialWidth());
                iColumn.setVisibleColumnIndexHint(viewIndex);
                prefs.removeTableColumnPreferences(iColumn);
                ++viewIndex;
            }
            this.reorganizeIndexes();
        }
        this.checkMultiline();
    }

    public int getColumnCount() {
        return this.m_columns.size();
    }

    public int getKeyColumnCount() {
        return this.m_keyIndexes.length;
    }

    public int getDisplayableColumnCount() {
        return this.m_displayableIndexes.length;
    }

    public int getVisibleColumnCount() {
        return this.m_visibleIndexes.length;
    }

    public int[] getKeyColumnIndexes() {
        int[] a = new int[this.m_keyIndexes.length];
        System.arraycopy(this.m_keyIndexes, 0, a, 0, a.length);
        return a;
    }

    public int[] getAllColumnIndexes() {
        int[] a = new int[this.m_columns.size()];
        int i = 0;
        while (i < a.length) {
            a[i] = i;
            ++i;
        }
        return a;
    }

    public List<IColumn<?>> getAllColumnsInUserOrder() {
        List<IColumn<?>> visibleCols = this.getVisibleColumns();
        int counter = 0;
        TreeMap sortMap = new TreeMap();
        for (IColumn<?> col : visibleCols) {
            sortMap.put(new CompositeObject(new Object[]{col.getVisibleColumnIndexHint(), counter++}), col);
        }
        for (IColumn<?> column : this.getColumns()) {
            if (column.isDisplayable() && column.isVisible()) continue;
            sortMap.put(new CompositeObject(new Object[]{column.getVisibleColumnIndexHint(), counter++}), column);
        }
        return CollectionUtility.arrayList(sortMap.values());
    }

    public int[] getDisplayableColumnIndexes() {
        int[] a = new int[this.m_displayableIndexes.length];
        System.arraycopy(this.m_displayableIndexes, 0, a, 0, a.length);
        return a;
    }

    public int[] getVisibleColumnIndexes() {
        int[] a = new int[this.m_visibleIndexes.length];
        System.arraycopy(this.m_visibleIndexes, 0, a, 0, a.length);
        return a;
    }

    public int getKeyColumnIndex(int keyIndex) {
        return this.m_keyIndexes[keyIndex];
    }

    public int getDisplayableColumnIndex(int displayableIndex) {
        return this.m_displayableIndexes[displayableIndex];
    }

    public int getVisibleColumnIndex(int visibleIndex) {
        return this.m_visibleIndexes[visibleIndex];
    }

    public IColumn getColumn(int index) {
        if (index >= 0 && index < this.m_columns.size()) {
            return this.m_columns.get(index);
        }
        return null;
    }

    public <T extends IColumn> T getColumnByClass(Class<T> c) {
        Class<T> columnClass = this.getReplacingColumnClass(c);
        IColumn col = this.m_classIndexes.get(columnClass);
        return (T)col;
    }

    public <T extends IColumn> T getColumnById(String id) {
        return (T)this.m_idIndexes.get(id);
    }

    private <T extends IColumn> Class<? extends T> getReplacingColumnClass(Class<T> c) {
        Class<? extends IColumn> replacingColumnClass;
        if (this.m_columnReplacements != null && (replacingColumnClass = this.m_columnReplacements.get(c)) != null) {
            return replacingColumnClass;
        }
        return c;
    }

    public IColumn getDisplayableColumn(int index) {
        if (index >= 0 && index < this.m_displayableIndexes.length) {
            return this.m_columns.get(this.m_displayableIndexes[index]);
        }
        return null;
    }

    public IColumn getVisibleColumn(int index) {
        if (index >= 0 && index < this.m_visibleIndexes.length) {
            return this.m_columns.get(this.m_visibleIndexes[index]);
        }
        return null;
    }

    public List<IColumn<?>> getColumns() {
        return CollectionUtility.arrayList(this.m_columns);
    }

    public List<IColumn<?>> getKeyColumns() {
        ArrayList keyColumns = new ArrayList(this.m_keyIndexes.length);
        int i = 0;
        while (i < this.m_keyIndexes.length) {
            keyColumns.add(this.getColumn(this.m_keyIndexes[i]));
            ++i;
        }
        return keyColumns;
    }

    public List<IColumn<?>> getDisplayableColumns() {
        ArrayList a = new ArrayList(this.m_displayableIndexes.length);
        int i = 0;
        while (i < this.m_displayableIndexes.length) {
            a.add(this.getColumn(this.m_displayableIndexes[i]));
            ++i;
        }
        return a;
    }

    public List<IColumn<?>> getVisibleColumns() {
        ArrayList a = new ArrayList(this.m_visibleIndexes.length);
        int i = 0;
        while (i < this.m_visibleIndexes.length) {
            a.add(this.getColumn(this.m_visibleIndexes[i]));
            ++i;
        }
        return a;
    }

    public IColumn getFirstVisibleColumn() {
        if (this.m_visibleIndexes.length > 0) {
            return this.m_columns.get(this.m_visibleIndexes[0]);
        }
        return null;
    }

    public IColumn getFirstDefinedVisibileColumn() {
        int colIdx = this.m_columns.size();
        int i = 0;
        while (i < this.m_visibleIndexes.length) {
            if (CompareUtility.compareTo((Comparable)Integer.valueOf(this.m_visibleIndexes[i]), (Comparable)Integer.valueOf(colIdx)) < 0) {
                colIdx = this.m_visibleIndexes[i];
            }
            ++i;
        }
        if (colIdx != this.m_columns.size()) {
            return this.m_columns.get(colIdx);
        }
        return null;
    }

    public List<IColumn<?>> getSummaryColumns() {
        ArrayList summaryColumns = new ArrayList();
        for (IColumn<?> c : this.getColumns()) {
            if (!c.isSummary()) continue;
            summaryColumns.add(c);
        }
        return summaryColumns;
    }

    public int getIndexFor(IColumn column) {
        return this.m_columns.indexOf(column);
    }

    public void moveColumnToVisibleIndex(int fromIndex, int toVisibleIndex) {
        int fromVisibleIndex = this.modelToVisibleIndex(fromIndex);
        if (fromVisibleIndex >= 0 && toVisibleIndex >= 0) {
            this.moveVisibleColumnToVisibleIndex(fromVisibleIndex, toVisibleIndex);
        }
    }

    public void moveVisibleColumnToVisibleIndex(int fromVisibleIndex, int toVisibleIndex) {
        if (fromVisibleIndex != toVisibleIndex) {
            IColumn fromCol = this.getVisibleColumn(fromVisibleIndex);
            IColumn toCol = this.getVisibleColumn(toVisibleIndex);
            if (fromCol != null && toCol != null) {
                boolean traversedFrom = false;
                ArrayList list = new ArrayList();
                for (IColumn<?> c : this.getAllColumnsInUserOrder()) {
                    if (c == fromCol) {
                        traversedFrom = true;
                        continue;
                    }
                    if (c == toCol) {
                        if (traversedFrom) {
                            list.add(c);
                            list.add(fromCol);
                            continue;
                        }
                        list.add(fromCol);
                        list.add(c);
                        continue;
                    }
                    list.add(c);
                }
                int viewHint = 0;
                for (IColumn iColumn : list) {
                    iColumn.setVisibleColumnIndexHint(viewHint);
                    ++viewHint;
                }
                this.reorganizeIndexes();
                this.fireColumnOrderChanged();
            }
        }
    }

    public void setVisibleColumns(Collection<? extends IColumn> columns) {
        try {
            this.m_table.setTableChanging(true);
            List<IColumn<?>> resolvedColumns = this.resolveColumns(columns);
            if (columns == null) {
                columns = CollectionUtility.hashSet((Object[])new IColumn[0]);
            }
            if (resolvedColumns.size() > 0 || columns.size() == 0) {
                ArrayList<IColumn> newColumns = new ArrayList<IColumn>();
                for (IColumn col : columns) {
                    if (!col.isDisplayable()) continue;
                    if (col.getInitialWidth() == 0 && col.getWidth() == 0) {
                        col.setInitialWidth(60);
                        col.setWidth(60);
                    }
                    newColumns.add(col);
                }
                int viewHint = 0;
                int nextNewIndex = 0;
                for (IColumn<?> col : this.getAllColumnsInUserOrder()) {
                    if (newColumns.contains(col)) {
                        IColumn nextSortedCol = (IColumn)newColumns.get(nextNewIndex);
                        ++nextNewIndex;
                        nextSortedCol.setVisible(true);
                        nextSortedCol.setVisibleColumnIndexHint(viewHint);
                    } else {
                        col.setVisible(false);
                        col.setVisibleColumnIndexHint(viewHint);
                    }
                    ++viewHint;
                }
                this.reorganizeIndexes();
                List<IColumn<?>> displayableColumns = this.getDisplayableColumns();
                for (IColumn<?> col : displayableColumns) {
                    this.rebuildHeaderCell(col);
                }
                this.fireColumnHeadersUpdated(displayableColumns);
                this.fireColumnStructureChanged();
                this.checkMultiline();
            }
        }
        finally {
            this.m_table.setTableChanging(false);
        }
    }

    private int visibleToModelIndex(int visibleIndex) {
        if (visibleIndex < 0 || visibleIndex >= this.m_visibleIndexes.length) {
            LOG.warn("viewIndex " + visibleIndex + " out of range [" + 0 + "," + (this.m_visibleIndexes.length - 1) + "]");
            return -1;
        }
        return this.m_visibleIndexes[visibleIndex];
    }

    private int keyToModelIndex(int keyIndex) {
        if (keyIndex < 0 || keyIndex >= this.m_keyIndexes.length) {
            LOG.warn("keyIndex " + keyIndex + " out of range [" + 0 + "," + (this.m_keyIndexes.length - 1) + "]");
            return -1;
        }
        return this.m_keyIndexes[keyIndex];
    }

    private int modelToVisibleIndex(int index) {
        int i = 0;
        while (i < this.m_visibleIndexes.length) {
            if (this.m_visibleIndexes[i] == index) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public IColumn resolveColumn(IColumn c) {
        if (c.getTable() == this.m_table) {
            return c;
        }
        return null;
    }

    public List<IColumn<?>> resolveColumns(Collection<? extends IColumn> columns) {
        if (columns != null) {
            ArrayList result = new ArrayList(columns.size());
            for (IColumn iColumn : columns) {
                IColumn resolvedCol = this.resolveColumn(iColumn);
                if (resolvedCol == null) continue;
                result.add(resolvedCol);
            }
            return result;
        }
        return CollectionUtility.emptyArrayList();
    }

    public void handleSortEvent(IColumn col, boolean multiSort) {
        if ((col = this.resolveColumn(col)) == null) {
            return;
        }
        try {
            this.m_table.setTableChanging(true);
            if (multiSort) {
                if (this.isSortColumn(col) && col.isSortExplicit()) {
                    this.toggleSortColumn(col);
                } else {
                    this.addSortColumn(col, true);
                }
            } else {
                int explicitCount = 0;
                for (IColumn<?> c : this.m_userSortColumns) {
                    if (!c.isSortExplicit()) continue;
                    ++explicitCount;
                }
                if (this.isSortColumn(col) && col.isSortExplicit() && explicitCount == 1) {
                    this.toggleSortColumn(col);
                } else {
                    this.setSortColumn(col, true, 5);
                }
            }
        }
        finally {
            this.m_table.setTableChanging(false);
        }
    }

    public int getSortColumnCount() {
        return this.m_userSortColumns.size() + this.m_permanentHeadSortColumns.size() + this.m_permanentTailSortColumns.size();
    }

    public List<IColumn<?>> getSortColumns() {
        ArrayList list = new ArrayList(this.getSortColumnCount());
        list.addAll(this.m_permanentHeadSortColumns);
        list.addAll(this.m_userSortColumns);
        list.addAll(this.m_permanentTailSortColumns);
        return list;
    }

    public List<IColumn<?>> getUserSortColumns() {
        return CollectionUtility.arrayList(this.m_userSortColumns);
    }

    public List<IColumn<?>> getPermanentHeadSortColumns() {
        return CollectionUtility.arrayList(this.m_permanentHeadSortColumns);
    }

    public List<IColumn<?>> getPermanentTailSortColumns() {
        return CollectionUtility.arrayList(this.m_permanentTailSortColumns);
    }

    public SortSpec getSortSpec() {
        ArrayList sortColumns = new ArrayList();
        for (IColumn<?> c : this.getSortColumns()) {
            if (!c.isSortExplicit()) continue;
            sortColumns.add(c);
        }
        if (sortColumns.size() > 0) {
            int[] indexes = new int[sortColumns.size()];
            boolean[] asc = new boolean[sortColumns.size()];
            int i = 0;
            while (i < sortColumns.size()) {
                indexes[i] = ((IColumn)sortColumns.get(i)).getColumnIndex();
                asc[i] = ((IColumn)sortColumns.get(i)).isSortAscending();
                ++i;
            }
            return new SortSpec(indexes, asc);
        }
        return null;
    }

    public void setSortSpec(SortSpec spec) {
        if (spec != null) {
            for (IColumn<?> col : this.m_userSortColumns) {
                HeaderCell cell = (HeaderCell)col.getHeaderCell();
                cell.setSortActive(false);
                cell.setSortAscending(false);
                cell.setSortExplicit(false);
            }
            this.m_userSortColumns.clear();
            ArrayList<IColumn> colList = new ArrayList<IColumn>();
            int i = 0;
            while (i < spec.size()) {
                IColumn col = this.getColumn(spec.getColumnIndex(i));
                if (col != null && !this.isSortColumn(col)) {
                    HeaderCell cell = (HeaderCell)col.getHeaderCell();
                    cell.setSortActive(true);
                    cell.setSortExplicit(true);
                    cell.setSortAscending(spec.isColumnAscending(i));
                    colList.add(col);
                }
                ++i;
            }
            this.m_userSortColumns.addAll(colList);
            for (IColumn col : colList) {
                this.rebuildHeaderCell(col);
            }
            this.fireColumnHeadersUpdated(colList);
        } else {
            this.clearSortColumns();
        }
    }

    public boolean isSortColumn(IColumn col) {
        return this.m_permanentHeadSortColumns.contains(col) || this.m_userSortColumns.contains(col) || this.m_permanentTailSortColumns.contains(col);
    }

    public boolean isUserSortColumn(IColumn col) {
        return this.m_userSortColumns.contains(col);
    }

    public boolean isPermanentHeadSortColumn(IColumn col) {
        return this.m_permanentHeadSortColumns.contains(col);
    }

    public boolean isPermanentTailSortColumn(IColumn col) {
        return this.m_permanentTailSortColumns.contains(col);
    }

    public int getSortColumnIndex(IColumn col) {
        if (this.isPermanentHeadSortColumn(col)) {
            return this.m_permanentHeadSortColumns.indexOf(col);
        }
        if (this.isUserSortColumn(col)) {
            return this.m_permanentHeadSortColumns.size() + this.m_userSortColumns.indexOf(col);
        }
        if (this.isPermanentTailSortColumn(col)) {
            return this.m_permanentHeadSortColumns.size() + this.m_userSortColumns.size() + this.m_permanentTailSortColumns.indexOf(col);
        }
        return -1;
    }

    public void setSortColumn(IColumn<?> col, boolean ascending, int keepHistoryCount) {
        if ((col = this.resolveColumn(col)) != null) {
            this.m_userSortColumns.remove(col);
            if (!this.isSortColumn(col)) {
                while (this.m_userSortColumns.size() > keepHistoryCount) {
                    IColumn<?> c = this.m_userSortColumns.remove(this.m_userSortColumns.size() - 1);
                    HeaderCell cell = (HeaderCell)c.getHeaderCell();
                    cell.setSortActive(false);
                    cell.setSortExplicit(false);
                    cell.setSortAscending(false);
                    this.rebuildHeaderCell(c);
                }
                for (IColumn<?> c : this.m_userSortColumns) {
                    HeaderCell cell = (HeaderCell)c.getHeaderCell();
                    cell.setSortExplicit(false);
                    this.rebuildHeaderCell(c);
                }
                HeaderCell cell = (HeaderCell)col.getHeaderCell();
                cell.setSortActive(true);
                cell.setSortExplicit(true);
                cell.setSortAscending(ascending);
                this.m_userSortColumns.add(0, col);
                this.rebuildHeaderCell(col);
                this.fireColumnHeadersUpdated(CollectionUtility.hashSet((Object)col));
            }
        }
    }

    public void addSortColumn(IColumn<?> col, boolean ascending) {
        if ((col = this.resolveColumn(col)) != null) {
            this.m_userSortColumns.remove(col);
            if (!this.isSortColumn(col)) {
                Iterator<IColumn<?>> it = this.m_userSortColumns.iterator();
                while (it.hasNext()) {
                    IColumn<?> c = it.next();
                    if (c.isSortExplicit()) continue;
                    it.remove();
                    HeaderCell cell = (HeaderCell)c.getHeaderCell();
                    cell.setSortActive(false);
                    cell.setSortExplicit(false);
                    cell.setSortAscending(false);
                    this.rebuildHeaderCell(c);
                }
                HeaderCell cell = (HeaderCell)col.getHeaderCell();
                cell.setSortActive(true);
                cell.setSortExplicit(true);
                cell.setSortAscending(ascending);
                this.m_userSortColumns.add(col);
                this.rebuildHeaderCell(col);
                this.fireColumnHeadersUpdated(CollectionUtility.hashSet((Object)col));
            }
        }
    }

    public void toggleSortColumn(IColumn<?> col) {
        if ((col = this.resolveColumn(col)) != null && this.isSortColumn(col) && !col.isSortPermanent()) {
            HeaderCell cell;
            cell.setSortAscending(!(cell = (HeaderCell)col.getHeaderCell()).isSortAscending());
            this.rebuildHeaderCell(col);
            this.fireColumnHeadersUpdated(CollectionUtility.hashSet((Object)col));
        }
    }

    private void updateColumnStructure(IColumn column) {
        this.reorganizeIndexes();
        this.checkMultiline();
        this.fireColumnStructureChanged();
    }

    private void resetColumnsViewOrder() {
        for (IColumn<?> c : this.getColumns()) {
            c.setVisibleColumnIndexHint(-1);
        }
        this.reorganizeIndexes();
        this.fireColumnOrderChanged();
    }

    public void updateColumn(IColumn<?> column) {
        this.checkMultiline();
        this.fireColumnHeadersUpdated(CollectionUtility.hashSet(column));
    }

    public void removeSortColumn(IColumn<?> col) {
        if ((col = this.resolveColumn(col)) != null) {
            this.m_userSortColumns.remove(col);
            if (!this.isSortColumn(col)) {
                HeaderCell cell = (HeaderCell)col.getHeaderCell();
                cell.setSortActive(false);
                cell.setSortExplicit(false);
                this.rebuildHeaderCell(col);
                this.fireColumnHeadersUpdated(CollectionUtility.hashSet((Object)col));
            }
        }
    }

    public void clearSortColumns() {
        if (this.m_userSortColumns.size() == 0) {
            return;
        }
        ArrayList userSortColumnsBackup = new ArrayList(this.m_userSortColumns);
        this.m_userSortColumns.clear();
        for (IColumn iColumn : userSortColumnsBackup) {
            HeaderCell cell = (HeaderCell)iColumn.getHeaderCell();
            cell.setSortActive(false);
            cell.setSortExplicit(false);
        }
        for (IColumn iColumn : userSortColumnsBackup) {
            this.rebuildHeaderCell(iColumn);
        }
        this.fireColumnHeadersUpdated(userSortColumnsBackup);
    }

    public void clearPermanentHeadSortColumns() {
        if (this.m_permanentHeadSortColumns.size() == 0) {
            return;
        }
        ArrayList currentColumnList = new ArrayList(this.m_permanentHeadSortColumns);
        this.m_permanentHeadSortColumns.clear();
        for (IColumn iColumn : currentColumnList) {
            HeaderCell cell = (HeaderCell)iColumn.getHeaderCell();
            cell.setSortActive(false);
            cell.setSortExplicit(false);
            cell.setSortPermanent(false);
        }
        for (IColumn iColumn : currentColumnList) {
            this.rebuildHeaderCell(iColumn);
        }
        this.fireColumnHeadersUpdated(currentColumnList);
    }

    public void clearPermanentTailSortColumns() {
        if (this.m_permanentTailSortColumns.size() == 0) {
            return;
        }
        ArrayList currentColumnList = new ArrayList(this.m_permanentTailSortColumns);
        this.m_permanentTailSortColumns.clear();
        for (IColumn iColumn : currentColumnList) {
            HeaderCell cell = (HeaderCell)iColumn.getHeaderCell();
            cell.setSortActive(false);
            cell.setSortExplicit(false);
            cell.setSortPermanent(false);
        }
        for (IColumn iColumn : currentColumnList) {
            this.rebuildHeaderCell(iColumn);
        }
        this.fireColumnHeadersUpdated(currentColumnList);
    }

    public void addPermanentHeadSortColumn(IColumn<?> col, boolean ascending) {
        if ((col = this.resolveColumn(col)) != null) {
            this.m_permanentHeadSortColumns.remove(col);
            HeaderCell cell = (HeaderCell)col.getHeaderCell();
            cell.setSortActive(true);
            cell.setSortExplicit(true);
            cell.setSortPermanent(true);
            cell.setSortAscending(ascending);
            this.m_permanentHeadSortColumns.add(col);
            this.rebuildHeaderCell(col);
            this.fireColumnHeadersUpdated(CollectionUtility.hashSet((Object)col));
        }
    }

    public void addPermanentTailSortColumn(IColumn<?> col, boolean ascending) {
        if ((col = this.resolveColumn(col)) != null) {
            this.m_permanentTailSortColumns.remove(col);
            HeaderCell cell = (HeaderCell)col.getHeaderCell();
            cell.setSortActive(true);
            cell.setSortExplicit(true);
            cell.setSortPermanent(true);
            cell.setSortAscending(ascending);
            this.m_permanentTailSortColumns.add(col);
            this.rebuildHeaderCell(col);
            this.fireColumnHeadersUpdated(CollectionUtility.hashSet((Object)col));
        }
    }

    private void reorganizeIndexes() {
        this.calculateDisplayableIndexes();
        this.calculateVisibleIndexes();
        this.calculateKeyIndexes();
    }

    private void calculateDisplayableIndexes() {
        int viewIndex = 0;
        TreeMap<CompositeObject, Integer> displayableMap = new TreeMap<CompositeObject, Integer>();
        int modelIndex = 0;
        while (modelIndex < this.getColumnCount()) {
            IColumn col = this.getColumn(modelIndex);
            if (col.isDisplayable()) {
                displayableMap.put(new CompositeObject(new Object[]{modelIndex}), modelIndex);
            }
            ++modelIndex;
        }
        this.m_displayableIndexes = new int[displayableMap.size()];
        viewIndex = 0;
        Iterator iterator = displayableMap.values().iterator();
        while (iterator.hasNext()) {
            modelIndex = (Integer)iterator.next();
            this.m_displayableIndexes[viewIndex++] = modelIndex;
        }
    }

    private void calculateVisibleIndexes() {
        int viewIndex = 0;
        TreeMap<CompositeObject, Integer> visibleMap = new TreeMap<CompositeObject, Integer>();
        int modelIndex = 0;
        while (modelIndex < this.getColumnCount()) {
            IColumn col = this.getColumn(modelIndex);
            if (col.isDisplayable() && col.isVisible()) {
                double viewHint = col.getVisibleColumnIndexHint();
                if (viewHint < 0.0) {
                    viewHint = col.getOrder();
                }
                if (viewHint < 0.0) {
                    viewHint = viewIndex;
                }
                visibleMap.put(new CompositeObject(new Object[]{viewHint, viewIndex}), modelIndex);
                ++viewIndex;
            }
            ++modelIndex;
        }
        this.m_visibleIndexes = new int[visibleMap.size()];
        viewIndex = 0;
        Iterator iterator = visibleMap.values().iterator();
        while (iterator.hasNext()) {
            modelIndex = (Integer)iterator.next();
            this.m_visibleIndexes[viewIndex++] = modelIndex;
        }
    }

    private void calculateKeyIndexes() {
        ArrayList<Integer> keyIndexes = new ArrayList<Integer>();
        int modelIndex = 0;
        while (modelIndex < this.getColumnCount()) {
            IColumn col = this.getColumn(modelIndex);
            if (col.isPrimaryKey()) {
                keyIndexes.add(modelIndex);
            }
            ++modelIndex;
        }
        this.m_keyIndexes = new int[keyIndexes.size()];
        int viewIndex = 0;
        Iterator iterator = keyIndexes.iterator();
        while (iterator.hasNext()) {
            int modelIndex2 = (Integer)iterator.next();
            this.m_keyIndexes[viewIndex++] = modelIndex2;
        }
    }

    private void rebuildHeaderCell(IColumn col) {
        col.decorateHeaderCell();
    }

    private void fireColumnHeadersUpdated(Collection<? extends IColumn<?>> columns) {
        TableEvent e = new TableEvent(this.m_table, 780);
        e.setColumns(columns);
        this.m_table.fireTableEventInternal(e);
    }

    private void fireColumnOrderChanged() {
        TableEvent e = new TableEvent(this.m_table, 770);
        this.m_table.fireTableEventInternal(e);
    }

    private void fireColumnStructureChanged() {
        TableEvent e = new TableEvent(this.m_table, 1);
        this.m_table.fireTableEventInternal(e);
    }

    private void checkMultiline() {
        if (this.m_table != null && !this.m_table.isInitialMultilineText() && !ConfigurationUtility.isMethodOverwrite(AbstractTable.class, (String)"getConfiguredMultilineText", null, this.m_table.getClass())) {
            boolean m = false;
            for (IColumn<?> col : this.getVisibleColumns()) {
                if (!(col instanceof IStringColumn) || !((IStringColumn)col).isTextWrap()) continue;
                m = true;
                break;
            }
            this.m_table.setMultilineText(m);
        }
    }
}

