/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table;

import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.HTMLUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.TypeCastUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IBigDecimalColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IBooleanColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IDateColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IDoubleColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IIntegerColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.ILongColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.ISmartColumn;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.rt.shared.services.lookup.ILookupCall;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRow;
import org.eclipse.scout.rt.shared.services.lookup.LocalLookupCall;
import org.eclipse.scout.rt.shared.services.lookup.LookupCall;
import org.eclipse.scout.service.SERVICES;

public final class TableUtility {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(TableUtility.class);

    private TableUtility() {
    }

    public static <T> void resolveLookupCall(Map<ILookupCall<T>, List<? extends ILookupRow<T>>> lookupCache, ITableRow row, ISmartColumn<T> col, boolean multilineText) {
        try {
            ILookupCall call = col.prepareLookupCall(row);
            if (call != null) {
                List result = null;
                boolean verifiedQuality = TableUtility.verifyLookupCallBeanQuality(call);
                if (verifiedQuality) {
                    result = lookupCache.get(call);
                }
                if (result == null) {
                    result = call.getDataByKey();
                    if (verifiedQuality) {
                        lookupCache.put(call, result);
                    }
                }
                TableUtility.applyLookupResult(row, col, result, multilineText);
            }
        }
        catch (ProcessingException e) {
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
        }
    }

    public static boolean verifyLookupCallBeanQuality(ILookupCall<?> call) {
        Class<?> clazz = call.getClass();
        if (LocalLookupCall.class == clazz) {
            return true;
        }
        if (LookupCall.class == clazz) {
            return true;
        }
        if (LocalLookupCall.class.isAssignableFrom(clazz)) {
            Class<?> tmp = clazz;
            while (tmp != LocalLookupCall.class) {
                if (ConfigurationUtility.isMethodOverwrite(LocalLookupCall.class, (String)"equals", (Class[])new Class[]{Object.class}, tmp)) {
                    return true;
                }
                Field[] fields = tmp.getDeclaredFields();
                if (fields != null && fields.length > 0) {
                    int i = 0;
                    while (i < fields.length) {
                        if ((fields[i].getModifiers() & 0x18) == 0) {
                            LOG.warn(clazz + " subclasses LocalLookupCall with additional member " + fields[i].getName() + " and should therefore override the 'equals' and 'hashCode' methods");
                            return false;
                        }
                        ++i;
                    }
                }
                tmp = tmp.getSuperclass();
            }
            return true;
        }
        if (LookupCall.class.isAssignableFrom(clazz)) {
            Class<?> tmp = clazz;
            while (tmp != LookupCall.class) {
                if (ConfigurationUtility.isMethodOverwrite(LookupCall.class, (String)"equals", (Class[])new Class[]{Object.class}, tmp)) {
                    return true;
                }
                Field[] fields = tmp.getDeclaredFields();
                if (fields != null && fields.length > 0) {
                    int i = 0;
                    while (i < fields.length) {
                        if ((fields[i].getModifiers() & 0x18) == 0) {
                            LOG.warn(clazz + " subclasses LookupCall with additional member " + fields[i].getName() + " and should therefore override the 'equals' and 'hashCode' methods");
                            return false;
                        }
                        ++i;
                    }
                }
                tmp = tmp.getSuperclass();
            }
            return true;
        }
        return false;
    }

    public static <T> void applyLookupResult(ITableRow row, IColumn<T> col, List<? extends ILookupRow<T>> result, boolean multilineText) {
        try {
            row.setRowChanging(true);
            Cell cell = (Cell)row.getCell(col.getColumnIndex());
            if (result.size() == 1) {
                cell.setText(result.get(0).getText());
            } else if (result.size() > 1) {
                StringBuffer buf = new StringBuffer();
                int i = 0;
                while (i < result.size()) {
                    if (i > 0) {
                        if (multilineText) {
                            buf.append("\n");
                        } else {
                            buf.append(", ");
                        }
                    }
                    buf.append(result.get(i).getText());
                    ++i;
                }
                cell.setText(buf.toString());
            } else {
                cell.setText("");
            }
        }
        finally {
            row.setRowPropertiesChanged(false);
            row.setRowChanging(false);
        }
    }

    public static Object[][] exportRowsAsCSV(List<? extends ITableRow> rows, List<? extends IColumn> columns, boolean includeLineForColumnNames, boolean includeLineForColumnTypes, boolean includeLineForColumnFormats) {
        int nr = rows.size();
        Object[][] a = new Object[nr + (includeLineForColumnNames ? 1 : 0) + (includeLineForColumnTypes ? 1 : 0) + (includeLineForColumnFormats ? 1 : 0)][columns.size()];
        int c = 0;
        while (c < columns.size()) {
            String format;
            boolean byValue;
            Class type;
            IColumn col = columns.get(c);
            if (col instanceof IDateColumn) {
                if (((IDateColumn)col).isHasTime()) {
                    type = Timestamp.class;
                    byValue = true;
                    format = ((IDateColumn)col).getFormat();
                } else {
                    type = Date.class;
                    byValue = true;
                    format = ((IDateColumn)col).getFormat();
                }
            } else if (col instanceof IDoubleColumn) {
                type = Double.class;
                byValue = true;
                format = ((IDoubleColumn)col).getFormat().toPattern();
            } else if (col instanceof IIntegerColumn) {
                type = Integer.class;
                byValue = true;
                format = ((IIntegerColumn)col).getFormat().toPattern();
            } else if (col instanceof ILongColumn) {
                type = Long.class;
                byValue = true;
                format = ((ILongColumn)col).getFormat().toPattern();
            } else if (col instanceof IBigDecimalColumn) {
                type = Double.class;
                byValue = true;
                format = ((IBigDecimalColumn)col).getFormat().toPattern();
            } else if (col instanceof ISmartColumn) {
                type = String.class;
                byValue = false;
                format = null;
            } else if (col instanceof IBooleanColumn) {
                type = Boolean.class;
                byValue = false;
                format = null;
            } else {
                type = String.class;
                byValue = false;
                format = null;
            }
            int csvRowIndex = 0;
            if (includeLineForColumnNames) {
                a[csvRowIndex][c] = columns.get(c).getHeaderCell().getText();
                ++csvRowIndex;
            }
            if (includeLineForColumnTypes) {
                a[csvRowIndex][c] = type;
                ++csvRowIndex;
            }
            if (includeLineForColumnFormats) {
                a[csvRowIndex][c] = format;
                ++csvRowIndex;
            }
            int r = 0;
            while (r < nr) {
                if (byValue) {
                    a[csvRowIndex][c] = type == Timestamp.class ? TypeCastUtility.castValue(columns.get(c).getValue(rows.get(r)), Timestamp.class) : columns.get(c).getValue(rows.get(r));
                } else {
                    Boolean b;
                    String text = columns.get(c).getDisplayText(rows.get(r));
                    if (type == Boolean.class && (b = (Boolean)TypeCastUtility.castValue(columns.get(c).getValue(rows.get(r)), Boolean.class)) != null && b.booleanValue() && !StringUtility.hasText((CharSequence)text)) {
                        text = "X";
                    }
                    if (type == String.class && text != null && text.startsWith("<html")) {
                        text = HTMLUtility.getPlainText((String)text);
                    }
                    a[csvRowIndex][c] = text;
                }
                ++csvRowIndex;
                ++r;
            }
            ++c;
        }
        return a;
    }

    public static void editNextTableCell(ITable table, ITableRow currentRow, IColumn<?> currentCol, boolean forward, ITableCellEditorFilter filter) {
        if (table == null) {
            return;
        }
        int rowCount = table.getFilteredRowCount();
        int colCount = table.getVisibleColumnCount();
        if (rowCount <= 0 || colCount <= 0) {
            return;
        }
        currentRow = table.resolveRow(currentRow);
        currentCol = table.getColumnSet().resolveColumn(currentCol);
        if (currentRow == null || currentCol == null) {
            return;
        }
        int row = table.getFilteredRowIndex(currentRow);
        int modelCol = currentCol.getColumnIndex();
        int[] visibleIndexes = table.getColumnSet().getVisibleColumnIndexes();
        int col = -1;
        int i = 0;
        while (i < visibleIndexes.length) {
            if (visibleIndexes[i] == modelCol) {
                col = i;
                break;
            }
            ++i;
        }
        if (row < 0 || col < 0) {
            return;
        }
        int a = rowCount * colCount;
        while (a > 1) {
            --a;
            if (forward) {
                if (++col >= colCount) {
                    ++row;
                    col = 0;
                }
                if (row >= rowCount) {
                    row = 0;
                }
            } else {
                if (--col < 0) {
                    --row;
                    col = colCount - 1;
                }
                if (row < 0) {
                    row = rowCount - 1;
                }
            }
            ITableRow tr = table.getFilteredRow(row);
            IColumn tc = table.getColumnSet().getVisibleColumn(col);
            if (tr == null || tc == null || !table.isCellEditable(tr, tc) || filter != null && !filter.accept(tr, tc)) continue;
            table.requestFocusInCell(tc, tr);
            return;
        }
    }

    public static interface ITableCellEditorFilter {
        public boolean accept(ITableRow var1, IColumn<?> var2);
    }
}

