/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table.columnfilter;

import java.io.Serializable;
import java.text.Collator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.eclipse.scout.commons.LocaleThreadLocal;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columnfilter.ITableColumnFilter;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.data.basic.FontSpec;
import org.eclipse.scout.rt.shared.services.lookup.LookupRow;

public class StringColumnFilter
implements ITableColumnFilter<String>,
Serializable {
    private static final long serialVersionUID = 1L;
    private IColumn<String> m_column;
    private Set<String> m_selectedValues;
    private String m_pattern;
    private transient Pattern m_regexPat;

    public StringColumnFilter(IColumn<String> column) {
        this.m_column = column;
    }

    @Override
    public IColumn<String> getColumn() {
        return this.m_column;
    }

    @Override
    public void setColumn(IColumn column) {
        this.m_column = column;
    }

    @Override
    public Set<String> getSelectedValues() {
        return this.m_selectedValues;
    }

    @Override
    public void setSelectedValues(Set<String> set) {
        this.m_selectedValues = set;
    }

    public String getPattern() {
        return this.m_pattern;
    }

    public void setPattern(String pattern) {
        this.m_pattern = pattern;
        this.m_regexPat = null;
    }

    @Override
    public List<LookupRow<String>> createHistogram() {
        TreeMap<Object, LookupRow> hist = new TreeMap<Object, LookupRow>(Collator.getInstance(LocaleThreadLocal.get()));
        HashMap<String, Integer> countMap = new HashMap<String, Integer>();
        for (ITableRow iTableRow : this.m_column.getTable().getRows()) {
            Integer count;
            String s = this.m_column.getDisplayText(iTableRow);
            if (!StringUtility.hasText((CharSequence)s)) {
                s = null;
            }
            if (s != null && !hist.containsKey(s)) {
                FontSpec font = iTableRow.isFilterAccepted() ? null : FontSpec.parse((String)"italic");
                hist.put(s, new LookupRow((Object)s, s, null, null, null, null, font));
            }
            countMap.put(s, (count = (Integer)countMap.get(s)) != null ? count + 1 : 1);
        }
        for (Map.Entry entry : hist.entrySet()) {
            Integer count = (Integer)countMap.get(entry.getKey());
            if (count == null || count <= 1) continue;
            ((LookupRow)entry.getValue()).setText(String.valueOf(((LookupRow)entry.getValue()).getText()) + " (" + count + ")");
        }
        ArrayList<LookupRow<String>> arrayList = new ArrayList<LookupRow<String>>();
        arrayList.addAll(hist.values());
        Integer nullCount = (Integer)countMap.get(null);
        arrayList.add(new LookupRow(null, "(" + ScoutTexts.get((String)"ColumnFilterNullText", (String[])new String[0]) + ")" + (nullCount != null && nullCount > 1 ? " (" + nullCount + ")" : "")));
        return arrayList;
    }

    @Override
    public boolean isEmpty() {
        return (this.m_selectedValues == null || this.m_selectedValues.isEmpty()) && this.m_pattern == null;
    }

    @Override
    public boolean accept(ITableRow row) {
        String value = this.m_column.getDisplayText(row);
        if (!StringUtility.hasText((CharSequence)value)) {
            value = null;
        }
        if (this.m_pattern != null) {
            if (this.m_regexPat == null) {
                this.m_regexPat = Pattern.compile(StringUtility.toRegExPattern((String)("*" + this.m_pattern.toLowerCase() + "*")), 32);
            }
            if (value == null) {
                return false;
            }
            if (!this.m_regexPat.matcher(value.toLowerCase()).matches()) {
                return false;
            }
        }
        return this.m_selectedValues == null || this.m_selectedValues.contains(value);
    }
}

