/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table.columns;

import java.math.BigDecimal;
import org.eclipse.scout.commons.annotations.ClassId;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.extension.ui.basic.table.columns.IBigDecimalColumnExtension;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractDecimalColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IBigDecimalColumn;
import org.eclipse.scout.rt.client.ui.form.fields.bigdecimalfield.AbstractBigDecimalField;
import org.eclipse.scout.rt.client.ui.form.fields.bigdecimalfield.IBigDecimalField;

@ClassId(value="cf4984e1-7ec9-4442-a9d8-23145b0e1614")
public abstract class AbstractBigDecimalColumn
extends AbstractDecimalColumn<BigDecimal>
implements IBigDecimalColumn {
    @Override
    @ConfigProperty(value="BIG_DECIMAL")
    @Order(value=200.0)
    protected BigDecimal getConfiguredMaxValue() {
        return null;
    }

    @Override
    @ConfigProperty(value="BIG_DECIMAL")
    @Order(value=210.0)
    protected BigDecimal getConfiguredMinValue() {
        return null;
    }

    @Override
    protected BigDecimal parseValueInternal(ITableRow row, Object rawValue) throws ProcessingException {
        BigDecimal validValue = null;
        if (rawValue == null) {
            validValue = null;
        } else if (rawValue instanceof BigDecimal) {
            validValue = (BigDecimal)rawValue;
        } else if (rawValue instanceof Long) {
            validValue = new BigDecimal(((Long)rawValue).toString());
        } else if (rawValue instanceof Double) {
            validValue = BigDecimal.valueOf((Double)rawValue);
        } else {
            throw new ProcessingException("invalid BigDecimal value in column '" + this.getClass().getSimpleName() + "': " + rawValue + " class=" + rawValue.getClass());
        }
        return validValue;
    }

    @Override
    protected IBigDecimalField getEditorField() {
        return new AbstractBigDecimalField(){};
    }

    @Override
    protected IBigDecimalColumnExtension<? extends AbstractBigDecimalColumn> createLocalExtension() {
        return new LocalBigDecimalColumnExtension<AbstractBigDecimalColumn>(this);
    }

    protected static class LocalBigDecimalColumnExtension<OWNER extends AbstractBigDecimalColumn>
    extends AbstractDecimalColumn.LocalDecimalColumnExtension<BigDecimal, OWNER>
    implements IBigDecimalColumnExtension<OWNER> {
        public LocalBigDecimalColumnExtension(OWNER owner) {
            super(owner);
        }
    }
}

