/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table.columns;

import java.util.List;
import org.eclipse.scout.commons.TypeCastUtility;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.extension.ui.basic.table.columns.ContentAssistColumnChains;
import org.eclipse.scout.rt.client.extension.ui.basic.table.columns.IContentAssistColumnExtension;
import org.eclipse.scout.rt.client.services.lookup.ILookupCallProvisioningService;
import org.eclipse.scout.rt.client.services.lookup.TableProvisioningContext;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IContentAssistColumn;
import org.eclipse.scout.rt.shared.services.common.code.ICodeType;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.rt.shared.services.lookup.CodeLookupCall;
import org.eclipse.scout.rt.shared.services.lookup.ILookupCall;
import org.eclipse.scout.service.SERVICES;

public abstract class AbstractContentAssistColumn<VALUE, LOOKUP_TYPE>
extends AbstractColumn<VALUE>
implements IContentAssistColumn<VALUE, LOOKUP_TYPE> {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractContentAssistColumn.class);
    private Class<? extends ICodeType<?, LOOKUP_TYPE>> m_codeTypeClass;
    private ILookupCall<LOOKUP_TYPE> m_lookupCall;

    @ConfigProperty(value="LOOKUP_CALL")
    @Order(value=140.0)
    protected Class<? extends ILookupCall<LOOKUP_TYPE>> getConfiguredLookupCall() {
        return null;
    }

    @ConfigProperty(value="CODE_TYPE")
    @Order(value=150.0)
    protected Class<? extends ICodeType<?, LOOKUP_TYPE>> getConfiguredCodeType() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=310.0)
    protected boolean getConfiguredBrowseHierarchy() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=280.0)
    protected boolean getConfiguredBrowseAutoExpandAll() {
        return true;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=265.0)
    protected int getConfiguredBrowseMaxRowCount() {
        return 100;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=270.0)
    protected boolean getConfiguredActiveFilterEnabled() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=240.0)
    protected boolean getConfiguredBrowseLoadIncremental() {
        return false;
    }

    @ConfigOperation
    @Order(value=140.0)
    protected void execPrepareLookup(ILookupCall<LOOKUP_TYPE> call, ITableRow row) {
    }

    @ConfigOperation
    @Order(value=410.0)
    protected LOOKUP_TYPE execConvertValueToKey(VALUE value) {
        return (LOOKUP_TYPE)value;
    }

    @Override
    public ILookupCall<LOOKUP_TYPE> prepareLookupCall(ITableRow row) {
        if (this.getLookupCall() != null) {
            ILookupCall<LOOKUP_TYPE> call = ((ILookupCallProvisioningService)SERVICES.getService(ILookupCallProvisioningService.class)).newClonedInstance(this.getLookupCall(), new TableProvisioningContext(this.getTable(), row, this));
            call.setKey(this.interceptConvertValueToKey(this.getValueInternal(row)));
            call.setText(null);
            call.setAll(null);
            call.setRec(null);
            this.interceptPrepareLookup(call, row);
            return call;
        }
        return null;
    }

    @Override
    protected void initConfig() {
        Class<ILookupCall<LOOKUP_TYPE>> lookupCallClass;
        super.initConfig();
        if (this.getConfiguredCodeType() != null) {
            this.setCodeTypeClass(this.getConfiguredCodeType());
        }
        if ((lookupCallClass = this.getConfiguredLookupCall()) != null) {
            try {
                ILookupCall<LOOKUP_TYPE> call = lookupCallClass.newInstance();
                this.setLookupCall(call);
            }
            catch (Exception e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("error creating instance of class '" + lookupCallClass.getName() + "'.", (Throwable)e));
            }
        }
    }

    @Override
    public Class<? extends ICodeType<?, LOOKUP_TYPE>> getCodeTypeClass() {
        return this.m_codeTypeClass;
    }

    @Override
    public void setCodeTypeClass(Class<? extends ICodeType<?, LOOKUP_TYPE>> codeTypeClass) {
        this.m_codeTypeClass = codeTypeClass;
        this.m_lookupCall = null;
        if (this.m_codeTypeClass != null) {
            this.m_lookupCall = CodeLookupCall.newInstanceByService(this.m_codeTypeClass);
        }
        this.validateColumnValues();
    }

    @Override
    public ILookupCall<LOOKUP_TYPE> getLookupCall() {
        return this.m_lookupCall;
    }

    @Override
    public void setLookupCall(ILookupCall<LOOKUP_TYPE> call) {
        this.m_lookupCall = call;
    }

    @Override
    protected VALUE parseValueInternal(ITableRow row, Object rawValue) throws ProcessingException {
        Object validValue = null;
        if (rawValue == null) {
            validValue = null;
        } else if (this.getDataType().isAssignableFrom(rawValue.getClass())) {
            validValue = rawValue;
        } else {
            try {
                validValue = TypeCastUtility.castValue((Object)rawValue, this.getDataType());
            }
            catch (Exception e) {
                throw new ProcessingException("invalid " + this.getDataType().getSimpleName() + " value in column '" + this.getClass().getName() + "': " + rawValue + " class=" + rawValue.getClass());
            }
        }
        return (VALUE)validValue;
    }

    protected final LOOKUP_TYPE interceptConvertValueToKey(VALUE value) {
        List extensions = this.getAllExtensions();
        ContentAssistColumnChains.ContentAssistColumnConvertValueToKeyChain chain = new ContentAssistColumnChains.ContentAssistColumnConvertValueToKeyChain(extensions);
        return chain.execConvertValueToKey(value);
    }

    protected final void interceptPrepareLookup(ILookupCall<LOOKUP_TYPE> call, ITableRow row) {
        List extensions = this.getAllExtensions();
        ContentAssistColumnChains.ContentAssistColumnPrepareLookupChain chain = new ContentAssistColumnChains.ContentAssistColumnPrepareLookupChain(extensions);
        chain.execPrepareLookup(call, row);
    }

    protected IContentAssistColumnExtension<VALUE, LOOKUP_TYPE, ? extends AbstractContentAssistColumn<VALUE, LOOKUP_TYPE>> createLocalExtension() {
        return new LocalContentAssistColumnExtension(this);
    }

    protected static class LocalContentAssistColumnExtension<VALUE, LOOKUP_TYPE, OWNER extends AbstractContentAssistColumn<VALUE, LOOKUP_TYPE>>
    extends AbstractColumn.LocalColumnExtension<VALUE, OWNER>
    implements IContentAssistColumnExtension<VALUE, LOOKUP_TYPE, OWNER> {
        public LocalContentAssistColumnExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public LOOKUP_TYPE execConvertValueToKey(ContentAssistColumnChains.ContentAssistColumnConvertValueToKeyChain<VALUE, LOOKUP_TYPE> chain, VALUE value) {
            return ((AbstractContentAssistColumn)this.getOwner()).execConvertValueToKey(value);
        }

        @Override
        public void execPrepareLookup(ContentAssistColumnChains.ContentAssistColumnPrepareLookupChain<VALUE, LOOKUP_TYPE> chain, ILookupCall<LOOKUP_TYPE> call, ITableRow row) {
            ((AbstractContentAssistColumn)this.getOwner()).execPrepareLookup(call, row);
        }
    }
}

