/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table.columns;

import java.util.Collection;
import java.util.List;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.TypeCastUtility;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.IOrdered;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.annotations.OrderedCollection;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.extension.ui.basic.table.columns.IMixedSmartColumnExtension;
import org.eclipse.scout.rt.client.extension.ui.basic.table.columns.MixedSmartColumnChains;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractContentAssistColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IMixedSmartColumn;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.AbstractMixedSmartField;
import org.eclipse.scout.rt.shared.extension.ContributionComposite;
import org.eclipse.scout.rt.shared.extension.IContributionOwner;
import org.eclipse.scout.rt.shared.services.common.code.CODES;
import org.eclipse.scout.rt.shared.services.common.code.ICodeType;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.rt.shared.services.lookup.ILookupCall;
import org.eclipse.scout.service.SERVICES;

public abstract class AbstractMixedSmartColumn<VALUE_TYPE, LOOKUP_CALL_KEY_TYPE>
extends AbstractContentAssistColumn<VALUE_TYPE, LOOKUP_CALL_KEY_TYPE>
implements IMixedSmartColumn<VALUE_TYPE, LOOKUP_CALL_KEY_TYPE>,
IContributionOwner {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractMixedSmartColumn.class);
    private boolean m_sortCodesByDisplayText;
    private IContributionOwner m_contributionHolder;

    public final List<Object> getAllContributions() {
        return this.m_contributionHolder.getAllContributions();
    }

    public final <T> List<T> getContributionsByClass(Class<T> type) {
        return this.m_contributionHolder.getContributionsByClass(type);
    }

    public final <T> T getContribution(Class<T> contribution) {
        return (T)this.m_contributionHolder.getContribution(contribution);
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=160.0)
    protected boolean getConfiguredSortCodesByDisplayText() {
        return false;
    }

    @ConfigProperty(value="STRING")
    @Order(value=315.0)
    protected String getConfiguredBrowseNewText() {
        return null;
    }

    @ConfigOperation
    @Order(value=400.0)
    protected VALUE_TYPE execConvertKeyToValue(LOOKUP_CALL_KEY_TYPE key) {
        return (VALUE_TYPE)key;
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.m_contributionHolder = new ContributionComposite((Object)this);
        this.setSortCodesByDisplayText(this.getConfiguredSortCodesByDisplayText());
    }

    @Override
    public boolean isSortCodesByDisplayText() {
        return this.m_sortCodesByDisplayText;
    }

    @Override
    public void setSortCodesByDisplayText(boolean b) {
        this.m_sortCodesByDisplayText = b;
    }

    @Override
    protected VALUE_TYPE parseValueInternal(ITableRow row, Object rawValue) throws ProcessingException {
        Object validValue = null;
        if (rawValue == null) {
            validValue = null;
        } else if (this.getDataType().isAssignableFrom(rawValue.getClass())) {
            validValue = rawValue;
        } else {
            try {
                validValue = TypeCastUtility.castValue((Object)rawValue, this.getDataType());
            }
            catch (Exception e) {
                throw new ProcessingException("invalid " + this.getDataType().getSimpleName() + " value in column '" + this.getClass().getName() + "': " + rawValue + " class=" + rawValue.getClass());
            }
        }
        return (VALUE_TYPE)validValue;
    }

    @Override
    protected IFormField prepareEditInternal(final ITableRow row) throws ProcessingException {
        AbstractMixedSmartField f = new AbstractMixedSmartField<VALUE_TYPE, LOOKUP_CALL_KEY_TYPE>(){

            @Override
            protected void initConfig() {
                super.initConfig();
                this.propertySupport.putPropertiesMap(AbstractMixedSmartColumn.this.propertySupport.getPropertiesMap());
            }

            @Override
            public Class<VALUE_TYPE> getHolderType() {
                return AbstractMixedSmartColumn.this.getDataType();
            }

            @Override
            protected void execPrepareLookup(ILookupCall<LOOKUP_CALL_KEY_TYPE> call) throws ProcessingException {
                AbstractMixedSmartColumn.this.interceptPrepareLookup(call, row);
            }

            @Override
            protected LOOKUP_CALL_KEY_TYPE execConvertValueToKey(VALUE_TYPE value) {
                return AbstractMixedSmartColumn.this.interceptConvertValueToKey(value);
            }

            @Override
            protected VALUE_TYPE execConvertKeyToValue(LOOKUP_CALL_KEY_TYPE key) {
                return AbstractMixedSmartColumn.this.interceptConvertKeyToValue(key);
            }

            @Override
            protected void injectMenusInternal(OrderedCollection<IMenu> menus) {
                Class[] menuCandidates = ConfigurationUtility.getDeclaredPublicClasses(AbstractMixedSmartColumn.this.getClass());
                List menuClazzes = ConfigurationUtility.filterClasses((Class[])menuCandidates, IMenu.class);
                for (Class menuClazz : menuClazzes) {
                    try {
                        menus.addOrdered((IOrdered)((IMenu)ConfigurationUtility.newInnerInstance((Object)AbstractMixedSmartColumn.this, (Class)menuClazz)));
                    }
                    catch (Exception e) {
                        ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException(this.getClass().getSimpleName(), (Throwable)e));
                    }
                }
                List contributedMenus = AbstractMixedSmartColumn.this.m_contributionHolder.getContributionsByClass(IMenu.class);
                menus.addAllOrdered((Collection)contributedMenus);
            }
        };
        f.setCodeTypeClass(this.getCodeTypeClass());
        f.setLookupCall(this.getLookupCall());
        f.setBrowseHierarchy(this.getConfiguredBrowseHierarchy());
        f.setBrowseMaxRowCount(this.getConfiguredBrowseMaxRowCount());
        f.setBrowseNewText(this.getConfiguredBrowseNewText());
        f.setActiveFilterEnabled(this.getConfiguredActiveFilterEnabled());
        f.setBrowseAutoExpandAll(this.getConfiguredBrowseAutoExpandAll());
        f.setBrowseLoadIncremental(this.getConfiguredBrowseLoadIncremental());
        return f;
    }

    @Override
    public int compareTableRows(ITableRow r1, ITableRow r2) {
        ILookupCall call;
        ICodeType codeType = this.getCodeTypeClass() != null ? CODES.getCodeType(this.getCodeTypeClass()) : null;
        ILookupCall iLookupCall = call = this.getLookupCall() != null ? this.getLookupCall() : null;
        if (codeType != null) {
            if (this.isSortCodesByDisplayText()) {
                String s1 = this.getDisplayText(r1);
                String s2 = this.getDisplayText(r2);
                return StringUtility.compareIgnoreCase((String)s1, (String)s2);
            }
            Object t1 = this.interceptConvertValueToKey(this.getValue(r1));
            Object t2 = this.interceptConvertValueToKey(this.getValue(r2));
            Integer sort1 = t1 != null ? codeType.getCodeIndex(t1) : -1;
            Integer sort2 = t2 != null ? codeType.getCodeIndex(t2) : -1;
            int c = sort1.compareTo(sort2);
            return c;
        }
        if (call != null) {
            String s1 = this.getDisplayText(r1);
            String s2 = this.getDisplayText(r2);
            return StringUtility.compareIgnoreCase((String)s1, (String)s2);
        }
        return super.compareTableRows(r1, r2);
    }

    protected final VALUE_TYPE interceptConvertKeyToValue(LOOKUP_CALL_KEY_TYPE key) {
        List extensions = this.getAllExtensions();
        MixedSmartColumnChains.MixedSmartColumnConvertKeyToValueChain chain = new MixedSmartColumnChains.MixedSmartColumnConvertKeyToValueChain(extensions);
        return (VALUE_TYPE)chain.execConvertKeyToValue(key);
    }

    @Override
    protected IMixedSmartColumnExtension<VALUE_TYPE, LOOKUP_CALL_KEY_TYPE, ? extends AbstractMixedSmartColumn<VALUE_TYPE, LOOKUP_CALL_KEY_TYPE>> createLocalExtension() {
        return new LocalMixedSmartColumnExtension(this);
    }

    protected static class LocalMixedSmartColumnExtension<VALUE_TYPE, LOOKUP_CALL_KEY_TYPE, OWNER extends AbstractMixedSmartColumn<VALUE_TYPE, LOOKUP_CALL_KEY_TYPE>>
    extends AbstractContentAssistColumn.LocalContentAssistColumnExtension<VALUE_TYPE, LOOKUP_CALL_KEY_TYPE, OWNER>
    implements IMixedSmartColumnExtension<VALUE_TYPE, LOOKUP_CALL_KEY_TYPE, OWNER> {
        public LocalMixedSmartColumnExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public VALUE_TYPE execConvertKeyToValue(MixedSmartColumnChains.MixedSmartColumnConvertKeyToValueChain<VALUE_TYPE, LOOKUP_CALL_KEY_TYPE> chain, LOOKUP_CALL_KEY_TYPE key) {
            return ((AbstractMixedSmartColumn)this.getOwner()).execConvertKeyToValue(key);
        }
    }
}

