/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table.customizer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.security.Permission;
import java.util.Set;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ui.action.menu.AbstractMenu;
import org.eclipse.scout.rt.client.ui.action.menu.IMenuType;
import org.eclipse.scout.rt.client.ui.action.menu.TableMenuType;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.security.CreateCustomColumnPermission;

public class AddCustomColumnMenu
extends AbstractMenu {
    private final ITable m_table;

    public AddCustomColumnMenu(ITable table) {
        this.m_table = table;
    }

    @Override
    protected String getConfiguredText() {
        return ScoutTexts.get((String)"AddCustomColumnMenu", (String[])new String[0]);
    }

    protected Set<IMenuType> getConfiguredMenuTypes() {
        return CollectionUtility.hashSet((Object)TableMenuType.Header);
    }

    @Override
    protected void execInitAction() throws ProcessingException {
        this.setVisiblePermission((Permission)new CreateCustomColumnPermission());
        this.m_table.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("tableCustomizer".equals(evt.getPropertyName())) {
                    AddCustomColumnMenu.this.updateVisibility();
                }
            }
        });
        this.updateVisibility();
    }

    private void updateVisibility() {
        this.setVisible(this.m_table.getTableCustomizer() != null);
    }

    @Override
    protected void execAction() throws ProcessingException {
        if (this.m_table != null && this.m_table.getTableCustomizer() != null) {
            this.m_table.getTableCustomizer().addColumn();
        }
    }
}

