/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.tree;

import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.IOrdered;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.annotations.OrderedCollection;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.extension.ui.action.tree.MoveActionNodesHandler;
import org.eclipse.scout.rt.client.extension.ui.basic.tree.ITreeNodeExtension;
import org.eclipse.scout.rt.client.extension.ui.basic.tree.TreeNodeChains;
import org.eclipse.scout.rt.client.ui.action.ActionFinder;
import org.eclipse.scout.rt.client.ui.action.ActionUtility;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.cell.ICell;
import org.eclipse.scout.rt.client.ui.basic.cell.ICellObserver;
import org.eclipse.scout.rt.client.ui.basic.tree.ITree;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.IVirtualTreeNode;
import org.eclipse.scout.rt.client.ui.profiler.DesktopProfiler;
import org.eclipse.scout.rt.shared.extension.AbstractExtension;
import org.eclipse.scout.rt.shared.extension.ContributionComposite;
import org.eclipse.scout.rt.shared.extension.IContributionOwner;
import org.eclipse.scout.rt.shared.extension.IExtensibleObject;
import org.eclipse.scout.rt.shared.extension.IExtension;
import org.eclipse.scout.rt.shared.extension.ObjectExtensions;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.rt.shared.services.common.security.IAccessControlService;
import org.eclipse.scout.service.SERVICES;

public abstract class AbstractTreeNode
implements ITreeNode,
ICellObserver,
IContributionOwner,
IExtensibleObject {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractTreeNode.class);
    private boolean m_initialized;
    private ITree m_tree;
    private ITreeNode m_parentNode;
    private final Object m_childNodeListLock;
    private List<ITreeNode> m_childNodeList;
    private final Object m_filteredChildNodesLock;
    private List<ITreeNode> m_filteredChildNodes;
    private int m_status;
    private final Cell m_cell;
    private List<IMenu> m_menus;
    private int m_childNodeIndex;
    private boolean m_childrenLoaded;
    private final OptimisticLock m_childrenLoadedLock = new OptimisticLock();
    private boolean m_leaf;
    private boolean m_checked;
    private boolean m_defaultExpanded;
    private boolean m_expanded;
    private boolean m_childrenVolatile;
    private boolean m_childrenDirty;
    private boolean m_filterAccepted;
    private Object m_primaryKey;
    private boolean m_enabledGranted;
    private boolean m_enabledProperty;
    private boolean m_visible;
    private boolean m_visibleGranted;
    private boolean m_visibleProperty;
    protected IContributionOwner m_contributionHolder;
    private Integer m_hashCode = null;
    private final ObjectExtensions<AbstractTreeNode, ITreeNodeExtension<? extends AbstractTreeNode>> m_objectExtensions;

    public AbstractTreeNode() {
        this(true);
    }

    public AbstractTreeNode(boolean callInitializer) {
        if (DesktopProfiler.getInstance().isEnabled()) {
            DesktopProfiler.getInstance().registerTreeNode(this);
        }
        this.m_filterAccepted = true;
        this.m_visibleGranted = true;
        this.m_visibleProperty = true;
        this.calculateVisible();
        this.m_enabledGranted = true;
        this.m_childNodeListLock = new Object();
        this.m_childNodeList = new ArrayList<ITreeNode>(0);
        this.m_filteredChildNodesLock = new Object();
        this.m_cell = new Cell(this);
        this.m_objectExtensions = new ObjectExtensions((Object)this);
        if (callInitializer) {
            this.callInitializer();
        }
    }

    protected void callInitializer() {
        if (!this.m_initialized) {
            this.interceptInitConfig();
            this.initTreeNode();
            this.m_initialized = true;
        }
    }

    public final List<Object> getAllContributions() {
        return this.m_contributionHolder.getAllContributions();
    }

    public final <T> List<T> getContributionsByClass(Class<T> type) {
        return this.m_contributionHolder.getContributionsByClass(type);
    }

    public final <T> T getContribution(Class<T> contribution) {
        return (T)this.m_contributionHolder.getContribution(contribution);
    }

    protected void ensureInitialized() {
        if (!this.m_initialized) {
            this.callInitializer();
        }
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=20.0)
    protected boolean getConfiguredLeaf() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=30.0)
    protected boolean getConfiguredExpanded() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=10.0)
    protected boolean getConfiguredEnabled() {
        return true;
    }

    @ConfigOperation
    @Order(value=20.0)
    protected void execInitTreeNode() {
    }

    @ConfigOperation
    @Order(value=10.0)
    protected void execDecorateCell(Cell cell) {
    }

    @ConfigOperation
    @Order(value=30.0)
    protected ITreeNode execResolveVirtualChildNode(IVirtualTreeNode node) throws ProcessingException {
        return node;
    }

    protected List<Class<? extends IMenu>> getDeclaredMenus() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        List filtered = ConfigurationUtility.filterClasses((Class[])dca, IMenu.class);
        return ConfigurationUtility.removeReplacedClasses((List)filtered);
    }

    protected final void interceptInitConfig() {
        this.m_objectExtensions.initConfig(this.createLocalExtension(), new Runnable(){

            @Override
            public void run() {
                AbstractTreeNode.this.initConfig();
            }
        });
    }

    protected void initConfig() {
        this.setLeafInternal(this.getConfiguredLeaf());
        this.setEnabledInternal(this.getConfiguredEnabled());
        this.setExpandedInternal(this.getConfiguredExpanded());
        this.m_defaultExpanded = this.getConfiguredExpanded();
        this.m_contributionHolder = new ContributionComposite((Object)this);
        List<Class<? extends IMenu>> declaredMenus = this.getDeclaredMenus();
        List contributedMenus = this.m_contributionHolder.getContributionsByClass(IMenu.class);
        OrderedCollection menus = new OrderedCollection();
        for (Class<? extends IMenu> menuClazz : declaredMenus) {
            try {
                IMenu menu = (IMenu)ConfigurationUtility.newInnerInstance((Object)this, menuClazz);
                menus.addOrdered((IOrdered)menu);
            }
            catch (Exception e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("error creating instance of class '" + menuClazz.getName() + "'.", (Throwable)e));
            }
        }
        try {
            this.injectMenusInternal((OrderedCollection<IMenu>)menus);
        }
        catch (Exception e) {
            LOG.error("error occured while dynamically contribute menus.", (Throwable)e);
        }
        menus.addAllOrdered((Collection)contributedMenus);
        new MoveActionNodesHandler(menus).moveModelObjects();
        this.m_menus = menus.getOrderedList();
    }

    public final List<? extends ITreeNodeExtension<? extends AbstractTreeNode>> getAllExtensions() {
        return this.m_objectExtensions.getAllExtensions();
    }

    protected ITreeNodeExtension<? extends AbstractTreeNode> createLocalExtension() {
        return new LocalTreeNodeExtension<AbstractTreeNode>(this);
    }

    public <T extends IExtension<?>> T getExtension(Class<T> c) {
        return (T)this.m_objectExtensions.getExtension(c);
    }

    protected void injectMenusInternal(OrderedCollection<IMenu> menus) {
    }

    public int hashCode() {
        if (this.m_hashCode != null) {
            return this.m_hashCode;
        }
        return super.hashCode();
    }

    void setHashCode(int hashCode) {
        if (this.m_hashCode != null) {
            LOG.warn("Overriding the hash code of an object will lead to inconsistent behavior of hash maps etc. setHashCode() must not be called more than once.");
        }
        this.m_hashCode = hashCode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IVirtualTreeNode && ((IVirtualTreeNode)obj).getResolvedNode() == this) {
            return true;
        }
        return super.equals(obj);
    }

    @Override
    public void initTreeNode() {
        try {
            ActionUtility.initActions(this.getMenus());
        }
        catch (ProcessingException e) {
            LOG.error("could not initialize actions.", (Throwable)e);
        }
        this.interceptInitTreeNode();
    }

    @Override
    public String getNodeId() {
        String s = this.getClass().getName();
        int i = Math.max(s.lastIndexOf(36), s.lastIndexOf(46));
        s = s.substring(i + 1);
        return s;
    }

    @Override
    public int getStatus() {
        return this.m_status;
    }

    @Override
    public void setStatusInternal(int status) {
        this.m_status = status;
    }

    @Override
    public void setStatus(int status) {
        if (this.getTree() != null) {
            this.getTree().setNodeStatus(this, status);
        } else {
            this.setStatusInternal(status);
        }
    }

    @Override
    public boolean isStatusInserted() {
        return this.m_status == 1;
    }

    @Override
    public boolean isStatusUpdated() {
        return this.m_status == 2;
    }

    @Override
    public boolean isStatusDeleted() {
        return this.m_status == 3;
    }

    @Override
    public boolean isStatusNonchanged() {
        return this.m_status == 0;
    }

    @Override
    public boolean isSelectedNode() {
        if (this.getTree() != null) {
            return this.getTree().isSelectedNode(this);
        }
        return false;
    }

    @Override
    public boolean isFilterAccepted() {
        return this.m_filterAccepted;
    }

    @Override
    public void setFilterAccepted(boolean b) {
        if (this.m_filterAccepted != b) {
            this.m_filterAccepted = b;
            if (this.getParentNode() != null) {
                this.getParentNode().resetFilterCache();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetFilterCache() {
        Object object = this.m_filteredChildNodesLock;
        synchronized (object) {
            this.m_filteredChildNodes = null;
        }
    }

    @Override
    public ITreeNode resolveVirtualChildNode(ITreeNode node) throws ProcessingException {
        if (this.m_tree != null && node instanceof IVirtualTreeNode && node.getTree() == this.m_tree && node.getParentNode() == this) {
            try {
                this.m_tree.setTreeChanging(true);
                ITreeNode resolvedNode = this.interceptResolveVirtualChildNode((IVirtualTreeNode)node);
                if (node != resolvedNode) {
                    if (resolvedNode == null) {
                        this.m_tree.removeChildNode(this, node);
                    } else {
                        this.replaceChildNodeInternal(node.getChildNodeIndex(), resolvedNode);
                        this.m_tree.updateNode(resolvedNode);
                    }
                    ITreeNode iTreeNode = resolvedNode;
                    return iTreeNode;
                }
            }
            finally {
                this.m_tree.setTreeChanging(false);
            }
        }
        return node;
    }

    @Override
    public final ICell getCell() {
        return this.m_cell;
    }

    @Override
    public final Cell getCellForUpdate() {
        return this.m_cell;
    }

    @Override
    public final void decorateCell() {
        try {
            this.interceptDecorateCell(this.m_cell);
        }
        catch (Throwable t) {
            LOG.warn("node " + this.getClass() + " " + this.getCell().getText(), t);
        }
    }

    @Override
    public boolean isLeaf() {
        return this.m_leaf;
    }

    @Override
    public void setLeafInternal(boolean b) {
        this.m_leaf = b;
    }

    @Override
    public void setLeaf(boolean b) {
        if (this.getTree() != null) {
            this.getTree().setNodeLeaf(this, b);
        } else {
            this.setLeafInternal(b);
        }
    }

    @Override
    public boolean isChecked() {
        return this.m_checked;
    }

    @Override
    public void setCheckedInternal(boolean b) {
        this.m_checked = b;
    }

    @Override
    public void setChecked(boolean b) {
        if (this.getTree() != null) {
            this.getTree().setNodeChecked(this, b);
        } else {
            this.setCheckedInternal(b);
        }
    }

    @Override
    public boolean isExpanded() {
        return this.m_expanded;
    }

    @Override
    public void setExpandedInternal(boolean b) {
        this.m_expanded = b;
    }

    @Override
    public boolean isInitialExpanded() {
        return this.m_defaultExpanded;
    }

    @Override
    public void setInitialExpanded(boolean b) {
        this.m_defaultExpanded = b;
    }

    @Override
    public void setExpanded(boolean b) {
        if (this.getTree() != null) {
            this.getTree().setNodeExpanded(this, b);
        } else {
            this.setExpandedInternal(b);
        }
    }

    @Override
    public void setVisiblePermissionInternal(Permission p) {
        boolean b = p != null ? ((IAccessControlService)SERVICES.getService(IAccessControlService.class)).checkPermission(p) : true;
        this.setVisibleGrantedInternal(b);
    }

    @Override
    public boolean isVisible() {
        return this.m_visible;
    }

    @Override
    public boolean isVisibleGranted() {
        return this.m_visibleGranted;
    }

    @Override
    public void setVisibleInternal(boolean b) {
        this.m_visibleProperty = b;
        this.calculateVisible();
    }

    @Override
    public void setVisibleGrantedInternal(boolean b) {
        this.m_visibleGranted = b;
        this.calculateVisible();
    }

    private void calculateVisible() {
        this.m_visible = this.m_visibleGranted && this.m_visibleProperty;
    }

    @Override
    public void setVisiblePermission(Permission p) {
        if (this.getTree() != null) {
            this.getTree().setNodeVisiblePermission(this, p);
        } else {
            this.setVisiblePermissionInternal(p);
        }
    }

    @Override
    public void setVisible(boolean b) {
        if (this.getTree() != null) {
            this.getTree().setNodeVisible(this, b);
        } else {
            this.setVisibleInternal(b);
        }
    }

    @Override
    public void setVisibleGranted(boolean b) {
        if (this.getTree() != null) {
            this.getTree().setNodeVisibleGranted(this, b);
        } else {
            this.setVisibleGrantedInternal(b);
        }
    }

    @Override
    public void setEnabledPermissionInternal(Permission p) {
        boolean b = p != null ? ((IAccessControlService)SERVICES.getService(IAccessControlService.class)).checkPermission(p) : true;
        this.setEnabledGrantedInternal(b);
    }

    @Override
    public boolean isEnabled() {
        return this.m_cell.isEnabled();
    }

    @Override
    public boolean isEnabledGranted() {
        return this.m_enabledGranted;
    }

    @Override
    public void setEnabledInternal(boolean b) {
        this.m_enabledProperty = b;
        this.calculateEnabled();
    }

    @Override
    public void setEnabledGrantedInternal(boolean b) {
        this.m_enabledGranted = b;
        this.calculateEnabled();
    }

    private void calculateEnabled() {
        this.m_cell.setEnabled(this.m_enabledGranted && this.m_enabledProperty);
    }

    @Override
    public void setEnabledPermission(Permission p) {
        if (this.getTree() != null) {
            this.getTree().setNodeEnabledPermission(this, p);
        } else {
            this.setEnabledPermissionInternal(p);
        }
    }

    @Override
    public void setEnabled(boolean b) {
        if (this.getTree() != null) {
            this.getTree().setNodeEnabled(this, b);
        } else {
            this.setEnabledInternal(b);
        }
    }

    @Override
    public void setEnabledGranted(boolean b) {
        if (this.getTree() != null) {
            this.getTree().setNodeEnabledGranted(this, b);
        } else {
            this.setEnabledGrantedInternal(b);
        }
    }

    @Override
    public boolean isChildrenVolatile() {
        return this.m_childrenVolatile;
    }

    @Override
    public void setChildrenVolatile(boolean childrenVolatile) {
        this.m_childrenVolatile = childrenVolatile;
    }

    @Override
    public boolean isChildrenDirty() {
        return this.m_childrenDirty;
    }

    @Override
    public void setChildrenDirty(boolean dirty) {
        this.m_childrenDirty = dirty;
    }

    @Override
    public Object getPrimaryKey() {
        return this.m_primaryKey;
    }

    @Override
    public void setPrimaryKey(Object key) {
        this.m_primaryKey = key;
    }

    @Override
    public List<IMenu> getMenus() {
        return this.m_menus;
    }

    @Override
    public <T extends IMenu> T getMenu(Class<T> menuType) throws ProcessingException {
        return (T)((IMenu)new ActionFinder().findAction(this.getMenus(), menuType));
    }

    @Override
    public void setMenus(List<? extends IMenu> menus) {
        this.m_menus = CollectionUtility.arrayListWithoutNullElements(menus);
    }

    @Override
    public ITreeNode getParentNode() {
        return this.m_parentNode;
    }

    @Override
    public <T extends ITreeNode> T getParentNode(Class<T> type) {
        ITreeNode node = this.getParentNode();
        if (node != null && type.isAssignableFrom(node.getClass())) {
            return (T)node;
        }
        return null;
    }

    @Override
    public <T extends ITreeNode> T getParentNode(Class<T> type, int backCount) {
        ITreeNode node = this;
        while (node != null && backCount > 0) {
            node = node.getParentNode();
            --backCount;
        }
        if (backCount == 0 && node != null && type.isAssignableFrom(node.getClass())) {
            return (T)node;
        }
        return null;
    }

    @Override
    public <T extends ITreeNode> T getAncestorNode(Class<T> type) {
        ITreeNode node = this.getParentNode();
        while (node != null && !type.isAssignableFrom(node.getClass())) {
            node = node.getParentNode();
        }
        return (T)node;
    }

    @Override
    public void setParentNodeInternal(ITreeNode parent) {
        this.m_parentNode = parent;
    }

    @Override
    public int getChildNodeCount() {
        return this.m_childNodeList.size();
    }

    @Override
    public int getChildNodeIndex() {
        return this.m_childNodeIndex;
    }

    @Override
    public void setChildNodeIndexInternal(int index) {
        this.m_childNodeIndex = index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ITreeNode> getFilteredChildNodes() {
        if (this.m_filteredChildNodes == null) {
            Object object = this.m_filteredChildNodesLock;
            synchronized (object) {
                if (this.m_filteredChildNodes == null) {
                    Object object2 = this.m_childNodeListLock;
                    synchronized (object2) {
                        ArrayList<ITreeNode> list = new ArrayList<ITreeNode>(this.m_childNodeList.size());
                        for (ITreeNode node : this.m_childNodeList) {
                            if (!node.isFilterAccepted()) continue;
                            list.add(node);
                        }
                        this.m_filteredChildNodes = list;
                    }
                }
            }
        }
        return CollectionUtility.arrayList(this.m_filteredChildNodes);
    }

    @Override
    public int getTreeLevel() {
        int level = 0;
        ITreeNode parent = this.getParentNode();
        while (parent != null) {
            ++level;
            parent = parent.getParentNode();
        }
        return level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ITreeNode getChildNode(int childIndex) {
        Object object = this.m_childNodeListLock;
        synchronized (object) {
            if (childIndex >= 0 && childIndex < this.m_childNodeList.size()) {
                return this.m_childNodeList.get(childIndex);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ITreeNode> getChildNodes() {
        Object object = this.m_childNodeListLock;
        synchronized (object) {
            return CollectionUtility.arrayList(this.m_childNodeList);
        }
    }

    @Override
    public ITreeNode findParentNode(Class<?> interfaceType) {
        ITreeNode test = this.getParentNode();
        while (test != null) {
            if (interfaceType.isInstance(test)) break;
            test = test.getParentNode();
        }
        return test;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setChildNodeOrderInternal(List<ITreeNode> nodes) {
        Object object = this.m_childNodeListLock;
        synchronized (object) {
            ArrayList<ITreeNode> newList = new ArrayList<ITreeNode>(this.m_childNodeList.size());
            int index = 0;
            for (ITreeNode n : nodes) {
                n.setChildNodeIndexInternal(index);
                newList.add(n);
                ++index;
            }
            this.m_childNodeList = newList;
        }
        this.resetFilterCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChildNodesInternal(int startIndex, List<? extends ITreeNode> nodes, boolean includeSubtree) {
        for (ITreeNode iTreeNode : nodes) {
            iTreeNode.setTreeInternal(this.m_tree, true);
            iTreeNode.setParentNodeInternal(this);
        }
        Object object = this.m_childNodeListLock;
        synchronized (object) {
            this.m_childNodeList.addAll(startIndex, nodes);
            int endIndex = this.m_childNodeList.size() - 1;
            int i = startIndex;
            while (i <= endIndex) {
                this.m_childNodeList.get(i).setChildNodeIndexInternal(i);
                ++i;
            }
        }
        for (ITreeNode iTreeNode : nodes) {
            this.postProcessAddRec(iTreeNode, includeSubtree);
        }
        this.resetFilterCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChildNodesInternal(Collection<? extends ITreeNode> nodes, boolean includeSubtree) {
        ArrayList<ITreeNode> removedNodes = new ArrayList<ITreeNode>();
        Object object = this.m_childNodeListLock;
        synchronized (object) {
            for (ITreeNode iTreeNode : nodes) {
                if (this.m_childNodeList.remove(iTreeNode)) {
                    removedNodes.add(iTreeNode);
                }
                iTreeNode.setTreeInternal(null, true);
                iTreeNode.setParentNodeInternal(null);
            }
            int n = 0;
            int endIndex = this.m_childNodeList.size() - 1;
            int i = n;
            while (i <= endIndex) {
                this.m_childNodeList.get(i).setChildNodeIndexInternal(i);
                ++i;
            }
        }
        for (ITreeNode removedNode : removedNodes) {
            this.postProcessRemoveRec(removedNode, this.getTree(), includeSubtree);
        }
        this.resetFilterCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void replaceChildNodeInternal(int index, ITreeNode newNode) {
        ITreeNode oldNode;
        Object object = this.m_childNodeListLock;
        synchronized (object) {
            oldNode = this.m_childNodeList.get(index);
            oldNode.setTreeInternal(null, true);
            oldNode.setParentNodeInternal(null);
            this.m_childNodeList.set(index, newNode);
            newNode.setTreeInternal(this.m_tree, true);
            newNode.setParentNodeInternal(this);
            this.m_childNodeList.get(index).setChildNodeIndexInternal(index);
        }
        this.postProcessRemoveRec(oldNode, this.m_tree, true);
        this.postProcessAddRec(newNode, true);
        this.resetFilterCache();
    }

    private void postProcessAddRec(ITreeNode node, boolean includeSubtree) {
        if (node.getTree() != null) {
            try {
                node.nodeAddedNotify();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            if (!node.isVisible()) {
                if (node instanceof AbstractTreeNode) {
                    ((AbstractTreeNode)node.getParentNode()).removeChildNodesInternal(CollectionUtility.arrayList((Object)node), false);
                }
                return;
            }
        }
        if (node.isChildrenLoaded()) {
            node.setLeafInternal(node.getChildNodeCount() == 0);
        }
        if (includeSubtree) {
            for (ITreeNode ch : node.getChildNodes()) {
                if (ch != node) {
                    this.postProcessAddRec(ch, includeSubtree);
                    continue;
                }
                LOG.warn("The node " + node + " is child of itself!");
            }
        }
    }

    @Override
    public void nodeAddedNotify() {
    }

    @Override
    public void nodeRemovedNotify() {
    }

    private void postProcessRemoveRec(ITreeNode node, ITree formerTree, boolean includeSubtree) {
        if (includeSubtree) {
            for (ITreeNode ch : node.getChildNodes()) {
                this.postProcessRemoveRec(ch, formerTree, includeSubtree);
            }
        }
        if (formerTree != null) {
            try {
                node.nodeRemovedNotify();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    @Override
    public boolean isChildrenLoaded() {
        return this.m_childrenLoaded;
    }

    @Override
    public void setChildrenLoaded(boolean b) {
        this.m_childrenLoaded = b;
    }

    @Override
    public final void ensureChildrenLoaded() throws ProcessingException {
        if (!this.isChildrenLoaded()) {
            try {
                if (this.m_childrenLoadedLock.acquire()) {
                    this.loadChildren();
                }
            }
            finally {
                this.m_childrenLoadedLock.release();
            }
        }
    }

    @Override
    public ITree getTree() {
        return this.m_tree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTreeInternal(ITree tree, boolean includeSubtree) {
        this.m_tree = tree;
        if (includeSubtree) {
            Object object = this.m_childNodeListLock;
            synchronized (object) {
                Iterator<ITreeNode> it = this.m_childNodeList.iterator();
                while (it.hasNext()) {
                    it.next().setTreeInternal(tree, includeSubtree);
                }
            }
        }
    }

    @Override
    public void loadChildren() throws ProcessingException {
    }

    @Override
    public void update() {
        this.getTree().updateNode(this);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + this.getCell() + "]";
    }

    @Override
    public void cellChanged(ICell cell, int changedBit) {
        if (this.getTree() != null) {
            this.getTree().fireNodeChanged(this);
        }
    }

    @Override
    public Object validateValue(ICell cell, Object value) throws ProcessingException {
        return value;
    }

    protected final void interceptDecorateCell(Cell cell) {
        List<? extends ITreeNodeExtension<? extends AbstractTreeNode>> extensions = this.getAllExtensions();
        TreeNodeChains.TreeNodeDecorateCellChain chain = new TreeNodeChains.TreeNodeDecorateCellChain(extensions);
        chain.execDecorateCell(cell);
    }

    protected final void interceptInitTreeNode() {
        List<? extends ITreeNodeExtension<? extends AbstractTreeNode>> extensions = this.getAllExtensions();
        TreeNodeChains.TreeNodeInitTreeNodeChain chain = new TreeNodeChains.TreeNodeInitTreeNodeChain(extensions);
        chain.execInitTreeNode();
    }

    protected final ITreeNode interceptResolveVirtualChildNode(IVirtualTreeNode node) throws ProcessingException {
        List<? extends ITreeNodeExtension<? extends AbstractTreeNode>> extensions = this.getAllExtensions();
        TreeNodeChains.TreeNodeResolveVirtualChildNodeChain chain = new TreeNodeChains.TreeNodeResolveVirtualChildNodeChain(extensions);
        return chain.execResolveVirtualChildNode(node);
    }

    protected static class LocalTreeNodeExtension<OWNER extends AbstractTreeNode>
    extends AbstractExtension<OWNER>
    implements ITreeNodeExtension<OWNER> {
        public LocalTreeNodeExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public void execDecorateCell(TreeNodeChains.TreeNodeDecorateCellChain chain, Cell cell) {
            ((AbstractTreeNode)this.getOwner()).execDecorateCell(cell);
        }

        @Override
        public void execInitTreeNode(TreeNodeChains.TreeNodeInitTreeNodeChain chain) {
            ((AbstractTreeNode)this.getOwner()).execInitTreeNode();
        }

        @Override
        public ITreeNode execResolveVirtualChildNode(TreeNodeChains.TreeNodeResolveVirtualChildNodeChain chain, IVirtualTreeNode node) throws ProcessingException {
            return ((AbstractTreeNode)this.getOwner()).execResolveVirtualChildNode(node);
        }
    }
}

