/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.tree;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;

public final class TreeUtility {
    private TreeUtility() {
    }

    public static ITreeNode calculateCommonParentNode(Collection<? extends ITreeNode> nodes) {
        if (!CollectionUtility.hasElements(nodes)) {
            return null;
        }
        if (nodes.size() == 1) {
            return ((ITreeNode)CollectionUtility.firstElement(nodes)).getParentNode();
        }
        Iterator<? extends ITreeNode> nodeIt = nodes.iterator();
        ITreeNode test = nodeIt.next().getParentNode();
        while (nodeIt.hasNext()) {
            if (nodeIt.next().getParentNode() == test) continue;
            test = null;
            break;
        }
        return test;
    }

    public static ITreeNode findLowestCommonAncestorNode(List<ITreeNode> nodes) {
        if (nodes == null || nodes.size() == 0) {
            return null;
        }
        if (nodes.size() == 1) {
            return nodes.get(0).getParentNode();
        }
        ITreeNode commonParent = nodes.get(0).getParentNode();
        int i = 1;
        while (i < nodes.size()) {
            ITreeNode parentNode = nodes.get(i).getParentNode();
            if (parentNode != commonParent) {
                commonParent = TreeUtility.findLowestCommonAncestorNode(commonParent, parentNode);
            }
            ++i;
        }
        return commonParent;
    }

    public static ITreeNode findLowestCommonAncestorNode(ITreeNode firstNode, ITreeNode secondNode) {
        if (firstNode == null || secondNode == null) {
            return null;
        }
        if (firstNode.getTree() != secondNode.getTree()) {
            return null;
        }
        if (firstNode.getParentNode() == secondNode.getParentNode()) {
            return firstNode.getParentNode();
        }
        if (secondNode.getTreeLevel() > firstNode.getTreeLevel()) {
            secondNode = TreeUtility.findAncestorNodeAtLevel(secondNode, firstNode.getTreeLevel());
        } else if (firstNode.getTreeLevel() > secondNode.getTreeLevel()) {
            firstNode = TreeUtility.findAncestorNodeAtLevel(firstNode, secondNode.getTreeLevel());
        }
        while (firstNode.getParentNode() != secondNode.getParentNode()) {
            firstNode = firstNode.getParentNode();
            secondNode = secondNode.getParentNode();
        }
        return firstNode.getParentNode();
    }

    /*
     * Unable to fully structure code
     */
    public static ITreeNode findAncestorNodeAtLevel(ITreeNode node, int level) {
        if (node == null) {
            return null;
        }
        if (node.getTreeLevel() >= level) ** GOTO lbl6
        return null;
lbl-1000:
        // 1 sources

        {
            node = node.getParentNode();
lbl6:
            // 2 sources

            ** while (node.getTreeLevel() > level)
        }
lbl7:
        // 1 sources

        return node;
    }
}

