/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop.outline;

import java.util.List;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.extension.ui.action.IActionExtension;
import org.eclipse.scout.rt.client.extension.ui.desktop.outline.FormToolButtonChains;
import org.eclipse.scout.rt.client.extension.ui.desktop.outline.IFormToolButtonExtension;
import org.eclipse.scout.rt.client.ui.action.AbstractAction;
import org.eclipse.scout.rt.client.ui.action.tool.AbstractToolButton;
import org.eclipse.scout.rt.client.ui.action.tool.IToolButton;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.outline.IFormToolButton;
import org.eclipse.scout.rt.client.ui.form.IForm;

public abstract class AbstractFormToolButton<FORM extends IForm>
extends AbstractToolButton
implements IFormToolButton<FORM> {
    private FORM m_form;
    private boolean m_previousSelectionState = false;

    @Override
    protected boolean getConfiguredToggleAction() {
        return true;
    }

    @Override
    public final FORM getForm() {
        return this.m_form;
    }

    @Override
    public final void setForm(FORM f) {
        this.setForm(f, false);
    }

    @Override
    public final void setForm(FORM f, boolean force) {
        if (force || f != this.m_form) {
            if (f != null) {
                this.decorateForm(f);
            }
            FORM oldForm = this.m_form;
            this.m_form = f;
            IDesktop desktop = ClientSyncJob.getCurrentSession().getDesktop();
            if (desktop != null) {
                if (this.m_form == null) {
                    desktop.removeForm((IForm)oldForm);
                    this.m_previousSelectionState = this.isSelected();
                    this.setSelected(false);
                    this.setEnabled(false);
                } else {
                    this.setEnabled(true);
                    if (!this.isSelected()) {
                        this.setSelected(this.m_previousSelectionState);
                    }
                    if (this.isSelected()) {
                        if (oldForm != null) {
                            desktop.removeForm((IForm)oldForm);
                        }
                        desktop.addForm((IForm)this.m_form);
                    }
                }
            }
        }
    }

    @ConfigOperation
    protected void execStartForm() throws ProcessingException {
    }

    @Override
    protected void execSelectionChanged(boolean selection) throws ProcessingException {
        IDesktop desktop = ClientSyncJob.getCurrentSession().getDesktop();
        if (desktop == null) {
            return;
        }
        if (selection) {
            if (this.isToggleAction()) {
                for (IToolButton b : desktop.getToolButtons()) {
                    if (b == this || !(b instanceof AbstractFormToolButton) || !b.isSelected()) continue;
                    b.setSelected(false);
                }
            }
            Object oldForm = this.getForm();
            this.interceptStartForm();
            if (oldForm == this.m_form && this.m_form != null) {
                this.m_previousSelectionState = true;
                desktop.addForm((IForm)this.m_form);
            }
        } else if (this.m_form != null) {
            this.m_previousSelectionState = false;
            desktop.removeForm((IForm)this.m_form);
        }
    }

    protected void decorateForm(FORM f) {
        f.setAutoAddRemoveOnDesktop(false);
        f.setDisplayHint(20);
        f.setDisplayViewId("E");
    }

    protected final void interceptStartForm() throws ProcessingException {
        List<? extends IActionExtension<? extends AbstractAction>> extensions = this.getAllExtensions();
        FormToolButtonChains.FormToolButtonStartFormChain chain = new FormToolButtonChains.FormToolButtonStartFormChain(extensions);
        chain.execStartForm();
    }

    @Override
    protected IFormToolButtonExtension<FORM, ? extends AbstractFormToolButton<FORM>> createLocalExtension() {
        return new LocalFormToolButtonExtension(this);
    }

    protected static class LocalFormToolButtonExtension<FORM extends IForm, OWNER extends AbstractFormToolButton<FORM>>
    extends AbstractToolButton.LocalToolButtonExtension<OWNER>
    implements IFormToolButtonExtension<FORM, OWNER> {
        public LocalFormToolButtonExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public void execStartForm(FormToolButtonChains.FormToolButtonStartFormChain<? extends IForm> chain) throws ProcessingException {
            ((AbstractFormToolButton)this.getOwner()).execStartForm();
        }
    }
}

