/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop.outline;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.scout.commons.annotations.ClassId;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.ui.desktop.DesktopEvent;
import org.eclipse.scout.rt.client.ui.desktop.DesktopListener;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutline;
import org.eclipse.scout.rt.client.ui.form.fields.button.AbstractButton;

@ClassId(value="b235fb65-6b50-4870-895a-f8a26ee41c96")
public abstract class AbstractOutlineButton
extends AbstractButton {
    private IOutline m_outline;

    public AbstractOutlineButton() {
        this(true);
    }

    public AbstractOutlineButton(boolean callInitializer) {
        super(callInitializer);
    }

    @Override
    protected int getConfiguredDisplayStyle() {
        return 1;
    }

    @Override
    protected boolean getConfiguredProcessButton() {
        return false;
    }

    @ConfigProperty(value="OUTLINE")
    protected Class<? extends IOutline> getConfiguredOutline() {
        return null;
    }

    @Override
    protected void execInitField() throws ProcessingException {
        IDesktop desktop = ClientSyncJob.getCurrentSession().getDesktop();
        for (IOutline o : desktop.getAvailableOutlines()) {
            if (o.getClass() != this.getConfiguredOutline()) continue;
            this.m_outline = o;
            break;
        }
        if (this.m_outline != null) {
            this.setVisible(this.m_outline.isVisible());
            this.setEnabled(this.m_outline.isEnabled());
            this.setLabel(this.m_outline.getTitle());
            this.setTooltipText(this.m_outline.getTitle());
            this.setIconId(this.m_outline.getIconId());
            this.setSelected(desktop.getOutline() == this.m_outline);
            desktop.addDesktopListener(new DesktopListener(){

                @Override
                public void desktopChanged(DesktopEvent e) {
                    switch (e.getType()) {
                        case 200: {
                            AbstractOutlineButton.this.setSelected(e.getOutline() == AbstractOutlineButton.this.m_outline);
                        }
                    }
                }
            });
            this.m_outline.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    String n = e.getPropertyName();
                    Object v = e.getNewValue();
                    if (n.equals("visible")) {
                        AbstractOutlineButton.this.setVisible((Boolean)v);
                    } else if (n.equals("enabled")) {
                        AbstractOutlineButton.this.setEnabled((Boolean)v);
                    } else if (n.equals("title")) {
                        AbstractOutlineButton.this.setLabel((String)v);
                    } else if (n.equals("iconId")) {
                        AbstractOutlineButton.this.setIconId((String)v);
                    }
                }
            });
        }
    }

    @Override
    protected final void execSelectionChanged(boolean selection) throws ProcessingException {
        IDesktop desktop;
        if (selection && (desktop = ClientSyncJob.getCurrentSession().getDesktop()) != null) {
            desktop.setOutline(this.m_outline);
        }
    }
}

