/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop.outline;

import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutline;
import org.eclipse.scout.rt.client.ui.desktop.outline.IPageChangeStrategy;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithNodes;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithTable;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.ISearchForm;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.service.SERVICES;

public class DefaultPageChangeStrategy
implements IPageChangeStrategy {
    @Override
    public void pageChanged(IOutline outline, IPage deselectedPage, IPage selectedPage) {
        if (outline == null) {
            return;
        }
        outline.clearContextPage();
        IForm detailForm = null;
        ITable detailTable = null;
        ISearchForm searchForm = null;
        outline.makeActivePageToContextPage();
        IPage activePage = outline.getActivePage();
        if (activePage != null) {
            try {
                activePage.ensureChildrenLoaded();
            }
            catch (ProcessingException e1) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e1);
            }
            if (activePage instanceof IPageWithTable) {
                IPageWithTable tablePage = (IPageWithTable)activePage;
                detailForm = activePage.getDetailForm();
                if (activePage.isTableVisible()) {
                    detailTable = (ITable)tablePage.getTable();
                }
                if (tablePage.isSearchActive()) {
                    searchForm = tablePage.getSearchFormInternal();
                }
            } else if (activePage instanceof IPageWithNodes) {
                IPageWithNodes nodePage = (IPageWithNodes)activePage;
                detailForm = activePage.getDetailForm();
                if (activePage.isTableVisible()) {
                    detailTable = nodePage.getTable();
                }
            }
        }
        if (detailForm == null) {
            outline.setDetailForm(null);
        }
        if (detailTable == null) {
            outline.setDetailTable(null);
        }
        if (searchForm == null) {
            outline.setSearchForm(null);
        }
        if (detailForm != null) {
            outline.setDetailForm(detailForm);
        }
        if (detailTable != null) {
            outline.setDetailTable(detailTable);
        }
        if (searchForm != null) {
            outline.setSearchForm(searchForm);
        }
    }
}

