/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop.outline.pages;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.IProcessingStatus;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.extension.ui.basic.tree.ITreeNodeExtension;
import org.eclipse.scout.rt.client.extension.ui.desktop.outline.pages.IPageWithNodesExtension;
import org.eclipse.scout.rt.client.extension.ui.desktop.outline.pages.PageWithNodesChains;
import org.eclipse.scout.rt.client.ui.action.ActionUtility;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.IMenuType;
import org.eclipse.scout.rt.client.ui.action.menu.TableMenuType;
import org.eclipse.scout.rt.client.ui.action.menu.TreeMenuType;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.cell.ICell;
import org.eclipse.scout.rt.client.ui.basic.table.AbstractTable;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.TableAdapter;
import org.eclipse.scout.rt.client.ui.basic.table.TableEvent;
import org.eclipse.scout.rt.client.ui.basic.table.TableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractStringColumn;
import org.eclipse.scout.rt.client.ui.basic.table.internal.TablePageTreeMenuWrapper;
import org.eclipse.scout.rt.client.ui.basic.tree.AbstractTreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.ITree;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.desktop.outline.OutlineMediator;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.AbstractPage;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithNodes;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithTable;
import org.eclipse.scout.rt.shared.ContextMap;
import org.eclipse.scout.rt.shared.ScoutTexts;

public abstract class AbstractPageWithNodes
extends AbstractPage
implements IPageWithNodes {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractPageWithNodes.class);
    private P_Table m_table;
    private final HashMap<ITableRow, IPage> m_tableRowToPageMap = new HashMap();
    private final HashMap<IPage, ITableRow> m_pageToTableRowMap = new HashMap();
    private List<? extends IMenu> m_pageMenusOfSelection;

    public AbstractPageWithNodes() {
        this(true, null, null);
    }

    public AbstractPageWithNodes(boolean callInitializer) {
        this(callInitializer, null, null);
    }

    @Deprecated
    public AbstractPageWithNodes(ContextMap contextMap) {
        this(true, contextMap, null);
    }

    public AbstractPageWithNodes(String userPreferenceContext) {
        this(true, null, userPreferenceContext);
    }

    public AbstractPageWithNodes(boolean callInitializer, String userPreferenceContext) {
        this(callInitializer, null, userPreferenceContext);
    }

    @Deprecated
    public AbstractPageWithNodes(boolean callInitializer, ContextMap contextMap, String userPreferenceContext) {
        super(callInitializer, contextMap, userPreferenceContext);
    }

    @ConfigOperation
    @Order(value=90.0)
    protected void execCreateChildPages(List<IPage> pageList) throws ProcessingException {
    }

    protected void createChildPagesInternal(List<IPage> pageList) throws ProcessingException {
        this.interceptCreateChildPages(pageList);
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.m_table = new P_Table();
        if (this.m_table instanceof AbstractTable) {
            this.m_table.setContainerInternal(this);
        }
        this.m_table.addTableListener(new P_TableListener());
        this.m_table.setAutoDiscardOnDelete(true);
        try {
            this.m_table.initTable();
        }
        catch (Exception e) {
            LOG.warn(null, (Throwable)e);
        }
    }

    @Override
    public void cellChanged(ICell cell, int changedBit) {
        super.cellChanged(cell, changedBit);
        this.updateParentTableRow(cell);
    }

    protected void updateParentTableRow(ICell cell) {
        ITableRow row;
        IPage parent = this.getParentPage();
        if (parent != null && parent instanceof IPageWithNodes && (row = ((IPageWithNodes)parent).getTableRowFor(this)) != null) {
            row.getCellForUpdate(0).setText(cell.getText());
        }
    }

    @Override
    public ITable getInternalTable() {
        return this.getTable();
    }

    @Override
    public ITable getTable() {
        return this.m_table;
    }

    @Override
    public void setPagePopulateStatus(IProcessingStatus status) {
        super.setPagePopulateStatus(status);
        this.getTable().tablePopulated();
    }

    @Override
    protected void execPageActivated() throws ProcessingException {
        super.execPageActivated();
        if (this.getTable() != null && this.getTree() != null) {
            this.getTable().setTitle(this.getTree().getPathText(this));
        }
    }

    @Override
    public void loadChildren() throws ProcessingException {
        ArrayList<IPage> pageList = new ArrayList<IPage>();
        this.createChildPagesInternal(pageList);
        ITree tree = this.getTree();
        try {
            if (tree != null) {
                tree.setTreeChanging(true);
            }
            boolean oldSelectionOwned = false;
            int oldSelectionDirectChildIndex = -1;
            ITreeNode oldSelectedNode = null;
            if (tree != null) {
                oldSelectedNode = tree.getSelectedNode();
            }
            String oldSelectedText = null;
            if (oldSelectedNode != null) {
                ITreeNode t = oldSelectedNode;
                while (t != null && t.getParentNode() != null) {
                    if (t.getParentNode() == this) {
                        oldSelectionOwned = true;
                        oldSelectedText = t.getCell().getText();
                        oldSelectionDirectChildIndex = t.getChildNodeIndex();
                        break;
                    }
                    t = t.getParentNode();
                }
            }
            this.setChildrenLoaded(false);
            this.getTree().removeAllChildNodes(this);
            this.getTree().addChildNodes(this, pageList);
            this.setChildrenLoaded(true);
            this.setChildrenDirty(false);
            if (tree != null && oldSelectionOwned && tree.getSelectedNode() == null) {
                if (oldSelectedNode != null && oldSelectedNode.getTree() == tree) {
                    tree.selectNode(oldSelectedNode);
                } else {
                    int index = Math.max(-1, Math.min(oldSelectionDirectChildIndex, this.getChildNodeCount() - 1));
                    if (index >= 0 && index < this.getChildNodeCount() && CompareUtility.equals((Object)oldSelectedText, (Object)this.getChildNode(index).getCell().getText())) {
                        tree.selectNode(this.getChildNode(index));
                    } else if (index >= 0 && index < this.getChildNodeCount()) {
                        tree.selectNode(this.getChildNode(index));
                    } else {
                        tree.selectNode(this);
                    }
                }
            }
        }
        finally {
            if (tree != null) {
                tree.setTreeChanging(false);
            }
        }
        try {
            this.getTable().setTableChanging(true);
            this.rebuildTableInternal();
            this.setPagePopulateStatus(null);
        }
        finally {
            this.getTable().setTableChanging(false);
        }
        super.loadChildren();
    }

    @Override
    public void rebuildTableInternal() throws ProcessingException {
        List<ITreeNode> childNodes = this.getChildNodes();
        try {
            this.getTable().setTableChanging(true);
            this.unlinkAllTableRowWithPage();
            this.getTable().discardAllRows();
            for (ITreeNode childNode : childNodes) {
                TableRow row = new TableRow(this.getTable().getColumnSet());
                row.setCell(0, childNode.getCell());
                ITableRow insertedRow = this.getTable().addRow(row);
                this.linkTableRowWithPage(insertedRow, (IPage)childNode);
            }
        }
        finally {
            this.getTable().setTableChanging(false);
        }
    }

    @Override
    public boolean isFilterAcceptedForChildNode(ITreeNode childPageNode) {
        return this.m_pageToTableRowMap.get(childPageNode) == null || this.m_pageToTableRowMap.get(childPageNode).isFilterAccepted();
    }

    private void linkTableRowWithPage(ITableRow tableRow, IPage page) {
        this.m_tableRowToPageMap.put(tableRow, page);
        this.m_pageToTableRowMap.put(page, tableRow);
    }

    private void unlinkAllTableRowWithPage() {
        this.m_tableRowToPageMap.clear();
        this.m_pageToTableRowMap.clear();
    }

    @Override
    public ITreeNode getTreeNodeFor(ITableRow tableRow) {
        if (tableRow == null) {
            return null;
        }
        return this.m_tableRowToPageMap.get(tableRow);
    }

    @Override
    public ITableRow getTableRowFor(ITreeNode childPageNode) {
        return this.m_pageToTableRowMap.get(childPageNode);
    }

    protected void updateContextMenusForSelection() {
        if (this.m_pageMenusOfSelection != null) {
            this.getTable().getContextMenu().removeChildActions(this.m_pageMenusOfSelection);
            this.m_pageMenusOfSelection = null;
        }
        ArrayList<? extends IMenu> pageMenus = new ArrayList<IMenu>();
        List<ITableRow> selectedRows = this.getTable().getSelectedRows();
        if (CollectionUtility.size(selectedRows) == 1) {
            ITreeNode node = this.getTreeNodeFor((ITableRow)CollectionUtility.firstElement(selectedRows));
            if (node instanceof IPageWithTable) {
                IPageWithTable tablePage = (IPageWithTable)node;
                List<IMenu> menus = ActionUtility.getActions(((ITable)tablePage.getTable()).getContextMenu().getChildActions(), ActionUtility.createMenuFilterMenuTypes(CollectionUtility.hashSet((Object)TableMenuType.EmptySpace), false));
                for (IMenu m : menus) {
                    pageMenus.add(new TablePageTreeMenuWrapper(m, TableMenuType.SingleSelection, new IMenuType[0]));
                }
            } else if (node instanceof IPageWithNodes) {
                IPageWithNodes pageWithNodes = (IPageWithNodes)node;
                List<IMenu> menus = ActionUtility.getActions(pageWithNodes.getMenus(), ActionUtility.createMenuFilterMenuTypes(CollectionUtility.hashSet((Object)TreeMenuType.SingleSelection), false));
                for (IMenu m : menus) {
                    pageMenus.add(new TablePageTreeMenuWrapper(m, TableMenuType.SingleSelection, new IMenuType[0]));
                }
            }
        }
        this.getTable().getContextMenu().addChildActions(pageMenus);
        this.m_pageMenusOfSelection = pageMenus;
    }

    private OutlineMediator getOutlineMediator() {
        if (this.getOutline() == null) {
            return null;
        }
        return this.getOutline().getOutlineMediator();
    }

    protected final void interceptCreateChildPages(List<IPage> pageList) throws ProcessingException {
        List<? extends ITreeNodeExtension<? extends AbstractTreeNode>> extensions = this.getAllExtensions();
        PageWithNodesChains.PageWithNodesCreateChildPagesChain chain = new PageWithNodesChains.PageWithNodesCreateChildPagesChain(extensions);
        chain.execCreateChildPages(pageList);
    }

    @Override
    protected IPageWithNodesExtension<? extends AbstractPageWithNodes> createLocalExtension() {
        return new LocalPageWithNodesExtension<AbstractPageWithNodes>(this);
    }

    protected static class LocalPageWithNodesExtension<OWNER extends AbstractPageWithNodes>
    extends AbstractPage.LocalPageExtension<OWNER>
    implements IPageWithNodesExtension<OWNER> {
        public LocalPageWithNodesExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public void execCreateChildPages(PageWithNodesChains.PageWithNodesCreateChildPagesChain chain, List<IPage> pageList) throws ProcessingException {
            ((AbstractPageWithNodes)this.getOwner()).execCreateChildPages(pageList);
        }
    }

    private class P_Table
    extends AbstractTable {
        private P_Table() {
        }

        @Override
        protected void execRowsSelected(List<? extends ITableRow> rows) throws ProcessingException {
            super.execRowsSelected(rows);
        }

        @Override
        protected boolean getConfiguredSortEnabled() {
            return false;
        }

        @Override
        protected boolean getConfiguredAutoResizeColumns() {
            return true;
        }

        @Override
        protected boolean getConfiguredMultiSelect() {
            return false;
        }

        public LabelColumn getLabelColumn() {
            return this.getColumnSet().getColumnByClass(LabelColumn.class);
        }

        @Order(value=1.0)
        public class LabelColumn
        extends AbstractStringColumn {
            @Override
            protected String getConfiguredHeaderText() {
                return ScoutTexts.get((String)"Folders", (String[])new String[0]);
            }

            @Override
            protected void decorateCellInternal(Cell cell, ITableRow row) {
                IPage page = (IPage)AbstractPageWithNodes.this.m_tableRowToPageMap.get(row);
                if (page != null) {
                    page.getCellForUpdate().setText(cell.getText());
                }
            }

            @Override
            protected int getConfiguredWidth() {
                return 200;
            }
        }
    }

    private class P_TableListener
    extends TableAdapter {
        private P_TableListener() {
        }

        @Override
        public void tableChanged(TableEvent e) {
            OutlineMediator outlineMediator = AbstractPageWithNodes.this.getOutlineMediator();
            if (outlineMediator == null) {
                return;
            }
            switch (e.getType()) {
                case 104: {
                    outlineMediator.mediateTableRowAction(e, AbstractPageWithNodes.this);
                    break;
                }
                case 740: {
                    outlineMediator.mediateTableRowDropAction(e, AbstractPageWithNodes.this);
                    break;
                }
                case 210: {
                    outlineMediator.mediateTableRowFilterChanged(AbstractPageWithNodes.this);
                    break;
                }
                case 103: {
                    AbstractPageWithNodes.this.updateContextMenusForSelection();
                }
            }
        }
    }
}

