/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form;

import java.util.List;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.extension.ui.form.FormHandlerChains;
import org.eclipse.scout.rt.client.extension.ui.form.IFormHandlerExtension;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.IFormHandler;
import org.eclipse.scout.rt.shared.extension.AbstractExtension;
import org.eclipse.scout.rt.shared.extension.IExtensibleObject;
import org.eclipse.scout.rt.shared.extension.IExtension;
import org.eclipse.scout.rt.shared.extension.ObjectExtensions;

public abstract class AbstractFormHandler
implements IFormHandler,
IExtensibleObject {
    private IForm m_form;
    private boolean m_openExclusive;
    private final ObjectExtensions<AbstractFormHandler, IFormHandlerExtension<? extends AbstractFormHandler>> m_objectExtensions = new ObjectExtensions((Object)this);

    public AbstractFormHandler() {
        this.interceptInitConfig();
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=10.0)
    protected boolean getConfiguredGuiLess() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=20.0)
    protected boolean getConfiguredOpenExclusive() {
        return false;
    }

    @ConfigOperation
    @Order(value=10.0)
    protected void execLoad() throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=20.0)
    protected void execPostLoad() throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=40.0)
    protected boolean execCheckFields() throws ProcessingException {
        return true;
    }

    @ConfigOperation
    @Order(value=50.0)
    protected boolean execValidate() throws ProcessingException {
        return true;
    }

    @ConfigOperation
    @Order(value=40.0)
    protected void execStore() throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=30.0)
    protected void execDiscard() throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=60.0)
    protected void execFinally() throws ProcessingException {
    }

    protected final void interceptInitConfig() {
        this.m_objectExtensions.initConfig(this.createLocalExtension(), new Runnable(){

            @Override
            public void run() {
                AbstractFormHandler.this.initConfig();
            }
        });
    }

    protected void initConfig() {
        this.setOpenExclusive(this.getConfiguredOpenExclusive());
    }

    protected IFormHandlerExtension<? extends AbstractFormHandler> createLocalExtension() {
        return new LocalFormHandlerExtension<AbstractFormHandler>(this);
    }

    public final List<? extends IFormHandlerExtension<? extends AbstractFormHandler>> getAllExtensions() {
        return this.m_objectExtensions.getAllExtensions();
    }

    public <T extends IExtension<?>> T getExtension(Class<T> c) {
        return (T)this.m_objectExtensions.getExtension(c);
    }

    @Override
    public void setOpenExclusive(boolean openExclusive) {
        this.m_openExclusive = openExclusive;
    }

    @Override
    public boolean isOpenExclusive() {
        return this.m_openExclusive;
    }

    @Override
    public IForm getForm() {
        return this.m_form;
    }

    @Override
    public void setFormInternal(IForm form) {
        this.m_form = form;
    }

    @Override
    public String getHandlerId() {
        String s = this.getClass().getName();
        int i = Math.max(s.lastIndexOf(36), s.lastIndexOf(46));
        s = s.substring(i + 1);
        return s;
    }

    @Override
    public boolean isGuiLess() {
        return this.getConfiguredGuiLess();
    }

    @Override
    public final void onLoad() throws ProcessingException {
        try {
            this.interceptLoad();
        }
        catch (ProcessingException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ProcessingException("Unexpected", e);
        }
    }

    @Override
    public final void onPostLoad() throws ProcessingException {
        try {
            this.interceptPostLoad();
        }
        catch (ProcessingException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ProcessingException("Unexpected", e);
        }
    }

    @Override
    public final boolean onCheckFields() throws ProcessingException {
        try {
            return this.interceptCheckFields();
        }
        catch (ProcessingException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ProcessingException("Unexpected", e);
        }
    }

    @Override
    public final boolean onValidate() throws ProcessingException {
        try {
            return this.interceptValidate();
        }
        catch (ProcessingException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ProcessingException("Unexpected", e);
        }
    }

    @Override
    public final void onStore() throws ProcessingException {
        try {
            this.interceptStore();
        }
        catch (ProcessingException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ProcessingException("Unexpected", e);
        }
    }

    @Override
    public final void onDiscard() throws ProcessingException {
        try {
            this.interceptDiscard();
        }
        catch (ProcessingException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ProcessingException("Unexpected", e);
        }
    }

    @Override
    public final void onFinally() throws ProcessingException {
        try {
            this.interceptFinally();
        }
        catch (ProcessingException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ProcessingException("Unexpected", e);
        }
    }

    protected final void interceptPostLoad() throws ProcessingException {
        List<? extends IFormHandlerExtension<? extends AbstractFormHandler>> extensions = this.getAllExtensions();
        FormHandlerChains.FormHandlerPostLoadChain chain = new FormHandlerChains.FormHandlerPostLoadChain(extensions);
        chain.execPostLoad();
    }

    protected final boolean interceptValidate() throws ProcessingException {
        List<? extends IFormHandlerExtension<? extends AbstractFormHandler>> extensions = this.getAllExtensions();
        FormHandlerChains.FormHandlerValidateChain chain = new FormHandlerChains.FormHandlerValidateChain(extensions);
        return chain.execValidate();
    }

    protected final void interceptLoad() throws ProcessingException {
        List<? extends IFormHandlerExtension<? extends AbstractFormHandler>> extensions = this.getAllExtensions();
        FormHandlerChains.FormHandlerLoadChain chain = new FormHandlerChains.FormHandlerLoadChain(extensions);
        chain.execLoad();
    }

    protected final void interceptStore() throws ProcessingException {
        List<? extends IFormHandlerExtension<? extends AbstractFormHandler>> extensions = this.getAllExtensions();
        FormHandlerChains.FormHandlerStoreChain chain = new FormHandlerChains.FormHandlerStoreChain(extensions);
        chain.execStore();
    }

    protected final void interceptDiscard() throws ProcessingException {
        List<? extends IFormHandlerExtension<? extends AbstractFormHandler>> extensions = this.getAllExtensions();
        FormHandlerChains.FormHandlerDiscardChain chain = new FormHandlerChains.FormHandlerDiscardChain(extensions);
        chain.execDiscard();
    }

    protected final boolean interceptCheckFields() throws ProcessingException {
        List<? extends IFormHandlerExtension<? extends AbstractFormHandler>> extensions = this.getAllExtensions();
        FormHandlerChains.FormHandlerCheckFieldsChain chain = new FormHandlerChains.FormHandlerCheckFieldsChain(extensions);
        return chain.execCheckFields();
    }

    protected final void interceptFinally() throws ProcessingException {
        List<? extends IFormHandlerExtension<? extends AbstractFormHandler>> extensions = this.getAllExtensions();
        FormHandlerChains.FormHandlerFinallyChain chain = new FormHandlerChains.FormHandlerFinallyChain(extensions);
        chain.execFinally();
    }

    protected static class LocalFormHandlerExtension<OWNER extends AbstractFormHandler>
    extends AbstractExtension<OWNER>
    implements IFormHandlerExtension<OWNER> {
        public LocalFormHandlerExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public void execPostLoad(FormHandlerChains.FormHandlerPostLoadChain chain) throws ProcessingException {
            ((AbstractFormHandler)this.getOwner()).execPostLoad();
        }

        @Override
        public boolean execValidate(FormHandlerChains.FormHandlerValidateChain chain) throws ProcessingException {
            return ((AbstractFormHandler)this.getOwner()).execValidate();
        }

        @Override
        public void execLoad(FormHandlerChains.FormHandlerLoadChain chain) throws ProcessingException {
            ((AbstractFormHandler)this.getOwner()).execLoad();
        }

        @Override
        public void execStore(FormHandlerChains.FormHandlerStoreChain chain) throws ProcessingException {
            ((AbstractFormHandler)this.getOwner()).execStore();
        }

        @Override
        public void execDiscard(FormHandlerChains.FormHandlerDiscardChain chain) throws ProcessingException {
            ((AbstractFormHandler)this.getOwner()).execDiscard();
        }

        @Override
        public boolean execCheckFields(FormHandlerChains.FormHandlerCheckFieldsChain chain) throws ProcessingException {
            return ((AbstractFormHandler)this.getOwner()).execCheckFields();
        }

        @Override
        public void execFinally(FormHandlerChains.FormHandlerFinallyChain chain) throws ProcessingException {
            ((AbstractFormHandler)this.getOwner()).execFinally();
        }
    }
}

