/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form;

import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.ISearchForm;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.IFormFieldVisitor;
import org.eclipse.scout.rt.client.ui.form.fields.GridData;
import org.eclipse.scout.rt.client.ui.form.fields.ICompositeField;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.tabbox.ITabBox;

public final class FormUtility {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(FormUtility.class);

    private FormUtility() {
    }

    public static void postInitConfig(IForm form) throws ProcessingException {
        PostInitConfigFieldVisitor v = new PostInitConfigFieldVisitor();
        form.visitFields(v);
        v.handleResult();
    }

    public static void rebuildFieldGrid(IForm form, boolean initMainBoxGridData) throws ProcessingException {
        RebuildFieldGridVisitor v = new RebuildFieldGridVisitor();
        form.visitFields(v);
        v.handleResult();
        if (initMainBoxGridData) {
            FormUtility.initRootBoxGridData(form, form.getRootGroupBox());
        }
    }

    private static void initRootBoxGridData(IForm form, ICompositeField rootBox) throws ProcessingException {
        String viewId;
        GridData rootData = new GridData(rootBox.getGridDataHints());
        if (rootData.w == 0) {
            rootData.w = rootBox.getGridColumnCount();
        }
        if (form instanceof ISearchForm && rootData.weightY < 0.0 && ((viewId = form.getDisplayViewId().toUpperCase()).indexOf("SEARCH") >= 0 || viewId.indexOf(83) >= 0)) {
            rootData.weightY = 0.0;
        }
        rootData.x = 0;
        rootData.y = 0;
        rootBox.setGridDataInternal(rootData);
    }

    public static void initFormFields(IForm form) throws ProcessingException {
        InitFieldVisitor v = new InitFieldVisitor();
        form.visitFields(v);
        v.handleResult();
    }

    public static void disposeFormFields(IForm form) {
        DisposeFieldVisitor v = new DisposeFieldVisitor();
        form.visitFields(v);
    }

    public static void setTabBoxMarkStrategy(IForm form, int strategy) {
        form.visitFields(new TabBoxMarkStrategyVisitor(strategy));
    }

    private static class DisposeFieldVisitor
    implements IFormFieldVisitor {
        private DisposeFieldVisitor() {
        }

        @Override
        public boolean visitField(IFormField field, int level, int fieldIndex) {
            try {
                field.disposeField();
            }
            catch (Throwable t) {
                LOG.warn("dispose on " + field, t);
            }
            return true;
        }
    }

    private static class InitFieldVisitor
    implements IFormFieldVisitor {
        private ProcessingException m_firstEx;

        private InitFieldVisitor() {
        }

        @Override
        public boolean visitField(IFormField field, int level, int fieldIndex) {
            block4: {
                try {
                    field.initField();
                }
                catch (ProcessingException e) {
                    if (this.m_firstEx == null) {
                        this.m_firstEx = e;
                    }
                }
                catch (Throwable t) {
                    if (this.m_firstEx != null) break block4;
                    this.m_firstEx = new ProcessingException("Unexpected", t);
                }
            }
            return true;
        }

        public void handleResult() throws ProcessingException {
            if (this.m_firstEx != null) {
                throw this.m_firstEx;
            }
        }
    }

    private static class PostInitConfigFieldVisitor
    implements IFormFieldVisitor {
        private ProcessingException m_firstEx;

        private PostInitConfigFieldVisitor() {
        }

        @Override
        public boolean visitField(IFormField field, int level, int fieldIndex) {
            block4: {
                try {
                    field.postInitConfig();
                }
                catch (ProcessingException e) {
                    if (this.m_firstEx == null) {
                        this.m_firstEx = e;
                    }
                }
                catch (Throwable t) {
                    if (this.m_firstEx != null) break block4;
                    this.m_firstEx = new ProcessingException("Unexpected", t);
                }
            }
            return true;
        }

        public void handleResult() throws ProcessingException {
            if (this.m_firstEx != null) {
                throw this.m_firstEx;
            }
        }
    }

    private static class RebuildFieldGridVisitor
    implements IFormFieldVisitor {
        private ProcessingException m_firstEx;

        private RebuildFieldGridVisitor() {
        }

        @Override
        public boolean visitField(IFormField field, int level, int fieldIndex) {
            block3: {
                try {
                    if (field instanceof ICompositeField) {
                        ((ICompositeField)field).rebuildFieldGrid();
                    }
                }
                catch (Throwable t) {
                    if (this.m_firstEx != null) break block3;
                    this.m_firstEx = new ProcessingException("Unexpected", t);
                }
            }
            return true;
        }

        public void handleResult() throws ProcessingException {
            if (this.m_firstEx != null) {
                throw this.m_firstEx;
            }
        }
    }

    private static final class TabBoxMarkStrategyVisitor
    implements IFormFieldVisitor {
        private final int m_strategy;

        private TabBoxMarkStrategyVisitor(int strategy) {
            this.m_strategy = strategy;
        }

        @Override
        public boolean visitField(IFormField field, int level, int fieldIndex) {
            if (field instanceof ITabBox) {
                ((ITabBox)field).setMarkStrategy(this.m_strategy);
            }
            return true;
        }
    }
}

