/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields;

import java.util.List;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.annotations.ClassId;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.annotations.ScoutSdkIgnore;
import org.eclipse.scout.rt.client.extension.ui.form.fields.BasicFieldChains;
import org.eclipse.scout.rt.client.extension.ui.form.fields.IBasicFieldExtension;
import org.eclipse.scout.rt.client.extension.ui.form.fields.IFormFieldExtension;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractFormField;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractValueField;
import org.eclipse.scout.rt.client.ui.form.fields.IBasicField;
import org.eclipse.scout.rt.client.ui.form.fields.IBasicFieldUIFacade;

@ScoutSdkIgnore
@ClassId(value="d5a72dd8-cb1c-4dea-a568-90d77e65854e")
public abstract class AbstractBasicField<VALUE>
extends AbstractValueField<VALUE>
implements IBasicField<VALUE> {
    private boolean m_whileTyping;

    protected AbstractBasicField(boolean callInitializer) {
        super(callInitializer);
    }

    @Override
    protected IBasicFieldExtension<VALUE, ? extends AbstractBasicField<VALUE>> createLocalExtension() {
        return new LocalBasicFieldExtension(this);
    }

    @ConfigOperation
    @Order(value=225.0)
    protected void execChangedDisplayText() {
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.setValidateOnAnyKey(this.getConfiguredValidateOnAnyKey());
        this.setUpdateDisplayTextOnModify(this.getConfiguredUpdateDisplayTextOnModify());
    }

    @Override
    public void setDisplayText(String s) {
        String oldDisplayText = this.getDisplayText();
        super.setDisplayText(s);
        if (CompareUtility.notEquals((Object)oldDisplayText, (Object)s)) {
            this.interceptExecChangedDisplayText();
        }
    }

    @Deprecated
    @Order(value=310.0)
    protected boolean getConfiguredValidateOnAnyKey() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=315.0)
    protected boolean getConfiguredUpdateDisplayTextOnModify() {
        return false;
    }

    @Override
    protected boolean shouldUpdateDisplayText(boolean validValueDiffersFromRawValue) {
        return (!this.isWhileTyping() || validValueDiffersFromRawValue) && super.shouldUpdateDisplayText(validValueDiffersFromRawValue);
    }

    @Override
    public boolean isValidateOnAnyKey() {
        return this.propertySupport.getPropertyBool("validateOnAnyKey");
    }

    @Override
    public void setValidateOnAnyKey(boolean b) {
        this.propertySupport.setPropertyBool("validateOnAnyKey", b);
    }

    @Override
    public void setUpdateDisplayTextOnModify(boolean b) {
        this.propertySupport.setPropertyBool("updateDisplayTextOnModify", b);
    }

    @Override
    public boolean isUpdateDisplayTextOnModify() {
        return this.propertySupport.getPropertyBool("updateDisplayTextOnModify");
    }

    protected boolean isWhileTyping() {
        return this.m_whileTyping;
    }

    protected void setWhileTyping(boolean whileTyping) {
        this.m_whileTyping = whileTyping;
    }

    protected final void interceptExecChangedDisplayText() {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        new BasicFieldChains.BasicFieldExecChangedDisplayTextChain(extensions).execChangedDisplayText();
    }

    protected static class LocalBasicFieldExtension<VALUE_TYPE, OWNER_FIELD extends AbstractBasicField<VALUE_TYPE>>
    extends AbstractValueField.LocalValueFieldExtension<VALUE_TYPE, OWNER_FIELD>
    implements IBasicFieldExtension<VALUE_TYPE, OWNER_FIELD> {
        public LocalBasicFieldExtension(OWNER_FIELD owner) {
            super(owner);
        }

        @Override
        public void execChangedDisplayText(BasicFieldChains.BasicFieldExecChangedDisplayTextChain<VALUE_TYPE> chain) {
            ((AbstractBasicField)this.getOwner()).execChangedDisplayText();
        }
    }

    protected abstract class P_UIFacade
    implements IBasicFieldUIFacade {
        protected P_UIFacade() {
        }

        @Override
        public void setDisplayTextFromUI(String text) {
            AbstractBasicField.this.setDisplayText(text);
        }
    }
}

