/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.bigdecimalfield;

import java.math.BigDecimal;
import org.eclipse.scout.commons.annotations.ClassId;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.extension.ui.form.fields.bigdecimalfield.IBigDecimalFieldExtension;
import org.eclipse.scout.rt.client.ui.form.fields.bigdecimalfield.IBigDecimalField;
import org.eclipse.scout.rt.client.ui.form.fields.decimalfield.AbstractDecimalField;
import org.eclipse.scout.rt.shared.data.form.ValidationRule;

@ClassId(value="68508a2e-690c-46e2-aa78-062e1504c0ac")
public abstract class AbstractBigDecimalField
extends AbstractDecimalField<BigDecimal>
implements IBigDecimalField {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractBigDecimalField.class);
    private static final BigDecimal DEFAULT_MIN_VALUE = new BigDecimal("-999999999999999999999999999999999999999999999999999999999999");
    private static final BigDecimal DEFAULT_MAX_VALUE = new BigDecimal("999999999999999999999999999999999999999999999999999999999999");

    public AbstractBigDecimalField() {
        this(true);
    }

    public AbstractBigDecimalField(boolean callInitializer) {
        super(callInitializer);
    }

    @Override
    @ConfigProperty(value="BIG_DECIMAL")
    @Order(value=300.0)
    @ValidationRule(value="minValue")
    protected BigDecimal getConfiguredMinValue() {
        return DEFAULT_MIN_VALUE;
    }

    @Override
    @ConfigProperty(value="BIG_DECIMAL")
    @Order(value=310.0)
    @ValidationRule(value="maxValue")
    protected BigDecimal getConfiguredMaxValue() {
        return DEFAULT_MAX_VALUE;
    }

    @Override
    protected BigDecimal getMinPossibleValue() {
        return DEFAULT_MIN_VALUE;
    }

    @Override
    protected BigDecimal getMaxPossibleValue() {
        return DEFAULT_MAX_VALUE;
    }

    @Override
    protected BigDecimal parseValueInternal(String text) throws ProcessingException {
        return this.parseToBigDecimalInternal(text);
    }

    @Override
    protected IBigDecimalFieldExtension<? extends AbstractBigDecimalField> createLocalExtension() {
        return new LocalBigDecimalFieldExtension<AbstractBigDecimalField>(this);
    }

    protected static class LocalBigDecimalFieldExtension<OWNER extends AbstractBigDecimalField>
    extends AbstractDecimalField.LocalDecimalFieldExtension<BigDecimal, OWNER>
    implements IBigDecimalFieldExtension<OWNER> {
        public LocalBigDecimalFieldExtension(OWNER owner) {
            super(owner);
        }
    }
}

