/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.button;

import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.commons.annotations.ClassId;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.IOrdered;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.annotations.OrderedCollection;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.extension.ui.action.tree.MoveActionNodesHandler;
import org.eclipse.scout.rt.client.extension.ui.form.fields.IFormFieldExtension;
import org.eclipse.scout.rt.client.extension.ui.form.fields.button.ButtonChains;
import org.eclipse.scout.rt.client.extension.ui.form.fields.button.IButtonExtension;
import org.eclipse.scout.rt.client.ui.action.ActionUtility;
import org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.MenuUtility;
import org.eclipse.scout.rt.client.ui.action.menu.root.IContextMenu;
import org.eclipse.scout.rt.client.ui.action.menu.root.internal.FormFieldContextMenu;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractFormField;
import org.eclipse.scout.rt.client.ui.form.fields.button.ButtonEvent;
import org.eclipse.scout.rt.client.ui.form.fields.button.ButtonListener;
import org.eclipse.scout.rt.client.ui.form.fields.button.IButton;
import org.eclipse.scout.rt.client.ui.form.fields.button.IButtonUIFacade;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.service.SERVICES;

@ClassId(value="998788cf-df0f-480b-bd5a-5037805610c9")
public abstract class AbstractButton
extends AbstractFormField
implements IButton {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractButton.class);
    private final EventListenerList m_listenerList = new EventListenerList();
    private int m_systemType;
    private int m_displayStyle;
    private boolean m_processButton;
    private Object m_radioValue;
    private List<IMenu> m_menus;
    private final IButtonUIFacade m_uiFacade = new P_UIFacade();
    private final OptimisticLock m_uiFacadeSetSelectedLock = new OptimisticLock();

    public AbstractButton() {
        this(true);
    }

    public AbstractButton(boolean callInitializer) {
        super(false);
        if (callInitializer) {
            this.callInitializer();
        }
    }

    @ConfigProperty(value="BUTTON_SYSTEM_TYPE")
    @Order(value=200.0)
    protected int getConfiguredSystemType() {
        return 0;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=220.0)
    protected boolean getConfiguredProcessButton() {
        return true;
    }

    @ConfigProperty(value="BUTTON_DISPLAY_STYLE")
    @Order(value=210.0)
    protected int getConfiguredDisplayStyle() {
        return 0;
    }

    @Override
    protected boolean getConfiguredFillHorizontal() {
        return false;
    }

    @Override
    protected boolean getConfiguredFillVertical() {
        return false;
    }

    @Override
    protected boolean getConfiguredGridUseUiWidth() {
        return true;
    }

    @Override
    protected boolean getConfiguredGridUseUiHeight() {
        return false;
    }

    @ConfigProperty(value="ICON_ID")
    @Order(value=190.0)
    protected String getConfiguredIconId() {
        return null;
    }

    @ConfigOperation
    @Order(value=190.0)
    protected void execClickAction() throws ProcessingException {
    }

    @Deprecated
    protected void execToggleAction(boolean selected) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=210.0)
    protected void execSelectionChanged(boolean selection) throws ProcessingException {
    }

    protected List<Class<? extends IMenu>> getDeclaredMenus() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        List menuClasses = ConfigurationUtility.filterClasses((Class[])dca, IMenu.class);
        List a = ConfigurationUtility.removeReplacedClasses((List)menuClasses);
        return a;
    }

    @Override
    public List<IKeyStroke> getContributedKeyStrokes() {
        return MenuUtility.getKeyStrokesFromMenus(this.getMenus());
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.setSystemType(this.getConfiguredSystemType());
        this.setDisplayStyleInternal(this.getConfiguredDisplayStyle());
        this.setProcessButton(this.getConfiguredProcessButton());
        this.setIconId(this.getConfiguredIconId());
        List<Class<? extends IMenu>> declaredMenus = this.getDeclaredMenus();
        List contributedMenus = this.m_contributionHolder.getContributionsByClass(IMenu.class);
        OrderedCollection menus = new OrderedCollection();
        for (Class<? extends IMenu> menuClazz : declaredMenus) {
            try {
                IMenu menu = (IMenu)ConfigurationUtility.newInnerInstance((Object)this, menuClazz);
                menus.addOrdered((IOrdered)menu);
            }
            catch (Throwable t) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("error creating instance of class '" + menuClazz.getName() + "'.", t));
            }
        }
        menus.addAllOrdered((Collection)contributedMenus);
        try {
            this.injectMenusInternal((OrderedCollection<IMenu>)menus);
        }
        catch (Exception e) {
            LOG.error("error occured while dynamically contributing menus.", (Throwable)e);
        }
        new MoveActionNodesHandler(menus).moveModelObjects();
        FormFieldContextMenu<AbstractButton> contextMenu = new FormFieldContextMenu<AbstractButton>(this, (List<? extends IMenu>)menus.getOrderedList());
        contextMenu.setContainerInternal(this);
        this.setContextMenu(contextMenu);
    }

    @Override
    protected void initFieldInternal() throws ProcessingException {
        super.initFieldInternal();
        ActionUtility.initActions(this.getMenus());
    }

    protected void injectMenusInternal(OrderedCollection<IMenu> menus) {
    }

    @Override
    public String getIconId() {
        return this.propertySupport.getPropertyString("iconId");
    }

    @Override
    public void setIconId(String iconId) {
        this.propertySupport.setPropertyString("iconId", iconId);
    }

    @Override
    public Object getImage() {
        return this.propertySupport.getProperty("image");
    }

    @Override
    public void setImage(Object nativeImg) {
        this.propertySupport.setProperty("image", nativeImg);
    }

    @Override
    public int getSystemType() {
        return this.m_systemType;
    }

    @Override
    public void setSystemType(int systemType) {
        this.m_systemType = systemType;
    }

    @Override
    public boolean isProcessButton() {
        return this.m_processButton;
    }

    @Override
    public void setProcessButton(boolean on) {
        this.m_processButton = on;
    }

    @Override
    public List<IMenu> getMenus() {
        return this.getContextMenu().getChildActions();
    }

    protected void setContextMenu(IContextMenu contextMenu) {
        this.propertySupport.setProperty("contextMenu", (Object)contextMenu);
    }

    @Override
    public IContextMenu getContextMenu() {
        return (IContextMenu)this.propertySupport.getProperty("contextMenu");
    }

    @Override
    public void doClick() throws ProcessingException {
        if (this.isEnabled() && this.isVisible() && this.isEnabledProcessingButton()) {
            try {
                this.setEnabledProcessingButton(false);
                this.fireButtonClicked();
                this.interceptClickAction();
            }
            finally {
                this.setEnabledProcessingButton(true);
            }
        }
    }

    @Override
    public boolean isSelected() {
        return this.propertySupport.getPropertyBool("selected");
    }

    @Override
    public void setSelected(boolean b) {
        boolean changed = this.propertySupport.setPropertyBool("selected", b);
        if (changed) {
            try {
                this.interceptSelectionChanged(b);
                this.execToggleAction(b);
            }
            catch (ProcessingException e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
            }
        }
    }

    @Override
    public void disarm() {
        this.fireDisarmButton();
    }

    @Override
    public void requestPopup() {
        this.fireRequestPopup();
    }

    @Override
    public int getDisplayStyle() {
        return this.m_displayStyle;
    }

    @Override
    public void setDisplayStyleInternal(int i) {
        this.m_displayStyle = i;
    }

    @Override
    public IButtonUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    @Override
    public void addButtonListener(ButtonListener listener) {
        this.m_listenerList.add(ButtonListener.class, (EventListener)listener);
    }

    @Override
    public void removeButtonListener(ButtonListener listener) {
        this.m_listenerList.remove(ButtonListener.class, (EventListener)listener);
    }

    private void fireButtonClicked() {
        this.fireButtonEvent(new ButtonEvent(this, 1));
    }

    private void fireDisarmButton() {
        this.fireButtonEvent(new ButtonEvent(this, 3));
    }

    private void fireRequestPopup() {
        this.fireButtonEvent(new ButtonEvent(this, 4));
    }

    private void fireButtonEvent(ButtonEvent e) {
        EventListener[] listeners = this.m_listenerList.getListeners(ButtonListener.class);
        if (listeners != null && listeners.length > 0) {
            int i = 0;
            while (i < listeners.length) {
                ((ButtonListener)listeners[i]).buttonChanged(e);
                ++i;
            }
        }
    }

    protected final void interceptSelectionChanged(boolean selection) throws ProcessingException {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        ButtonChains.ButtonSelectionChangedChain chain = new ButtonChains.ButtonSelectionChangedChain(extensions);
        chain.execSelectionChanged(selection);
    }

    protected final void interceptClickAction() throws ProcessingException {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        ButtonChains.ButtonClickActionChain chain = new ButtonChains.ButtonClickActionChain(extensions);
        chain.execClickAction();
    }

    protected IButtonExtension<? extends AbstractButton> createLocalExtension() {
        return new LocalButtonExtension<AbstractButton>(this);
    }

    protected static class LocalButtonExtension<OWNER extends AbstractButton>
    extends AbstractFormField.LocalFormFieldExtension<OWNER>
    implements IButtonExtension<OWNER> {
        public LocalButtonExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public void execSelectionChanged(ButtonChains.ButtonSelectionChangedChain chain, boolean selection) throws ProcessingException {
            ((AbstractButton)this.getOwner()).execSelectionChanged(selection);
        }

        @Override
        public void execClickAction(ButtonChains.ButtonClickActionChain chain) throws ProcessingException {
            ((AbstractButton)this.getOwner()).execClickAction();
        }
    }

    private class P_UIFacade
    implements IButtonUIFacade {
        private P_UIFacade() {
        }

        @Override
        public void fireButtonClickedFromUI() {
            try {
                if (AbstractButton.this.isEnabled() && AbstractButton.this.isVisible()) {
                    AbstractButton.this.doClick();
                }
            }
            catch (ProcessingException e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
            }
        }

        @Override
        public void setSelectedFromUI(boolean b) {
            try {
                if (AbstractButton.this.m_uiFacadeSetSelectedLock.acquire()) {
                    AbstractButton.this.setSelected(b);
                }
            }
            finally {
                AbstractButton.this.m_uiFacadeSetSelectedLock.release();
            }
        }
    }
}

