/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.colorpickerfield;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.scout.commons.ColorUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.extension.ui.form.fields.colorpickerfield.IColorFieldExtension;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractBasicField;
import org.eclipse.scout.rt.client.ui.form.fields.colorpickerfield.IColorField;
import org.eclipse.scout.rt.client.ui.form.fields.colorpickerfield.IColorFieldUiFacade;
import org.eclipse.scout.rt.shared.ScoutTexts;

public abstract class AbstractColorField
extends AbstractBasicField<String>
implements IColorField {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractColorField.class);
    private IColorFieldUiFacade m_uiFacade;
    protected static final Pattern RGB_COLOR_PATTERN = Pattern.compile("^([0-9]{1,3})[\\-\\,\\;\\/\\\\\\s]{1}([0-9]{1,3})[\\-\\,\\;\\/\\\\\\s]{1}([0-9]{1,3})$");

    public AbstractColorField() {
        this(true);
    }

    public AbstractColorField(boolean callInitializer) {
        super(callInitializer);
    }

    @ConfigProperty(value="ICON_ID")
    @Order(value=230.0)
    protected String getConfiguredIconId() {
        return "colorpicker_browse";
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.m_uiFacade = new P_UiFacade();
        this.setIconId(this.getConfiguredIconId());
    }

    @Override
    public IColorFieldUiFacade getUIFacade() {
        return this.m_uiFacade;
    }

    @Override
    protected String parseValueInternal(String text) throws ProcessingException {
        if (StringUtility.isNullOrEmpty((CharSequence)text)) {
            return null;
        }
        try {
            Matcher matcher = ColorUtility.HEX_COLOR_PATTERN.matcher(text);
            if (matcher.matches()) {
                return "#" + matcher.group(2);
            }
            matcher = RGB_COLOR_PATTERN.matcher(text);
            if (matcher.matches()) {
                int r = Integer.valueOf(matcher.group(1));
                int g = Integer.valueOf(matcher.group(2));
                int b = Integer.valueOf(matcher.group(3));
                if (r < 0 || r > 255 || g < 0 || g > 255 || b < 0 || b > 255) {
                    throw new ProcessingException(ScoutTexts.get((String)"InvalidValueMessageX", (String[])new String[]{text}));
                }
                String hexValue = ColorUtility.rgbToText((int)r, (int)g, (int)b).toUpperCase();
                return hexValue;
            }
        }
        catch (Exception e) {
            throw new ProcessingException(ScoutTexts.get((String)"InvalidValueMessageX", (String[])new String[]{text}), (Throwable)e);
        }
        throw new ProcessingException(ScoutTexts.get((String)"InvalidValueMessageX", (String[])new String[]{text}));
    }

    @Override
    public String getIconId() {
        return this.propertySupport.getPropertyString("iconId");
    }

    @Override
    public void setIconId(String s) {
        this.propertySupport.setPropertyString("iconId", s);
    }

    @Override
    protected IColorFieldExtension<? extends AbstractColorField> createLocalExtension() {
        return new LocalColorFieldExtension<AbstractColorField>(this);
    }

    protected static class LocalColorFieldExtension<OWNER extends AbstractColorField>
    extends AbstractBasicField.LocalBasicFieldExtension<String, OWNER>
    implements IColorFieldExtension<OWNER> {
        public LocalColorFieldExtension(OWNER owner) {
            super(owner);
        }
    }

    private class P_UiFacade
    extends AbstractBasicField.P_UIFacade
    implements IColorFieldUiFacade {
        private P_UiFacade() {
        }

        @Override
        public boolean setTextFromUI(String newText, boolean whileTyping) {
            if (newText != null && newText.length() == 0) {
                newText = null;
            }
            AbstractColorField.this.setWhileTyping(whileTyping);
            return AbstractColorField.this.parseValue(newText);
        }

        @Override
        public void setValueFromUi(String value) {
            if (StringUtility.hasText((CharSequence)value)) {
                AbstractColorField.this.setValue(value);
            } else {
                AbstractColorField.this.setValue(null);
            }
        }
    }
}

